/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.impl;

import com.sun.facelets.Facelet;
import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletFactory;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.impl.DefaultFacelet;
import com.sun.facelets.impl.ResourceResolver;
import com.sun.facelets.util.ParameterCheck;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;

public final class DefaultFaceletFactory
extends FaceletFactory {
    protected static final Logger log = Logger.getLogger("facelets.factory");
    private final Compiler compiler;
    private Map facelets;
    private Map relativeLocations;
    private final ResourceResolver resolver;
    private final URL baseUrl;
    private final long refreshPeriod;

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver) throws IOException {
        this(compiler, resolver, -1L);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver, long refreshPeriod) {
        ParameterCheck.notNull("compiler", compiler);
        ParameterCheck.notNull("resolver", resolver);
        this.compiler = compiler;
        this.facelets = new HashMap();
        this.relativeLocations = new HashMap();
        this.resolver = resolver;
        this.baseUrl = resolver.resolveUrl("/");
        log.fine("Using ResourceResolver: " + resolver);
        this.refreshPeriod = refreshPeriod >= 0L ? refreshPeriod * 1000L : -1L;
        log.fine("Using Refresh Period: " + this.refreshPeriod);
    }

    public Facelet getFacelet(String uri) throws IOException, FaceletException, FacesException, ELException {
        URL url = (URL)this.relativeLocations.get(uri);
        if (url == null) {
            url = this.resolveURL(this.baseUrl, uri);
            if (url != null) {
                HashMap<String, URL> newLoc = new HashMap<String, URL>(this.relativeLocations);
                newLoc.put(uri, url);
                this.relativeLocations = newLoc;
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return this.getFacelet(url);
    }

    public URL resolveURL(URL source, String path) throws IOException {
        if (path.startsWith("/")) {
            URL url = this.resolver.resolveUrl(path);
            if (url == null) {
                throw new FileNotFoundException(path + " Not Found in ExternalContext as a Resource");
            }
            return url;
        }
        return new URL(source, path);
    }

    public Facelet getFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        ParameterCheck.notNull("url", url);
        String key = url.toString();
        DefaultFacelet f = (DefaultFacelet)this.facelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = this.createFacelet(url);
            HashMap<String, DefaultFacelet> newLoc = new HashMap<String, DefaultFacelet>(this.facelets);
            newLoc.put(key, f);
            this.facelets = newLoc;
        }
        return f;
    }

    protected boolean needsToBeRefreshed(DefaultFacelet facelet) {
        if (this.refreshPeriod != -1L) {
            long ttl = facelet.getCreateTime() + this.refreshPeriod;
            if (System.currentTimeMillis() > ttl) {
                try {
                    long atl = facelet.getSource().openConnection().getLastModified();
                    return atl == 0L || atl > ttl;
                }
                catch (Exception e) {
                    throw new FaceletException("Error Checking Last Modified for " + facelet.getAlias(), e);
                }
            }
        }
        return false;
    }

    private DefaultFacelet createFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet for: " + url);
        }
        String alias = "/" + url.getFile().replaceFirst(this.baseUrl.getFile(), "");
        try {
            FaceletHandler h = this.compiler.compile(url, alias);
            DefaultFacelet f = new DefaultFacelet(this, this.compiler.createExpressionFactory(), url, alias, h);
            return f;
        }
        catch (FileNotFoundException fnfe) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning(alias + " not found at " + url.toExternalForm());
            }
            throw new FileNotFoundException("Facelet Not Found: " + url.toExternalForm());
        }
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }
}

