/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IllegalFormatFlagsException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.model.NoSqlFieldsModel;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.config.model.Translate;
import org.sagacity.sqltoy.model.inner.TranslateExtend;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.MacroIfLogic;
import org.sagacity.sqltoy.utils.ResultUtils;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoElasticUtils {
    protected static final Logger logger = LoggerFactory.getLogger(MongoElasticUtils.class);
    private static final String SQL_PSEUDO_START_MARK = "#[";
    public static final String SQL_PSEUDO_SYM_START_MARK = "[";
    private static final String MQL_PSEUDO_START_MARK = "<#>";
    private static final String SQL_PSEUDO_END_MARK = "]";
    private static final String MQL_PSEUDO_END_MARK = "</#>";
    private static final String BLANK = " ";
    public static final String BLANK_REGEX = "(?i)\\@blank\\s*\\(\\s*\\:[A-Za-z_0-9\\-]+\\s*\\)";
    public static final Pattern BLANK_PATTERN = Pattern.compile("(?i)\\@blank\\s*\\(\\s*\\:[A-Za-z_0-9\\-]+\\s*\\)");
    public static final String VALUE_REGEX = "(?i)\\@value\\s*\\(\\s*\\:[A-Za-z_0-9\\-]+\\s*\\)";
    public static final Pattern VALUE_PATTERN = Pattern.compile("(?i)\\@value\\s*\\(\\s*\\:[A-Za-z_0-9\\-]+\\s*\\)");

    private MongoElasticUtils() {
    }

    private static SqlToyResult wrapNoSql(SqlToyConfig sqlToyConfig, String[] paramNames, Object[] paramValues) {
        String mql = sqlToyConfig.getSql(null);
        String[] fullNames = null;
        fullNames = sqlToyConfig.getNoSqlConfigModel().isSqlMode() ? SqlConfigParseUtils.getSqlParamsName(mql, false) : SqlConfigParseUtils.getNoSqlParamsName(mql, false);
        Object[] fullParamValues = SqlConfigParseUtils.matchNamedParam(fullNames, paramNames, paramValues);
        SqlToyResult sqlToyResult = MongoElasticUtils.processNullConditions(mql, fullParamValues, sqlToyConfig.getNoSqlConfigModel().isSqlMode());
        MongoElasticUtils.processBlank(sqlToyResult);
        MongoElasticUtils.processValue(sqlToyResult);
        return sqlToyResult;
    }

    public static String wrapMql(SqlToyConfig sqlToyConfig, String[] paramNames, Object[] paramValues) {
        if (paramNames == null || paramNames.length == 0) {
            return sqlToyConfig.getSql(null);
        }
        SqlToyResult sqlToyResult = MongoElasticUtils.wrapNoSql(sqlToyConfig, paramNames, paramValues);
        if (sqlToyConfig.getNoSqlConfigModel().isSqlMode()) {
            return MongoElasticUtils.replaceSqlParams(sqlToyResult.getSql(), sqlToyResult.getParamsValue(), "'");
        }
        String mongoJson = MongoElasticUtils.replaceNoSqlParams(sqlToyResult.getSql(), sqlToyResult.getParamsValue(), "'").trim();
        if (!mongoJson.startsWith("{")) {
            mongoJson = "{".concat(mongoJson);
        }
        if (!mongoJson.endsWith("}")) {
            mongoJson = mongoJson.concat("}");
        }
        return mongoJson;
    }

    public static String wrapES(SqlToyConfig sqlToyConfig, String[] paramNames, Object[] paramValues) {
        if (paramNames == null || paramNames.length == 0) {
            return sqlToyConfig.getSql(null);
        }
        SqlToyResult sqlToyResult = MongoElasticUtils.wrapNoSql(sqlToyConfig, paramNames, paramValues);
        if (sqlToyConfig.getNoSqlConfigModel().isSqlMode()) {
            return MongoElasticUtils.replaceSqlParams(sqlToyResult.getSql(), sqlToyResult.getParamsValue(), "'");
        }
        String elasticJson = MongoElasticUtils.replaceNoSqlParams(sqlToyResult.getSql(), sqlToyResult.getParamsValue(), "\"").trim();
        if (!elasticJson.startsWith("{")) {
            elasticJson = "{".concat(elasticJson);
        }
        if (!elasticJson.endsWith("}")) {
            elasticJson = elasticJson.concat("}");
        }
        return elasticJson;
    }

    private static SqlToyResult processNullConditions(String queryStr, Object[] paramValues, boolean sqlMode) {
        SqlToyResult sqlToyResult = new SqlToyResult();
        sqlToyResult.setSql(queryStr);
        sqlToyResult.setParamsValue(paramValues);
        if (queryStr.indexOf(SQL_PSEUDO_START_MARK) == -1 && queryStr.indexOf(MQL_PSEUDO_START_MARK) == -1) {
            return sqlToyResult;
        }
        boolean isMqlMark = false;
        if (queryStr.indexOf(MQL_PSEUDO_START_MARK) != -1) {
            isMqlMark = true;
        }
        String startMark = isMqlMark ? MQL_PSEUDO_START_MARK : SQL_PSEUDO_START_MARK;
        String endMark = isMqlMark ? MQL_PSEUDO_END_MARK : SQL_PSEUDO_END_MARK;
        Pattern namedPattern = sqlMode ? SqlToyConstants.SQL_NAMED_PATTERN : SqlToyConstants.NOSQL_NAMED_PATTERN;
        int startMarkLength = startMark.length();
        int endMarkLength = endMark.length();
        int pseudoMarkStart = queryStr.indexOf(startMark);
        List paramValuesList = CollectionUtil.arrayToList(paramValues);
        boolean logicValue = true;
        while (pseudoMarkStart != -1) {
            int beginMarkIndex = queryStr.lastIndexOf(startMark);
            int endMarkIndex = startMark.equals(SQL_PSEUDO_START_MARK) ? StringUtil.getSymMarkIndex(SQL_PSEUDO_SYM_START_MARK, endMark, queryStr, beginMarkIndex) : StringUtil.getSymMarkIndex(startMark, endMark, queryStr, beginMarkIndex + startMarkLength);
            if (endMarkIndex == -1) {
                throw new IllegalFormatFlagsException("json\u67e5\u8be2\u8bed\u53e5\u4e2d\u7f3a\u4e4f:\"" + startMark + "\" \u76f8\u5bf9\u79f0\u7684:\"" + endMark + "\"\u7b26\u53f7,\u8bf7\u68c0\u67e5json\u67e5\u8be2\u8bed\u53e5\u683c\u5f0f!");
            }
            String preSql = queryStr.substring(0, beginMarkIndex).concat(BLANK);
            String markContentSql = BLANK.concat(queryStr.substring(beginMarkIndex + startMarkLength, endMarkIndex)).concat(BLANK);
            String tailSql = queryStr.substring(endMarkIndex + endMarkLength);
            int paramCnt = StringUtil.matchCnt(markContentSql, namedPattern);
            if (paramCnt == 0) {
                queryStr = preSql.concat(BLANK).concat(tailSql);
            } else {
                int preParamCnt = StringUtil.matchCnt(preSql, namedPattern);
                logicValue = true;
                int start = markContentSql.toLowerCase().indexOf("@if(");
                if (start > -1) {
                    int logicParamCnt;
                    int end = StringUtil.getSymMarkIndex("(", ")", markContentSql, start);
                    String evalStr = BLANK.concat(markContentSql.substring(markContentSql.indexOf("(", start) + 1, end));
                    logicValue = MacroIfLogic.evalLogic(evalStr, paramValuesList, preParamCnt, logicParamCnt = StringUtil.matchCnt(evalStr, namedPattern));
                    if (!logicValue) {
                        markContentSql = BLANK;
                        for (k = paramCnt; k > 0; --k) {
                            paramValuesList.remove(k + preParamCnt - 1);
                        }
                    } else {
                        markContentSql = markContentSql.substring(0, start).concat(markContentSql.substring(end + 1));
                        for (k = 0; k < logicParamCnt; ++k) {
                            paramValuesList.remove(preParamCnt);
                        }
                        paramCnt -= logicParamCnt;
                    }
                }
                if (logicValue) {
                    int beginIndex = 0;
                    int endIndex = 0;
                    for (int i = preParamCnt; i < preParamCnt + paramCnt; ++i) {
                        Object paramValue = paramValuesList.get(i);
                        beginIndex = endIndex;
                        endIndex = StringUtil.matchIndex(markContentSql.substring(beginIndex), namedPattern);
                        boolean isNull = false;
                        if (null == paramValue) {
                            isNull = true;
                        } else if (null != paramValue) {
                            if (paramValue.getClass().isArray() && CollectionUtil.convertArray(paramValue).length == 0) {
                                isNull = true;
                            } else if (paramValue instanceof Collection && ((Collection)paramValue).isEmpty()) {
                                isNull = true;
                            }
                        }
                        if (!isNull) continue;
                        markContentSql = BLANK;
                        for (int k = paramCnt; k > 0; --k) {
                            paramValuesList.remove(k + preParamCnt - 1);
                        }
                        break;
                    }
                }
                queryStr = sqlMode ? SqlConfigParseUtils.processWhereLinkAnd(preSql, markContentSql, tailSql) : preSql.concat(BLANK).concat(markContentSql).concat(BLANK).concat(tailSql);
            }
            pseudoMarkStart = queryStr.indexOf(startMark);
        }
        sqlToyResult.setSql(sqlMode ? queryStr : MongoElasticUtils.processComma(queryStr));
        sqlToyResult.setParamsValue(paramValuesList.toArray());
        return sqlToyResult;
    }

    private static void processBlank(SqlToyResult sqlToyResult) {
        if (null == sqlToyResult.getParamsValue() || sqlToyResult.getParamsValue().length == 0) {
            return;
        }
        String queryStr = sqlToyResult.getSql().toLowerCase();
        Matcher m = BLANK_PATTERN.matcher(queryStr);
        int index = 0;
        int paramCnt = 0;
        int blankCnt = 0;
        List paramValueList = null;
        while (m.find()) {
            if (blankCnt == 0) {
                paramValueList = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
            }
            index = m.start();
            paramCnt = StringUtil.matchCnt(queryStr.substring(0, index), SqlToyConstants.SQL_NAMED_PATTERN);
            paramValueList.remove(paramCnt - blankCnt);
            ++blankCnt;
        }
        if (blankCnt > 0) {
            sqlToyResult.setSql(sqlToyResult.getSql().replaceAll(BLANK_REGEX, BLANK));
            sqlToyResult.setParamsValue(paramValueList.toArray());
        }
    }

    private static void processValue(SqlToyResult sqlToyResult) {
        if (null == sqlToyResult.getParamsValue() || sqlToyResult.getParamsValue().length == 0) {
            return;
        }
        String queryStr = sqlToyResult.getSql().toLowerCase();
        Matcher m = VALUE_PATTERN.matcher(queryStr);
        int index = 0;
        int paramCnt = 0;
        int valueCnt = 0;
        List paramValueList = null;
        Object paramValue = null;
        while (m.find()) {
            if (valueCnt == 0) {
                paramValueList = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
            }
            index = m.start();
            paramCnt = StringUtil.matchCnt(queryStr.substring(0, index), SqlToyConstants.SQL_NAMED_PATTERN);
            paramValue = paramValueList.get(paramCnt - valueCnt);
            sqlToyResult.setSql(sqlToyResult.getSql().replaceFirst(VALUE_REGEX, paramValue == null ? "null" : paramValue.toString()));
            paramValueList.remove(paramCnt - valueCnt);
            ++valueCnt;
        }
        if (valueCnt > 0) {
            sqlToyResult.setParamsValue(paramValueList.toArray());
        }
    }

    public static String processComma(String sql) {
        String[] sqlSlice = sql.split("(?i)\\@(dot|comma)\\(\\s*\\)");
        if (sqlSlice.length == 1) {
            return sql;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < sqlSlice.length; ++i) {
            String fragment;
            if (i > 0) {
                result.append(" , ");
            }
            if ((fragment = sqlSlice[i].trim()).startsWith(",")) {
                fragment = fragment.substring(1);
            }
            if (fragment.endsWith(",")) {
                fragment = fragment.substring(0, fragment.length() - 1);
            }
            result.append(fragment);
        }
        return result.toString();
    }

    public static String replaceNoSqlParams(String sql, Object[] paramValues, String charSign) {
        if (paramValues == null || paramValues.length == 0) {
            return sql;
        }
        Matcher m = SqlToyConstants.NOSQL_NAMED_PATTERN.matcher(sql);
        StringBuilder realMql = new StringBuilder();
        int start = 0;
        int index = 0;
        boolean isAry = false;
        Object[] ary = null;
        while (m.find()) {
            String groupStr = m.group();
            realMql.append(sql.substring(start, m.start()));
            start = m.end();
            String method = groupStr.substring(1, groupStr.indexOf("(")).toLowerCase().trim();
            Object value = paramValues[index];
            if ("".equals(method) || "param".equals(method) || "value".equals(method)) {
                isAry = true;
                if (value.getClass().isArray()) {
                    ary = CollectionUtil.convertArray(value);
                } else if (value instanceof Collection) {
                    ary = ((Collection)value).toArray();
                } else {
                    ary = new Object[]{value};
                    isAry = false;
                }
                if (isAry) {
                    realMql.append(SQL_PSEUDO_SYM_START_MARK);
                }
                int i = 0;
                for (Object var : ary) {
                    if (i > 0) {
                        realMql.append(",");
                    }
                    if (var instanceof Number) {
                        realMql.append(var.toString());
                    } else if (var instanceof Date || var instanceof LocalDateTime) {
                        realMql.append(charSign).append(DateUtil.formatDate(var, "yyyy-MM-dd HH:mm:ss")).append(charSign);
                    } else if (var instanceof LocalDate) {
                        realMql.append(charSign).append(DateUtil.formatDate(var, "yyyy-MM-dd")).append(charSign);
                    } else if (var instanceof LocalTime) {
                        realMql.append(charSign).append(DateUtil.formatDate(var, "HH:mm:ss")).append(charSign);
                    } else {
                        realMql.append(charSign).append(MongoElasticUtils.removeDangerWords(var.toString())).append(charSign);
                    }
                    ++i;
                }
                if (isAry) {
                    realMql.append(SQL_PSEUDO_END_MARK);
                }
            }
            ++index;
        }
        realMql.append(sql.substring(start));
        return realMql.toString();
    }

    public static String replaceSqlParams(String sql, Object[] paramValues, String charSign) {
        if (paramValues == null || paramValues.length == 0) {
            return sql;
        }
        Matcher m = SqlToyConstants.SQL_NAMED_PATTERN.matcher(sql);
        StringBuilder realMql = new StringBuilder();
        int start = 0;
        int index = 0;
        Object[] ary = null;
        while (m.find()) {
            String group = m.group();
            realMql.append(sql.substring(start, m.start() + 1));
            start = m.end();
            Object value = paramValues[index];
            ary = value.getClass().isArray() ? CollectionUtil.convertArray(value) : (value instanceof Collection ? ((Collection)value).toArray() : new Object[]{value});
            int i = 0;
            for (Object var : ary) {
                if (i > 0) {
                    realMql.append(",");
                }
                if (var instanceof Number) {
                    realMql.append(var.toString());
                } else if (var instanceof Date || var instanceof LocalDateTime) {
                    realMql.append(charSign).append(DateUtil.formatDate(var, "yyyy-MM-dd HH:mm:ss")).append(charSign);
                } else if (var instanceof LocalDate) {
                    realMql.append(charSign).append(DateUtil.formatDate(var, "yyyy-MM-dd")).append(charSign);
                } else if (var instanceof LocalTime) {
                    realMql.append(charSign).append(DateUtil.formatDate(var, "HH:mm:ss")).append(charSign);
                } else {
                    realMql.append(charSign).append(MongoElasticUtils.removeDangerWords(var.toString())).append(charSign);
                }
                ++i;
            }
            ++index;
            if (!StringUtil.matches(group, SqlToyConstants.BLANK_END)) continue;
            realMql.append(BLANK);
        }
        realMql.append(sql.substring(start));
        return realMql.toString();
    }

    private static String removeDangerWords(String paramValue) {
        return paramValue.replaceAll("(\"|'|\\{|\\[|\\}|\\]|\\$|&quot;)", "");
    }

    public static void processTranslate(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, List resultSet, String[] fields) {
        HashMap<String, Translate> translateMap = sqlToyConfig.getTranslateMap();
        HashMap<String, HashMap<String, Object[]>> translateCache = null;
        if (!sqlToyConfig.getTranslateMap().isEmpty()) {
            translateCache = sqlToyContext.getTranslateManager().getTranslates(translateMap);
            if (translateCache == null || translateCache.isEmpty()) {
                logger.warn("mongo or elastic cache:{} has no data!{}", translateMap.keySet(), (Object)sqlToyConfig.getSql());
            } else {
                translateMap = ResultUtils.wrapI18nIndex(sqlToyContext.getTranslateManager(), translateMap);
                MongoElasticUtils.translate(translateCache, translateMap, resultSet, null, fields);
            }
        }
    }

    private static void translate(HashMap<String, HashMap<String, Object[]>> translateCache, HashMap<String, Translate> translateMap, List<List> dataSet, Map dataMap, String[] fields) {
        TranslateExtend extend;
        int i;
        if (translateMap == null || translateMap.isEmpty()) {
            return;
        }
        if ((dataSet == null || dataSet.isEmpty()) && (dataMap == null || dataMap.isEmpty())) {
            return;
        }
        int[] cacheMapIndex = new int[translateMap.size()];
        int[] realIndex = new int[translateMap.size()];
        String[] lables = new String[translateMap.size()];
        int index = 0;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (i = 0; i < fields.length; ++i) {
            map.put(fields[i].toLowerCase(), i);
        }
        for (i = 0; i < fields.length; ++i) {
            String field = fields[i].toLowerCase();
            if (!translateMap.containsKey(field)) continue;
            extend = translateMap.get(field).getExtend();
            cacheMapIndex[index] = i;
            realIndex[index] = (Integer)map.get(extend.alias);
            lables[index] = field;
            ++index;
        }
        if (dataSet != null) {
            int size = dataSet.size();
            for (int i2 = 0; i2 < cacheMapIndex.length; ++i2) {
                int colIndex = cacheMapIndex[i2];
                HashMap<String, Object[]> keyValues = translateCache.get(lables[i2]);
                extend = translateMap.get(lables[i2]).getExtend();
                int cacheIndex = extend.index;
                for (int j = 0; j < size; ++j) {
                    Object[] translateAry;
                    Object value = dataSet.get(j).get(realIndex[i2]);
                    if (value == null || null == (translateAry = keyValues.get(value.toString()))) continue;
                    dataSet.get(j).set(colIndex, keyValues.get(value.toString())[cacheIndex]);
                }
            }
        } else {
            for (int i3 = 0; i3 < cacheMapIndex.length; ++i3) {
                Object[] translateAry;
                HashMap<String, Object[]> keyValues = translateCache.get(lables[i3]);
                extend = translateMap.get(lables[i3]).getExtend();
                int cacheIndex = extend.index;
                Object value = dataMap.get(extend.alias);
                if (value == null || null == (translateAry = keyValues.get(value.toString()))) continue;
                dataMap.put(lables[i3], keyValues.get(value.toString())[cacheIndex]);
            }
        }
    }

    public static NoSqlFieldsModel processFields(String[] fields, HashMap<String, String[]> fieldMap) {
        NoSqlFieldsModel result = new NoSqlFieldsModel();
        String[] realFields = new String[fields.length];
        String[] aliasFields = new String[fields.length];
        int aliasIndex = 0;
        for (int i = 0; i < fields.length; ++i) {
            realFields[i] = fields[i];
            aliasFields[i] = fields[i];
            aliasIndex = fields[i].indexOf(":");
            if (aliasIndex != -1) {
                realFields[i] = fields[i].substring(0, aliasIndex).trim();
                aliasFields[i] = fields[i].substring(aliasIndex + 1).trim();
            } else {
                aliasIndex = fields[i].lastIndexOf(".");
                if (aliasIndex != -1) {
                    aliasFields[i] = fields[i].substring(aliasIndex + 1).trim();
                }
            }
            if (fieldMap == null || !realFields[i].contains(".")) continue;
            fieldMap.put(realFields[i], realFields[i].split("\\."));
        }
        result.setFields(realFields);
        result.setAliasLabels(aliasFields);
        return result;
    }
}

