/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.secure.impl;

import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.sagacity.sqltoy.plugins.secure.FieldsSecureProvider;
import org.sagacity.sqltoy.utils.FileUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class FieldsRSASecureProvider
implements FieldsSecureProvider {
    private String CHARSET = "UTF-8";
    private RSAPrivateKey privateKey;
    private RSAPublicKey publicKey;
    private static final String ALGORITHM_RSA = "RSA";
    private Cipher encryptCipher;
    private Cipher decryptCipher;

    @Override
    public void initialize(String charset, String privateKeyStr, String publicKeyStr) throws Exception {
        String string = this.CHARSET = StringUtil.isBlank(charset) ? "UTF-8" : charset;
        if (StringUtil.isBlank(privateKeyStr) || StringUtil.isBlank(publicKeyStr)) {
            throw new IllegalArgumentException("\u8bf7\u6b63\u786e\u7ef4\u62a4RSA\u7684\u79c1\u94a5\u548c\u516c\u94a5!spring.sqltoy.securePrivateKey \u548c securePublicKey");
        }
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        this.privateKey = (RSAPrivateKey)keyFactory.generatePrivate(this.getPrivateKeySpec(privateKeyStr));
        this.publicKey = (RSAPublicKey)keyFactory.generatePublic(this.getPublicKeySpec(publicKeyStr));
        this.encryptCipher = Cipher.getInstance(ALGORITHM_RSA);
        this.encryptCipher.init(1, this.publicKey);
        this.decryptCipher = Cipher.getInstance(ALGORITHM_RSA);
        this.decryptCipher.init(2, this.privateKey);
    }

    private X509EncodedKeySpec getPublicKeySpec(String keyStr) throws Exception {
        byte[] keyBytes;
        if (keyStr.toLowerCase().trim().startsWith("classpath:")) {
            String contents = FileUtil.readFileAsStr(keyStr, this.CHARSET);
            if (StringUtil.isBlank(contents)) {
                throw new Exception("publicKey\u6587\u4ef6\u5185\u5bb9\u8bfb\u53d6\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u7f16\u8bd1\u5230classes\u76ee\u5f55\u4e0b!");
            }
            keyBytes = Base64.getDecoder().decode(contents.trim().replaceAll("\r|\n", ""));
        } else {
            keyBytes = Base64.getDecoder().decode(keyStr.trim());
        }
        return new X509EncodedKeySpec(keyBytes);
    }

    private PKCS8EncodedKeySpec getPrivateKeySpec(String keyStr) throws Exception {
        byte[] keyBytes;
        if (keyStr.toLowerCase().trim().startsWith("classpath:")) {
            String contents = FileUtil.readFileAsStr(keyStr, this.CHARSET);
            if (StringUtil.isBlank(contents)) {
                throw new Exception("privateKey\u6587\u4ef6\u5185\u5bb9\u8bfb\u53d6\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u7f16\u8bd1\u5230classes\u76ee\u5f55\u4e0b!");
            }
            keyBytes = Base64.getDecoder().decode(contents.trim().replaceAll("\r|\n", ""));
        } else {
            keyBytes = Base64.getDecoder().decode(keyStr.trim());
        }
        return new PKCS8EncodedKeySpec(keyBytes);
    }

    @Override
    public String encrypt(String contents) {
        try {
            byte[] result = this.encryptCipher.doFinal(contents.getBytes(this.CHARSET));
            return Base64.getEncoder().encodeToString(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String decrypt(String secureContents) {
        try {
            byte[] result = this.decryptCipher.doFinal(Base64.getDecoder().decode(secureContents));
            return new String(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

