/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.calculator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sagacity.sqltoy.config.model.LabelIndexModel;
import org.sagacity.sqltoy.config.model.TreeSortModel;
import org.sagacity.sqltoy.plugins.utils.CalculateUtils;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.MacroIfLogic;
import org.sagacity.sqltoy.utils.StringUtil;

public class TreeDataSort {
    public static void process(TreeSortModel treeTableSortModel, LabelIndexModel labelIndexMap, List treeList) {
        if (treeList == null || treeList.isEmpty()) {
            return;
        }
        Integer idColIndex = labelIndexMap.get(treeTableSortModel.getIdColumn());
        Integer pidColIndex = labelIndexMap.get(treeTableSortModel.getPidColumn());
        if (idColIndex == null || pidColIndex == null) {
            throw new RuntimeException("\u5bf9\u6811\u5f62\u7ed3\u6784\u6570\u636e\u8fdb\u884c\u6392\u5e8f,\u672a\u6b63\u786e\u6307\u5b9aid-column\u548cpid-column!");
        }
        int dataWidth = ((List)treeList.get(0)).size();
        List<Integer> sumColList = CalculateUtils.parseColumns(labelIndexMap, treeTableSortModel.getSumColumns(), dataWidth);
        TreeDataSort.sortTree(treeList, idColIndex, pidColIndex);
        if (!sumColList.isEmpty()) {
            Integer[] sumIndexes = new Integer[sumColList.size()];
            sumColList.toArray(sumIndexes);
            TreeDataSort.summaryTreeList(treeTableSortModel, labelIndexMap, treeList, sumIndexes, idColIndex, pidColIndex);
        }
        if (StringUtil.isNotBlank(treeTableSortModel.getLevelOrderColumn())) {
            Integer sortColIndex = labelIndexMap.get(treeTableSortModel.getLevelOrderColumn());
            if (sortColIndex == null) {
                throw new RuntimeException("\u5bf9\u6811\u5f62\u7ed3\u6784\u6bcf\u5c42\u7ea7\u5185\u90e8\u8fdb\u884c\u6392\u5e8f\uff0c\u672a\u6b63\u786e\u6307\u5b9a\u5c42\u7ea7\u6392\u5e8f\u4f9d\u636e\u7684\u5217:levelOrderColumn=" + treeTableSortModel.getLevelOrderColumn() + "!");
            }
            int dataType = CollectionUtil.getSortDataType(treeList, sortColIndex);
            boolean desc = treeTableSortModel.getOrderWay().equalsIgnoreCase("desc");
            CollectionUtil.sortList(treeList, sortColIndex, dataType, 0, treeList.size() - 1, !desc);
            TreeDataSort.sortTree(treeList, idColIndex, pidColIndex);
        }
    }

    private static void sortTree(List treeList, Integer idColIndex, Integer pidColIndex) {
        Set topPids = TreeDataSort.getTopPids(treeList, idColIndex, pidColIndex);
        ArrayList result = new ArrayList();
        for (int i = 0; i < treeList.size(); ++i) {
            List row = (List)treeList.get(i);
            if (!topPids.contains(row.get(pidColIndex))) continue;
            result.add(row);
            treeList.remove(i);
            --i;
        }
        int beginIndex = 0;
        int addCount = 0;
        while (treeList.size() != 0) {
            addCount = 0;
            Object idValue = ((List)result.get(beginIndex)).get(idColIndex);
            for (int i = 0; i < treeList.size(); ++i) {
                Object pidValue = ((List)treeList.get(i)).get(pidColIndex);
                if (!idValue.equals(pidValue)) continue;
                result.add(beginIndex + addCount + 1, treeList.get(i));
                treeList.remove(i);
                ++addCount;
                --i;
            }
            if (++beginIndex + 1 <= result.size()) continue;
        }
        treeList.clear();
        treeList.addAll(result);
    }

    public static Set getTopPids(List treeList, int idIndex, int pidIndex) {
        HashSet idSet = new HashSet();
        HashSet pidSet = new HashSet();
        int n = treeList.size();
        for (int i = 0; i < n; ++i) {
            List row = (List)treeList.get(i);
            idSet.add(row.get(idIndex));
            pidSet.add(row.get(pidIndex));
        }
        HashSet topPids = new HashSet();
        for (Object pid : pidSet) {
            if (idSet.contains(pid)) continue;
            topPids.add(pid);
        }
        return topPids;
    }

    public static void summaryTreeList(TreeSortModel treeTableSortModel, LabelIndexModel labelIndexMap, List treeList, Integer[] sumIndexes, Integer idColIndex, Integer pidColIndex) {
        boolean hasFilter = false;
        if (StringUtil.isNotBlank(treeTableSortModel.getFilterColumn()) && StringUtil.isNotBlank(treeTableSortModel.getCompareValues()) && StringUtil.isNotBlank(treeTableSortModel.getCompareType())) {
            hasFilter = true;
        }
        boolean doSum = true;
        block0: for (int i = treeList.size() - 1; i > 0; --i) {
            List idRow = (List)treeList.get(i);
            Object pid = idRow.get(pidColIndex);
            doSum = true;
            if (hasFilter) {
                Object filterValue = idRow.get(labelIndexMap.get(treeTableSortModel.getFilterColumn()));
                doSum = MacroIfLogic.compare(filterValue, treeTableSortModel.getCompareType(), treeTableSortModel.getCompareValues());
            }
            if (!doSum) continue;
            for (int j = i - 1; j >= 0; --j) {
                List pidRow = (List)treeList.get(j);
                Object id = pidRow.get(idColIndex);
                if (!id.equals(pid)) continue;
                Integer[] integerArray = sumIndexes;
                int n = integerArray.length;
                for (int k = 0; k < n; ++k) {
                    int sumIndex = integerArray[k];
                    Object pidCellValue = pidRow.get(sumIndex);
                    Object idCellValue = idRow.get(sumIndex);
                    if (pidCellValue == null) {
                        if (idCellValue == null) {
                            pidRow.set(sumIndex, BigDecimal.ZERO);
                            continue;
                        }
                        pidRow.set(sumIndex, new BigDecimal(idCellValue.toString().replace(",", "")));
                        continue;
                    }
                    if (pidCellValue instanceof BigDecimal) {
                        if (idCellValue == null) continue;
                        pidRow.set(sumIndex, ((BigDecimal)pidCellValue).add(new BigDecimal(idCellValue.toString().replace(",", ""))));
                        continue;
                    }
                    if (idCellValue != null) {
                        pidRow.set(sumIndex, new BigDecimal(pidCellValue.toString().replace(",", "")).add(new BigDecimal(idCellValue.toString().replace(",", ""))));
                        continue;
                    }
                    pidRow.set(sumIndex, new BigDecimal(pidCellValue.toString().replace(",", "")));
                }
                continue block0;
            }
        }
    }
}

