/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.integration.impl;

import com.mongodb.client.MongoCollection;
import java.util.List;
import org.bson.Document;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.integration.MongoQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;

public class SpringMongoQuery
implements MongoQuery {
    protected final Logger logger = LoggerFactory.getLogger(SpringMongoQuery.class);
    private MongoTemplate mongoTemplate;

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.mongoTemplate.getCollection(collectionName);
    }

    @Override
    public <T> List<T> find(String mql, Class<T> entityClass, String collectionName, Long skip, Integer limit) {
        BasicQuery query = new BasicQuery(mql);
        if (skip != null && skip >= 0L) {
            query.skip(skip.longValue());
        }
        if (limit != null && limit > 0) {
            query.limit(limit.intValue());
        }
        this.logger.debug("findByMongo script=" + query.getQueryObject());
        return this.mongoTemplate.find((Query)query, entityClass, collectionName);
    }

    @Override
    public long count(String query, String collectionName) {
        return this.mongoTemplate.count((Query)new BasicQuery(query), collectionName);
    }

    @Override
    public void initialize(SqlToyContext sqlToyContext) {
        if (this.mongoTemplate == null) {
            this.mongoTemplate = sqlToyContext.getAppContext().getBean(MongoTemplate.class);
        }
    }
}

