/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.utils;

import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sagacity.sqltoy.SqlExecuteStat;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.PreparedStatementResultHandler;
import org.sagacity.sqltoy.callback.ReflectPropsHandler;
import org.sagacity.sqltoy.callback.UpdateRowHandler;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.dialect.utils.SqlServerDialectUtils;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.model.ColumnMeta;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.TableMeta;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.plugins.IUnifyFieldsHandler;
import org.sagacity.sqltoy.plugins.UnifyUpdateFieldsController;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.ResultUtils;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.SqlUtilsExt;
import org.sagacity.sqltoy.utils.StringUtil;

public class DefaultDialectUtils {
    public static QueryResult getRandomResult(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long totalCount, Long randomCount, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        StringBuilder sql = new StringBuilder();
        String innerSql = sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect);
        innerSql = SqlUtilsExt.markOriginalSql(innerSql);
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        sql.append("select " + SqlToyConstants.INTERMEDIATE_TABLE1 + ".* from (");
        if (DialectUtils.hasOrderByOrUnion(innerSql)) {
            sql.append("select rand() as sag_row_number," + SqlToyConstants.INTERMEDIATE_TABLE + ".* from (");
            sql.append(innerSql);
            sql.append(") ");
            sql.append(SqlToyConstants.INTERMEDIATE_TABLE);
            sql.append(" ");
        } else {
            sql.append(innerSql.replaceFirst("(?i)select", "select rand() as sag_row_number,"));
        }
        sql.append(" )  as " + SqlToyConstants.INTERMEDIATE_TABLE1);
        sql.append(" order by " + SqlToyConstants.INTERMEDIATE_TABLE1 + ".sag_row_number limit ");
        sql.append(randomCount);
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), null, null, dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.random : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    public static QueryResult findPageBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long pageNo, Integer pageSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        StringBuilder sql = new StringBuilder();
        String innerSql = sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect);
        innerSql = SqlUtilsExt.markOriginalSql(innerSql);
        boolean isNamed = sqlToyConfig.isNamedParam();
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        sql.append(innerSql);
        sql.append(" limit ");
        sql.append(isNamed ? ":pageFirstParamName" : "?");
        boolean useDefault = true;
        if (dbType == 0 && !sqlToyContext.isDefaultPageOffset()) {
            useDefault = false;
        }
        if (useDefault) {
            sql.append(" offset ");
        } else {
            sql.append(" , ");
        }
        sql.append(isNamed ? ":pageLastParamName" : "?");
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        Long startIndex = (pageNo - 1L) * (long)pageSize.intValue();
        Number start = startIndex.intValue();
        if (startIndex > Integer.MAX_VALUE) {
            start = startIndex;
        }
        SqlToyResult queryParam = useDefault ? DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), pageSize, start, dialect) : DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), start, pageSize, dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.page : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    public static QueryResult findTopBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Integer topSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        StringBuilder sql = new StringBuilder();
        String innerSql = sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect);
        innerSql = SqlUtilsExt.markOriginalSql(innerSql);
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        sql.append(innerSql);
        sql.append(" limit ");
        sql.append(topSize);
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), null, null, dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.top : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    public static Long deleteAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, Connection conn, Integer dbType, Boolean autoCommit, String tableName) throws Exception {
        if (null == entities || entities.isEmpty()) {
            return 0L;
        }
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (null == entityMeta.getIdArray() || entityMeta.getIdArray().length == 0) {
            throw new IllegalArgumentException("delete/deleteAll \u64cd\u4f5c,\u8868:" + realTable + "\u6ca1\u6709\u4e3b\u952e,\u8bf7\u68c0\u67e5\u8868\u8bbe\u8ba1!");
        }
        int idSize = entityMeta.getIdArray().length;
        StringBuilder deleteSql = new StringBuilder();
        if (dbType == 60) {
            deleteSql.append("alter table ");
            deleteSql.append(realTable);
            deleteSql.append(" delete where ");
        } else {
            deleteSql.append("delete from ");
            deleteSql.append(realTable);
            deleteSql.append(" where ");
        }
        SqlToyResult sqlToyResult = null;
        if (idSize == 1) {
            idValues = BeanUtil.sliceToArray(entities, entityMeta.getIdArray()[0]);
            if (idValues == null || ((Object)idValues).length == 0) {
                throw new IllegalArgumentException(tableName + " deleteAll method must assign value for pk field:" + entityMeta.getIdArray()[0]);
            }
            String field = entityMeta.getIdArray()[0];
            String colName = ReservedWordsUtil.convertWord(entityMeta.getColumnName(field), dbType);
            deleteSql.append(colName);
            deleteSql.append(" in (?) ");
            sqlToyResult = SqlConfigParseUtils.processSql(deleteSql.toString(), null, new Object[]{idValues}, null);
        } else {
            int i;
            idValues = BeanUtil.reflectBeansToInnerAry(entities, entityMeta.getIdArray(), null, null);
            int dataSize = idValues.size();
            Object[] realValues = new Object[idValues.size() * idSize];
            int index = 0;
            for (int i2 = 0; i2 < dataSize; ++i2) {
                Object[] rowData = (Object[])idValues.get(i2);
                for (int j = 0; j < idSize; ++j) {
                    Object cellValue = rowData[j];
                    if (StringUtil.isBlank(cellValue)) {
                        throw new IllegalArgumentException(tableName + " deleteAll method must assign value for pk,row:" + i2 + " pk field:" + entityMeta.getIdArray()[j]);
                    }
                    realValues[index] = cellValue;
                    ++index;
                }
            }
            String condition = " (";
            int n = idSize;
            for (i = 0; i < n; ++i) {
                String field = entityMeta.getIdArray()[i];
                String colName = ReservedWordsUtil.convertWord(entityMeta.getColumnName(field), dbType);
                if (i > 0) {
                    condition = condition.concat(" and ");
                }
                condition = condition.concat(colName).concat("=?");
            }
            condition = condition.concat(")");
            for (i = 0; i < dataSize; ++i) {
                if (i > 0) {
                    deleteSql.append(" or ");
                }
                deleteSql.append(condition);
            }
            sqlToyResult = SqlConfigParseUtils.processSql(deleteSql.toString(), null, realValues, null);
        }
        SqlToyConfig sqlToyConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
        sqlToyConfig.setSqlType(SqlType.delete);
        sqlToyConfig.setSql(sqlToyResult.getSql());
        sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.execute, sqlToyResult, entities.get(0).getClass(), dbType);
        return SqlUtil.executeSql(sqlToyContext.getTypeHandler(), sqlToyResult.getSql(), sqlToyResult.getParamsValue(), null, conn, dbType, autoCommit, false);
    }

    public static Serializable updateSaveFetch(final SqlToyContext sqlToyContext, final Serializable entity, final UpdateRowHandler updateRowHandler, String[] uniqueProps, final Connection conn, final Integer dbType, String dialect, String tableName) throws Exception {
        final EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        String[] whereFields = uniqueProps;
        if (whereFields == null || whereFields.length == 0) {
            whereFields = entityMeta.getIdArray();
        }
        if (whereFields == null || whereFields.length == 0) {
            throw new DataAccessException("updateSaveFetch\u64cd\u4f5c\u7684\u8868:" + tableName + " \u6ca1\u6709\u552f\u4e00\u83b7\u5f97\u4e00\u6761\u8bb0\u5f55\u7684\u6761\u4ef6\u5b57\u6bb5,\u8bf7\u68c0\u67e5!");
        }
        Object[] tempFieldValues = null;
        Object[] whereParamValues = BeanUtil.reflectBeanToAry(entity, whereFields);
        for (int i = 0; i < whereParamValues.length; ++i) {
            if (!StringUtil.isBlank(whereParamValues[i])) continue;
            tempFieldValues = DefaultDialectUtils.processFieldValues(sqlToyContext, entityMeta, entity);
            whereParamValues = BeanUtil.reflectBeanToAry(entity, whereFields);
            break;
        }
        final IUnifyFieldsHandler unifyFieldsHandler = UnifyUpdateFieldsController.useUnifyFields() ? sqlToyContext.getUnifyFieldsHandler() : null;
        final Object[] fieldValues = tempFieldValues;
        final boolean hasUpdateRow = updateRowHandler != null;
        String sql = DefaultDialectUtils.wrapFetchSql(entityMeta, dbType, whereFields, tableName);
        SqlToyResult queryParam = new SqlToyResult(sql, whereParamValues);
        queryParam = DialectUtils.doInterceptors(sqlToyContext, null, OperateType.singleTable, queryParam, entity.getClass(), dbType);
        SqlExecuteStat.showSql("\u6267\u884c\u9501\u8bb0\u5f55\u67e5\u8be2", queryParam.getSql(), queryParam.getParamsValue());
        PreparedStatement pst = conn.prepareStatement(queryParam.getSql(), 1003, 1008);
        List updateResult = (List)SqlUtil.preparedStatementProcess(queryParam.getParamsValue(), pst, null, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object rowData, PreparedStatement pst, ResultSet rs) throws Exception {
                SqlUtil.setParamsValue(sqlToyContext.getTypeHandler(), conn, dbType, pst, (Object[])rowData, null, 0);
                ResultSet finalRs = pst.executeQuery();
                int rowCnt = finalRs.getMetaData().getColumnCount();
                int index = 0;
                ArrayList<List> result = new ArrayList<List>();
                while (finalRs.next()) {
                    if (index > 0) {
                        throw new DataAccessException("updateSaveFetch\u64cd\u4f5c\u53ea\u80fd\u9488\u5bf9\u5355\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c,\u8bf7\u68c0\u67e5uniqueProps\u53c2\u6570\u8bbe\u7f6e!");
                    }
                    if (hasUpdateRow) {
                        SqlExecuteStat.debug("\u6267\u884cupdateRow", "\u8bb0\u5f55\u5b58\u5728\u8c03\u7528updateRowHandler.updateRow!", new Object[0]);
                        updateRowHandler.updateRow(finalRs, index);
                        updateRowHandler.updateRow(finalRs, index, (fieldName, fieldValue) -> Optional.ofNullable(entityMeta.getFieldMeta((String)fieldName)).ifPresent(fieldMeta -> {
                            try {
                                DefaultDialectUtils.resultUpdate(conn, finalRs, fieldMeta, fieldValue, dbType, false);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }));
                        if (unifyFieldsHandler != null && unifyFieldsHandler.updateUnifyFields() != null) {
                            Map<String, Object> updateProps = unifyFieldsHandler.updateUnifyFields();
                            for (Map.Entry<String, Object> entry : updateProps.entrySet()) {
                                String field = entry.getKey();
                                Object fieldValue2 = entry.getValue();
                                FieldMeta fieldMeta = entityMeta.getFieldMeta(field);
                                if (fieldMeta == null) continue;
                                if (unifyFieldsHandler.forceUpdateFields() != null && unifyFieldsHandler.forceUpdateFields().contains(field)) {
                                    DefaultDialectUtils.resultUpdate(conn, finalRs, fieldMeta, fieldValue2, dbType, false);
                                    continue;
                                }
                                Object pojoFieldValue = BeanUtil.getProperty(entity, field);
                                if (pojoFieldValue != null) {
                                    fieldValue2 = pojoFieldValue;
                                }
                                DefaultDialectUtils.resultUpdate(conn, finalRs, fieldMeta, fieldValue2, dbType, false);
                            }
                        }
                        finalRs.updateRow();
                    }
                    ++index;
                    result.add(ResultUtils.processResultRow(finalRs, 0, rowCnt, false));
                }
                if (index == 0) {
                    SqlExecuteStat.debug("\u6267\u884cinsertRow", "\u67e5\u8be2\u672a\u5339\u914d\u5230\u7ed3\u679c\u5219\u8fdb\u884c\u9996\u6b21\u63d2\u5165!", new Object[0]);
                    finalRs.moveToInsertRow();
                    Object[] fullFieldvalues = fieldValues == null ? DefaultDialectUtils.processFieldValues(sqlToyContext, entityMeta, entity) : fieldValues;
                    for (int i = 0; i < entityMeta.getFieldsArray().length; ++i) {
                        FieldMeta fieldMeta = entityMeta.getFieldMeta(entityMeta.getFieldsArray()[i]);
                        DefaultDialectUtils.resultUpdate(conn, finalRs, fieldMeta, fullFieldvalues[i], dbType, true);
                    }
                    finalRs.insertRow();
                }
                this.setResult(result);
            }
        });
        if (updateResult == null || updateResult.isEmpty()) {
            return entity;
        }
        List rowList = (List)updateResult.get(0);
        for (int i = 0; i < entityMeta.getFieldsArray().length; ++i) {
            BeanUtil.setProperty(entity, entityMeta.getFieldsArray()[i], rowList.get(i));
        }
        return entity;
    }

    private static void resultUpdate(Connection conn, ResultSet rs, FieldMeta fieldMeta, Object paramValue, Integer dbType, boolean isInsert) throws Exception {
        if (!fieldMeta.isPK() && isInsert) {
            paramValue = SqlUtilsExt.getDefaultValue(paramValue, fieldMeta.getDefaultValue(), fieldMeta.getType(), fieldMeta.isNullable());
        }
        if (paramValue == null) {
            return;
        }
        int jdbcType = fieldMeta.getType();
        String columnName = fieldMeta.getColumnName();
        if (paramValue instanceof String) {
            String tmpStr = (String)paramValue;
            if (jdbcType == 2005) {
                if (10 == dbType || 20 == dbType || 100 == dbType || 11 == dbType || 110 == dbType || 120 == dbType) {
                    Clob clob = conn.createClob();
                    clob.setString(1L, tmpStr);
                    rs.updateClob(columnName, clob);
                } else {
                    rs.updateString(columnName, tmpStr);
                }
            } else if (jdbcType == 2011) {
                if (10 == dbType || 20 == dbType || 100 == dbType || 11 == dbType || 110 == dbType || 120 == dbType) {
                    NClob nclob = conn.createNClob();
                    nclob.setString(1L, tmpStr);
                    rs.updateNClob(columnName, nclob);
                } else {
                    rs.updateString(columnName, tmpStr);
                }
            } else {
                rs.updateString(columnName, tmpStr);
            }
        } else if (paramValue instanceof Integer) {
            Integer paramInt = (Integer)paramValue;
            if (jdbcType == 16) {
                if (paramInt == 1) {
                    rs.updateBoolean(columnName, true);
                } else {
                    rs.updateBoolean(columnName, false);
                }
            } else {
                rs.updateInt(columnName, (int)paramInt);
            }
        } else if (paramValue instanceof LocalDateTime) {
            rs.updateTimestamp(columnName, Timestamp.valueOf((LocalDateTime)paramValue));
        } else if (paramValue instanceof BigDecimal) {
            rs.updateBigDecimal(columnName, (BigDecimal)paramValue);
        } else if (paramValue instanceof LocalDate) {
            rs.updateDate(columnName, Date.valueOf((LocalDate)paramValue));
        } else if (paramValue instanceof Timestamp) {
            rs.updateTimestamp(columnName, (Timestamp)paramValue);
        } else if (paramValue instanceof java.util.Date) {
            if (dbType == 60) {
                rs.updateDate(columnName, new Date(((java.util.Date)paramValue).getTime()));
            } else {
                rs.updateTimestamp(columnName, new Timestamp(((java.util.Date)paramValue).getTime()));
            }
        } else if (paramValue instanceof BigInteger) {
            rs.updateBigDecimal(columnName, new BigDecimal((BigInteger)paramValue));
        } else if (paramValue instanceof Double) {
            rs.updateDouble(columnName, (double)((Double)paramValue));
        } else if (paramValue instanceof Long) {
            rs.updateLong(columnName, (long)((Long)paramValue));
        } else if (paramValue instanceof Clob) {
            String tmpStr = SqlUtil.clobToString((Clob)paramValue);
            rs.updateString(columnName, tmpStr);
        } else if (paramValue instanceof byte[]) {
            if (jdbcType == 2004) {
                Blob blob = null;
                try {
                    blob = conn.createBlob();
                    OutputStream out = blob.setBinaryStream(1L);
                    out.write((byte[])paramValue);
                    out.flush();
                    out.close();
                    rs.updateBlob(columnName, blob);
                }
                catch (Exception e) {
                    rs.updateBytes(columnName, (byte[])paramValue);
                }
            } else {
                rs.updateBytes(columnName, (byte[])paramValue);
            }
        } else if (paramValue instanceof Float) {
            rs.updateFloat(columnName, ((Float)paramValue).floatValue());
        } else if (paramValue instanceof Blob) {
            Blob tmp = (Blob)paramValue;
            rs.updateBytes(columnName, tmp.getBytes(0L, Long.valueOf(tmp.length()).intValue()));
        } else if (paramValue instanceof Date) {
            rs.updateDate(columnName, (Date)paramValue);
        } else if (paramValue instanceof Boolean) {
            if (jdbcType == 12 || jdbcType == 1) {
                rs.updateString(columnName, (Boolean)paramValue != false ? "1" : "0");
            } else if (jdbcType == 4 || jdbcType == 5 || jdbcType == -6) {
                rs.updateInt(columnName, (Boolean)paramValue != false ? 1 : 0);
            } else {
                rs.updateBoolean(columnName, (boolean)((Boolean)paramValue));
            }
        } else if (paramValue instanceof LocalTime) {
            rs.updateTime(columnName, Time.valueOf((LocalTime)paramValue));
        } else if (paramValue instanceof Time) {
            rs.updateTime(columnName, (Time)paramValue);
        } else if (paramValue instanceof Character) {
            String tmpStr = ((Character)paramValue).toString();
            rs.updateString(columnName, tmpStr);
        } else if (paramValue instanceof Short) {
            rs.updateShort(columnName, (short)((Short)paramValue));
        } else if (paramValue instanceof Byte) {
            rs.updateByte(columnName, (byte)((Byte)paramValue));
        } else if (paramValue instanceof Object[]) {
            DefaultDialectUtils.setArray(dbType, conn, rs, columnName, paramValue);
        } else if (paramValue instanceof Enum) {
            rs.updateObject(columnName, BeanUtil.getEnumValue(paramValue));
        } else if (paramValue instanceof Collection) {
            Object[] values = ((Collection)paramValue).toArray();
            if (values.length > 0) {
                String type = null;
                for (Object val : values) {
                    if (val == null) continue;
                    type = val.getClass().getName().concat("[]");
                    break;
                }
                if (type != null) {
                    DefaultDialectUtils.setArray(dbType, conn, rs, columnName, BeanUtil.convertArray(values, type));
                }
            }
        } else if (jdbcType != 0) {
            rs.updateObject(columnName, paramValue, jdbcType);
        } else {
            rs.updateObject(columnName, paramValue);
        }
    }

    private static void setArray(Integer dbType, Connection conn, ResultSet rs, String columnName, Object paramValue) throws SQLException {
        if (dbType == 70) {
            if (paramValue instanceof Integer[]) {
                Array array = conn.createArrayOf("INTEGER", (Integer[])paramValue);
                rs.updateArray(columnName, array);
            } else if (paramValue instanceof String[]) {
                Array array = conn.createArrayOf("VARCHAR", (String[])paramValue);
                rs.updateArray(columnName, array);
            } else if (paramValue instanceof BigDecimal[]) {
                Array array = conn.createArrayOf("NUMBER", (BigDecimal[])paramValue);
                rs.updateArray(columnName, array);
            } else if (paramValue instanceof BigInteger[]) {
                Array array = conn.createArrayOf("BIGINT", (BigInteger[])paramValue);
                rs.updateArray(columnName, array);
            } else if (paramValue instanceof Float[]) {
                Array array = conn.createArrayOf("FLOAT", (Float[])paramValue);
                rs.updateArray(columnName, array);
            } else if (paramValue instanceof Long[]) {
                Array array = conn.createArrayOf("INTEGER", (Long[])paramValue);
                rs.updateArray(columnName, array);
            } else {
                rs.updateObject(columnName, paramValue, 2003);
            }
        } else {
            rs.updateObject(columnName, paramValue, 2003);
        }
    }

    private static String wrapFetchSql(EntityMeta entityMeta, Integer dbType, String[] uniqueProps, String tableName) {
        String columnName;
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        StringBuilder sql = new StringBuilder("select ");
        for (int i = 0; i < entityMeta.getFieldsArray().length; ++i) {
            columnName = entityMeta.getColumnName(entityMeta.getFieldsArray()[i]);
            if (i > 0) {
                sql.append(",");
            }
            sql.append(ReservedWordsUtil.convertWord(columnName, dbType));
        }
        sql.append(" from ").append(realTable).append(" where ");
        int index = 0;
        for (String field : uniqueProps) {
            if (index > 0) {
                sql.append(" and ");
            }
            columnName = entityMeta.getColumnName(field);
            sql.append(ReservedWordsUtil.convertWord(columnName, dbType)).append("=?");
            ++index;
        }
        if (dbType == 30) {
            return SqlServerDialectUtils.lockSql(sql.toString(), realTable, LockMode.UPGRADE);
        }
        if (dbType == 20) {
            return sql.append(" for update with rs").toString();
        }
        return sql.append(" for update").toString();
    }

    private static Object[] processFieldValues(SqlToyContext sqlToyContext, EntityMeta entityMeta, Serializable entity) throws Exception {
        int bizIdColIndex;
        ReflectPropsHandler handler = DialectUtils.getAddReflectHandler(entityMeta, null, sqlToyContext.getUnifyFieldsHandler());
        handler = DialectUtils.getSecureReflectHandler(handler, sqlToyContext.getFieldsSecureProvider(), sqlToyContext.getDesensitizeProvider(), entityMeta.getSecureFields());
        Object[] fullParamValues = BeanUtil.reflectBeanToAry(entity, entityMeta.getFieldsArray(), null, handler);
        boolean hasId = entityMeta.getIdStrategy() != null && null != entityMeta.getIdGenerator();
        boolean hasBizId = entityMeta.getBusinessIdGenerator() != null;
        int n = bizIdColIndex = hasBizId ? entityMeta.getFieldIndex(entityMeta.getBusinessIdField()) : 0;
        if (hasId || hasBizId) {
            int pkIndex = entityMeta.getIdIndex();
            Integer[] relatedColumn = entityMeta.getBizIdRelatedColIndex();
            Object[] relatedColValue = null;
            if (relatedColumn != null) {
                int relatedColumnSize = relatedColumn.length;
                relatedColValue = new Object[relatedColumnSize];
                for (int meter = 0; meter < relatedColumnSize; ++meter) {
                    relatedColValue[meter] = fullParamValues[relatedColumn[meter]];
                    if (!StringUtil.isBlank(relatedColValue[meter])) continue;
                    throw new IllegalArgumentException("\u5bf9\u8c61:" + entityMeta.getEntityClass().getName() + " \u751f\u6210\u4e1a\u52a1\u4e3b\u952e\u4f9d\u8d56\u7684\u5173\u8054\u5b57\u6bb5:" + entityMeta.getBizIdRelatedColumns()[meter] + " \u503c\u4e3anull!");
                }
            }
            if (hasId && StringUtil.isBlank(fullParamValues[pkIndex])) {
                fullParamValues[pkIndex] = entityMeta.getIdGenerator().getId(entityMeta.getTableName(), entityMeta.getBizIdSignature(), entityMeta.getBizIdRelatedColumns(), relatedColValue, null, entityMeta.getIdType(), entityMeta.getIdLength(), entityMeta.getBizIdSequenceSize());
                BeanUtil.setProperty(entity, entityMeta.getIdArray()[0], fullParamValues[pkIndex]);
            }
            if (hasBizId && StringUtil.isBlank(fullParamValues[bizIdColIndex])) {
                String businessIdType = entityMeta.getColumnJavaType(entityMeta.getBusinessIdField());
                fullParamValues[bizIdColIndex] = entityMeta.getBusinessIdGenerator().getId(entityMeta.getTableName(), entityMeta.getBizIdSignature(), entityMeta.getBizIdRelatedColumns(), relatedColValue, null, businessIdType, entityMeta.getBizIdLength(), entityMeta.getBizIdSequenceSize());
                BeanUtil.setProperty(entity, entityMeta.getBusinessIdField(), fullParamValues[bizIdColIndex]);
            }
        }
        if (entityMeta.getDataVersion() != null) {
            String dataVersionField = entityMeta.getDataVersion().getField();
            int dataVersionIndex = entityMeta.getFieldIndex(dataVersionField);
            BeanUtil.setProperty(entity, dataVersionField, fullParamValues[dataVersionIndex]);
        }
        return fullParamValues;
    }

    public static List<ColumnMeta> getTableColumns(String catalog, String schema, String tableName, Connection conn, final Integer dbType, String dialect) throws Exception {
        Map<String, ColumnMeta> indexsMap;
        ColumnMeta mapMeta;
        ResultSet rs = conn.getMetaData().getColumns(catalog, schema, tableName, "%");
        List tableCols = (List)SqlUtil.preparedStatementProcess(null, null, rs, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object rowData, PreparedStatement pst, ResultSet rs) throws Exception {
                ArrayList<ColumnMeta> colMetas = new ArrayList<ColumnMeta>();
                while (rs.next()) {
                    ColumnMeta colMeta = new ColumnMeta();
                    colMeta.setColName(rs.getString("COLUMN_NAME"));
                    colMeta.setDataType(rs.getInt("DATA_TYPE"));
                    colMeta.setTypeName(rs.getString("TYPE_NAME"));
                    colMeta.setDefaultValue(SqlUtil.clearDefaultValue(rs.getString("COLUMN_DEF")));
                    colMeta.setColumnSize(rs.getInt("COLUMN_SIZE"));
                    colMeta.setDecimalDigits(rs.getInt("DECIMAL_DIGITS"));
                    colMeta.setNumPrecRadix(rs.getInt("NUM_PREC_RADIX"));
                    colMeta.setComments(rs.getString("REMARKS"));
                    colMeta.setAutoIncrement(false);
                    if (dbType == 10 || dbType == 11) {
                        if (colMeta.getDefaultValue() != null && colMeta.getDefaultValue().toLowerCase().endsWith(".nextval")) {
                            colMeta.setAutoIncrement(true);
                            colMeta.setDefaultValue(colMeta.getDefaultValue().replaceAll("\"", "\\\\\""));
                        }
                    } else {
                        try {
                            String isAutoIncrement = rs.getString("IS_AUTOINCREMENT");
                            if (isAutoIncrement != null && ("true".equalsIgnoreCase(isAutoIncrement) || "YES".equalsIgnoreCase(isAutoIncrement) || "Y".equalsIgnoreCase(isAutoIncrement) || "1".equals(isAutoIncrement))) {
                                colMeta.setAutoIncrement(true);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (rs.getInt("NULLABLE") == 1) {
                        colMeta.setNullable(true);
                    } else {
                        colMeta.setNullable(false);
                    }
                    colMetas.add(colMeta);
                }
                this.setResult(colMetas);
            }
        });
        Map<String, ColumnMeta> pkMap = DefaultDialectUtils.getTablePrimaryKeys(catalog, schema, tableName, conn, dbType, dialect);
        if (pkMap != null && !pkMap.isEmpty()) {
            for (ColumnMeta colMeta : tableCols) {
                mapMeta = pkMap.get(colMeta.getColName());
                if (mapMeta == null) continue;
                colMeta.setPK(true);
            }
        }
        if ((indexsMap = DefaultDialectUtils.getTableIndexes(catalog, schema, tableName, conn, dbType, dialect)) != null && !indexsMap.isEmpty()) {
            for (ColumnMeta colMeta : tableCols) {
                mapMeta = indexsMap.get(colMeta.getColName());
                if (mapMeta == null) continue;
                colMeta.setIndexName(mapMeta.getIndexName());
                colMeta.setUnique(mapMeta.isUnique());
                colMeta.setIndex(true);
            }
        }
        return tableCols;
    }

    private static Map<String, ColumnMeta> getTableIndexes(String catalog, String schema, String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        ResultSet rs = null;
        try {
            rs = conn.getMetaData().getIndexInfo(catalog, schema, tableName, false, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rs != null) {
            return (Map)SqlUtil.preparedStatementProcess(null, null, rs, new PreparedStatementResultHandler(){

                @Override
                public void execute(Object rowData, PreparedStatement pst, ResultSet rs) throws Exception {
                    HashMap<String, ColumnMeta> indexsMeta = new HashMap<String, ColumnMeta>();
                    while (rs.next()) {
                        ColumnMeta colMeta = new ColumnMeta();
                        colMeta.setColName(rs.getString("COLUMN_NAME"));
                        colMeta.setIndex(true);
                        colMeta.setUnique(!rs.getBoolean("NON_UNIQUE"));
                        colMeta.setIndexName(rs.getString("INDEX_NAME"));
                        indexsMeta.put(colMeta.getColName(), colMeta);
                    }
                    this.setResult(indexsMeta);
                }
            });
        }
        if (dbType == 10 || dbType == 11) {
            String tableNameUp = tableName.toUpperCase();
            String sql = "SELECT t1.INDEX_NAME,t1.COLUMN_NAME,t0.UNIQUENESS FROM USER_IND_COLUMNS t1 LEFT JOIN  (SELECT INDEX_NAME,UNIQUENESS FROM USER_INDEXES WHERE TABLE_NAME ='" + tableNameUp + "') t0 ON  t1.INDEX_NAME = t0.INDEX_NAME WHERE TABLE_NAME ='" + tableNameUp + "'";
            rs = conn.createStatement().executeQuery(sql);
            return (Map)SqlUtil.preparedStatementProcess(null, null, rs, new PreparedStatementResultHandler(){

                @Override
                public void execute(Object obj, PreparedStatement pst, ResultSet rs) throws SQLException {
                    HashMap<String, ColumnMeta> indexsMeta = new HashMap<String, ColumnMeta>();
                    while (rs.next()) {
                        ColumnMeta colMeta = new ColumnMeta();
                        colMeta.setColName(rs.getString("COLUMN_NAME"));
                        colMeta.setIndex(true);
                        if ("UNIQUE".equalsIgnoreCase(rs.getString("UNIQUENESS"))) {
                            colMeta.setUnique(true);
                        }
                        colMeta.setIndexName(rs.getString("INDEX_NAME"));
                        indexsMeta.put(colMeta.getColName(), colMeta);
                    }
                    this.setResult(indexsMeta);
                }
            });
        }
        return null;
    }

    public static Map<String, ColumnMeta> getTablePrimaryKeys(String catalog, String schema, String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        ResultSet rs = null;
        try {
            rs = conn.getMetaData().getPrimaryKeys(catalog, schema, tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rs != null) {
            return (Map)SqlUtil.preparedStatementProcess(null, null, rs, new PreparedStatementResultHandler(){

                @Override
                public void execute(Object rowData, PreparedStatement pst, ResultSet rs) throws Exception {
                    HashMap<String, ColumnMeta> pkMeta = new HashMap<String, ColumnMeta>();
                    while (rs.next()) {
                        ColumnMeta colMeta = new ColumnMeta();
                        colMeta.setColName(rs.getString("COLUMN_NAME"));
                        colMeta.setPK(true);
                        pkMeta.put(colMeta.getColName(), colMeta);
                    }
                    this.setResult(pkMeta);
                }
            });
        }
        if (dbType == 40 || dbType == 42) {
            rs = conn.createStatement().executeQuery("desc " + tableName);
            return (Map)SqlUtil.preparedStatementProcess(null, null, rs, new PreparedStatementResultHandler(){

                @Override
                public void execute(Object obj, PreparedStatement pst, ResultSet rs) throws SQLException {
                    HashMap<String, ColumnMeta> pkMeta = new HashMap<String, ColumnMeta>();
                    while (rs.next()) {
                        ColumnMeta colMeta = new ColumnMeta();
                        colMeta.setColName(rs.getString("FIELD"));
                        colMeta.setPK(rs.getBoolean("KEY"));
                        if (!colMeta.isPK()) continue;
                        pkMeta.put(colMeta.getColName(), colMeta);
                    }
                    this.setResult(pkMeta);
                }
            });
        }
        return null;
    }

    public static List<TableMeta> getTables(String catalog, String schema, String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        ResultSet rs = conn.getMetaData().getTables(catalog, schema, tableName, new String[]{"TABLE", "VIEW"});
        return (List)SqlUtil.preparedStatementProcess(null, null, rs, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object rowData, PreparedStatement pst, ResultSet rs) throws Exception {
                ArrayList<TableMeta> tables = new ArrayList<TableMeta>();
                while (rs.next()) {
                    TableMeta tableMeta = new TableMeta();
                    tableMeta.setTableName(rs.getString("TABLE_NAME"));
                    tableMeta.setSchema(rs.getString("TABLE_SCHEM"));
                    tableMeta.setType(rs.getString("TABLE_TYPE"));
                    tableMeta.setRemarks(rs.getString("REMARKS"));
                    tables.add(tableMeta);
                }
                this.setResult(tables);
            }
        });
    }
}

