/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.executor;

import java.util.concurrent.Callable;
import org.sagacity.sqltoy.SqlExecuteStat;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.ParallelCallbackHandler;
import org.sagacity.sqltoy.config.model.ShardingGroupModel;
import org.sagacity.sqltoy.model.ShardingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialectExecutor
implements Callable<ShardingResult> {
    protected final Logger logger = LoggerFactory.getLogger(DialectExecutor.class);
    private SqlToyContext sqltoyContext = null;
    private ShardingGroupModel shardingGroupModel;
    private ParallelCallbackHandler handler;

    public DialectExecutor(SqlToyContext sqltoyContext, ShardingGroupModel shardingGroupModel, ParallelCallbackHandler handler) {
        this.sqltoyContext = sqltoyContext;
        this.shardingGroupModel = shardingGroupModel;
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShardingResult call() {
        String dataSourceName = this.shardingGroupModel.getShardingModel().getDataSourceName();
        String tableName = this.shardingGroupModel.getShardingModel().getTableName();
        ShardingResult result = new ShardingResult();
        try {
            this.logger.debug("\u6267\u884c\u5206\u5e93\u5206\u8868,DataSource\u8282\u70b9:{},table={}", (Object)dataSourceName, (Object)tableName);
            result.setRows(this.handler.execute(this.sqltoyContext, this.shardingGroupModel));
        }
        catch (Exception e) {
            SqlExecuteStat.error(e);
            e.printStackTrace();
            result.setSuccess(false);
            result.setMessage("\u6267\u884c\u5206\u5e93\u5206\u8868,DataSource\u8282\u70b9:" + dataSourceName + ",table=" + tableName + " \u53d1\u751f\u5f02\u5e38:" + e.getMessage());
            this.logger.error("\u6267\u884c\u5206\u5e93\u5206\u8868,DataSource\u8282\u70b9:{},table={} \u53d1\u751f\u5f02\u5e38:{}", new Object[]{dataSourceName, tableName, e.getMessage()});
        }
        finally {
            SqlExecuteStat.destroy();
        }
        return result;
    }
}

