/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.config;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.ScanEntityAndSqlResource;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.annotation.BusinessId;
import org.sagacity.sqltoy.config.annotation.Column;
import org.sagacity.sqltoy.config.annotation.DataVersion;
import org.sagacity.sqltoy.config.annotation.Entity;
import org.sagacity.sqltoy.config.annotation.Foreign;
import org.sagacity.sqltoy.config.annotation.Id;
import org.sagacity.sqltoy.config.annotation.Index;
import org.sagacity.sqltoy.config.annotation.Indexes;
import org.sagacity.sqltoy.config.annotation.OneToMany;
import org.sagacity.sqltoy.config.annotation.OneToOne;
import org.sagacity.sqltoy.config.annotation.PartitionKey;
import org.sagacity.sqltoy.config.annotation.Secure;
import org.sagacity.sqltoy.config.annotation.SecureConfig;
import org.sagacity.sqltoy.config.annotation.Sharding;
import org.sagacity.sqltoy.config.annotation.Strategy;
import org.sagacity.sqltoy.config.annotation.Tenant;
import org.sagacity.sqltoy.config.model.DataVersionConfig;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.FieldSecureConfig;
import org.sagacity.sqltoy.config.model.IndexModel;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.ShardingConfig;
import org.sagacity.sqltoy.config.model.ShardingStrategyConfig;
import org.sagacity.sqltoy.config.model.TableCascadeModel;
import org.sagacity.sqltoy.model.IgnoreCaseSet;
import org.sagacity.sqltoy.model.SecureType;
import org.sagacity.sqltoy.plugins.id.IdGenerator;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManager {
    protected static final Logger logger = LoggerFactory.getLogger(EntityManager.class);
    private static HashMap<String, IdGenerator> idGenerators = new HashMap();
    private static HashMap<String, String> IdGenerators = new HashMap<String, String>(){
        private static final long serialVersionUID = 3964534243191167226L;
        {
            this.put("default", "DefaultIdGenerator");
            this.put("uuid", "UUIDGenerator");
            this.put("redis", "RedisIdGenerator");
            this.put("nanotime", "NanoTimeIdGenerator");
            this.put("snowflake", "SnowflakeIdGenerator");
            this.put("defaultidgenerator", "DefaultIdGenerator");
            this.put("defaultgenerator", "DefaultIdGenerator");
            this.put("nanotimeidgenerator", "NanoTimeIdGenerator");
            this.put("snowflakeidgenerator", "SnowflakeIdGenerator");
            this.put("uuidgenerator", "UUIDGenerator");
            this.put("redisidgenerator", "RedisIdGenerator");
        }
    };
    private static final String IdGeneratorPackage = "org.sagacity.sqltoy.plugins.id.impl.";
    private String[] packagesToScan;
    private boolean recursive = true;
    private String[] annotatedClasses;
    private ConcurrentHashMap<String, EntityMeta> entitysMetaMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> tableEntityNameMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> unEntityMap = new ConcurrentHashMap();

    public boolean isEntity(SqlToyContext sqlToyContext, Class voClass) {
        if (voClass == null || voClass.equals(Object.class)) {
            return false;
        }
        Class entityClass = BeanUtil.getEntityClass(voClass);
        String className = entityClass.getName();
        if (this.unEntityMap.containsKey(className)) {
            return false;
        }
        if (this.entitysMetaMap.containsKey(className)) {
            return true;
        }
        EntityMeta entityMeta = this.parseEntityMeta(sqlToyContext, entityClass, false, false);
        if (entityMeta != null) {
            return true;
        }
        this.unEntityMap.put(className, "1");
        return false;
    }

    public EntityMeta getEntityMeta(SqlToyContext sqlToyContext, Class voClass) {
        if (voClass == null || voClass.equals(Object.class)) {
            return null;
        }
        Class entityClass = BeanUtil.getEntityClass(voClass);
        String className = entityClass.getName();
        EntityMeta entityMeta = this.entitysMetaMap.get(className);
        if (entityMeta == null) {
            entityMeta = this.parseEntityMeta(sqlToyContext, entityClass, true, false);
            if (entityMeta == null) {
                throw new IllegalArgumentException("\u60a8\u4f20\u5165\u7684\u5bf9\u8c61:[".concat(className).concat(" ]\u4e0d\u662f\u4e00\u4e2a@Entity\u5b9e\u4f53POJO\u5bf9\u8c61,sqltoy\u5b9e\u4f53\u5bf9\u8c61\u5fc5\u987b\u4f7f\u7528 @Entity/@Id \u7b49\u6ce8\u89e3\u6765\u6807\u8bc6!"));
            }
            if (entityMeta.getFieldsArray() == null || entityMeta.getFieldsArray().length == 0) {
                throw new RuntimeException("\u60a8\u4f20\u5165\u7684\u5bf9\u8c61:[".concat(className).concat(" ] \u6ca1\u6709@column\u7b49\u914d\u7f6e,\u65e0\u6cd5\u83b7\u5f97POJO\u5c5e\u6027\u6620\u5c04\u6570\u636e\u5e93\u5b57\u6bb5\u7684\u5173\u7cfb,\u8bf7\u7528quickvo\u81ea\u52a8\u751f\u6210POJO!"));
            }
        }
        return entityMeta;
    }

    public void initialize(SqlToyContext sqlToyContext) throws Exception {
        LinkedHashSet entities = new LinkedHashSet();
        if (this.packagesToScan != null && this.packagesToScan.length > 0) {
            for (String pkg : this.packagesToScan) {
                entities.addAll(ScanEntityAndSqlResource.getPackageEntities(pkg.trim(), this.recursive, "UTF-8"));
            }
        }
        if (this.annotatedClasses != null && this.annotatedClasses.length > 0) {
            for (String annotationClass : this.annotatedClasses) {
                try {
                    Class<?> entityClass = Thread.currentThread().getContextClassLoader().loadClass(annotationClass);
                    if (!ScanEntityAndSqlResource.isSqlToyEntity(entityClass)) continue;
                    entities.add(entityClass);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        for (Class clazz : entities) {
            this.parseEntityMeta(sqlToyContext, clazz, true, false);
        }
    }

    public synchronized EntityMeta parseEntityMeta(SqlToyContext sqlToyContext, Class entityClass, boolean isWarn, boolean forCascade) {
        if (entityClass == null || entityClass.equals(Object.class) || entityClass.equals(Map.class)) {
            return null;
        }
        String className = entityClass.getName();
        if (this.entitysMetaMap.containsKey(className)) {
            return this.entitysMetaMap.get(className);
        }
        EntityMeta entityMeta = null;
        try {
            Class realEntityClass = entityClass;
            Entity entity = null;
            DataVersion dataVersion = null;
            Tenant tenant = null;
            while (!realEntityClass.equals(Object.class)) {
                entity = realEntityClass.getAnnotation(Entity.class);
                if (dataVersion == null) {
                    dataVersion = realEntityClass.getAnnotation(DataVersion.class);
                }
                if (tenant == null) {
                    tenant = realEntityClass.getAnnotation(Tenant.class);
                }
                if (entity != null) break;
                realEntityClass = realEntityClass.getSuperclass();
            }
            if (entity != null) {
                entityMeta = new EntityMeta();
                entityMeta.setEntityClass(realEntityClass);
                entityMeta.setTableName(entity.tableName());
                if (StringUtil.isNotBlank(entity.schema())) {
                    entityMeta.setSchema(entity.schema());
                }
                if (StringUtil.isNotBlank(entity.pk_constraint())) {
                    entityMeta.setPkConstraint(entity.pk_constraint());
                }
                if (tenant != null && !"".equals(tenant.field())) {
                    entityMeta.setTenantField(tenant.field());
                }
                Field[] allFields = this.parseAllFields(entityClass);
                ArrayList<String> rejectIdFieldList = new ArrayList<String>();
                ArrayList<String> fieldList = new ArrayList<String>();
                ArrayList<String> idList = new ArrayList<String>();
                this.parseIdFileds(idList, allFields);
                StringBuilder loadNamedWhereSql = new StringBuilder("");
                StringBuilder loadArgWhereSql = new StringBuilder("");
                ArrayList<String> allColumnNames = new ArrayList<String>();
                String dataVersionField = null;
                for (Field field : allFields) {
                    this.parseFieldMeta(sqlToyContext, entityMeta, field, rejectIdFieldList, allColumnNames, loadNamedWhereSql, loadArgWhereSql);
                    if (dataVersion == null && (dataVersion = field.getAnnotation(DataVersion.class)) != null) {
                        dataVersionField = field.getName();
                    }
                    if (tenant != null || (tenant = field.getAnnotation(Tenant.class)) == null) continue;
                    entityMeta.setTenantField(field.getName());
                }
                StringBuilder allColNames = new StringBuilder();
                for (int i = 0; i < allColumnNames.size(); ++i) {
                    if (i > 0) {
                        allColNames.append(",");
                    }
                    allColNames.append(ReservedWordsUtil.convertWord((String)allColumnNames.get(i), null));
                }
                entityMeta.setAllColumnNames(allColNames.toString());
                entityMeta.setLoadAllSql("select ".concat(entityMeta.getAllColumnNames()).concat(" from ").concat(entityMeta.getSchemaTable(null, null)));
                entityMeta.setIdArgWhereSql(loadArgWhereSql.toString());
                entityMeta.setIdNameWhereSql(loadNamedWhereSql.toString());
                if (rejectIdFieldList.size() > 0) {
                    entityMeta.setRejectIdFieldArray(rejectIdFieldList.toArray(new String[rejectIdFieldList.size()]));
                    fieldList.addAll(rejectIdFieldList);
                }
                if (idList.size() > 0) {
                    entityMeta.setIdArray(idList.toArray(new String[idList.size()]));
                    fieldList.addAll(idList);
                    if (StringUtil.isBlank(entityMeta.getLoadSql(null))) {
                        entityMeta.setLoadSql(entityMeta.getLoadAllSql().concat(loadNamedWhereSql.toString()));
                    }
                }
                entityMeta.setFieldsArray(fieldList.toArray(new String[rejectIdFieldList.size() + idList.size()]));
                this.parseFieldTypeAndDefault(entityMeta);
                this.parseSharding(entityMeta, entityClass);
                this.parseSecureConfig(entityMeta, entityClass);
                this.parseIndexes(entityMeta, entityClass);
                if (dataVersion != null) {
                    FieldMeta fieldMeta;
                    if (dataVersionField == null) {
                        dataVersionField = dataVersion.field();
                    }
                    if ((fieldMeta = entityMeta.getFieldMeta(dataVersionField)) != null) {
                        DataVersionConfig dataVersionConfig = new DataVersionConfig();
                        dataVersionConfig.setField(dataVersionField);
                        if (dataVersion.startDate() && fieldMeta.getLength() > 8) {
                            dataVersionConfig.setStartDate(true);
                        }
                        entityMeta.setDataVersion(dataVersionConfig);
                    } else {
                        throw new RuntimeException("@DataVersion(field=" + dataVersionField + ") \u5728POJO\u7c7b:" + className + " \u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u5c5e\u6027!");
                    }
                }
                if (entityMeta.getTenantField() != null && entityMeta.getFieldMeta(entityMeta.getTenantField()) == null) {
                    throw new RuntimeException("@Tenant(field=" + entityMeta.getTenantField() + ") \u5728POJO\u7c7b:" + className + " \u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u5c5e\u6027!");
                }
                if (!forCascade) {
                    for (Field field : allFields) {
                        this.parseCascade(sqlToyContext, entityMeta, field, idList);
                    }
                    if (!entityMeta.getCascadeModels().isEmpty()) {
                        Class[] cascadeTypes = new Class[entityMeta.getCascadeModels().size()];
                        for (int i = 0; i < entityMeta.getCascadeModels().size(); ++i) {
                            cascadeTypes[i] = entityMeta.getCascadeModels().get(i).getMappedType();
                        }
                        entityMeta.setCascadeTypes(cascadeTypes);
                    }
                }
            }
        }
        catch (Exception e) {
            if (isWarn) {
                logger.error("Sqltoy \u89e3\u6790Entity\u5bf9\u8c61:[{}]\u53d1\u751f\u9519\u8bef,\u8bf7\u68c0\u67e5\u5bf9\u8c61\u6ce8\u89e3\u662f\u5426\u6b63\u786e!" + e.getMessage(), (Object)className);
                throw e;
            }
            return null;
        }
        if (!forCascade) {
            if (entityMeta != null) {
                this.entitysMetaMap.put(className, entityMeta);
                this.tableEntityNameMap.put(entityMeta.getTableName().toLowerCase(), className);
            } else if (isWarn) {
                logger.warn("SqlToy Entity:{}\u6ca1\u6709\u4f7f\u7528@Entity\u6ce8\u89e3\uff0c\u8868\u660e\u4e0d\u662f\u4e00\u4e2a\u5b9e\u4f53\u7c7b,\u8bf7\u68c0\u67e5!", (Object)className);
            }
        }
        return entityMeta;
    }

    private void parseSharding(EntityMeta entityMeta, Class entityClass) {
        Strategy shardingTable;
        Sharding sharding = null;
        for (Class classType = entityClass; classType != null && !classType.equals(Object.class) && (sharding = classType.getAnnotation(Sharding.class)) == null; classType = classType.getSuperclass()) {
        }
        if (sharding == null) {
            return;
        }
        ShardingConfig shardingConfig = new ShardingConfig();
        shardingConfig.setMaxConcurrents(sharding.maxConcurrents());
        shardingConfig.setMaxWaitSeconds(sharding.maxWaitSeconds());
        shardingConfig.setGlobalRollback(sharding.is_global_rollback());
        Strategy shardingDB = sharding.db();
        String strategy = shardingDB.name();
        if (StringUtil.isNotBlank(strategy)) {
            ShardingStrategyConfig config = new ShardingStrategyConfig(0);
            config.setFields(shardingDB.fields());
            String[] aliasNames = new String[shardingDB.fields().length];
            System.arraycopy(shardingDB.fields(), 0, aliasNames, 0, aliasNames.length);
            if (shardingDB.aliasNames() != null) {
                System.arraycopy(shardingDB.aliasNames(), 0, aliasNames, 0, shardingDB.aliasNames().length);
            }
            config.setAliasNames(aliasNames);
            config.setDecisionType(shardingDB.decisionType());
            config.setStrategy(strategy);
            shardingConfig.setShardingDBStrategy(config);
        }
        if (StringUtil.isNotBlank(strategy = (shardingTable = sharding.table()).name())) {
            ShardingStrategyConfig config = new ShardingStrategyConfig(1);
            config.setFields(shardingTable.fields());
            String[] aliasNames = new String[shardingTable.fields().length];
            System.arraycopy(shardingTable.fields(), 0, aliasNames, 0, aliasNames.length);
            if (shardingTable.aliasNames() != null) {
                System.arraycopy(shardingTable.aliasNames(), 0, aliasNames, 0, shardingTable.aliasNames().length);
            }
            config.setTables(new String[]{entityMeta.getTableName()});
            config.setAliasNames(aliasNames);
            config.setDecisionType(shardingDB.decisionType());
            config.setStrategy(strategy);
            shardingConfig.setShardingTableStrategy(config);
        }
        if (shardingConfig.getShardingDBStrategy() != null || shardingConfig.getShardingTableStrategy() != null) {
            entityMeta.setShardingConfig(shardingConfig);
        }
    }

    private void parseSecureConfig(EntityMeta entityMeta, Class entityClass) {
        SecureConfig secureConfig = null;
        for (Class classType = entityClass; classType != null && !classType.equals(Object.class) && (secureConfig = classType.getAnnotation(SecureConfig.class)) == null; classType = classType.getSuperclass()) {
        }
        if (secureConfig == null) {
            return;
        }
        Secure[] secures = secureConfig.secures();
        if (secures != null && secures.length > 0) {
            IgnoreCaseSet secureColumns = new IgnoreCaseSet();
            for (Secure secure : secures) {
                String field = secure.field();
                FieldMeta fieldMeta = entityMeta.getFieldMeta(field);
                if (fieldMeta == null) continue;
                if (secure.secureType().equals((Object)SecureType.ENCRYPT)) {
                    secureColumns.add(fieldMeta.getColumnName());
                    entityMeta.addSecureField(new FieldSecureConfig(field, SecureType.ENCRYPT, null, null, 0, 0, 0));
                    continue;
                }
                entityMeta.addSecureField(new FieldSecureConfig(field, secure.secureType(), secure.sourceField(), secure.maskCode(), secure.headSize(), secure.tailSize(), secure.maskRate()));
            }
            if (!secureColumns.isEmpty()) {
                entityMeta.setSecureColumns(secureColumns);
            }
        }
    }

    private void parseIndexes(EntityMeta entityMeta, Class entityClass) {
        Indexes indexes = null;
        for (Class classType = entityClass; classType != null && !classType.equals(Object.class) && (indexes = classType.getAnnotation(Indexes.class)) == null; classType = classType.getSuperclass()) {
        }
        if (indexes == null || indexes.indexes() == null || indexes.indexes().length == 0) {
            return;
        }
        Index[] indexs = indexes.indexes();
        IndexModel[] indexModels = new IndexModel[indexs.length];
        for (int i = 0; i < indexs.length; ++i) {
            indexModels[i] = new IndexModel(indexs[i].name(), indexs[i].isUnique(), indexs[i].columns());
        }
        entityMeta.setIndexModels(indexModels);
    }

    private void parseIdFileds(List<String> idList, Field[] allFields) {
        for (Field field : allFields) {
            if (field.getAnnotation(Id.class) == null) continue;
            idList.add(field.getName());
        }
    }

    private Field[] parseAllFields(Class entityClass) {
        HashSet<String> fieldSet = new HashSet<String>();
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class classType = entityClass; classType != null && !classType.equals(Object.class); classType = classType.getSuperclass()) {
            for (Field field : classType.getDeclaredFields()) {
                String fieldName = field.getName().toLowerCase();
                if (fieldSet.contains(fieldName) || field.getAnnotation(Column.class) == null && field.getAnnotation(OneToMany.class) == null && field.getAnnotation(OneToOne.class) == null) continue;
                allFields.add(field);
                fieldSet.add(fieldName);
            }
        }
        return allFields.toArray(new Field[allFields.size()]);
    }

    private void parseFieldMeta(SqlToyContext sqlToyContext, EntityMeta entityMeta, Field field, List<String> rejectIdFieldList, List<String> allFieldAry, StringBuilder loadNamedWhereSql, StringBuilder loadArgWhereSql) {
        Column column = field.getAnnotation(Column.class);
        if (column == null) {
            return;
        }
        FieldMeta fieldMeta = new FieldMeta(field.getName(), column.name(), "_SQLTOY_NULL_FLAG".equals(column.defaultValue()) ? null : column.defaultValue(), column.nativeType(), column.type(), column.nullable(), column.keyword(), Long.valueOf(column.length()).intValue(), column.precision(), column.scale());
        allFieldAry.add(column.name());
        fieldMeta.setAutoIncrement(column.autoIncrement());
        fieldMeta.setFieldType(field.getType().getTypeName().toLowerCase());
        if (field.getAnnotation(PartitionKey.class) != null) {
            fieldMeta.setPartitionKey(true);
        }
        if (field.getAnnotation(Foreign.class) != null) {
            Foreign foregin = field.getAnnotation(Foreign.class);
            Map<String, String[]> foreignFieldMap = entityMeta.getForeignFields();
            if (foreignFieldMap == null) {
                foreignFieldMap = new HashMap<String, String[]>();
            }
            foreignFieldMap.put(field.getName(), new String[]{foregin.table(), foregin.field()});
            entityMeta.setForeignFields(foreignFieldMap);
        }
        if (column.type() == 1111) {
            Class<?> fieldType = field.getType();
            if (fieldType.equals(String.class)) {
                fieldMeta.setType(12);
            } else if (fieldType.equals(java.util.Date.class) || fieldType.equals(Date.class) || fieldType.equals(LocalDate.class) || fieldType.equals(LocalDateTime.class)) {
                fieldMeta.setType(91);
            } else if (fieldType.equals(Timestamp.class)) {
                fieldMeta.setType(93);
            } else if (fieldType.equals(LocalTime.class) || fieldType.equals(Time.class)) {
                fieldMeta.setType(92);
            } else if (fieldType.equals(Long.class) || fieldType.equals(BigInteger.class)) {
                fieldMeta.setType(-5);
            } else if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE) || fieldType.equals(Long.TYPE) || fieldType.equals(Short.TYPE)) {
                fieldMeta.setType(4);
            } else if (fieldType.equals(BigDecimal.class)) {
                fieldMeta.setType(3);
            } else if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
                fieldMeta.setType(16);
            } else if (fieldType.equals(Double.class) || fieldType.equals(Double.TYPE)) {
                fieldMeta.setType(8);
            } else if (fieldType.equals(Float.class) || fieldType.equals(Float.TYPE)) {
                fieldMeta.setType(6);
            } else if (fieldType.equals(Byte.class) && fieldType.isArray()) {
                fieldMeta.setType(-2);
            }
        }
        entityMeta.addFieldMeta(fieldMeta);
        Id id = field.getAnnotation(Id.class);
        if (id != null) {
            fieldMeta.setPK(true);
            entityMeta.setIdStrategy(PKStrategy.getPKStrategy(id.strategy().toLowerCase()));
            entityMeta.setSequence(id.sequence());
            String idGenerator = id.generator();
            if (StringUtil.isNotBlank(idGenerator)) {
                this.processIdGenerator(sqlToyContext, entityMeta, idGenerator);
                entityMeta.setIdGenerator(idGenerators.get(idGenerator));
            }
            if (loadNamedWhereSql.length() > 1) {
                loadNamedWhereSql.append(" and ");
                loadArgWhereSql.append(" and ");
            } else {
                loadNamedWhereSql.append(" where ");
                loadArgWhereSql.append(" where ");
            }
            String idColName = ReservedWordsUtil.convertWord(column.name(), null);
            loadNamedWhereSql.append(idColName).append("=:").append(field.getName());
            loadArgWhereSql.append(idColName).append("=?");
        } else {
            rejectIdFieldList.add(field.getName());
        }
        BusinessId bizId = field.getAnnotation(BusinessId.class);
        if (bizId != null && StringUtil.isNotBlank(bizId.generator())) {
            String bizGenerator = bizId.generator();
            entityMeta.setBizIdLength(bizId.length());
            entityMeta.setBizIdSignature(bizId.signature());
            entityMeta.setHasBizIdConfig(true);
            entityMeta.setBizIdSequenceSize(bizId.sequenceSize());
            entityMeta.setBusinessIdField(field.getName());
            if (bizId.relatedColumns() != null && bizId.relatedColumns().length > 0) {
                entityMeta.setBizIdRelatedColumns(bizId.relatedColumns());
            }
            this.processIdGenerator(sqlToyContext, entityMeta, bizGenerator);
            if (id != null) {
                entityMeta.setIdGenerator(idGenerators.get(bizGenerator));
                fieldMeta.setLength(bizId.length());
                entityMeta.setBizIdEqPK(true);
            } else {
                entityMeta.setBusinessIdGenerator(idGenerators.get(bizGenerator));
            }
        }
    }

    private void processIdGenerator(SqlToyContext sqlToyContext, EntityMeta entityMeta, String idGenerator) {
        if (sqlToyContext == null || idGenerators.containsKey(idGenerator)) {
            return;
        }
        if (idGenerator.toLowerCase().startsWith("@bean(")) {
            String beanName = idGenerator.substring(idGenerator.indexOf("(") + 1, idGenerator.indexOf(")")).replaceAll("\"|'", "").trim();
            idGenerators.put(idGenerator, (IdGenerator)sqlToyContext.getBean(beanName));
        } else {
            String generator = IdGenerators.get(idGenerator.toLowerCase());
            generator = generator != null ? IdGeneratorPackage.concat(generator) : idGenerator;
            try {
                IdGenerator idGeneratorBean = (IdGenerator)Class.forName(generator).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                idGeneratorBean.initialize(sqlToyContext);
                idGenerators.put(idGenerator, idGeneratorBean);
            }
            catch (Exception e) {
                throw new RuntimeException("\u5b9e\u4f8b\u5316\u4e3b\u952e\u751f\u6210\u7b56\u7565\u5931\u8d25:className=" + generator + ",\u9519\u8bef\u4fe1\u606f:" + e.getMessage());
            }
        }
    }

    private void parseCascade(SqlToyContext sqlToyContext, EntityMeta entityMeta, Field field, List<String> idList) {
        boolean isRepeat;
        String[] mappedFields;
        String[] fields;
        OneToMany oneToMany = field.getAnnotation(OneToMany.class);
        OneToOne oneToOne = field.getAnnotation(OneToOne.class);
        if (oneToMany == null && oneToOne == null) {
            return;
        }
        TableCascadeModel cascadeModel = new TableCascadeModel();
        String load = null;
        String orderBy = null;
        String update = null;
        if (oneToMany != null) {
            fields = oneToMany.fields();
            mappedFields = oneToMany.mappedFields();
            cascadeModel.setCascadeType(1);
            cascadeModel.setMappedType((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]);
            load = oneToMany.load();
            orderBy = oneToMany.orderBy();
            update = oneToMany.update();
            if (StringUtil.isNotBlank(oneToMany.notNullField())) {
                cascadeModel.setNotNullField(oneToMany.notNullField());
            }
            cascadeModel.setDelete(oneToMany.delete());
        } else {
            fields = oneToOne.fields();
            mappedFields = oneToOne.mappedFields();
            cascadeModel.setCascadeType(2);
            cascadeModel.setMappedType(field.getType());
            load = oneToOne.load();
            update = oneToOne.update();
            cascadeModel.setDelete(oneToOne.delete());
            if (StringUtil.isNotBlank(oneToOne.notNullField())) {
                cascadeModel.setNotNullField(oneToOne.notNullField());
            }
        }
        EntityMeta subTableMeta = this.parseEntityMeta(sqlToyContext, cascadeModel.getMappedType(), false, true);
        if ((fields == null || fields.length == 0) && idList.size() == 1) {
            fields = entityMeta.getIdArray();
        }
        if (fields == null || fields.length != mappedFields.length) {
            throw new IllegalArgumentException(StringUtil.fillArgs("\u4e3b\u8868:{}\u7684fields \u8ddf\u5b50\u8868:{} mappedFields \u957f\u5ea6\u4e0d\u4e00\u81f4,\u8bf7\u68c0\u67e5!", entityMeta.getTableName(), subTableMeta.getTableName()));
        }
        String[] mappedColumns = new String[fields.length];
        fields = StringUtil.humpFieldNames(fields);
        mappedFields = StringUtil.humpFieldNames(mappedFields);
        for (int i = 0; i < fields.length; ++i) {
            if (entityMeta.getFieldMeta(fields[i]) == null) {
                throw new IllegalArgumentException(StringUtil.fillArgs("\u8868\u7ea7\u8054\u914d\u7f6e\u5bf9\u5e94\u4e3b\u8868:{}\u7684field\u5c5e\u6027:{} \u5e76\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5!", entityMeta.getTableName(), fields[i]));
            }
            if (subTableMeta.getFieldMeta(mappedFields[i]) == null) {
                throw new IllegalArgumentException(StringUtil.fillArgs("\u8868\u7ea7\u8054\u914d\u7f6e\u5bf9\u5e94\u5b50\u8868:{}\u7684field\u5c5e\u6027:{} \u5e76\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5!", subTableMeta.getTableName(), mappedFields[i]));
            }
            mappedColumns[i] = ReservedWordsUtil.convertWord(subTableMeta.getColumnName(mappedFields[i]), null);
        }
        cascadeModel.setFields(fields);
        cascadeModel.setMappedColumns(mappedColumns);
        cascadeModel.setMappedFields(mappedFields);
        String subSchemaTable = subTableMeta.getSchemaTable(null, null);
        cascadeModel.setMappedTable(subSchemaTable);
        cascadeModel.setField(field);
        cascadeModel.setProperty(field.getName());
        cascadeModel.setAnnotations(field.getAnnotations());
        String subWhereSql = " where ";
        String subDeleteSql = "delete from ".concat(subSchemaTable).concat(" where ");
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                subWhereSql = subWhereSql.concat(" and ");
                subDeleteSql = subDeleteSql.concat(" and ");
            }
            subWhereSql = subWhereSql.concat(mappedColumns[i]).concat("=:").concat(mappedFields[i]);
            subDeleteSql = subDeleteSql.concat(mappedColumns[i]).concat("=?");
        }
        cascadeModel.setLoadSubTableSql(subTableMeta.getLoadAllSql().concat(subWhereSql));
        cascadeModel.setDeleteSubTableSql(subDeleteSql);
        boolean matchedWhere = false;
        if (StringUtil.isNotBlank(load)) {
            String loadLow = load.toLowerCase();
            boolean isNamedSql = SqlConfigParseUtils.isNamedQuery(load);
            if (isNamedSql && !StringUtil.matches(loadLow, "(\\>|\\<)|(\\=)|(\\<\\>)|(\\>\\=|\\<\\=)")) {
                if (!"default".equals(loadLow) && !"true".equals(loadLow)) {
                    cascadeModel.setLoadSubTableSql(load);
                }
            } else {
                String loadSql = SqlUtil.convertFieldsToColumns(subTableMeta, load);
                matchedWhere = StringUtil.matches(loadLow, "\\s+where\\s+");
                if (matchedWhere) {
                    cascadeModel.setLoadSubTableSql(loadSql);
                } else {
                    cascadeModel.setLoadSubTableSql(subTableMeta.getLoadAllSql().concat(subWhereSql).concat(" and ").concat(loadSql));
                    cascadeModel.setLoadExtCondition(loadSql);
                }
            }
        }
        if (StringUtil.isNotBlank(orderBy)) {
            orderBy = SqlUtil.convertFieldsToColumns(subTableMeta, orderBy);
            cascadeModel.setOrderBy(orderBy);
            cascadeModel.setLoadSubTableSql(cascadeModel.getLoadSubTableSql().concat(" order by ").concat(orderBy));
        }
        if (StringUtil.isNotBlank(update)) {
            String updateLow = update;
            if ("delete".equals(updateLow)) {
                cascadeModel.setCascadeUpdateSql("delete from ".concat(subSchemaTable).concat(subWhereSql));
            } else {
                matchedWhere = StringUtil.matches(updateLow, "\\s+where\\s+");
                cascadeModel.setCascadeUpdateSql("update ".concat(subSchemaTable).concat(" set ").concat(update).concat(matchedWhere ? "" : subWhereSql));
            }
        }
        if (isRepeat = entityMeta.addCascade(cascadeModel)) {
            logger.warn("\u8868:{} \u7ea7\u8054\u64cd\u4f5c\u5b50\u8868:{} \u51fa\u73b0\u91cd\u590d\u5173\u8054,\u540e\u7eed:{}\u5173\u8054\u7c7b\u578b\u8986\u76d6\u524d\u9762\u7684\u5173\u8054", new Object[]{entityMeta.getTableName(), subTableMeta.getTableName(), cascadeModel.getCascadeType() == 1 ? "oneToMany" : "oneToOne"});
        }
    }

    private void parseFieldTypeAndDefault(EntityMeta entityMeta) {
        int fieldSize = entityMeta.getFieldsArray().length;
        int pkSize = entityMeta.getIdArray() == null ? 0 : entityMeta.getIdArray().length;
        Integer[] fieldsTypeArray = new Integer[fieldSize];
        String[] fieldsDefaultValue = new String[fieldSize];
        Boolean[] fieldsNullable = new Boolean[fieldSize];
        boolean hasDefault = false;
        for (int i = 0; i < fieldSize; ++i) {
            FieldMeta fieldMeta = entityMeta.getFieldMeta(entityMeta.getFieldsArray()[i]);
            fieldsTypeArray[i] = fieldMeta.getType();
            if (!fieldMeta.isPK() || pkSize > 1) {
                fieldsDefaultValue[i] = fieldMeta.getDefaultValue();
                if (null != fieldMeta.getDefaultValue()) {
                    hasDefault = true;
                }
            }
            fieldsNullable[i] = fieldMeta.isNullable();
        }
        entityMeta.setFieldsTypeArray(fieldsTypeArray);
        if (hasDefault) {
            entityMeta.setFieldsDefaultValue(fieldsDefaultValue);
        }
        entityMeta.setFieldsNullable(fieldsNullable);
    }

    public String[] getPackagesToScan() {
        return this.packagesToScan;
    }

    public void setPackagesToScan(String[] packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public String[] getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    public void setAnnotatedClasses(String[] annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public EntityMeta getEntityMeta(String tableName) {
        String className = this.tableEntityNameMap.get(tableName.toLowerCase());
        if (className == null) {
            return null;
        }
        return this.entitysMetaMap.get(className);
    }

    public ConcurrentHashMap<String, EntityMeta> getAllEntities() {
        return this.entitysMetaMap;
    }
}

