/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import oracle.sql.TIMESTAMP;
import org.sagacity.sqltoy.callback.ReflectPropsHandler;
import org.sagacity.sqltoy.config.annotation.Entity;
import org.sagacity.sqltoy.config.annotation.OneToMany;
import org.sagacity.sqltoy.config.annotation.OneToOne;
import org.sagacity.sqltoy.config.annotation.SqlToyEntity;
import org.sagacity.sqltoy.config.model.DataType;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.KeyAndIndex;
import org.sagacity.sqltoy.config.model.TableCascadeModel;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.plugins.TypeHandler;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtil {
    protected static final Logger logger = LoggerFactory.getLogger(BeanUtil.class);
    public static final Pattern ARRAY_PATTERN = Pattern.compile("\\[\\d+\\]$");
    private static ConcurrentHashMap<String, Method> setMethods = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Method> getMethods = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, List> cascadeModels = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class, Method> enumGetKeyMethods = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class, Integer> enumGetKeyExists = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Class> enumClassMap = new ConcurrentHashMap();
    private static String[] enumKeys = new String[]{"value", "key", "code", "id", "status", "level", "type"};

    private BeanUtil() {
    }

    public static Object getEnumValue(Object enumValue) {
        if (enumValue == null) {
            return null;
        }
        Object result = null;
        Class<?> enumClass = enumValue.getClass();
        if (enumGetKeyExists.containsKey(enumClass)) {
            Method getKeyMethod = enumGetKeyMethods.get(enumClass);
            if (getKeyMethod != null) {
                try {
                    result = getKeyMethod.invoke(enumValue, new Object[0]);
                }
                catch (Exception exception) {}
            }
        } else {
            Method getKeyMethod = BeanUtil.matchEnumKeyMethod(enumClass, enumKeys);
            if (getKeyMethod != null) {
                try {
                    result = getKeyMethod.invoke(enumValue, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                enumGetKeyMethods.put(enumClass, getKeyMethod);
            }
            enumGetKeyExists.put(enumClass, 1);
        }
        if (result == null) {
            return enumValue.toString();
        }
        return result;
    }

    public static Object newEnumInstance(Object key, Class enumClass) {
        if (key == null) {
            return null;
        }
        Method getKeyMethod = null;
        if (enumGetKeyExists.containsKey(enumClass)) {
            getKeyMethod = enumGetKeyMethods.get(enumClass);
        } else {
            getKeyMethod = BeanUtil.matchEnumKeyMethod(enumClass, enumKeys);
            if (getKeyMethod != null) {
                enumGetKeyMethods.put(enumClass, getKeyMethod);
            }
            enumGetKeyExists.put(enumClass, 1);
        }
        if (getKeyMethod == null) {
            return null;
        }
        T[] enums = enumClass.getEnumConstants();
        try {
            for (Object enumVal : enums) {
                if (!key.equals(getKeyMethod.invoke(enumVal, new Object[0]))) continue;
                return enumVal;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Method matchEnumKeyMethod(Class enumClass, String[] props) {
        Method[] methods = enumClass.getMethods();
        ArrayList<Method> realMeth = new ArrayList<Method>();
        for (Method mt : methods) {
            if (Void.TYPE.equals(mt.getReturnType()) || mt.getParameterTypes().length != 0) continue;
            realMeth.add(mt);
        }
        for (int i = 0; i < props.length; ++i) {
            String prop = props[i].toLowerCase();
            for (Method getKeyMethod : realMeth) {
                String name = getKeyMethod.getName().toLowerCase();
                if (!"get".concat(prop).equals(name) && !prop.equals(name)) continue;
                return getKeyMethod;
            }
        }
        return null;
    }

    public static Method[] matchSetMethods(Class voClass, String ... props) {
        int indexSize = props.length;
        Method[] result = new Method[indexSize];
        Method[] methods = voClass.getMethods();
        ArrayList<Method> realMeth = new ArrayList<Method>();
        for (Method mt : methods) {
            if (mt.getParameterTypes().length != 1 || !mt.getName().startsWith("set")) continue;
            realMeth.add(mt);
        }
        if (realMeth.isEmpty()) {
            return result;
        }
        boolean matched = false;
        int meter = 0;
        for (int i = 0; i < indexSize; ++i) {
            if (props[i] == null) continue;
            String prop = "set".concat(props[i].toLowerCase());
            matched = false;
            String minProp = null;
            if (prop.contains("_")) {
                minProp = prop.replace("_", "");
            }
            meter = 0;
            Method underlinMethod = null;
            int index = 0;
            for (int j = 0; j < realMeth.size(); ++j) {
                boolean isBool = false;
                Method method = (Method)realMeth.get(j);
                String name = method.getName().toLowerCase();
                if (prop.equals(name)) {
                    matched = true;
                } else {
                    Class<?> type = method.getParameterTypes()[0];
                    boolean bl = isBool = (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) && prop.startsWith("setis");
                    if (isBool && prop.replaceFirst("setis", "set").equals(name)) {
                        matched = true;
                    }
                }
                if (!matched && minProp != null && (minProp.equals(name) || isBool && minProp.replaceFirst("setis", "set").equals(name))) {
                    ++meter;
                    underlinMethod = method;
                    index = j;
                }
                if (!matched) continue;
                result[i] = method;
                result[i].setAccessible(true);
                realMeth.remove(j);
                break;
            }
            if (!matched && meter == 1) {
                result[i] = underlinMethod;
                result[i].setAccessible(true);
                realMeth.remove(index);
            }
            if (realMeth.isEmpty()) break;
        }
        return result;
    }

    public static Method[] matchGetMethods(Class voClass, String ... props) {
        String name;
        Method[] methods = voClass.getMethods();
        ArrayList<Method> realMeth = new ArrayList<Method>();
        for (Method mt : methods) {
            if (Void.TYPE.equals(mt.getReturnType()) || mt.getParameterTypes().length != 0 || !(name = mt.getName().toLowerCase()).startsWith("get") && !name.startsWith("is")) continue;
            realMeth.add(mt);
        }
        int indexSize = props.length;
        Method[] result = new Method[indexSize];
        if (realMeth.isEmpty()) {
            return result;
        }
        boolean matched = false;
        int meter = 0;
        for (int i = 0; i < indexSize; ++i) {
            if (props[i] == null) continue;
            String prop = props[i].toLowerCase();
            matched = false;
            String minProp = null;
            if (prop.contains("_")) {
                minProp = prop.replace("_", "");
            }
            meter = 0;
            Method underlinMethod = null;
            int index = 0;
            for (int j = 0; j < realMeth.size(); ++j) {
                boolean isBool = false;
                Method method = (Method)realMeth.get(j);
                name = method.getName().toLowerCase();
                if (name.equals("get".concat(prop))) {
                    matched = true;
                } else {
                    Class<?> type = method.getReturnType();
                    boolean bl = isBool = name.startsWith("is") && (type.equals(Boolean.class) || type.equals(Boolean.TYPE));
                    if (isBool && (name.equals(prop) || name.equals("is".concat(prop)))) {
                        matched = true;
                    }
                }
                if (!matched && minProp != null && (name.equals("get".concat(minProp)) || isBool && (name.equals(minProp) || name.equals("is".concat(minProp))))) {
                    ++meter;
                    underlinMethod = method;
                    index = j;
                }
                if (!matched) continue;
                result[i] = method;
                result[i].setAccessible(true);
                realMeth.remove(j);
                break;
            }
            if (!matched && meter == 1) {
                result[i] = underlinMethod;
                result[i].setAccessible(true);
                realMeth.remove(index);
            }
            if (realMeth.isEmpty()) break;
        }
        return result;
    }

    public static Integer[] matchMethodsType(Class voClass, String ... properties) {
        if (properties == null || properties.length == 0) {
            return null;
        }
        int indexSize = properties.length;
        Method[] methods = voClass.getMethods();
        Integer[] fieldsType = new Integer[indexSize];
        int methodCnt = methods.length;
        block0: for (int i = 0; i < indexSize; ++i) {
            fieldsType[i] = 0;
            String property = properties[i].toLowerCase();
            for (int j = 0; j < methodCnt; ++j) {
                Method method = methods[j];
                String methodName = method.getName().toLowerCase();
                if (Void.TYPE.equals(method.getReturnType()) || method.getParameterTypes().length != 0 || !methodName.equals("get".concat(property)) && !methodName.equals("is".concat(property)) && (!methodName.startsWith("is") || !methodName.equals(property))) continue;
                String typeName = method.getReturnType().getSimpleName().toLowerCase();
                if ("string".equals(typeName)) {
                    fieldsType[i] = 12;
                    continue block0;
                }
                if ("integer".equals(typeName)) {
                    fieldsType[i] = 4;
                    continue block0;
                }
                if ("bigdecimal".equals(typeName)) {
                    fieldsType[i] = 3;
                    continue block0;
                }
                if ("date".equals(typeName)) {
                    fieldsType[i] = 91;
                    continue block0;
                }
                if ("timestamp".equals(typeName)) {
                    fieldsType[i] = 93;
                    continue block0;
                }
                if ("int".equals(typeName)) {
                    fieldsType[i] = 4;
                    continue block0;
                }
                if ("long".equals(typeName)) {
                    fieldsType[i] = 2;
                    continue block0;
                }
                if ("double".equals(typeName)) {
                    fieldsType[i] = 8;
                    continue block0;
                }
                if ("clob".equals(typeName)) {
                    fieldsType[i] = 2005;
                    continue block0;
                }
                if ("biginteger".equals(typeName)) {
                    fieldsType[i] = -5;
                    continue block0;
                }
                if ("blob".equals(typeName)) {
                    fieldsType[i] = 2004;
                    continue block0;
                }
                if ("byte[]".equals(typeName)) {
                    fieldsType[i] = -2;
                    continue block0;
                }
                if ("boolean".equals(typeName)) {
                    fieldsType[i] = 16;
                    continue block0;
                }
                if ("char".equals(typeName)) {
                    fieldsType[i] = 1;
                    continue block0;
                }
                if ("number".equals(typeName)) {
                    fieldsType[i] = 2;
                    continue block0;
                }
                if ("short".equals(typeName)) {
                    fieldsType[i] = 2;
                    continue block0;
                }
                if ("float".equals(typeName)) {
                    fieldsType[i] = 6;
                    continue block0;
                }
                if ("datetime".equals(typeName)) {
                    fieldsType[i] = 91;
                    continue block0;
                }
                if ("time".equals(typeName)) {
                    fieldsType[i] = 92;
                    continue block0;
                }
                if ("byte".equals(typeName)) {
                    fieldsType[i] = -6;
                    continue block0;
                }
                if (typeName.endsWith("[]")) {
                    fieldsType[i] = 2003;
                    continue block0;
                }
                fieldsType[i] = 0;
                continue block0;
            }
        }
        return fieldsType;
    }

    public static Object invokeMethod(Object bean, String methodName, Object[] args) throws Exception {
        try {
            Method method = BeanUtil.getMethod(bean.getClass(), methodName, args == null ? 0 : args.length);
            if (method == null) {
                return null;
            }
            return method.invoke(bean, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static boolean equals(Object target, Object compared) {
        if (null == target) {
            return target == compared;
        }
        return target.equals(compared);
    }

    public static boolean equalsIgnoreType(Object target, Object compared, boolean ignoreCase) {
        if (target == null || compared == null) {
            return target == compared;
        }
        if (target.getClass().equals(compared.getClass()) && !(target instanceof CharSequence)) {
            return target.equals(compared);
        }
        if (ignoreCase) {
            return target.toString().equalsIgnoreCase(compared.toString());
        }
        return target.toString().equals(compared.toString());
    }

    public static int compare(Object target, Object compared) {
        if (null == target && null == compared) {
            return 0;
        }
        if (null == target) {
            return -1;
        }
        if (null == compared) {
            return 1;
        }
        if (target.equals(compared)) {
            return 0;
        }
        if (target instanceof java.util.Date || target instanceof LocalDate || target instanceof LocalTime || target instanceof LocalDateTime || compared instanceof java.util.Date || compared instanceof LocalDate || compared instanceof LocalTime || compared instanceof LocalDateTime) {
            return DateUtil.convertDateObject(target).compareTo(DateUtil.convertDateObject(compared));
        }
        if (target instanceof Number || compared instanceof Number) {
            return new BigDecimal(target.toString()).compareTo(new BigDecimal(compared.toString()));
        }
        return target.toString().compareTo(compared.toString());
    }

    public static Object convertType(Object value, int typeValue, String typeName) throws Exception {
        return BeanUtil.convertType(null, value, typeValue, typeName, null);
    }

    public static Object convertType(TypeHandler typeHandler, Object value, int typeValue, String typeName, Class genericType) throws Exception {
        Object[] tmp;
        String valueStr;
        Clob clob;
        Object result;
        Object paramValue = value;
        if (paramValue == null) {
            if (typeValue >= 1 && typeValue <= 5) {
                return 0;
            }
            if (6 == typeValue) {
                return false;
            }
            if (7 == typeValue) {
                return Character.valueOf(" ".charAt(0));
            }
            if (8 == typeValue) {
                return (byte)Byte.valueOf("0");
            }
            return null;
        }
        if (value.getClass().getTypeName().equals(typeName)) {
            return value;
        }
        if (typeHandler != null && (result = typeHandler.toJavaType(typeName, genericType, paramValue)) != null) {
            return result;
        }
        if (paramValue.getClass().isArray() && typeValue < 91) {
            if (typeValue == 11 && paramValue instanceof byte[]) {
                paramValue = new String((byte[])paramValue);
            } else if (typeValue == 11 && paramValue instanceof char[]) {
                paramValue = new String((char[])paramValue);
            } else {
                Object[] paramAry = CollectionUtil.convertArray(paramValue);
                if (paramAry.length > 1) {
                    throw new DataAccessException("\u4e0d\u80fd\u5c06\u957f\u5ea6\u5927\u4e8e1,\u7c7b\u578b\u4e3a:" + paramValue.getClass().getTypeName() + " \u7684\u6570\u7ec4\u8f6c\u5316\u4e3a:" + typeName + " \u7c7b\u578b\u7684\u503c,\u8bf7\u68c0\u67e5!");
                }
                paramValue = paramAry[0];
                if (paramValue == null) {
                    return null;
                }
            }
        }
        if (11 == typeValue) {
            if (paramValue instanceof Clob) {
                clob = (Clob)paramValue;
                return clob.getSubString(1L, (int)clob.length());
            }
            if (paramValue instanceof LocalDate) {
                return DateUtil.formatDate(paramValue, "yyyy-MM-dd");
            }
            if (paramValue instanceof LocalTime) {
                return DateUtil.formatDate(paramValue, "HH:mm:ss");
            }
            if (paramValue instanceof java.util.Date) {
                return DateUtil.formatDate(paramValue, "yyyy-MM-dd HH:mm:ss");
            }
            if (paramValue instanceof Enum) {
                return BeanUtil.getEnumValue(paramValue).toString();
            }
            return paramValue.toString();
        }
        if (20 == typeValue) {
            valueStr = BeanUtil.enumToString(paramValue);
            if ("".equals(valueStr.trim())) {
                return null;
            }
            return new BigDecimal(BeanUtil.convertBoolean(valueStr));
        }
        if (21 == typeValue) {
            valueStr = BeanUtil.enumToString(paramValue);
            if ("".equals(valueStr.trim())) {
                return null;
            }
            return Integer.valueOf(BeanUtil.convertBoolean(valueStr).split("\\.")[0]);
        }
        if (43 == typeValue) {
            if (paramValue instanceof LocalDateTime) {
                return (LocalDateTime)paramValue;
            }
            if ("oracle.sql.TIMESTAMP".equals(paramValue.getClass().getTypeName())) {
                return DateUtil.asLocalDateTime(BeanUtil.oracleTimeStampConvert(paramValue));
            }
            return DateUtil.asLocalDateTime(DateUtil.convertDateObject(paramValue));
        }
        if (41 == typeValue) {
            if (paramValue instanceof LocalDate) {
                return (LocalDate)paramValue;
            }
            if ("oracle.sql.TIMESTAMP".equals(paramValue.getClass().getTypeName())) {
                return DateUtil.asLocalDate(BeanUtil.oracleDateConvert(paramValue));
            }
            return DateUtil.asLocalDate(DateUtil.convertDateObject(paramValue));
        }
        if (42 == typeValue) {
            if (paramValue instanceof Timestamp) {
                return (Timestamp)paramValue;
            }
            if (paramValue instanceof java.util.Date) {
                return new Timestamp(((java.util.Date)paramValue).getTime());
            }
            if ("oracle.sql.TIMESTAMP".equals(paramValue.getClass().getTypeName())) {
                return BeanUtil.oracleTimeStampConvert(paramValue);
            }
            valueStr = paramValue.toString();
            if ("".equals(valueStr.trim())) {
                return null;
            }
            return new Timestamp(DateUtil.parseString(valueStr).getTime());
        }
        if (22 == typeValue) {
            valueStr = BeanUtil.enumToString(paramValue);
            if ("".equals(valueStr.trim())) {
                return null;
            }
            return Long.valueOf(BeanUtil.convertBoolean(valueStr).split("\\.")[0]);
        }
        if (1 == typeValue) {
            valueStr = BeanUtil.enumToString(paramValue);
            if ("".equals(valueStr.trim())) {
                return 0;
            }
            return Double.valueOf(BeanUtil.convertBoolean(valueStr)).intValue();
        }
        if (27 == typeValue) {
            valueStr = paramValue.toString();
            if ("true".equals(valueStr.toLowerCase()) || "1".equals(valueStr)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (6 == typeValue) {
            valueStr = paramValue.toString();
            if ("true".equals(valueStr.toLowerCase()) || "1".equals(valueStr)) {
                return true;
            }
            return false;
        }
        if (45 == typeValue) {
            if (paramValue instanceof java.util.Date) {
                return (java.util.Date)paramValue;
            }
            if (paramValue instanceof Number) {
                return new java.util.Date(((Number)paramValue).longValue());
            }
            if ("oracle.sql.TIMESTAMP".equals(paramValue.getClass().getTypeName())) {
                return BeanUtil.oracleDateConvert(paramValue);
            }
            return DateUtil.parseString(paramValue.toString());
        }
        if (26 == typeValue) {
            valueStr = BeanUtil.enumToString(paramValue);
            if ("".equals(valueStr.trim())) {
                return null;
            }
            return new BigInteger(BeanUtil.convertBoolean(valueStr).split("\\.")[0]);
        }
        if (25 == typeValue) {
            valueStr = BeanUtil.enumToString(paramValue);
            if ("".equals(valueStr.trim())) {
                return null;
            }
            return Double.valueOf(BeanUtil.convertBoolean(valueStr));
        }
        if (44 == typeValue) {
            if (paramValue instanceof LocalTime) {
                return (LocalTime)paramValue;
            }
            if ("oracle.sql.TIMESTAMP".equals(paramValue.getClass().getTypeName())) {
                return DateUtil.asLocalTime(BeanUtil.oracleTimeStampConvert(paramValue));
            }
            return DateUtil.asLocalTime(DateUtil.convertDateObject(paramValue));
        }
        if (2 == typeValue) {
            valueStr = BeanUtil.enumToString(paramValue);
            if ("".equals(valueStr.trim())) {
                return 0;
            }
            return Double.valueOf(BeanUtil.convertBoolean(valueStr)).longValue();
        }
        if (5 == typeValue) {
            valueStr = BeanUtil.enumToString(paramValue);
            if ("".equals(valueStr.trim())) {
                return 0;
            }
            return Double.parseDouble(BeanUtil.convertBoolean(valueStr));
        }
        if (92 == typeValue) {
            if (paramValue instanceof byte[]) {
                return (byte[])paramValue;
            }
            if (paramValue instanceof Blob) {
                Blob blob = (Blob)paramValue;
                return blob.getBytes(1L, (int)blob.length());
            }
            return paramValue.toString().getBytes();
        }
        if (23 == typeValue) {
            valueStr = BeanUtil.enumToString(paramValue);
            if ("".equals(valueStr.trim())) {
                return null;
            }
            return Float.valueOf(BeanUtil.convertBoolean(valueStr));
        }
        if (4 == typeValue) {
            valueStr = BeanUtil.enumToString(paramValue);
            if ("".equals(valueStr.trim())) {
                return 0;
            }
            return Float.valueOf(Float.parseFloat(BeanUtil.convertBoolean(valueStr)));
        }
        if (24 == typeValue) {
            valueStr = BeanUtil.enumToString(paramValue);
            if ("".equals(valueStr.trim())) {
                return null;
            }
            return Double.valueOf(BeanUtil.convertBoolean(valueStr)).shortValue();
        }
        if (3 == typeValue) {
            valueStr = BeanUtil.enumToString(paramValue);
            if ("".equals(valueStr.trim())) {
                return 0;
            }
            return Double.valueOf(BeanUtil.convertBoolean(valueStr)).shortValue();
        }
        if (46 == typeValue) {
            if (paramValue instanceof Date) {
                return (Date)paramValue;
            }
            if (paramValue instanceof java.util.Date) {
                return new Date(((java.util.Date)paramValue).getTime());
            }
            if ("oracle.sql.TIMESTAMP".equals(paramValue.getClass().getTypeName())) {
                return new Date(BeanUtil.oracleDateConvert(paramValue).getTime());
            }
            valueStr = paramValue.toString();
            if ("".equals(valueStr.trim())) {
                return null;
            }
            return new Date(DateUtil.parseString(valueStr).getTime());
        }
        if (12 == typeValue) {
            int c;
            if (paramValue instanceof String) {
                return paramValue.toString();
            }
            clob = (Clob)paramValue;
            BufferedReader in = new BufferedReader(clob.getCharacterStream());
            StringWriter out = new StringWriter();
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            return out.toString();
        }
        if (47 == typeValue) {
            if (paramValue instanceof Time) {
                return (Time)paramValue;
            }
            if (paramValue instanceof java.util.Date) {
                return new Time(((java.util.Date)paramValue).getTime());
            }
            if ("oracle.sql.TIMESTAMP".equals(paramValue.getClass().getTypeName())) {
                return new Time(BeanUtil.oracleDateConvert(paramValue).getTime());
            }
            return new Time(DateUtil.parseString(paramValue.toString()).getTime());
        }
        if (8 == typeValue) {
            return (byte)Byte.valueOf(paramValue.toString());
        }
        if (7 == typeValue) {
            valueStr = paramValue.toString();
            if ("".equals(valueStr.trim())) {
                return Character.valueOf(" ".charAt(0));
            }
            return Character.valueOf(valueStr.charAt(0));
        }
        if (91 == typeValue) {
            if (paramValue instanceof char[]) {
                return (char[])paramValue;
            }
            if (paramValue instanceof Clob) {
                int c;
                clob = (Clob)paramValue;
                BufferedReader in = new BufferedReader(clob.getCharacterStream());
                StringWriter out = new StringWriter();
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                return out.toString().toCharArray();
            }
            return paramValue.toString().toCharArray();
        }
        if (28 == typeValue) {
            return Byte.valueOf(paramValue.toString());
        }
        if (93 == typeValue) {
            if (paramValue instanceof Array) {
                return BeanUtil.convertArray(((Array)paramValue).getArray(), typeName);
            }
            if (paramValue instanceof Collection) {
                return BeanUtil.convertArray(((Collection)paramValue).toArray(), typeName);
            }
        }
        if (101 == typeValue) {
            if (paramValue instanceof Array) {
                tmp = (Object[])((Array)paramValue).getArray();
                if (genericType != null) {
                    return CollectionUtil.arrayToList(BeanUtil.convertArray(tmp, genericType.getName().concat("[]")));
                }
                return CollectionUtil.arrayToList(tmp);
            }
            if (paramValue instanceof Object[]) {
                if (genericType != null) {
                    return CollectionUtil.arrayToList(BeanUtil.convertArray(paramValue, genericType.getName().concat("[]")));
                }
                return CollectionUtil.arrayToList((Object[])paramValue);
            }
            if (paramValue instanceof Set) {
                tmp = ((Set)paramValue).toArray();
                if (genericType != null) {
                    return CollectionUtil.arrayToList(BeanUtil.convertArray(tmp, genericType.getName().concat("[]")));
                }
                return CollectionUtil.arrayToList(tmp);
            }
        }
        if (102 == typeValue) {
            if (paramValue instanceof Array) {
                tmp = (Object[])((Array)paramValue).getArray();
                if (genericType != null) {
                    return BeanUtil.arrayToSet((Object[])BeanUtil.convertArray(tmp, genericType.getName().concat("[]")));
                }
                return BeanUtil.arrayToSet(tmp);
            }
            if (paramValue instanceof Object[]) {
                if (genericType != null) {
                    return BeanUtil.arrayToSet((Object[])BeanUtil.convertArray(paramValue, genericType.getName().concat("[]")));
                }
                return BeanUtil.arrayToSet((Object[])paramValue);
            }
            if (paramValue instanceof Collection) {
                tmp = ((Collection)paramValue).toArray();
                if (genericType != null) {
                    return BeanUtil.arrayToSet((Object[])BeanUtil.convertArray(tmp, genericType.getName().concat("[]")));
                }
                return BeanUtil.arrayToSet(tmp);
            }
        }
        if (110 == typeValue) {
            Class<?> enumClass = enumClassMap.get(typeName);
            if (enumClass == null) {
                enumClass = Class.forName(typeName);
                enumClassMap.put(typeName, enumClass);
            }
            return BeanUtil.newEnumInstance(paramValue, enumClass);
        }
        return paramValue;
    }

    private static String enumToString(Object paramValue) {
        if (paramValue instanceof Enum) {
            return BeanUtil.getEnumValue(paramValue).toString();
        }
        return paramValue.toString();
    }

    private static HashSet arrayToSet(Object[] values) {
        HashSet<Object> result = new HashSet<Object>();
        for (Object val : values) {
            if (val == null) continue;
            result.add(val);
        }
        return result;
    }

    public static String convertBoolean(String boolVar) {
        if ("true".equals(boolVar)) {
            return "1";
        }
        if ("false".equals(boolVar)) {
            return "0";
        }
        return boolVar;
    }

    private static Timestamp oracleTimeStampConvert(Object obj) throws Exception {
        return ((TIMESTAMP)obj).timestampValue();
    }

    private static java.util.Date oracleDateConvert(Object obj) throws Exception {
        return ((TIMESTAMP)obj).dateValue();
    }

    public static List reflectBeansToList(List datas, String[] props) throws RuntimeException {
        return BeanUtil.reflectBeansToList(datas, props, null);
    }

    public static Object[] sliceToArray(List datas, String propertyName) throws RuntimeException {
        List sliceList = BeanUtil.reflectBeansToList(datas, new String[]{propertyName}, null);
        if (sliceList == null || sliceList.isEmpty()) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (int i = 0; i < sliceList.size(); ++i) {
            List row = (List)sliceList.get(i);
            if (row == null || row.get(0) == null) continue;
            result.add(row.get(0));
        }
        if (result.isEmpty()) {
            return null;
        }
        Object[] ary = new Object[result.size()];
        result.toArray(ary);
        return ary;
    }

    public static List reflectBeansToList(List datas, String[] properties, ReflectPropsHandler reflectPropsHandler) throws RuntimeException {
        if (null == datas || datas.isEmpty() || null == properties || properties.length < 1) {
            return null;
        }
        ArrayList<List> resultList = new ArrayList<List>();
        try {
            boolean hasHandler;
            Object rowObject = null;
            int methodLength = properties.length;
            boolean bl = hasHandler = reflectPropsHandler != null;
            if (hasHandler) {
                HashMap<String, Integer> propertyIndexMap = new HashMap<String, Integer>();
                for (int i = 0; i < methodLength; ++i) {
                    propertyIndexMap.put(properties[i].toLowerCase(), i);
                }
                reflectPropsHandler.setPropertyIndexMap(propertyIndexMap);
            }
            boolean hasInnerClass = false;
            for (String prop : properties) {
                if (!prop.contains(".")) continue;
                hasInnerClass = true;
                break;
            }
            if (hasInnerClass) {
                int n = datas.size();
                for (int i = 0; i < n; ++i) {
                    Object[] rowAry;
                    rowObject = datas.get(i);
                    if (rowObject == null) continue;
                    ArrayList<Object> rowList = new ArrayList<Object>();
                    for (Object cell : rowAry = BeanUtil.reflectBeanToAry(rowObject, properties, null, reflectPropsHandler)) {
                        rowList.add(cell);
                    }
                    resultList.add(rowList);
                }
                return resultList;
            }
            Method[] realMethods = null;
            boolean inited = false;
            Object[] params = new Object[]{};
            boolean isMap = false;
            if (datas.get(0) != null && Map.class.isAssignableFrom(datas.get(0).getClass())) {
                isMap = true;
            }
            int n = datas.size();
            for (int i = 0; i < n; ++i) {
                rowObject = datas.get(i);
                if (null != rowObject) {
                    int j;
                    ArrayList<Object> dataList = new ArrayList<Object>();
                    if (isMap) {
                        Map rowMap;
                        if (rowObject instanceof IgnoreKeyCaseMap) {
                            rowMap = (IgnoreKeyCaseMap)rowObject;
                            for (j = 0; j < methodLength; ++j) {
                                dataList.add(rowMap.get(properties[j]));
                            }
                        } else {
                            rowMap = (Map)rowObject;
                            block8: for (j = 0; j < methodLength; ++j) {
                                String fieldLow = properties[j].toLowerCase();
                                for (Map.Entry entry : rowMap.entrySet()) {
                                    if (!((String)entry.getKey()).toLowerCase().equals(fieldLow)) continue;
                                    dataList.add(entry.getValue());
                                    continue block8;
                                }
                            }
                        }
                    } else {
                        if (!inited) {
                            realMethods = BeanUtil.matchGetMethods(rowObject.getClass(), properties);
                            inited = true;
                        }
                        for (j = 0; j < methodLength; ++j) {
                            if (realMethods[j] != null) {
                                dataList.add(realMethods[j].invoke(rowObject, params));
                                continue;
                            }
                            dataList.add(null);
                        }
                    }
                    if (hasHandler) {
                        reflectPropsHandler.setRowIndex(i);
                        reflectPropsHandler.setRowList(dataList);
                        reflectPropsHandler.process();
                        resultList.add(reflectPropsHandler.getRowList());
                        continue;
                    }
                    resultList.add(dataList);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("BeanUtil.reflectBeansToList \u65b9\u6cd5,\u7b2c:{}\u884c\u6570\u636e\u4e3anull,\u5982\u679c\u662fsql\u67e5\u8be2\u8bf7\u68c0\u67e5\u5199\u6cd5\u662f\u5426\u6b63\u786e!", (Object)i);
                } else {
                    System.err.println("BeanUtil.reflectBeansToList \u65b9\u6cd5,\u7b2c:{" + i + "}\u884c\u6570\u636e\u4e3anull,\u5982\u679c\u662fsql\u67e5\u8be2\u8bf7\u68c0\u67e5\u5199\u6cd5\u662f\u5426\u6b63\u786e!");
                }
                resultList.add(null);
            }
        }
        catch (Exception e) {
            logger.error("\u53cd\u5c04Java Bean\u83b7\u53d6\u6570\u636e\u7ec4\u88c5List\u96c6\u5408\u5f02\u5e38!{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u53cd\u5c04Java Bean\u83b7\u53d6\u6570\u636e\u7ec4\u88c5List\u96c6\u5408\u5f02\u5e38!" + e.getMessage());
        }
        return resultList;
    }

    public static Object[] reflectBeanToAry(Object serializable, String[] properties) {
        return BeanUtil.reflectBeanToAry(serializable, properties, null, null);
    }

    public static Object[] reflectBeanToAry(Object serializable, String[] properties, Object[] defaultValues, ReflectPropsHandler reflectPropsHandler) {
        int i;
        boolean hasHandler;
        if (null == serializable || null == properties || properties.length == 0) {
            return null;
        }
        int methodLength = properties.length;
        Object[] result = new Object[methodLength];
        boolean bl = hasHandler = reflectPropsHandler != null;
        if (hasHandler && !reflectPropsHandler.initPropsIndexMap()) {
            HashMap<String, Integer> propertyIndexMap = new HashMap<String, Integer>();
            for (int i2 = 0; i2 < methodLength; ++i2) {
                propertyIndexMap.put(properties[i2].toLowerCase(), i2);
            }
            reflectPropsHandler.setPropertyIndexMap(propertyIndexMap);
        }
        boolean isMapped = false;
        boolean hasKey = false;
        try {
            for (i = 0; i < methodLength; ++i) {
                Map.Entry entry;
                String fieldLow;
                Iterator iter;
                if (properties[i] == null) continue;
                String[] fields = properties[i].split("\\.");
                Object fieldValue = serializable;
                hasKey = false;
                if (fieldValue instanceof Map) {
                    iter = ((Map)fieldValue).entrySet().iterator();
                    fieldLow = properties[i].trim().toLowerCase();
                    while (iter.hasNext()) {
                        entry = iter.next();
                        if (!((String)entry.getKey()).toLowerCase().equals(fieldLow)) continue;
                        fieldValue = entry.getValue();
                        hasKey = true;
                        break;
                    }
                }
                if (!hasKey) {
                    int index = 0;
                    int fieldLen = fields.length;
                    for (String field : fields) {
                        int j;
                        Object[] fieldValueAry;
                        Object[] tmp;
                        String fieldTrim = field.trim();
                        if (fieldValue instanceof Map) {
                            KeyAndIndex keyAndIndex;
                            if (fieldValue instanceof IgnoreKeyCaseMap) {
                                fieldValue = !((IgnoreKeyCaseMap)fieldValue).containsKey(fieldTrim) ? ((keyAndIndex = BeanUtil.getKeyAndIndex(fieldTrim)) != null ? BeanUtil.getArrayIndexValue(((IgnoreKeyCaseMap)fieldValue).get(keyAndIndex.getKey()), keyAndIndex.getIndex()) : null) : ((IgnoreKeyCaseMap)fieldValue).get(fieldTrim);
                            } else {
                                iter = ((Map)fieldValue).entrySet().iterator();
                                isMapped = false;
                                fieldLow = fieldTrim.toLowerCase();
                                while (iter.hasNext()) {
                                    entry = iter.next();
                                    if (((String)entry.getKey()).toLowerCase().equals(fieldLow)) {
                                        fieldValue = entry.getValue();
                                        isMapped = true;
                                        break;
                                    }
                                    keyAndIndex = BeanUtil.getKeyAndIndex(fieldLow);
                                    if (keyAndIndex == null || !((String)entry.getKey()).toLowerCase().equals(keyAndIndex.getKey())) continue;
                                    fieldValue = BeanUtil.getArrayIndexValue(entry.getValue(), keyAndIndex.getIndex());
                                    isMapped = true;
                                    break;
                                }
                                if (!isMapped) {
                                    fieldValue = null;
                                }
                            }
                        } else if (fieldValue instanceof List) {
                            tmp = fieldValue;
                            if (index < fieldLen - 1) {
                                fieldValue = BeanUtil.sliceToArray((List)tmp, fieldTrim);
                            } else {
                                fieldValueAry = new Object[tmp.size()];
                                for (j = 0; j < tmp.size(); ++j) {
                                    fieldValueAry[j] = BeanUtil.getComplexProperty(tmp.get(j), fieldTrim);
                                }
                                fieldValue = fieldValueAry;
                            }
                        } else if (fieldValue instanceof Object[]) {
                            tmp = fieldValue;
                            fieldValueAry = new Object[tmp.length];
                            for (j = 0; j < tmp.length; ++j) {
                                fieldValueAry[j] = BeanUtil.getComplexProperty(tmp[j], fieldTrim);
                            }
                            fieldValue = fieldValueAry;
                        } else {
                            fieldValue = BeanUtil.getComplexProperty(fieldValue, fieldTrim);
                        }
                        if (fieldValue == null) break;
                        ++index;
                    }
                }
                result[i] = fieldValue;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (defaultValues != null) {
            int end = defaultValues.length > methodLength ? methodLength : defaultValues.length;
            for (i = 0; i < end; ++i) {
                if (result[i] != null) continue;
                result[i] = defaultValues[i];
            }
        }
        if (hasHandler) {
            reflectPropsHandler.setRowIndex(0);
            reflectPropsHandler.setRowData(result);
            reflectPropsHandler.process();
            return reflectPropsHandler.getRowData();
        }
        return result;
    }

    public static List<Object[]> reflectBeansToInnerAry(List dataSet, String[] properties, Object[] defaultValues, ReflectPropsHandler reflectPropsHandler) {
        if (null == dataSet || dataSet.isEmpty() || null == properties || properties.length < 1) {
            return null;
        }
        ArrayList<Object[]> resultList = new ArrayList<Object[]>();
        try {
            boolean hasHandler;
            int methodLength = properties.length;
            int defaultValueLength = defaultValues == null ? 0 : defaultValues.length;
            Method[] realMethods = null;
            boolean inited = false;
            Object rowObject = null;
            Object[] params = new Object[]{};
            boolean bl = hasHandler = reflectPropsHandler != null;
            if (hasHandler) {
                HashMap<String, Integer> propertyIndexMap = new HashMap<String, Integer>();
                for (int i = 0; i < methodLength; ++i) {
                    propertyIndexMap.put(properties[i].toLowerCase(), i);
                }
                reflectPropsHandler.setPropertyIndexMap(propertyIndexMap);
            }
            int n = dataSet.size();
            for (int i = 0; i < n; ++i) {
                rowObject = dataSet.get(i);
                if (null != rowObject) {
                    if (!inited) {
                        realMethods = BeanUtil.matchGetMethods(rowObject.getClass(), properties);
                        inited = true;
                    }
                    Object[] dataAry = new Object[methodLength];
                    for (int j = 0; j < methodLength; ++j) {
                        if (null != realMethods[j]) {
                            dataAry[j] = realMethods[j].invoke(rowObject, params);
                            if (null != dataAry[j] || null == defaultValues) continue;
                            dataAry[j] = j >= defaultValueLength ? null : defaultValues[j];
                            continue;
                        }
                        dataAry[j] = null == defaultValues ? null : (j >= defaultValueLength ? null : defaultValues[j]);
                    }
                    if (hasHandler) {
                        reflectPropsHandler.setRowIndex(i);
                        reflectPropsHandler.setRowData(dataAry);
                        reflectPropsHandler.process();
                        resultList.add(reflectPropsHandler.getRowData());
                        continue;
                    }
                    resultList.add(dataAry);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("BeanUtil.reflectBeansToInnerAry \u65b9\u6cd5,\u7b2c:{}\u884c\u6570\u636e\u4e3anull,\u5982\u679c\u662fsql\u67e5\u8be2\u8bf7\u68c0\u67e5\u5199\u6cd5\u662f\u5426\u6b63\u786e!", (Object)i);
                } else {
                    System.err.println("BeanUtil.reflectBeansToInnerAry \u65b9\u6cd5,\u7b2c:{" + i + "}\u884c\u6570\u636e\u4e3anull,\u5982\u679c\u662fsql\u67e5\u8be2\u8bf7\u68c0\u67e5\u5199\u6cd5\u662f\u5426\u6b63\u786e!");
                }
                resultList.add(null);
            }
        }
        catch (Exception e) {
            logger.error("\u53cd\u5c04Java Bean\u83b7\u53d6\u6570\u636e\u7ec4\u88c5List\u96c6\u5408\u5f02\u5e38!{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return resultList;
    }

    public static List reflectListToBean(TypeHandler typeHandler, Collection datas, String[] properties, Class voClass) {
        int[] indexs = null;
        if (properties != null && properties.length > 0) {
            indexs = new int[properties.length];
            for (int i = 0; i < indexs.length; ++i) {
                indexs[i] = i;
            }
        }
        return BeanUtil.reflectListToBean(typeHandler, datas, indexs, properties, voClass, true);
    }

    public static List reflectListToBean(TypeHandler typeHandler, Collection datas, int[] indexs, String[] properties, Class voClass) throws RuntimeException {
        return BeanUtil.reflectListToBean(typeHandler, datas, indexs, properties, voClass, true);
    }

    public static List reflectListToBean(TypeHandler typeHandler, Collection datas, int[] indexs, String[] properties, Class voClass, boolean autoConvertType) {
        if (null == datas || datas.isEmpty()) {
            return null;
        }
        if (null == properties || properties.length < 1 || null == voClass || null == indexs || indexs.length == 0 || properties.length != indexs.length) {
            throw new IllegalArgumentException("\u96c6\u5408\u6216\u5c5e\u6027\u540d\u79f0\u6570\u7ec4\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u53c2\u6570\u4fe1\u606f!");
        }
        if (Modifier.isAbstract(voClass.getModifiers()) || Modifier.isInterface(voClass.getModifiers())) {
            throw new IllegalArgumentException("toClassType:" + voClass.getName() + " \u662f\u62bd\u8c61\u7c7b\u6216\u63a5\u53e3,\u975e\u6cd5\u53c2\u6570!");
        }
        ArrayList resultList = new ArrayList();
        Object cellData = null;
        String propertyName = null;
        try {
            Object rowObject = null;
            boolean isArray = false;
            int meter = 0;
            int indexSize = indexs.length;
            Method[] realMethods = BeanUtil.matchSetMethods(voClass, properties);
            String[] methodTypes = new String[indexSize];
            int[] methodTypeValues = new int[indexSize];
            Class[] genericTypes = new Class[indexSize];
            if (autoConvertType) {
                for (int i = 0; i < indexSize; ++i) {
                    if (null == realMethods[i]) continue;
                    Class<?> methodType = realMethods[i].getParameterTypes()[0];
                    methodTypes[i] = methodType.getTypeName();
                    methodTypeValues[i] = DataType.getType(methodType);
                    Type[] types = realMethods[i].getGenericParameterTypes();
                    if (types.length <= 0 || !(types[0] instanceof ParameterizedType)) continue;
                    genericTypes[i] = (Class)((ParameterizedType)types[0]).getActualTypeArguments()[0];
                }
            }
            Iterator iter = datas.iterator();
            int index = 0;
            while (iter.hasNext()) {
                rowObject = iter.next();
                if (rowObject != null) {
                    int i;
                    int size;
                    Object bean = voClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (meter == 0 && rowObject instanceof Object[]) {
                        isArray = true;
                    }
                    if (isArray) {
                        Object[] rowArray = rowObject;
                        size = rowArray.length;
                        for (i = 0; i < indexSize; ++i) {
                            if (indexs[i] >= size) continue;
                            cellData = rowArray[indexs[i]];
                            if (realMethods[i] == null || cellData == null) continue;
                            propertyName = realMethods[i].getName();
                            if (cellData.getClass().getTypeName().equals(methodTypes[i])) {
                                realMethods[i].invoke(bean, cellData);
                                continue;
                            }
                            realMethods[i].invoke(bean, autoConvertType ? BeanUtil.convertType(typeHandler, cellData, methodTypeValues[i], methodTypes[i], genericTypes[i]) : cellData);
                        }
                    } else {
                        List rowList = rowObject;
                        size = rowList.size();
                        for (i = 0; i < indexSize; ++i) {
                            if (indexs[i] >= size) continue;
                            cellData = rowList.get(indexs[i]);
                            if (realMethods[i] == null || cellData == null) continue;
                            propertyName = realMethods[i].getName();
                            if (cellData.getClass().getTypeName().equals(methodTypes[i])) {
                                realMethods[i].invoke(bean, cellData);
                                continue;
                            }
                            realMethods[i].invoke(bean, autoConvertType ? BeanUtil.convertType(typeHandler, cellData, methodTypeValues[i], methodTypes[i], genericTypes[i]) : cellData);
                        }
                    }
                    resultList.add(bean);
                    ++meter;
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("BeanUtil.reflectListToBean \u65b9\u6cd5,\u7b2c:{}\u884c\u6570\u636e\u4e3anull,\u5982\u679c\u662fsql\u67e5\u8be2\u8bf7\u68c0\u67e5\u5199\u6cd5\u662f\u5426\u6b63\u786e!", (Object)index);
                    } else {
                        System.err.println("BeanUtil.reflectListToBean \u65b9\u6cd5,\u7b2c:{" + index + "}\u884c\u6570\u636e\u4e3anull,\u5982\u679c\u662fsql\u67e5\u8be2\u8bf7\u68c0\u67e5\u5199\u6cd5\u662f\u5426\u6b63\u786e!");
                    }
                    resultList.add(null);
                }
                ++index;
            }
        }
        catch (Exception e) {
            String errorMsg = "";
            if (propertyName == null) {
                errorMsg = "\u5c06\u96c6\u5408\u6570\u636e\u6620\u5c04\u5230\u7c7b:" + voClass.getName() + " \u5f02\u5e38,\u8bf7\u68c0\u67e5\u7c7b\u662f\u5426\u6b63\u786e!" + e.getMessage();
                logger.error(errorMsg);
            } else {
                errorMsg = "\u5c06\u96c6\u5408\u6570\u636e:[" + cellData + "] \u6620\u5c04\u5230\u7c7b:" + voClass.getName() + " \u7684\u5c5e\u6027:" + propertyName + ":\u8fc7\u7a0b\u5f02\u5e38!" + e.getMessage();
                logger.error(errorMsg);
            }
            throw new RuntimeException(errorMsg, e);
        }
        return resultList;
    }

    public static <T extends Serializable> T reflectRowToBean(TypeHandler typeHandler, Method[] realMethods, int[] methodTypeValues, String[] methodTypes, Class[] genericTypes, List rowList, int[] indexs, String[] properties, Class<T> voClass) {
        Object cellData = null;
        String propertyName = null;
        Object bean = null;
        try {
            bean = voClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            int indexSize = indexs.length;
            int size = rowList.size();
            for (int i = 0; i < indexSize; ++i) {
                if (indexs[i] >= size) continue;
                cellData = rowList.get(indexs[i]);
                if (realMethods[i] == null || cellData == null) continue;
                propertyName = realMethods[i].getName();
                if (cellData.getClass().getTypeName().equals(methodTypes[i])) {
                    realMethods[i].invoke(bean, cellData);
                    continue;
                }
                realMethods[i].invoke(bean, BeanUtil.convertType(typeHandler, cellData, methodTypeValues[i], methodTypes[i], genericTypes[i]));
            }
        }
        catch (Exception e) {
            String errorMsg = "";
            if (propertyName == null) {
                errorMsg = "\u5c06\u96c6\u5408\u6570\u636e\u6620\u5c04\u5230\u7c7b:" + voClass.getName() + " \u5f02\u5e38,\u8bf7\u68c0\u67e5\u7c7b\u662f\u5426\u6b63\u786e!" + e.getMessage();
                logger.error(errorMsg);
            } else {
                errorMsg = "\u5c06\u96c6\u5408\u6570\u636e:[" + cellData + "] \u6620\u5c04\u5230\u7c7b:" + voClass.getName() + " \u7684\u5c5e\u6027:" + propertyName + ":\u8fc7\u7a0b\u5f02\u5e38!" + e.getMessage();
                logger.error(errorMsg);
            }
            throw new RuntimeException(errorMsg, e);
        }
        return (T)((Serializable)bean);
    }

    public static void batchSetProperties(Collection voList, String[] properties, Object[] values, boolean autoConvertType) {
        BeanUtil.batchSetProperties(voList, properties, values, autoConvertType, true);
    }

    public static void batchSetProperties(Collection voList, String[] properties, Object[] values, boolean autoConvertType, boolean forceUpdate) {
        if (null == voList || voList.isEmpty()) {
            return;
        }
        if (null == properties || properties.length < 1 || null == values || values.length < 1 || properties.length != values.length) {
            throw new IllegalArgumentException("\u96c6\u5408\u6216\u5c5e\u6027\u540d\u79f0\u6570\u7ec4\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u53c2\u6570\u4fe1\u606f!");
        }
        try {
            int indexSize = properties.length;
            Method[] realMethods = null;
            String[] methodTypes = new String[indexSize];
            int[] methodTypeValues = new int[indexSize];
            Class[] genericTypes = new Class[indexSize];
            Iterator iter = voList.iterator();
            boolean inited = false;
            while (iter.hasNext()) {
                int i;
                Object bean = iter.next();
                if (null == bean) continue;
                if (!inited) {
                    realMethods = BeanUtil.matchSetMethods(bean.getClass(), properties);
                    if (autoConvertType) {
                        for (i = 0; i < indexSize; ++i) {
                            if (realMethods[i] == null) continue;
                            Class<?> methodType = realMethods[i].getParameterTypes()[0];
                            methodTypes[i] = methodType.getTypeName();
                            methodTypeValues[i] = DataType.getType(methodType);
                            Type[] types = realMethods[i].getGenericParameterTypes();
                            if (types.length <= 0 || !(types[0] instanceof ParameterizedType)) continue;
                            genericTypes[i] = (Class)((ParameterizedType)types[0]).getActualTypeArguments()[0];
                        }
                    }
                    inited = true;
                }
                for (i = 0; i < indexSize; ++i) {
                    if (realMethods[i] == null || !forceUpdate && values[i] == null) continue;
                    realMethods[i].invoke(bean, autoConvertType ? BeanUtil.convertType(null, values[i], methodTypeValues[i], methodTypes[i], genericTypes[i]) : values[i]);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5c06\u96c6\u5408\u6570\u636e\u53cd\u5c04\u5230Java Bean\u8fc7\u7a0b\u5f02\u5e38!{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u5c06\u96c6\u5408\u6570\u636e\u53cd\u5c04\u5230Java Bean\u8fc7\u7a0b\u5f02\u5e38!{}" + e.getMessage(), e);
        }
    }

    public static void mappingSetProperties(Collection voList, String[] properties, List<Object[]> values, int[] index, boolean autoConvertType) throws RuntimeException {
        BeanUtil.mappingSetProperties(voList, properties, values, index, autoConvertType, true);
    }

    public static void mappingSetProperties(Collection voList, String[] properties, List<Object[]> values, int[] index, boolean autoConvertType, boolean forceUpdate) throws RuntimeException {
        if (null == voList || voList.isEmpty()) {
            return;
        }
        if (null == properties || properties.length < 1 || null == values || values.get(0).length < 1 || properties.length != index.length) {
            throw new IllegalArgumentException("\u96c6\u5408\u6216\u5c5e\u6027\u540d\u79f0\u6570\u7ec4\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u53c2\u6570\u4fe1\u606f!");
        }
        try {
            int indexSize = properties.length;
            Method[] realMethods = null;
            String[] methodTypes = new String[indexSize];
            int[] methodTypeValues = new int[indexSize];
            Class[] genericTypes = new Class[indexSize];
            Iterator iter = voList.iterator();
            boolean inited = false;
            for (int rowIndex = 0; iter.hasNext() && rowIndex <= values.size() - 1; ++rowIndex) {
                int i;
                Object[] rowData = values.get(rowIndex);
                Object bean = iter.next();
                if (null == bean) continue;
                if (!inited) {
                    realMethods = BeanUtil.matchSetMethods(bean.getClass(), properties);
                    if (autoConvertType) {
                        for (i = 0; i < indexSize; ++i) {
                            if (realMethods[i] == null) continue;
                            Class<?> methodType = realMethods[i].getParameterTypes()[0];
                            methodTypes[i] = methodType.getTypeName();
                            methodTypeValues[i] = DataType.getType(methodType);
                            Type[] types = realMethods[i].getGenericParameterTypes();
                            if (types.length <= 0 || !(types[0] instanceof ParameterizedType)) continue;
                            genericTypes[i] = (Class)((ParameterizedType)types[0]).getActualTypeArguments()[0];
                        }
                    }
                    inited = true;
                }
                for (i = 0; i < indexSize; ++i) {
                    if (realMethods[i] == null || !forceUpdate && rowData[index[i]] == null) continue;
                    realMethods[i].invoke(bean, autoConvertType ? BeanUtil.convertType(null, rowData[index[i]], methodTypeValues[i], methodTypes[i], genericTypes[i]) : rowData[index[i]]);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5c06\u96c6\u5408\u6570\u636e\u53cd\u5c04\u5230Java Bean\u8fc7\u7a0b\u5f02\u5e38!{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u5c06\u96c6\u5408\u6570\u636e\u53cd\u5c04\u5230Java Bean\u8fc7\u7a0b\u5f02\u5e38!" + e.getMessage());
        }
    }

    public static String[] matchSetMethodNames(Class voClass) {
        return BeanUtil.matchMethodNames(voClass, false);
    }

    private static String[] matchMethodNames(Class voClass, boolean isGet) {
        Method[] methods = voClass.getMethods();
        int methodCnt = methods.length;
        ArrayList<String> methodAry = new ArrayList<String>();
        for (int i = 0; i < methodCnt; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            if (isGet) {
                if (!methodName.startsWith("get") && !methodName.startsWith("is") || Void.TYPE.equals(method.getReturnType()) || method.getParameterTypes().length != 0 || "getclass".equals(methodName.toLowerCase())) continue;
                methodAry.add(StringUtil.firstToLowerCase(methodName.replaceFirst("get|is", "")));
                continue;
            }
            if (!methodName.startsWith("set") || !Void.TYPE.equals(method.getReturnType()) || method.getParameterTypes().length != 1) continue;
            methodAry.add(StringUtil.firstToLowerCase(methodName.replaceFirst("set", "")));
        }
        String[] result = new String[methodAry.size()];
        methodAry.toArray(result);
        return result;
    }

    public static Method getMethod(Class beanClass, String methodName, int argLength) {
        Method[] methods;
        for (Method method : methods = beanClass.getMethods()) {
            int methodArgsLength = 0;
            if (method.getParameterTypes() != null) {
                methodArgsLength = method.getParameterTypes().length;
            }
            if (!method.getName().equalsIgnoreCase(methodName) || methodArgsLength != argLength) continue;
            return method;
        }
        return null;
    }

    public static boolean isBaseDataType(Class clazz) {
        return clazz.isPrimitive() || clazz.equals(String.class) || clazz.equals(Integer.class) || clazz.equals(Byte.class) || clazz.equals(Long.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Character.class) || clazz.equals(Short.class) || clazz.equals(BigDecimal.class) || clazz.equals(BigInteger.class) || clazz.equals(Boolean.class) || clazz.equals(java.util.Date.class) || clazz.equals(LocalDate.class) || clazz.equals(LocalDateTime.class) || clazz.equals(LocalTime.class) || clazz.equals(Timestamp.class);
    }

    public static void setProperty(Object bean, String property, Object value) throws RuntimeException {
        String key = bean.getClass().getName().concat(":set").concat(property);
        Method method = setMethods.get(key);
        if (method == null) {
            method = BeanUtil.matchSetMethods(bean.getClass(), property)[0];
            if (method == null) {
                throw new RuntimeException(bean.getClass().getName() + " \u6ca1\u6709\u5bf9\u5e94\u7684:" + property);
            }
            setMethods.put(key, method);
        }
        String typeName = method.getParameterTypes()[0].getTypeName();
        Type[] types = method.getGenericParameterTypes();
        Class genericType = null;
        if (types.length > 0 && types[0] instanceof ParameterizedType) {
            genericType = (Class)((ParameterizedType)types[0]).getActualTypeArguments()[0];
        }
        try {
            method.invoke(bean, BeanUtil.convertType(null, value, DataType.getType(method.getParameterTypes()[0]), typeName, genericType));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Object getProperty(Object bean, String property) throws RuntimeException {
        if (bean instanceof Map) {
            return ((Map)bean).get(property);
        }
        String key = bean.getClass().getName().concat(":get").concat(property);
        Method method = getMethods.get(key);
        if (method == null) {
            method = BeanUtil.matchGetMethods(bean.getClass(), property)[0];
            if (method == null) {
                return null;
            }
            getMethods.put(key, method);
        }
        Object result = null;
        try {
            result = method.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

    public static Object getComplexProperty(Object bean, String property) throws RuntimeException {
        KeyAndIndex keyAndIndex = BeanUtil.getKeyAndIndex(property);
        String realProperty = keyAndIndex == null ? property : keyAndIndex.getKey();
        Object result = null;
        if (bean instanceof Map) {
            result = ((Map)bean).get(property);
            if (result == null && keyAndIndex != null) {
                result = BeanUtil.getArrayIndexValue(((Map)bean).get(realProperty), keyAndIndex.getIndex());
            }
            return result;
        }
        String key = bean.getClass().getName().concat(":get").concat(realProperty);
        Method method = getMethods.get(key);
        if (method == null) {
            method = BeanUtil.matchGetMethods(bean.getClass(), realProperty)[0];
            if (method == null) {
                return null;
            }
            getMethods.put(key, method);
        }
        try {
            result = method.invoke(bean, new Object[0]);
            if (result != null && keyAndIndex != null) {
                result = BeanUtil.getArrayIndexValue(result, keyAndIndex.getIndex());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

    public static <T extends Serializable> List<T> wrapEntities(TypeHandler typeHandler, EntityMeta entityMeta, Class<T> voClass, Object ... ids) {
        ArrayList<Serializable> entities = new ArrayList<Serializable>();
        HashSet<Object> repeat = new HashSet<Object>();
        try {
            Method method = BeanUtil.matchSetMethods(voClass, entityMeta.getIdArray())[0];
            String typeName = method.getParameterTypes()[0].getTypeName();
            int typeValue = DataType.getType(method.getParameterTypes()[0]);
            Type[] types = method.getGenericParameterTypes();
            Class genericType = null;
            if (types.length > 0 && types[0] instanceof ParameterizedType) {
                genericType = (Class)((ParameterizedType)types[0]).getActualTypeArguments()[0];
            }
            for (Object id : ids) {
                if (id == null || repeat.contains(id)) continue;
                Serializable bean = (Serializable)voClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                method.invoke((Object)bean, BeanUtil.convertType(typeHandler, id, typeValue, typeName, genericType));
                entities.add(bean);
                repeat.add(id);
            }
        }
        catch (Exception e) {
            logger.error("\u5c06\u96c6\u5408\u6570\u636e\u53cd\u5c04\u5230Java Bean\u8fc7\u7a0b\u5f02\u5e38!{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return entities;
    }

    public static Class getEntityClass(Class entityClass) {
        if (entityClass == null || entityClass.equals(Object.class) || entityClass.getModifiers() != 0) {
            return entityClass;
        }
        Class realEntityClass = entityClass;
        while (!realEntityClass.equals(Object.class)) {
            if (realEntityClass.isAnnotationPresent(SqlToyEntity.class) || realEntityClass.isAnnotationPresent(Entity.class) && !Modifier.isAbstract(realEntityClass.getModifiers())) {
                return realEntityClass;
            }
            realEntityClass = realEntityClass.getSuperclass();
        }
        if (entityClass.getModifiers() == 0 && !entityClass.getSuperclass().equals(Object.class)) {
            return entityClass.getSuperclass();
        }
        return entityClass;
    }

    public static Object convertArray(Object values, String typeName) {
        if (typeName.equals(values.getClass().getTypeName())) {
            return values;
        }
        Object[] array = (Object[])values;
        int index = 0;
        if ("java.lang.String[]".equals(typeName) && !(values instanceof String[])) {
            String[] result = new String[array.length];
            for (Object obj : array) {
                if (obj != null) {
                    result[index] = obj.toString();
                }
                ++index;
            }
            return result;
        }
        if ("java.lang.Integer[]".equals(typeName) && !(values instanceof Integer[])) {
            Integer[] result = new Integer[array.length];
            for (Object obj : array) {
                if (obj != null) {
                    result[index] = Integer.valueOf(obj.toString());
                }
                ++index;
            }
            return result;
        }
        if ("java.lang.Long[]".equals(typeName) && !(values instanceof Long[])) {
            Long[] result = new Long[array.length];
            for (Object obj : array) {
                if (obj != null) {
                    result[index] = Long.valueOf(obj.toString());
                }
                ++index;
            }
            return result;
        }
        if ("java.math.BigDecimal[]".equals(typeName) && !(values instanceof BigDecimal[])) {
            BigDecimal[] result = new BigDecimal[array.length];
            for (Object obj : array) {
                if (obj != null) {
                    result[index] = new BigDecimal(obj.toString());
                }
                ++index;
            }
            return result;
        }
        if ("int[]".equals(typeName) && !(values instanceof int[])) {
            int[] result = new int[array.length];
            for (Object obj : array) {
                if (obj != null) {
                    result[index] = Integer.parseInt(obj.toString());
                }
                ++index;
            }
            return result;
        }
        if ("long[]".equals(typeName) && !(values instanceof long[])) {
            long[] result = new long[array.length];
            for (Object obj : array) {
                if (obj != null) {
                    result[index] = Long.parseLong(obj.toString());
                }
                ++index;
            }
            return result;
        }
        if ("java.lang.Double[]".equals(typeName) && !(values instanceof Double[])) {
            Double[] result = new Double[array.length];
            for (Object obj : array) {
                if (obj != null) {
                    result[index] = Double.valueOf(obj.toString());
                }
                ++index;
            }
            return result;
        }
        if ("double[]".equals(typeName) && !(values instanceof double[])) {
            double[] result = new double[array.length];
            for (Object obj : array) {
                if (obj != null) {
                    result[index] = Double.parseDouble(obj.toString());
                }
                ++index;
            }
            return result;
        }
        if ("java.lang.Float[]".equals(typeName) && !(values instanceof Float[])) {
            Float[] result = new Float[array.length];
            for (Object obj : array) {
                if (obj != null) {
                    result[index] = Float.valueOf(obj.toString());
                }
                ++index;
            }
            return result;
        }
        if ("float[]".equals(typeName) && !(values instanceof float[])) {
            float[] result = new float[array.length];
            for (Object obj : array) {
                if (obj != null) {
                    result[index] = Float.parseFloat(obj.toString());
                }
                ++index;
            }
            return result;
        }
        return values;
    }

    public static void loadAllMapping(List mainEntities, List itemEntities, TableCascadeModel cascadeModel) throws Exception {
        if (mainEntities == null || mainEntities.isEmpty() || itemEntities == null || itemEntities.isEmpty()) {
            return;
        }
        boolean isOneToMany = cascadeModel.getCascadeType() == 1;
        String[] mainProps = cascadeModel.getFields();
        String property = cascadeModel.getProperty();
        String[] mappedFields = cascadeModel.getMappedFields();
        ArrayList itemList = null;
        int fieldLength = mainProps.length;
        boolean isEqual = true;
        int itemSize = 0;
        for (int i = 0; i < mainEntities.size(); ++i) {
            Object mainEntity = mainEntities.get(i);
            Object[] mainValues = BeanUtil.reflectBeanToAry(mainEntity, mainProps, null, null);
            if (isOneToMany) {
                itemList = new ArrayList();
            }
            itemSize = 0;
            for (int j = 0; j < itemEntities.size(); ++j) {
                Object itemEntity = itemEntities.get(j);
                Object[] mappedFieldValues = BeanUtil.reflectBeanToAry(itemEntity, mappedFields, null, null);
                isEqual = true;
                for (int k = 0; k < fieldLength; ++k) {
                    if (null != mainValues[k] && mainValues[k].equals(mappedFieldValues[k])) continue;
                    isEqual = false;
                    break;
                }
                if (!isEqual) continue;
                if (isOneToMany) {
                    itemList.add(itemEntity);
                } else {
                    if (itemSize > 0) {
                        throw new DataAccessException("\u8bf7\u68c0\u67e5\u5bf9\u8c61:" + mainEntity.getClass().getName() + "\u4e2d\u7684@OneToOne\u7ea7\u8054\u914d\u7f6e,\u7ea7\u8054\u67e5\u51fa\u7684\u6570\u636e\u4e3a>1\u6761,\u4e0d\u7b26\u5408\u9884\u671f!");
                    }
                    BeanUtil.setProperty(mainEntity, property, itemEntity);
                }
                ++itemSize;
            }
            if (!isOneToMany || itemList == null || itemList.isEmpty()) continue;
            BeanUtil.setProperty(mainEntity, property, itemList);
        }
    }

    private static Field[] parseCascadeFields(Class entityClass) {
        HashSet<String> fieldSet = new HashSet<String>();
        ArrayList<Field> cascadeFields = new ArrayList<Field>();
        for (Class classType = entityClass; classType != null && !classType.equals(Object.class); classType = classType.getSuperclass()) {
            for (Field field : classType.getDeclaredFields()) {
                String fieldName = field.getName().toLowerCase();
                if (fieldSet.contains(fieldName) || field.getAnnotation(OneToMany.class) == null && field.getAnnotation(OneToOne.class) == null) continue;
                cascadeFields.add(field);
                fieldSet.add(fieldName);
            }
        }
        return cascadeFields.toArray(new Field[cascadeFields.size()]);
    }

    public static List<TableCascadeModel> getCascadeModels(Class entityClass) {
        String className = entityClass.getName();
        ArrayList<TableCascadeModel> result = cascadeModels.get(className);
        if (result == null) {
            Field[] cascadeFields;
            result = new ArrayList<TableCascadeModel>();
            for (Field field : cascadeFields = BeanUtil.parseCascadeFields(entityClass)) {
                TableCascadeModel cascadeModel = new TableCascadeModel();
                cascadeModel.setProperty(field.getName());
                OneToMany oneToMany = field.getAnnotation(OneToMany.class);
                OneToOne oneToOne = field.getAnnotation(OneToOne.class);
                if (oneToMany != null) {
                    cascadeModel.setCascadeType(1);
                    cascadeModel.setFields(oneToMany.fields());
                    cascadeModel.setMappedFields(oneToMany.mappedFields());
                    cascadeModel.setMappedType((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]);
                } else {
                    cascadeModel.setCascadeType(2);
                    cascadeModel.setFields(oneToOne.fields());
                    cascadeModel.setMappedFields(oneToOne.mappedFields());
                    cascadeModel.setMappedType(field.getType());
                }
                result.add(cascadeModel);
            }
            cascadeModels.put(className, result);
        }
        return result;
    }

    public static KeyAndIndex getKeyAndIndex(String property) {
        if (property == null) {
            return null;
        }
        if (!StringUtil.matches(property, ARRAY_PATTERN)) {
            return null;
        }
        KeyAndIndex result = new KeyAndIndex();
        int lastIndex = property.lastIndexOf("[");
        result.setKey(property.substring(0, lastIndex));
        result.setIndex(Integer.parseInt(property.substring(lastIndex + 1, property.length() - 1)));
        return result;
    }

    public static Object getArrayIndexValue(Object result, int index) {
        if (result == null) {
            return null;
        }
        Object[] ary = null;
        if (result instanceof Object[]) {
            ary = (Object[])result;
        } else if (result instanceof Collection) {
            ary = ((Collection)result).toArray();
        }
        if (ary != null && ary.length > index) {
            return ary[index];
        }
        return null;
    }
}

