/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.nosql;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.ElasticEndpoint;
import org.sagacity.sqltoy.config.model.NoSqlConfigModel;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.model.Page;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.inner.DataSetResult;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.plugins.nosql.ElasticSearchUtils;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.HttpClientUtils;
import org.sagacity.sqltoy.utils.MongoElasticUtils;
import org.sagacity.sqltoy.utils.QueryExecutorBuilder;
import org.sagacity.sqltoy.utils.ResultUtils;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchPlugin {
    protected static final Logger logger = LoggerFactory.getLogger(ElasticSearchPlugin.class);

    public static Page findPage(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, Page pageModel, QueryExecutor queryExecutor) throws Exception {
        String realMql = "";
        JSONObject jsonQuery = null;
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        QueryExecutorBuilder.initQueryExecutor(sqlToyContext, extend, sqlToyConfig, false);
        try {
            realMql = MongoElasticUtils.wrapES(sqlToyConfig, extend.getParamsName(), extend.getParamsValue(sqlToyContext, sqlToyConfig)).trim();
            jsonQuery = JSON.parseObject((String)realMql);
            jsonQuery.remove((Object)"from");
            jsonQuery.remove((Object)"FROM");
            jsonQuery.remove((Object)"size");
            jsonQuery.remove((Object)"SIZE");
            jsonQuery.put("from", (Object)((pageModel.getPageNo() - 1L) * (long)pageModel.getPageSize()));
            jsonQuery.put("size", (Object)pageModel.getPageSize());
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u89e3\u6790es\u539f\u751fjson\u9519\u8bef,\u8bf7\u68c0\u67e5json\u4e32\u683c\u5f0f\u662f\u5426\u6b63\u786e!\u9519\u8bef\u4fe1\u606f:{},json={}", (Object)e.getMessage(), (Object)realMql);
            throw e;
        }
        Page page = new Page();
        page.setPageNo(pageModel.getPageNo());
        page.setPageSize(pageModel.getPageSize());
        DataSetResult result = ElasticSearchPlugin.executeQuery(sqlToyContext, sqlToyConfig, jsonQuery, (Class)extend.resultType, extend.humpMapLabel);
        page.setRows(result.getRows());
        page.setRecordCount(result.getRecordCount());
        return page;
    }

    public static List<?> findTop(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, Integer topSize) throws Exception {
        String realMql = "";
        JSONObject jsonQuery = null;
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        QueryExecutorBuilder.initQueryExecutor(sqlToyContext, extend, sqlToyConfig, false);
        try {
            realMql = MongoElasticUtils.wrapES(sqlToyConfig, extend.getParamsName(), extend.getParamsValue(sqlToyContext, sqlToyConfig)).trim();
            jsonQuery = JSON.parseObject((String)realMql);
            if (topSize != null) {
                jsonQuery.remove((Object)"from");
                jsonQuery.remove((Object)"FROM");
                jsonQuery.remove((Object)"size");
                jsonQuery.remove((Object)"SIZE");
                jsonQuery.put("from", (Object)0);
                jsonQuery.put("size", (Object)topSize);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790es\u539f\u751fjson\u9519\u8bef,\u8bf7\u68c0\u67e5json\u4e32\u683c\u5f0f\u662f\u5426\u6b63\u786e!\u9519\u8bef\u4fe1\u606f:{},json={}", (Object)e.getMessage(), (Object)realMql);
            throw e;
        }
        DataSetResult result = ElasticSearchPlugin.executeQuery(sqlToyContext, sqlToyConfig, jsonQuery, (Class)extend.resultType, extend.humpMapLabel);
        return result.getRows();
    }

    private static DataSetResult executeQuery(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, JSONObject jsonQuery, Class resultClass, Boolean humpMapLabel) throws Exception {
        JSONObject json;
        JSONArray array;
        NoSqlConfigModel noSqlModel = sqlToyConfig.getNoSqlConfigModel();
        ElasticEndpoint esConfig = sqlToyContext.getElasticEndpoint(noSqlModel.getEndpoint());
        String source = "_source";
        boolean hasFields = false;
        if (jsonQuery.containsKey((Object)source)) {
            hasFields = true;
        } else if (jsonQuery.containsKey((Object)source.toUpperCase())) {
            hasFields = true;
            source = source.toUpperCase();
        }
        String[] fields = null;
        if (noSqlModel.getFields() != null) {
            fields = noSqlModel.getFields();
            if (!hasFields && !noSqlModel.isHasAggs()) {
                array = new JSONArray();
                for (String field : fields) {
                    int aliasIndex = field.indexOf(":");
                    if (aliasIndex == -1) {
                        array.add((Object)field);
                        continue;
                    }
                    array.add((Object)field.substring(0, aliasIndex).trim());
                }
                jsonQuery.fluentPut("_source", (Object)array);
            }
        } else if (hasFields) {
            array = jsonQuery.getJSONArray(source).toArray();
            fields = new String[((Object[])array).length];
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = array[i].toString();
            }
        } else if (!(resultClass == null || Array.class.isAssignableFrom(resultClass) || Collection.class.isAssignableFrom(resultClass) || Map.class.isAssignableFrom(resultClass))) {
            fields = BeanUtil.matchSetMethodNames(resultClass);
        }
        if (sqlToyContext.isDebug()) {
            if (logger.isDebugEnabled()) {
                logger.debug("execute elastic eql=" + jsonQuery.toJSONString());
            } else {
                System.out.println("execute elastic eql=" + jsonQuery.toJSONString());
            }
        }
        if ((json = HttpClientUtils.doPost(sqlToyContext, noSqlModel, esConfig, jsonQuery)) == null || json.isEmpty()) {
            return new DataSetResult();
        }
        DataSetResult resultSet = ElasticSearchUtils.extractFieldValue(sqlToyContext, sqlToyConfig, json, fields);
        MongoElasticUtils.processTranslate(sqlToyContext, sqlToyConfig, resultSet.getRows(), resultSet.getLabelNames());
        boolean changedCols = ResultUtils.calculate(sqlToyContext.getDesensitizeProvider(), sqlToyConfig, resultSet, null, null);
        resultSet.setRows(ResultUtils.wrapQueryResult(sqlToyContext, resultSet.getRows(), StringUtil.humpFieldNames(resultSet.getLabelNames()), resultClass, changedCols, humpMapLabel, false, null, null));
        return resultSet;
    }
}

