/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.GenerateSavePKStrategy;
import org.sagacity.sqltoy.callback.GenerateSqlHandler;
import org.sagacity.sqltoy.callback.ReflectPropsHandler;
import org.sagacity.sqltoy.callback.UpdateRowHandler;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.dialect.Dialect;
import org.sagacity.sqltoy.dialect.model.SavePKStrategy;
import org.sagacity.sqltoy.dialect.utils.DefaultDialectUtils;
import org.sagacity.sqltoy.dialect.utils.DialectExtUtils;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.dialect.utils.OracleDialectUtils;
import org.sagacity.sqltoy.model.ColumnMeta;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.StoreResult;
import org.sagacity.sqltoy.model.TableMeta;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDialect
implements Dialect {
    protected final Logger logger = LoggerFactory.getLogger(OracleDialect.class);
    public static final String NVL_FUNCTION = "nvl";
    public static final String VIRTUAL_TABLE = "dual";

    @Override
    public boolean isUnique(SqlToyContext sqlToyContext, Serializable entity, String[] paramsNamed, Connection conn, Integer dbType, String tableName) {
        return DialectUtils.isUnique(sqlToyContext, entity, paramsNamed, conn, dbType, tableName, (entityMeta, realParamNamed, table, topSize) -> {
            String queryStr = DialectExtUtils.wrapUniqueSql(entityMeta, realParamNamed, dbType, table);
            return queryStr + " fetch first " + topSize + " rows only";
        });
    }

    @Override
    public QueryResult getRandomResult(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long totalCount, Long randomCount, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        return OracleDialectUtils.getRandomResult(sqlToyContext, sqlToyConfig, queryExecutor, decryptHandler, totalCount, randomCount, conn, dbType, dialect, fetchSize, maxRows);
    }

    @Override
    public QueryResult findPageBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long pageNo, Integer pageSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        return OracleDialectUtils.findPageBySql(sqlToyContext, sqlToyConfig, queryExecutor, decryptHandler, pageNo, pageSize, conn, dbType, dialect, fetchSize, maxRows);
    }

    @Override
    public QueryResult findTopBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Integer topSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        return OracleDialectUtils.findTopBySql(sqlToyContext, sqlToyConfig, queryExecutor, decryptHandler, topSize, conn, dbType, dialect, fetchSize, maxRows);
    }

    @Override
    public QueryResult findBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, QueryExecutorExtend queryExecutorExtend, DecryptHandler decryptHandler, Connection conn, LockMode lockMode, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        String realSql = sql.concat(OracleDialectUtils.getLockSql(sql, dbType, lockMode));
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, realSql, paramsValue, queryExecutorExtend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    @Override
    public Long getCountBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, boolean isLastSql, Connection conn, Integer dbType, String dialect) throws Exception {
        return DialectUtils.getCountBySql(sqlToyContext, sqlToyConfig, sql, paramsValue, isLastSql, conn, dbType);
    }

    @Override
    public Long saveOrUpdate(SqlToyContext sqlToyContext, Serializable entity, String[] forceUpdateFields, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        ArrayList<Serializable> entities = new ArrayList<Serializable>();
        entities.add(entity);
        return this.saveOrUpdateAll(sqlToyContext, entities, sqlToyContext.getBatchSize(), null, forceUpdateFields, conn, dbType, dialect, autoCommit, tableName);
    }

    @Override
    public Long saveOrUpdateAll(final SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, String[] forceUpdateFields, Connection conn, final Integer dbType, String dialect, Boolean autoCommit, final String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        return DialectUtils.saveOrUpdateAll(sqlToyContext, entities, batchSize, entityMeta, forceUpdateFields, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                String sequence = entityMeta.getSequence() + ".nextval";
                if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    pkStrategy = PKStrategy.SEQUENCE;
                    sequence = entityMeta.getFieldsMeta().get(entityMeta.getIdArray()[0]).getDefaultValue();
                }
                return DialectUtils.getSaveOrUpdateSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, forceUpdateFields, OracleDialect.VIRTUAL_TABLE, OracleDialect.NVL_FUNCTION, sequence, OracleDialectUtils.isAssignPKValue(pkStrategy), tableName);
            }
        }, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public Long saveAllIgnoreExist(final SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, final Integer dbType, String dialect, Boolean autoCommit, final String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        return DialectUtils.saveAllIgnoreExist(sqlToyContext, entities, batchSize, entityMeta, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                String sequence = entityMeta.getSequence() + ".nextval";
                if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    pkStrategy = PKStrategy.SEQUENCE;
                    sequence = entityMeta.getFieldsMeta().get(entityMeta.getIdArray()[0]).getDefaultValue();
                }
                return DialectExtUtils.mergeIgnore(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, OracleDialect.VIRTUAL_TABLE, OracleDialect.NVL_FUNCTION, sequence, OracleDialectUtils.isAssignPKValue(pkStrategy), tableName);
            }
        }, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public Serializable load(SqlToyContext sqlToyContext, Serializable entity, List<Class> cascadeTypes, LockMode lockMode, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return OracleDialectUtils.load(sqlToyContext, entity, cascadeTypes, lockMode, conn, dbType, dialect, tableName);
    }

    @Override
    public List<?> loadAll(SqlToyContext sqlToyContext, List<?> entities, List<Class> cascadeTypes, LockMode lockMode, Connection conn, Integer dbType, String dialect, String tableName, int fetchSize, int maxRows) throws Exception {
        return OracleDialectUtils.loadAll(sqlToyContext, entities, cascadeTypes, lockMode, conn, dbType, tableName, fetchSize, maxRows);
    }

    @Override
    public Object save(final SqlToyContext sqlToyContext, Serializable entity, Connection conn, final Integer dbType, String dialect, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        PKStrategy pkStrategy = entityMeta.getIdStrategy();
        String sequence = entityMeta.getSequence().concat(".nextval");
        if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
            pkStrategy = PKStrategy.SEQUENCE;
            sequence = entityMeta.getFieldsMeta().get(entityMeta.getIdArray()[0]).getDefaultValue();
        }
        boolean isAssignPK = OracleDialectUtils.isAssignPKValue(pkStrategy);
        String insertSql = DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, NVL_FUNCTION, sequence, isAssignPK, tableName);
        return DialectUtils.save(sqlToyContext, entityMeta, pkStrategy, isAssignPK, insertSql, entity, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateField) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                String sequence = entityMeta.getSequence().concat(".nextval");
                if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    pkStrategy = PKStrategy.SEQUENCE;
                    sequence = entityMeta.getFieldsMeta().get(entityMeta.getIdArray()[0]).getDefaultValue();
                }
                return DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, OracleDialect.NVL_FUNCTION, sequence, OracleDialectUtils.isAssignPKValue(pkStrategy), null);
            }
        }, new GenerateSavePKStrategy(){

            @Override
            public SavePKStrategy generate(EntityMeta entityMeta) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    pkStrategy = PKStrategy.SEQUENCE;
                }
                return new SavePKStrategy(pkStrategy, OracleDialectUtils.isAssignPKValue(pkStrategy));
            }
        }, conn, dbType);
    }

    @Override
    public Long saveAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        PKStrategy pkStrategy = entityMeta.getIdStrategy();
        boolean isAssignPK = OracleDialectUtils.isAssignPKValue(pkStrategy);
        String sequence = entityMeta.getSequence().concat(".nextval");
        if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
            pkStrategy = PKStrategy.SEQUENCE;
            sequence = entityMeta.getFieldsMeta().get(entityMeta.getIdArray()[0]).getDefaultValue();
        }
        String insertSql = DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, NVL_FUNCTION, sequence, isAssignPK, tableName);
        return DialectUtils.saveAll(sqlToyContext, entityMeta, pkStrategy, isAssignPK, insertSql, entities, batchSize, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public Long update(final SqlToyContext sqlToyContext, Serializable entity, String[] forceUpdateFields, boolean cascade, Class[] forceCascadeClass, HashMap<Class, String[]> subTableForceUpdateProps, Connection conn, final Integer dbType, String dialect, String tableName) throws Exception {
        return DialectUtils.update(sqlToyContext, entity, NVL_FUNCTION, forceUpdateFields, cascade, !cascade ? null : new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                String sequence = entityMeta.getSequence().concat(".nextval");
                if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    pkStrategy = PKStrategy.SEQUENCE;
                    sequence = entityMeta.getFieldsMeta().get(entityMeta.getIdArray()[0]).getDefaultValue();
                }
                return DialectUtils.getSaveOrUpdateSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, forceUpdateFields, OracleDialect.VIRTUAL_TABLE, OracleDialect.NVL_FUNCTION, sequence, OracleDialectUtils.isAssignPKValue(pkStrategy), null);
            }
        }, forceCascadeClass, subTableForceUpdateProps, conn, dbType, tableName);
    }

    @Override
    public Long updateAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, String[] uniqueFields, String[] forceUpdateFields, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        return DialectUtils.updateAll(sqlToyContext, entities, batchSize, forceUpdateFields, reflectPropsHandler, NVL_FUNCTION, conn, dbType, autoCommit, tableName, false);
    }

    @Override
    public Serializable updateSaveFetch(SqlToyContext sqlToyContext, Serializable entity, UpdateRowHandler updateRowHandler, String[] uniqueProps, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return DefaultDialectUtils.updateSaveFetch(sqlToyContext, entity, updateRowHandler, uniqueProps, conn, dbType, dialect, tableName);
    }

    @Override
    public Long delete(SqlToyContext sqlToyContext, Serializable entity, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return DialectUtils.delete(sqlToyContext, entity, conn, dbType, tableName);
    }

    @Override
    public Long deleteAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        return DialectUtils.deleteAll(sqlToyContext, entities, batchSize, conn, dbType, autoCommit, tableName);
    }

    @Override
    public QueryResult updateFetch(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, UpdateRowHandler updateRowHandler, Connection conn, Integer dbType, String dialect, LockMode lockMode, int fetchSize, int maxRows) throws Exception {
        String realSql = sql.concat(OracleDialectUtils.getLockSql(sql, dbType, lockMode == null ? LockMode.UPGRADE : lockMode));
        return DialectUtils.updateFetchBySql(sqlToyContext, sqlToyConfig, realSql, paramsValue, updateRowHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    @Override
    public StoreResult executeStore(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] inParamsValue, Integer[] outParamsType, boolean moreResult, Connection conn, Integer dbType, String dialect, int fetchSize) throws Exception {
        return OracleDialectUtils.executeStore(sqlToyConfig, sqlToyContext, sql, inParamsValue, outParamsType, moreResult, conn, dbType, fetchSize);
    }

    @Override
    public List<ColumnMeta> getTableColumns(String catalog, String schema, String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        List<ColumnMeta> tableColumns = OracleDialectUtils.getTableColumns(catalog, schema, tableName, conn, dbType, dialect);
        Map<String, ColumnMeta> pkMap = DefaultDialectUtils.getTablePrimaryKeys(catalog, schema, tableName, conn, dbType, dialect);
        if (pkMap == null || pkMap.isEmpty()) {
            return tableColumns;
        }
        for (ColumnMeta colMeta : tableColumns) {
            ColumnMeta mapMeta = pkMap.get(colMeta.getColName());
            if (mapMeta == null) continue;
            colMeta.setPK(true);
        }
        return tableColumns;
    }

    @Override
    public List<TableMeta> getTables(String catalog, String schema, String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        return OracleDialectUtils.getTables(catalog, schema, tableName, conn, dbType, dialect);
    }
}

