/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.config.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.sagacity.sqltoy.config.model.FormatModel;
import org.sagacity.sqltoy.config.model.LinkModel;
import org.sagacity.sqltoy.config.model.NoSqlConfigModel;
import org.sagacity.sqltoy.config.model.PageOptimize;
import org.sagacity.sqltoy.config.model.ParamFilterModel;
import org.sagacity.sqltoy.config.model.SecureMask;
import org.sagacity.sqltoy.config.model.ShardingStrategyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.config.model.Translate;
import org.sagacity.sqltoy.model.IgnoreCaseSet;
import org.sagacity.sqltoy.plugins.function.FunctionUtils;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class SqlToyConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3168222164418634488L;
    private String dialect;
    private List<ParamFilterModel> filters = new ArrayList<ParamFilterModel>();
    private HashMap<String, Translate> translateMap = new HashMap();
    private List<SecureMask> secureMasks = new ArrayList<SecureMask>();
    private List<FormatModel> formatModels = new ArrayList<FormatModel>();
    private String dataSource;
    private ShardingStrategyConfig dataSourceSharding;
    private List<ShardingStrategyConfig> tableShardings = new ArrayList<ShardingStrategyConfig>();
    private String[] tableShardingParams = null;
    private String[] dbShardingParams = null;
    private LinkModel linkModel = null;
    private String id;
    private SqlType sqlType;
    private String sql;
    private ConcurrentHashMap<String, String> dialectSqlMap = new ConcurrentHashMap();
    private String fastSql;
    private String fastWithSql;
    private String fastPreSql;
    private String fastTailSql;
    private String countSql;
    private boolean isUnionAllCount = false;
    private String[] paramsName;
    private List<String> cacheArgNames = new ArrayList<String>();
    private boolean hasFast = false;
    private boolean hasWith = false;
    private boolean hasUnion = false;
    private boolean ignoreBracket = false;
    private IgnoreCaseSet decryptColumns;
    private boolean hasIncludeSql = false;
    private int fastWithIndex = -1;
    private PageOptimize pageOptimize;
    private Boolean showSql;
    private boolean ignoreEmpty = false;
    private List resultProcessor = new ArrayList();
    private NoSqlConfigModel noSqlConfigModel;

    public boolean isHasUnion() {
        return this.hasUnion;
    }

    public void setHasUnion(boolean hasUnion) {
        this.hasUnion = hasUnion;
    }

    public boolean isIgnoreEmpty() {
        return this.ignoreEmpty;
    }

    public void setIgnoreEmpty(boolean ignoreEmpty) {
        this.ignoreEmpty = ignoreEmpty;
    }

    public SqlToyConfig(String dialect) {
        this.dialect = dialect;
    }

    public SqlToyConfig(String id, String sql) {
        this.id = id;
        this.sql = sql;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSql() {
        return this.getDialectSql("sql", this.sql, this.dialect);
    }

    public String getSql(String dialect) {
        return this.getDialectSql("sql", this.sql, dialect);
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public boolean isHasFast() {
        return this.hasFast;
    }

    public void setHasFast(boolean hasFast) {
        this.hasFast = hasFast;
    }

    public boolean isUnionAllCount() {
        return this.isUnionAllCount;
    }

    public void setUnionAllCount(boolean isUnionAllCount) {
        this.isUnionAllCount = isUnionAllCount;
    }

    public String[] getParamsName() {
        return this.paramsName;
    }

    public void setParamsName(String[] paramsName) {
        this.paramsName = paramsName;
    }

    public void addFilters(List<ParamFilterModel> paramFilters) {
        if (paramFilters != null && !paramFilters.isEmpty()) {
            this.filters.addAll(paramFilters);
        }
    }

    public void addFilter(ParamFilterModel paramFilter) {
        if (paramFilter != null) {
            this.filters.add(paramFilter);
        }
    }

    public List<ParamFilterModel> getFilters() {
        return this.filters;
    }

    public HashMap<String, Translate> getTranslateMap() {
        return this.translateMap;
    }

    public void setTranslateMap(HashMap<String, Translate> translateMap) {
        this.translateMap = translateMap;
    }

    public LinkModel getLinkModel() {
        return this.linkModel;
    }

    public void setLinkModel(LinkModel linkModel) {
        this.linkModel = linkModel;
    }

    public List getResultProcessor() {
        return this.resultProcessor;
    }

    public void setResultProcessor(List resultProcessor) {
        this.resultProcessor = resultProcessor;
    }

    public boolean isHasWith() {
        return this.hasWith;
    }

    public void setHasWith(boolean hasWith) {
        this.hasWith = hasWith;
    }

    public String getFastSql(String dialect) {
        return this.getDialectSql("fastSql", this.fastSql, dialect);
    }

    public void setFastSql(String fastSql) {
        this.fastSql = fastSql;
    }

    public String getFastWithSql(String dialect) {
        return this.getDialectSql("fastWithSql", this.fastWithSql, dialect);
    }

    public void setFastWithSql(String fastWithSql) {
        this.fastWithSql = fastWithSql;
    }

    public String getFastPreSql(String dialect) {
        return this.getDialectSql("fastPreSql", this.fastPreSql, dialect);
    }

    public void setFastPreSql(String fastPreSql) {
        this.fastPreSql = fastPreSql;
    }

    public String getFastTailSql(String dialect) {
        return this.getDialectSql("fastTailSql", this.fastTailSql, dialect);
    }

    public void setFastTailSql(String fastTailSql) {
        this.fastTailSql = fastTailSql;
    }

    public boolean isNamedParam() {
        return this.paramsName != null && this.paramsName.length > 0;
    }

    public int getFastWithIndex() {
        return this.fastWithIndex;
    }

    public void setFastWithIndex(int fastWithIndex) {
        this.fastWithIndex = fastWithIndex;
    }

    public String getCountSql(String dialect) {
        return this.getDialectSql("countSql", this.countSql, dialect);
    }

    public void setCountSql(String countSql) {
        this.countSql = countSql;
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public List<SecureMask> getSecureMasks() {
        return this.secureMasks;
    }

    public void setSecureMasks(List<SecureMask> secureMasks) {
        this.secureMasks = secureMasks;
    }

    public NoSqlConfigModel getNoSqlConfigModel() {
        return this.noSqlConfigModel;
    }

    public void setNoSqlConfigModel(NoSqlConfigModel noSqlConfigModel) {
        this.noSqlConfigModel = noSqlConfigModel;
    }

    public Boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(Boolean showSql) {
        this.showSql = showSql;
    }

    public List<FormatModel> getFormatModels() {
        return this.formatModels;
    }

    public void setFormatModels(List<FormatModel> formatModels) {
        this.formatModels = formatModels;
    }

    public SqlToyConfig clone() {
        try {
            return (SqlToyConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addCacheArgParam(String name) {
        String nameLow = name.toLowerCase();
        boolean exists = false;
        for (String argName : this.cacheArgNames) {
            if (!argName.toLowerCase().equals(nameLow)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.cacheArgNames.add(name);
        }
    }

    public List<String> getCacheArgNames() {
        return this.cacheArgNames;
    }

    public String[] getFullParamNames() {
        String key;
        if (this.cacheArgNames == null || this.cacheArgNames.isEmpty()) {
            return this.paramsName;
        }
        HashSet<String> keys = new HashSet<String>();
        ArrayList<String> params = new ArrayList<String>();
        if (this.paramsName != null && this.paramsName.length > 0) {
            for (String item : this.paramsName) {
                key = item.toLowerCase();
                if (keys.contains(key)) continue;
                keys.add(key);
                params.add(item);
            }
        }
        for (String item : this.cacheArgNames) {
            key = item.toLowerCase();
            if (keys.contains(key)) continue;
            keys.add(key);
            params.add(item);
        }
        return params.toArray(new String[params.size()]);
    }

    private String getDialectSql(String type, String sqlContent, String dialect) {
        if (StringUtil.isBlank(sqlContent)) {
            return sqlContent;
        }
        if (dialect == null || dialect.equals("") || dialect.equals("UNDEFINE") || dialect.equals(this.dialect)) {
            return sqlContent;
        }
        String key = dialect.concat(".").concat(type);
        if (!this.dialectSqlMap.containsKey(key)) {
            String dialectSql = FunctionUtils.getDialectSql(sqlContent, dialect);
            dialectSql = ReservedWordsUtil.convertSql(dialectSql, DataSourceUtils.getDBType(dialect));
            this.dialectSqlMap.put(key, dialectSql);
        }
        return this.dialectSqlMap.get(key);
    }

    public String getIdOrSql() {
        if (StringUtil.isBlank(this.id)) {
            return this.sql;
        }
        return this.id;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void clearDialectSql() {
        this.dialectSqlMap.clear();
    }

    public PageOptimize getPageOptimize() {
        return this.pageOptimize;
    }

    public void setPageOptimize(PageOptimize pageOptimize) {
        this.pageOptimize = pageOptimize;
    }

    public ShardingStrategyConfig getDataSourceSharding() {
        return this.dataSourceSharding;
    }

    public void setDataSourceSharding(ShardingStrategyConfig dataSourceSharding) {
        this.dataSourceSharding = dataSourceSharding;
    }

    public List<ShardingStrategyConfig> getTableShardings() {
        return this.tableShardings;
    }

    public void setTableShardings(List<ShardingStrategyConfig> tableShardings) {
        this.tableShardings = tableShardings;
    }

    public String[] getTableShardingParams() {
        return this.tableShardingParams;
    }

    public void setTableShardingParams(String[] tableShardingParams) {
        this.tableShardingParams = tableShardingParams;
    }

    public String[] getDbShardingParams() {
        return this.dbShardingParams;
    }

    public void setDbShardingParams(String[] dbShardingParams) {
        this.dbShardingParams = dbShardingParams;
    }

    public boolean isIgnoreBracket() {
        return this.ignoreBracket;
    }

    public void setIgnoreBracket(boolean ignoreBracket) {
        this.ignoreBracket = ignoreBracket;
    }

    public IgnoreCaseSet getDecryptColumns() {
        return this.decryptColumns;
    }

    public void setDecryptColumns(IgnoreCaseSet decryptColumns) {
        this.decryptColumns = decryptColumns;
    }

    public boolean isHasIncludeSql() {
        return this.hasIncludeSql;
    }

    public void setHasIncludeSql(boolean hasIncludeSql) {
        this.hasIncludeSql = hasIncludeSql;
    }
}

