/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static Pattern chinaPattern = Pattern.compile("[\u4e00-\u9fa5]");
    private static Pattern quotaPattern = Pattern.compile("(^')|([^\\\\]')");
    private static Pattern quotaChkPattern = Pattern.compile("[^\\\\]'");
    private static Pattern twoQuotaPattern = Pattern.compile("(^\")|([^\\\\]\")");
    private static Pattern twoQuotaChkPattern = Pattern.compile("[^\\\\]\"");

    private StringUtil() {
    }

    public static String trim(String str) {
        if (str == null) {
            return null;
        }
        return str.trim();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return "";
        }
        return obj.toString();
    }

    public static boolean isNotBlank(Object str) {
        return !StringUtil.isBlank(str);
    }

    public static boolean isBlank(Object str) {
        if (null == str) {
            return true;
        }
        if (str instanceof CharSequence && "".equals(str.toString().trim())) {
            return true;
        }
        if (str instanceof Collection && ((Collection)str).isEmpty()) {
            return true;
        }
        if (str instanceof Map && ((Map)str).isEmpty()) {
            return true;
        }
        return str instanceof Object[] && ((Object[])str).length == 0;
    }

    public static String clearMistyChars(String source, String target) {
        if (source == null) {
            return null;
        }
        return source.replaceAll("\t|\r|\n", target);
    }

    public static String firstToUpperCase(String sourceStr) {
        if (StringUtil.isBlank(sourceStr)) {
            return sourceStr;
        }
        if (sourceStr.length() == 1) {
            return sourceStr.toUpperCase();
        }
        return sourceStr.substring(0, 1).toUpperCase().concat(sourceStr.substring(1));
    }

    public static String firstToLowerCase(String sourceStr) {
        if (StringUtil.isBlank(sourceStr)) {
            return sourceStr;
        }
        if (sourceStr.length() == 1) {
            return sourceStr.toUpperCase();
        }
        return sourceStr.substring(0, 1).toLowerCase().concat(sourceStr.substring(1));
    }

    public static String firstToUpperOtherToLower(String sourceStr) {
        if (StringUtil.isBlank(sourceStr)) {
            return sourceStr;
        }
        if (sourceStr.length() == 1) {
            return sourceStr.toUpperCase();
        }
        return sourceStr.substring(0, 1).toUpperCase().concat(sourceStr.substring(1).toLowerCase());
    }

    public static int indexOfIgnoreCase(String source, String pattern) {
        if (source == null || pattern == null) {
            return -1;
        }
        return source.toLowerCase().indexOf(pattern.toLowerCase());
    }

    public static int indexOfIgnoreCase(String source, String pattern, int start) {
        if (source == null || pattern == null) {
            return -1;
        }
        return source.toLowerCase().indexOf(pattern.toLowerCase(), start);
    }

    public static String addLeftZero2Len(String source, int length) {
        return StringUtil.addSign2Len(source, length, 0, 0);
    }

    public static String addRightZero2Len(String source, int length) {
        return StringUtil.addSign2Len(source, length, 0, 1);
    }

    public static String addRightBlank2Len(String source, int length) {
        return StringUtil.addSign2Len(source, length, 1, 1);
    }

    private static String addSign2Len(String source, int length, int flag, int leftOrRight) {
        if (source == null || source.length() >= length) {
            return source;
        }
        int addSize = length - source.length();
        StringBuilder addStr = new StringBuilder();
        if (leftOrRight == 1) {
            addStr.append(source);
        }
        String sign = flag == 1 ? " " : "0";
        for (int i = 0; i < addSize; ++i) {
            addStr.append(sign);
        }
        if (leftOrRight == 0) {
            addStr.append(source);
        }
        return addStr.toString();
    }

    public static String loopAppendWithSign(String source, String sign, int loopSize) {
        if (loopSize == 0) {
            return "";
        }
        if (loopSize == 1) {
            return source;
        }
        StringBuilder result = new StringBuilder(source);
        for (int i = 1; i < loopSize; ++i) {
            result.append(sign).append(source);
        }
        return result.toString();
    }

    public static String appendStr(String source, String sign, int size, boolean isLeft) {
        int length = 0;
        StringBuilder addStr = new StringBuilder("");
        String tmpStr = "";
        if (source != null) {
            length = source.length();
            tmpStr = source;
        }
        if (!isLeft) {
            addStr.append(tmpStr);
        }
        for (int i = 0; i < size - length; ++i) {
            addStr.append(sign);
        }
        if (isLeft) {
            addStr.append(tmpStr);
        }
        return addStr.toString();
    }

    public static int getSymMarkIndex(String beginMarkSign, String endMarkSign, String source, int startIndex) {
        Pattern pattern = null;
        Pattern chkPattern = null;
        if ("'".equals(beginMarkSign)) {
            pattern = quotaPattern;
            chkPattern = quotaChkPattern;
        } else if ("\"".equals(beginMarkSign)) {
            pattern = twoQuotaPattern;
            chkPattern = twoQuotaChkPattern;
        }
        boolean symMarkIsEqual = beginMarkSign.equals(endMarkSign);
        int beginSignIndex = -1;
        if (pattern == null) {
            beginSignIndex = source.indexOf(beginMarkSign, startIndex);
        } else {
            beginSignIndex = StringUtil.matchIndex(source, pattern, startIndex)[0];
            if (beginSignIndex > startIndex) {
                ++beginSignIndex;
            }
        }
        if (beginSignIndex == -1) {
            return source.indexOf(endMarkSign, startIndex);
        }
        int endIndex = -1;
        if (pattern == null) {
            endIndex = source.indexOf(endMarkSign, beginSignIndex + 1);
        } else {
            endIndex = StringUtil.matchIndex(source, pattern, beginSignIndex + 1)[0];
            if (endIndex > beginSignIndex + 1) {
                ++endIndex;
            } else if (endIndex == beginSignIndex + 1 && StringUtil.matchIndex(source, chkPattern, beginSignIndex + 1)[0] == endIndex) {
                ++endIndex;
            }
        }
        int preEndIndex = 0;
        while (endIndex > beginSignIndex) {
            if (pattern == null) {
                beginSignIndex = source.indexOf(beginMarkSign, (symMarkIsEqual ? endIndex : beginSignIndex) + 1);
            } else {
                beginSignIndex = StringUtil.matchIndex(source, pattern, endIndex + 1)[0];
                if (beginSignIndex > endIndex + 1) {
                    ++beginSignIndex;
                } else if (beginSignIndex == endIndex + 1 && StringUtil.matchIndex(source, chkPattern, endIndex + 1)[0] == beginSignIndex) {
                    ++beginSignIndex;
                }
            }
            if (beginSignIndex == -1 || beginSignIndex > endIndex) {
                return endIndex;
            }
            preEndIndex = endIndex;
            if (pattern == null) {
                endIndex = source.indexOf(endMarkSign, (symMarkIsEqual ? beginSignIndex : endIndex) + 1);
            } else {
                endIndex = StringUtil.matchIndex(source, pattern, beginSignIndex + 1)[0];
                if (endIndex > beginSignIndex + 1) {
                    ++endIndex;
                } else if (endIndex == beginSignIndex + 1 && StringUtil.matchIndex(source, chkPattern, beginSignIndex + 1)[0] == endIndex) {
                    ++endIndex;
                }
            }
            if (endIndex != -1) continue;
            return preEndIndex;
        }
        return endIndex;
    }

    public static int getSymMarkIndexIgnoreCase(String beginMarkSign, String endMarkSign, String source, int startIndex) {
        return StringUtil.getSymMarkIndex(beginMarkSign.toLowerCase(), endMarkSign.toLowerCase(), source.toLowerCase(), startIndex);
    }

    public static int getSymMarkMatchIndex(String beginMarkSign, String endMarkSign, String source, int startIndex) {
        boolean symMarkIsEqual = beginMarkSign.equals(endMarkSign);
        Pattern startP = Pattern.compile(beginMarkSign);
        Pattern endP = Pattern.compile(endMarkSign);
        int[] beginSignIndex = StringUtil.matchIndex(source, startP, startIndex);
        if (beginSignIndex[0] == -1) {
            return StringUtil.matchIndex(source, endP, startIndex)[0];
        }
        int[] endIndex = StringUtil.matchIndex(source, endP, beginSignIndex[1] + 1);
        int[] tmpIndex = new int[]{0, 0};
        while (endIndex[0] > beginSignIndex[0]) {
            beginSignIndex = StringUtil.matchIndex(source, startP, (symMarkIsEqual ? endIndex[1] : beginSignIndex[1]) + 1);
            if (beginSignIndex[0] == -1 || beginSignIndex[0] > endIndex[0]) {
                return endIndex[0];
            }
            tmpIndex = endIndex;
            endIndex = StringUtil.matchIndex(source, endP, (symMarkIsEqual ? beginSignIndex[1] : endIndex[1]) + 1);
            if (endIndex[0] != -1) continue;
            return tmpIndex[0];
        }
        return endIndex[0];
    }

    public static boolean matches(String source, String regex) {
        return StringUtil.matches(source, Pattern.compile(regex));
    }

    public static boolean matches(String source, Pattern pattern) {
        if (StringUtil.isBlank(source)) {
            return false;
        }
        return pattern.matcher(source).find();
    }

    public static int matchIndex(String source, String regex) {
        return StringUtil.matchIndex(source, Pattern.compile(regex));
    }

    public static int[] matchIndex(String source, String regex, int start) {
        return StringUtil.matchIndex(source, Pattern.compile(regex), start);
    }

    public static int matchIndex(String source, Pattern pattern) {
        Matcher m = pattern.matcher(source);
        if (m.find()) {
            return m.start();
        }
        return -1;
    }

    public static int[] matchIndex(String source, Pattern pattern, int start) {
        if (source.length() <= start) {
            return new int[]{-1, -1};
        }
        Matcher m = pattern.matcher(source.substring(start));
        if (m.find()) {
            return new int[]{m.start() + start, m.end() + start};
        }
        return new int[]{-1, -1};
    }

    public static int matchLastIndex(String source, String regex) {
        return StringUtil.matchLastIndex(source, Pattern.compile(regex));
    }

    public static int matchLastIndex(String source, Pattern pattern) {
        if (source == null) {
            return -1;
        }
        Matcher m = pattern.matcher(source);
        int matchIndex = -1;
        while (m.find()) {
            matchIndex = m.start();
        }
        return matchIndex;
    }

    public static int matchCnt(String source, String regex) {
        return StringUtil.matchCnt(source, Pattern.compile(regex));
    }

    public static int matchCnt(String source, Pattern pattern) {
        if (source == null) {
            return 0;
        }
        Matcher matcher = pattern.matcher(source);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static int matchCnt(String source, String regex, int beginIndex, int endIndex) {
        return StringUtil.matchCnt(source.substring(beginIndex, endIndex), Pattern.compile(regex));
    }

    public static int indexOrder(String source, String regex, int order) {
        int begin = 0;
        int count = 0;
        int index = source.indexOf(regex, begin);
        while (index != -1) {
            if (count == order) {
                return index;
            }
            begin = index + 1;
            index = source.indexOf(regex, begin);
            ++count;
        }
        return -1;
    }

    public static int[] str2ASCII(String str) {
        char[] chars = str.toCharArray();
        int[] result = new int[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            result[i] = chars[i];
        }
        return result;
    }

    public static String[] splitExcludeSymMark(String source, String splitSign, HashMap filterMap) {
        if (source == null) {
            return null;
        }
        int splitIndex = source.indexOf(splitSign);
        if (splitIndex == -1) {
            return new String[]{source};
        }
        if (filterMap == null || filterMap.isEmpty()) {
            if ("?".equals(splitSign)) {
                return source.split("\\?");
            }
            if (",".equals(splitSign)) {
                return source.split("\\,");
            }
            if (";".equals(splitSign)) {
                return source.split("\\;");
            }
            if (":".equals(splitSign)) {
                return source.split("\\:");
            }
            if ("".equals(splitSign.trim())) {
                return source.split("\\s+");
            }
            return source.split(splitSign);
        }
        List<String[]> filters = StringUtil.matchFilters(source, filterMap);
        if (filters.isEmpty()) {
            if ("?".equals(splitSign)) {
                return source.split("\\?");
            }
            if (",".equals(splitSign)) {
                return source.split("\\,");
            }
            if (";".equals(splitSign)) {
                return source.split("\\;");
            }
            if (":".equals(splitSign)) {
                return source.split("\\:");
            }
            if ("".equals(splitSign.trim())) {
                return source.split("\\s+");
            }
            return source.split(splitSign);
        }
        int start = 0;
        int skipIndex = 0;
        int preSplitIndex = splitIndex;
        ArrayList<String> splitResults = new ArrayList<String>();
        int max = -1;
        while (splitIndex != -1) {
            max = -1;
            for (String[] filter : filters) {
                int[] startEnd = StringUtil.getStartEndIndex(source, filter, skipIndex, splitIndex);
                if (startEnd[0] < 0 || startEnd[0] > splitIndex || startEnd[1] < splitIndex || startEnd[1] <= max) continue;
                max = startEnd[1];
            }
            if (max > -1) {
                skipIndex = max + 1;
                splitIndex = source.indexOf(splitSign, skipIndex);
            }
            if (preSplitIndex == splitIndex) {
                splitResults.add(source.substring(start, preSplitIndex));
                skipIndex = start = preSplitIndex + 1;
                preSplitIndex = splitIndex = source.indexOf(splitSign, skipIndex);
                continue;
            }
            preSplitIndex = splitIndex;
        }
        splitResults.add(source.substring(start));
        String[] resultStr = new String[splitResults.size()];
        for (int j = 0; j < splitResults.size(); ++j) {
            resultStr[j] = (String)splitResults.get(j);
        }
        return resultStr;
    }

    private static int[] getStartEndIndex(String source, String[] filter, int skipIndex, int splitIndex) {
        String tmp;
        int[] result = new int[]{-1, -1};
        Pattern pattern = null;
        if ("'".equals(filter[0])) {
            pattern = quotaPattern;
        } else if ("\"".equals(filter[0])) {
            pattern = twoQuotaPattern;
        }
        if (pattern == null) {
            result[0] = source.indexOf(filter[0], skipIndex);
            if (result[0] >= 0) {
                result[1] = StringUtil.getSymMarkIndex(filter[0], filter[1], source, skipIndex);
            }
        } else {
            result[0] = StringUtil.matchIndex(source, pattern, skipIndex)[0];
            if (result[0] >= 0) {
                tmp = source.substring(result[0], result[0] + 1);
                if (!"'".equals(tmp) && !"\"".equals(tmp)) {
                    result[0] = result[0] + 1;
                }
                result[1] = StringUtil.getSymMarkIndex(filter[0], filter[1], source, result[0]);
            }
        }
        while (result[1] > 0 && result[1] < splitIndex) {
            if (pattern == null) {
                result[0] = source.indexOf(filter[0], result[1] + 1);
                if (result[0] > 0) {
                    result[1] = StringUtil.getSymMarkIndex(filter[0], filter[1], source, result[0]);
                    continue;
                }
                result[1] = -1;
                continue;
            }
            tmp = source.substring(result[1], result[1] + 1);
            result[0] = !"'".equals(tmp) && !"\"".equals(tmp) ? StringUtil.matchIndex(source, pattern, result[1] + 2)[0] : StringUtil.matchIndex(source, pattern, result[1] + 1)[0];
            if (result[0] > 0) {
                tmp = source.substring(result[0], result[0] + 1);
                if (!"'".equals(tmp) && !"\"".equals(tmp)) {
                    result[0] = result[0] + 1;
                }
                result[1] = StringUtil.getSymMarkIndex(filter[0], filter[1], source, result[0]);
                continue;
            }
            result[1] = -1;
        }
        return result;
    }

    private static List<String[]> matchFilters(String source, HashMap filterMap) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (Map.Entry entry : filterMap.entrySet()) {
            int beginSignIndex;
            String beginSign = (String)entry.getKey();
            String endSign = (String)entry.getValue();
            Pattern pattern = null;
            Pattern chkPattern = null;
            if ("'".equals(beginSign)) {
                pattern = quotaPattern;
                chkPattern = quotaChkPattern;
            } else if ("\"".equals(beginSign)) {
                pattern = twoQuotaPattern;
                chkPattern = twoQuotaChkPattern;
            }
            int endSignIndex = -1;
            if (pattern == null) {
                beginSignIndex = source.indexOf(beginSign);
                if (beginSignIndex > -1) {
                    endSignIndex = source.indexOf(endSign, beginSignIndex + 1);
                }
            } else {
                beginSignIndex = StringUtil.matchIndex(source, pattern);
                if (beginSignIndex > -1) {
                    if ((endSignIndex = StringUtil.matchIndex(source, pattern, ++beginSignIndex + 1)[0]) > beginSignIndex + 1) {
                        ++endSignIndex;
                    } else if (endSignIndex == beginSignIndex + 1 && StringUtil.matchIndex(source, chkPattern, beginSignIndex + 1)[0] == endSignIndex) {
                        ++endSignIndex;
                    }
                }
            }
            if (beginSignIndex == -1 || endSignIndex == -1) continue;
            result.add(new String[]{beginSign, endSign});
        }
        return result;
    }

    public static String toHumpStr(String source, boolean firstIsUpperCase) {
        return StringUtil.toHumpStr(source, firstIsUpperCase, true);
    }

    public static String toHumpStr(String source, boolean firstIsUpperCase, boolean removeDealine) {
        if (StringUtil.isBlank(source)) {
            return source;
        }
        String[] humpAry = source.trim().replace("-", "_").split("\\_");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < humpAry.length; ++i) {
            String cell = humpAry[i];
            if (i > 0 && !removeDealine) {
                result.append("_");
            }
            if (cell.toUpperCase().equals(cell)) {
                result.append(StringUtil.firstToUpperOtherToLower(cell));
                continue;
            }
            result.append(StringUtil.firstToUpperCase(cell));
        }
        if (firstIsUpperCase) {
            return StringUtil.firstToUpperCase(result.toString());
        }
        return StringUtil.firstToLowerCase(result.toString());
    }

    public static String secureMask(Object value, int preLength, int tailLength, String maskStr) {
        if (value == null) {
            return null;
        }
        String tmp = value.toString();
        if (tmp.length() <= preLength + tailLength) {
            return tmp;
        }
        return tmp.substring(0, preLength).concat(maskStr == null || "".equals(maskStr) ? "***" : maskStr).concat(tmp.substring(tmp.length() - tailLength));
    }

    public static boolean hasChinese(String str) {
        return chinaPattern.matcher(str).find();
    }

    public static String humpToSplitStr(String source, String split) {
        if (source == null) {
            return null;
        }
        char[] chars = source.trim().toCharArray();
        StringBuilder result = new StringBuilder();
        int uperCaseCnt = 0;
        for (int i = 0; i < chars.length; ++i) {
            char charInt = chars[i];
            uperCaseCnt = charInt >= 'A' && charInt <= 'Z' ? ++uperCaseCnt : 0;
            if (uperCaseCnt == 1 && i != 0) {
                result.append(split);
            }
            result.append(Character.toString(chars[i]));
        }
        return result.toString();
    }

    public static String[] humpFieldNames(String[] labelNames) {
        if (labelNames == null) {
            return null;
        }
        String[] result = new String[labelNames.length];
        int aliasIndex = 0;
        int n = labelNames.length;
        for (int i = 0; i < n; ++i) {
            aliasIndex = labelNames[i].indexOf(":");
            result[i] = aliasIndex != -1 ? StringUtil.toHumpStr(labelNames[i].substring(aliasIndex + 1), false) : StringUtil.toHumpStr(labelNames[i], false);
        }
        return result;
    }

    public static String fillArgs(String template, Object ... args) {
        if (template == null || args == null || args.length == 0) {
            return template;
        }
        for (Object arg : args) {
            template = template.replaceFirst("\\$?\\{\\s*\\}", arg == null ? "null" : Matcher.quoteReplacement(arg.toString()));
        }
        return template;
    }

    public static String replaceAllStr(String source, String template, String target) {
        return StringUtil.replaceAllStr(source, template, target, 0);
    }

    public static String replaceAllStr(String source, String template, String target, int fromIndex) {
        if (source == null || template.equals(target)) {
            return source;
        }
        int index = source.indexOf(template, fromIndex);
        int subLength = target.length() - template.length();
        int begin = index - 1;
        while (index != -1 && index >= begin) {
            source = source.substring(0, index).concat(target).concat(source.substring(index + template.length()));
            begin = index + subLength + 1;
            index = source.indexOf(template, begin);
        }
        return source;
    }

    public static String replaceAllStr(String source, String template, String target, int fromIndex, int endIndex) {
        if (source == null || template.equals(target) || endIndex <= fromIndex) {
            return source;
        }
        if (endIndex >= source.length() - 1) {
            return StringUtil.replaceAllStr(source, template, target, fromIndex);
        }
        String beforeStr = fromIndex == 0 ? "" : source.substring(0, fromIndex);
        String replaceBody = source.substring(fromIndex, endIndex + 1);
        String endStr = source.substring(endIndex + 1);
        int index = replaceBody.indexOf(template);
        int begin = index - 1;
        int subLength = target.length() - template.length();
        while (index != -1 && index >= begin) {
            replaceBody = replaceBody.substring(0, index).concat(target).concat(replaceBody.substring(index + template.length()));
            begin = index + subLength + 1;
            index = replaceBody.indexOf(template, begin);
        }
        return beforeStr.concat(replaceBody).concat(endStr);
    }

    public static String toDBC(String SBCStr) {
        if (StringUtil.isBlank(SBCStr)) {
            return SBCStr;
        }
        return SBCStr.replaceAll("\\\uff1b", ";").replaceAll("\\\uff1f", "?").replaceAll("\\\uff0e", ".").replaceAll("\\\uff1a", ":").replaceAll("\\\uff07", "'").replaceAll("\\\uff02", "\"").replaceAll("\\\uff0c", ",").replaceAll("\\\u3010", "[").replaceAll("\\\u3011", "]").replaceAll("\\\uff09", ")").replaceAll("\\\uff08", "(").replaceAll("\\\uff1d", "=");
    }

    public static String linkAry(String sign, boolean skipNull, Object ... arys) {
        if (arys == null || arys.length == 0) {
            return "";
        }
        String linkSign = sign == null ? "," : sign;
        int index = 0;
        StringBuilder result = new StringBuilder();
        for (Object str : arys) {
            if (str == null && skipNull) continue;
            if (index > 0) {
                result.append(linkSign);
            }
            result.append(str == null ? "null" : str.toString());
            ++index;
        }
        return result.toString();
    }

    public static boolean like(String source, String[] keywords) {
        int index = 0;
        for (String keyword : keywords) {
            if ((index = source.indexOf(keyword, index)) == -1) {
                return false;
            }
            index += keyword.length();
        }
        return true;
    }

    public static void arrayTrim(String[] params) {
        if (params == null || params.length == 0) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            params[i] = params[i].trim();
        }
    }
}

