/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.annotation.SqlToyFieldAlias;
import org.sagacity.sqltoy.config.model.DTOEntityMapModel;
import org.sagacity.sqltoy.config.model.DataType;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperUtils {
    protected static final Logger logger = LoggerFactory.getLogger(MapperUtils.class);
    private static Map<String, DTOEntityMapModel> dtoEntityMappCache = new HashMap<String, DTOEntityMapModel>();

    private MapperUtils() {
    }

    public static <T extends Serializable> T map(SqlToyContext sqlToyContext, Serializable source, Class<T> resultType, String ... ignoreProperties) throws Exception {
        if (source == null || resultType == null || resultType.equals(Object.class)) {
            throw new IllegalArgumentException("source \u548c resultType \u4e0d\u80fd\u4e3anull,\u4e14resultType\u4e0d\u80fd\u4e3aObject.class!");
        }
        ArrayList<Serializable> sourceList = new ArrayList<Serializable>();
        sourceList.add(source);
        List<T> result = MapperUtils.mapList(sqlToyContext, sourceList, resultType, ignoreProperties);
        return (T)((Serializable)result.get(0));
    }

    public static <T extends Serializable> List<T> mapList(SqlToyContext sqlToyContext, List<Serializable> sourceList, Class<T> resultType, String ... ignoreProperties) throws Exception {
        Method[] setMethods;
        Method[] getMethods;
        if (sourceList == null || resultType == null || resultType.equals(Object.class)) {
            throw new IllegalArgumentException("sourceList \u548c resultType \u4e0d\u80fd\u4e3anull,\u4e14resultType\u4e0d\u80fd\u4e3aObject.class!");
        }
        if (sourceList.isEmpty()) {
            return new ArrayList();
        }
        if (Modifier.isAbstract(resultType.getModifiers()) || Modifier.isInterface(resultType.getModifiers())) {
            throw new IllegalArgumentException("resultType:" + resultType.getName() + " \u662f\u62bd\u8c61\u7c7b\u6216\u63a5\u53e3,\u975e\u6cd5\u53c2\u6570!");
        }
        DTOEntityMapModel mapModel = MapperUtils.getDTOEntityMap(sqlToyContext, sourceList.iterator().next().getClass(), resultType);
        if (mapModel.dtoClassName.equals(resultType.getName())) {
            getMethods = mapModel.pojoGetMethods;
            setMethods = mapModel.dtoSetMethods;
        } else {
            getMethods = mapModel.dtoGetMethods;
            setMethods = mapModel.pojoSetMethods;
        }
        if (ignoreProperties != null && ignoreProperties.length > 0) {
            ArrayList<Method> getRealMethods = new ArrayList<Method>();
            ArrayList<Method> setRealMethods = new ArrayList<Method>();
            ArrayList<String> props = new ArrayList<String>();
            for (String ignoreProp : ignoreProperties) {
                props.add(ignoreProp.toLowerCase());
            }
            for (int i = 0; i < setMethods.length; ++i) {
                if (setMethods[i] == null) continue;
                String methodName = setMethods[i].getName().toLowerCase();
                Class<?> paramType = setMethods[i].getParameterTypes()[0];
                boolean skip = false;
                for (int j = 0; j < props.size(); ++j) {
                    String ignorePropLow = (String)props.get(j);
                    if (!methodName.equals("set".concat(ignorePropLow)) && (!ignorePropLow.startsWith("is") || !paramType.equals(Boolean.TYPE) || !methodName.equals("set".concat(ignorePropLow.substring(2))))) continue;
                    skip = true;
                    props.remove(j);
                    --j;
                    break;
                }
                if (skip) continue;
                getRealMethods.add(getMethods[i]);
                setRealMethods.add(setMethods[i]);
            }
            if (setRealMethods.size() == 0) {
                throw new IllegalArgumentException("\u6700\u7ec8\u6620\u5c04\u5bf9\u5e94\u7684\u5c5e\u6027\u6570\u91cf\u4e3a\u96f6,\u8bf7\u68c0\u67e5ignoreProperties\u662f\u5426\u6b63\u786e,\u8fc7\u6ee4\u4e86\u5168\u90e8\u5339\u914d\u5c5e\u6027!");
            }
            getMethods = new Method[setRealMethods.size()];
            setMethods = new Method[setRealMethods.size()];
            getRealMethods.toArray(getMethods);
            setRealMethods.toArray(setMethods);
        }
        List dataSets = MapperUtils.invokeGetValues(sourceList, getMethods);
        return MapperUtils.reflectListToBean(dataSets, resultType, setMethods);
    }

    private static List invokeGetValues(List sourceList, Method[] getMethods) throws Exception {
        ArrayList result = new ArrayList();
        for (int i = 0; i < sourceList.size(); ++i) {
            Object row = sourceList.get(i);
            ArrayList<Object> rowData = new ArrayList<Object>();
            for (Method method : getMethods) {
                if (method == null) {
                    rowData.add(null);
                    continue;
                }
                rowData.add(method.invoke(row, new Object[0]));
            }
            result.add(rowData);
        }
        return result;
    }

    private static DTOEntityMapModel getDTOEntityMap(SqlToyContext sqlToyContext, Class sourceClass, Class resultType) {
        String sourceKey = sourceClass.getName();
        String resultKey = resultType.getName();
        String key = "POJO=".concat(sourceKey).concat(";DTO=").concat(resultKey);
        if (dtoEntityMappCache.containsKey(key)) {
            return dtoEntityMappCache.get(key);
        }
        key = "POJO=".concat(resultKey).concat(";DTO=").concat(sourceKey);
        if (dtoEntityMappCache.containsKey(key)) {
            return dtoEntityMappCache.get(key);
        }
        int style = 0;
        Class dtoClass = null;
        Class pojoClass = null;
        if (sqlToyContext.isEntity(sourceClass)) {
            dtoClass = resultType;
            pojoClass = sourceClass;
            key = "POJO=".concat(sourceKey).concat(";DTO=").concat(resultKey);
            ++style;
        }
        if (sqlToyContext.isEntity(resultType)) {
            dtoClass = sourceClass;
            pojoClass = resultType;
            key = "POJO=".concat(resultKey).concat(";DTO=").concat(sourceKey);
            ++style;
        }
        DTOEntityMapModel result = null;
        if (style == 2 || style == 0) {
            key = "POJO=".concat(sourceKey).concat(";DTO=").concat(resultKey);
            result = MapperUtils.PO2PO(sourceClass, resultType);
        } else {
            result = MapperUtils.PO2DTO(pojoClass, dtoClass);
        }
        dtoEntityMappCache.put(key, result);
        return result;
    }

    private static DTOEntityMapModel PO2PO(Class dtoClass, Class pojoClass) {
        String fieldName;
        DTOEntityMapModel result = new DTOEntityMapModel();
        HashMap<String, String> pojoPropsMap = new HashMap<String, String>();
        Class parentClass = pojoClass;
        while (!parentClass.equals(Object.class)) {
            for (Field field : parentClass.getDeclaredFields()) {
                fieldName = field.getName();
                pojoPropsMap.put(fieldName.toLowerCase(), fieldName);
            }
            parentClass = parentClass.getSuperclass();
        }
        ArrayList<String> dtoProps = new ArrayList<String>();
        ArrayList<String> pojoProps = new ArrayList<String>();
        parentClass = dtoClass;
        while (!parentClass.equals(Object.class)) {
            for (Field field : parentClass.getDeclaredFields()) {
                fieldName = field.getName();
                if (!pojoPropsMap.containsKey(fieldName.toLowerCase())) continue;
                dtoProps.add(fieldName);
                pojoProps.add((String)pojoPropsMap.get(fieldName.toLowerCase()));
            }
            parentClass = parentClass.getSuperclass();
        }
        result.dtoClassName = dtoClass.getName();
        result.dtoProps = dtoProps.toArray(new String[dtoProps.size()]);
        result.pojoClassName = pojoClass.getName();
        result.pojoProps = pojoProps.toArray(new String[pojoProps.size()]);
        result.dtoGetMethods = BeanUtil.matchGetMethods(dtoClass, result.dtoProps);
        result.dtoSetMethods = BeanUtil.matchSetMethods(dtoClass, result.dtoProps);
        result.pojoGetMethods = BeanUtil.matchGetMethods(pojoClass, result.pojoProps);
        result.pojoSetMethods = BeanUtil.matchSetMethods(pojoClass, result.pojoProps);
        return result;
    }

    private static DTOEntityMapModel PO2DTO(Class pojoClass, Class dtoClass) {
        String fieldName;
        HashMap<String, String> pojoPropsMap = new HashMap<String, String>();
        Class parentClass = pojoClass;
        while (!parentClass.equals(Object.class)) {
            for (Field field : parentClass.getDeclaredFields()) {
                fieldName = field.getName();
                pojoPropsMap.put(fieldName.toLowerCase(), fieldName);
            }
            parentClass = parentClass.getSuperclass();
        }
        ArrayList<String> dtoProps = new ArrayList<String>();
        ArrayList<String> pojoProps = new ArrayList<String>();
        parentClass = dtoClass;
        while (!parentClass.equals(Object.class)) {
            for (Field field : parentClass.getDeclaredFields()) {
                String aliasName = fieldName = field.getName();
                SqlToyFieldAlias alias = field.getAnnotation(SqlToyFieldAlias.class);
                if (alias != null) {
                    aliasName = alias.value();
                }
                if (!pojoPropsMap.containsKey(aliasName.toLowerCase())) continue;
                dtoProps.add(fieldName);
                pojoProps.add((String)pojoPropsMap.get(aliasName.toLowerCase()));
            }
            parentClass = parentClass.getSuperclass();
        }
        if (dtoProps.isEmpty()) {
            throw new IllegalArgumentException("dto:" + dtoClass.getName() + " mapping pojo:" + pojoClass.getName() + " \u6ca1\u6709\u5c5e\u6027\u540d\u79f0\u662f\u5339\u914d\u7684\uff0c\u8bf7\u68c0\u67e5!");
        }
        DTOEntityMapModel result = new DTOEntityMapModel();
        result.dtoClassName = dtoClass.getName();
        result.dtoProps = dtoProps.toArray(new String[dtoProps.size()]);
        result.pojoClassName = pojoClass.getName();
        result.pojoProps = pojoProps.toArray(new String[pojoProps.size()]);
        result.dtoGetMethods = BeanUtil.matchGetMethods(dtoClass, result.dtoProps);
        result.dtoSetMethods = BeanUtil.matchSetMethods(dtoClass, result.dtoProps);
        result.pojoGetMethods = BeanUtil.matchGetMethods(pojoClass, result.pojoProps);
        result.pojoSetMethods = BeanUtil.matchSetMethods(pojoClass, result.pojoProps);
        return result;
    }

    private static List reflectListToBean(List datas, Class voClass, Method[] realMethods) throws Exception {
        ArrayList result = new ArrayList();
        int indexSize = realMethods.length;
        String[] methodTypes = new String[indexSize];
        int[] methodTypeValues = new int[indexSize];
        for (int i = 0; i < indexSize; ++i) {
            if (null == realMethods[i]) continue;
            methodTypes[i] = realMethods[i].getParameterTypes()[0].getTypeName();
            methodTypeValues[i] = DataType.getType(methodTypes[i]);
        }
        Object cellData = null;
        for (int i = 0; i < datas.size(); ++i) {
            List row = (List)datas.get(i);
            if (row == null) continue;
            Object bean = voClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            int size = row.size();
            for (int j = 0; j < size; ++j) {
                cellData = row.get(j);
                if (cellData == null || realMethods[j] == null) continue;
                if (cellData.getClass().getTypeName().equals(methodTypes[j])) {
                    realMethods[j].invoke(bean, cellData);
                    continue;
                }
                realMethods[j].invoke(bean, BeanUtil.convertType(cellData, methodTypeValues[j], methodTypes[j]));
            }
            result.add(bean);
        }
        return result;
    }
}

