/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.NumberUtil;

public class MacroIfLogic {
    private MacroIfLogic() {
    }

    public static boolean evalLogic(String evalExpression, List paramValues, int preCount, int logicParamCnt) {
        for (int i = 0; i < logicParamCnt; ++i) {
            Object value = paramValues.get(preCount + i);
            if (value == null || (!value.getClass().isArray() || CollectionUtil.convertArray(value).length != 0) && (!(value instanceof Collection) || !((Collection)value).isEmpty())) continue;
            return false;
        }
        String simpleResult = MacroIfLogic.evalSimpleExpress(evalExpression = evalExpression.replaceAll("\\<\\>", "!=").replaceAll("\r|\t|\n", " ").trim(), logicParamCnt == 0 ? null : paramValues, preCount);
        if (!"undefine".equals(simpleResult)) {
            return Boolean.parseBoolean(simpleResult);
        }
        return true;
    }

    private static String evalSimpleExpress(String evalExpression, List paramValues, int preCount) {
        if (evalExpression.indexOf("||") != -1 && evalExpression.indexOf("&&") != -1) {
            return "undefine";
        }
        String[] compareStr = new String[]{"!=", "==", ">=", "<=", ">", "<", "=", " include ", " in ", " out ", " startswith ", " endswith "};
        String[] splitReg = new String[]{"\\!\\=", "\\=\\=", "\\>\\=", "\\<\\=", "\\>", "\\<", "\\=", "\\s+include\\s+", "\\s+in\\s+", "\\s+out\\s+", "\\s+startswith\\s+", "\\s+endswith\\s+"};
        String splitStr = "==";
        String logicStr = "\\&\\&";
        try {
            int i;
            if (evalExpression.indexOf("||") != -1) {
                logicStr = "\\|\\|";
            }
            String[] expressions = evalExpression.split(logicStr);
            boolean[] expressResult = new boolean[expressions.length];
            String compareType = "==";
            for (i = 0; i < expressions.length; ++i) {
                String value = paramValues == null ? null : (String)paramValues.get(preCount + i);
                String express = expressions[i].trim();
                String expressLow = express.toLowerCase();
                for (int j = 0; j < compareStr.length; ++j) {
                    if (expressLow.indexOf(compareStr[j]) == -1) continue;
                    compareType = compareStr[j].trim();
                    splitStr = splitReg[j];
                    break;
                }
                String[] params = express.split(splitStr);
                String compareParam = params[0].trim().toLowerCase();
                String compareValue = params[1].trim();
                expressResult[i] = compareParam.startsWith("size(") || compareParam.startsWith("length(") ? MacroIfLogic.compare(value == null ? 0 : CollectionUtil.convertArray(value).length, compareType, compareValue) : MacroIfLogic.compare(paramValues == null ? params[0].trim() : value, compareType, compareValue);
            }
            if ("\\&\\&".equals(logicStr) || "&&".equals(logicStr)) {
                for (i = 0; i < expressions.length; ++i) {
                    if (expressResult[i]) continue;
                    return "false";
                }
                return "true";
            }
            for (i = 0; i < expressions.length; ++i) {
                if (!expressResult[i]) continue;
                return "true";
            }
            return "false";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "undefine";
        }
    }

    public static boolean compare(Object value, String compareType, String compareValue) {
        String[] compareValues;
        String realValue;
        String[] calculateStr;
        if (compareValue.startsWith("'") && compareValue.endsWith("'")) {
            compareValue = compareValue.substring(1, compareValue.length() - 1);
        } else if (compareValue.startsWith("\"") && compareValue.endsWith("\"")) {
            compareValue = compareValue.substring(1, compareValue.length() - 1);
        }
        Object append = "0";
        for (String calculate : calculateStr = new String[]{"+", "-"}) {
            if (compareValue.trim().indexOf(calculate) <= 0) continue;
            String[] tmpAry = compareValue.split("+".equals(calculate) ? "\\+" : "\\-");
            append = calculate + tmpAry[1].trim();
            compareValue = tmpAry[0].trim();
            break;
        }
        String type = "string";
        String dayTimeFmt = "yyyy-MM-dd HH:mm:ss";
        String dayFmt = "yyyy-MM-dd";
        String lowCompareValue = compareValue.toLowerCase();
        if ("now()".equals(lowCompareValue) || ".now".equals(lowCompareValue) || "${.now}".equals(lowCompareValue) || "nowtime()".equals(lowCompareValue)) {
            compareValue = DateUtil.formatDate(DateUtil.addSecond(new Date(), Double.parseDouble((String)append)), dayTimeFmt);
            type = "time";
        } else if ("day()".equals(lowCompareValue) || "sysdate()".equals(lowCompareValue) || ".day".equals(lowCompareValue) || ".day()".equals(lowCompareValue) || "${.day}".equals(lowCompareValue)) {
            compareValue = DateUtil.formatDate(DateUtil.addSecond(new Date(), Double.parseDouble((String)append)), dayFmt);
            type = "date";
        }
        compareValue = compareValue.replaceAll("'", "").replaceAll("\"", "");
        String string = realValue = value == null ? "null" : value.toString();
        if ("time".equals(type)) {
            realValue = DateUtil.formatDate(value, dayTimeFmt);
        } else if ("date".equals(type)) {
            realValue = DateUtil.formatDate(value, dayFmt);
        }
        if ("==".equals(compareType) || "=".equals(compareType)) {
            return realValue.equalsIgnoreCase(compareValue);
        }
        if ("!=".equals(compareType)) {
            return !realValue.equalsIgnoreCase(compareValue);
        }
        if (value == null) {
            return false;
        }
        if (">=".equals(compareType)) {
            return MacroIfLogic.moreEqual(value, realValue, compareValue, type);
        }
        if ("<=".equals(compareType)) {
            return MacroIfLogic.lessEqual(value, realValue, compareValue, type);
        }
        if (">".equals(compareType)) {
            return MacroIfLogic.more(value, realValue, compareValue, type);
        }
        if ("<".equals(compareType)) {
            return MacroIfLogic.less(value, realValue, compareValue, type);
        }
        if ("include".equals(compareType)) {
            return MacroIfLogic.include(value, realValue, compareValue, type);
        }
        if ("in".equals(compareType)) {
            return MacroIfLogic.in(value, realValue, compareValue, type);
        }
        if ("out".equals(compareType)) {
            return MacroIfLogic.out(value, realValue, compareValue, type);
        }
        if ("startswith".equals(compareType)) {
            return realValue.startsWith(compareValue);
        }
        if ("endswith".equals(compareType)) {
            return realValue.endsWith(compareValue);
        }
        if ("between".equals(compareType) && (compareValues = compareValue.split("\\,")).length == 2) {
            return MacroIfLogic.between(value, realValue, compareValues[0], compareValues[1]);
        }
        return true;
    }

    private static boolean moreEqual(Object value, String valueStr, String compare, String type) {
        if ("time".equals(type) || "date".equals(type)) {
            return DateUtil.convertDateObject(valueStr).compareTo(DateUtil.convertDateObject(compare)) >= 0;
        }
        if (NumberUtil.isNumber(valueStr) && NumberUtil.isNumber(compare)) {
            return Double.parseDouble(valueStr) >= Double.parseDouble(compare);
        }
        return valueStr.compareTo(compare) >= 0;
    }

    private static boolean lessEqual(Object value, String valueStr, String compare, String type) {
        if ("time".equals(type) || "date".equals(type)) {
            return DateUtil.convertDateObject(valueStr).compareTo(DateUtil.convertDateObject(compare)) <= 0;
        }
        if (NumberUtil.isNumber(valueStr) && NumberUtil.isNumber(compare)) {
            return Double.parseDouble(valueStr) <= Double.parseDouble(compare);
        }
        return valueStr.compareTo(compare) <= 0;
    }

    private static boolean more(Object value, String valueStr, String compare, String type) {
        if ("time".equals(type) || "date".equals(type)) {
            return DateUtil.convertDateObject(valueStr).compareTo(DateUtil.convertDateObject(compare)) > 0;
        }
        if (NumberUtil.isNumber(valueStr) && NumberUtil.isNumber(compare)) {
            return Double.parseDouble(valueStr) > Double.parseDouble(compare);
        }
        return valueStr.compareTo(compare) > 0;
    }

    private static boolean less(Object value, String valueStr, String compare, String type) {
        if ("time".equals(type) || "date".equals(type)) {
            return DateUtil.convertDateObject(valueStr).compareTo(DateUtil.convertDateObject(compare)) < 0;
        }
        if (NumberUtil.isNumber(valueStr) && NumberUtil.isNumber(compare)) {
            return Double.parseDouble(valueStr) < Double.parseDouble(compare);
        }
        return valueStr.compareTo(compare) < 0;
    }

    private static boolean include(Object value, String valueStr, String compare, String type) {
        if (value == null) {
            return false;
        }
        String compareLow = compare.toLowerCase();
        if (value instanceof String) {
            return valueStr.toLowerCase().contains(compareLow);
        }
        if (value.getClass().isArray()) {
            Object[] values;
            for (Object var : values = CollectionUtil.convertArray(value)) {
                if (!compareLow.equals(var == null ? null : var.toString().toLowerCase())) continue;
                return true;
            }
        }
        if (value instanceof Collection) {
            for (Object var : (Collection)value) {
                if (!compareLow.equals(var == null ? null : var.toString().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean in(Object value, String valueStr, String compare, String type) {
        if (value == null) {
            return false;
        }
        String[] compareAry = compare.toLowerCase().split("\\,");
        String compareLow = valueStr.toLowerCase();
        if (compareAry.length == 1) {
            return compareAry[0].contains(compareLow);
        }
        for (int i = 0; i < compareAry.length; ++i) {
            if (!compareLow.equals(compareAry[i].trim())) continue;
            return true;
        }
        return false;
    }

    private static boolean out(Object value, String valueStr, String compare, String type) {
        if (value == null) {
            return true;
        }
        String[] compareAry = compare.toLowerCase().split("\\,");
        String compareLow = valueStr.toLowerCase();
        if (compareAry.length == 1) {
            return !compareAry[0].contains(compareLow);
        }
        for (int i = 0; i < compareAry.length; ++i) {
            if (!compareLow.equals(compareAry[i].trim())) continue;
            return false;
        }
        return true;
    }

    private static boolean between(Object param, String valueStr, String beginContrast, String endContrast) {
        Date var;
        if (null == param) {
            return false;
        }
        return param instanceof Date || param instanceof LocalDate || param instanceof LocalDateTime ? (var = DateUtil.convertDateObject(param)).compareTo(DateUtil.convertDateObject(beginContrast)) >= 0 && var.compareTo(DateUtil.convertDateObject(endContrast)) <= 0 : (param instanceof LocalTime ? ((LocalTime)param).compareTo(LocalTime.parse(beginContrast)) >= 0 && ((LocalTime)param).compareTo(LocalTime.parse(endContrast)) <= 0 : (param instanceof Number ? new BigDecimal(param.toString()).compareTo(new BigDecimal(beginContrast)) >= 0 && new BigDecimal(param.toString()).compareTo(new BigDecimal(endContrast)) <= 0 : valueStr.compareTo(beginContrast) >= 0 && valueStr.compareTo(endContrast) <= 0));
    }
}

