/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.ElasticEndpoint;
import org.sagacity.sqltoy.config.model.NoSqlConfigModel;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static final RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(30000).setConnectTimeout(10000).setSocketTimeout(180000).build();
    protected static final Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    private static final String CHARSET = "UTF-8";
    private static final String SEARCH = "_search";
    private static final String CONTENT_TYPE = "application/json";
    private static final String POST = "POST";

    private HttpClientUtils() {
    }

    public static String doPost(SqlToyContext sqltoyContext, String url, String username, String password, String[] paramName, String[] paramValue) throws Exception {
        CloseableHttpResponse response;
        HttpEntity reponseEntity;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Connection", "close");
        httpPost.setConfig(requestConfig);
        CloseableHttpClient client = null;
        if (StringUtil.isNotBlank(username) && StringUtil.isNotBlank(password)) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        } else {
            client = HttpClients.createDefault();
        }
        if (paramValue != null && paramValue.length > 0) {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            for (int i = 0; i < paramValue.length; ++i) {
                if (paramValue[i] == null) continue;
                nvps.add(new BasicNameValuePair(paramName[i], paramValue[i]));
            }
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(nvps, CHARSET);
            httpEntity.setContentType(CONTENT_TYPE);
            httpPost.setEntity((HttpEntity)httpEntity);
        }
        if ((reponseEntity = (response = client.execute((HttpUriRequest)httpPost)).getEntity()) != null) {
            return EntityUtils.toString((HttpEntity)reponseEntity, (String)CHARSET);
        }
        return null;
    }

    public static JSONObject doPost(SqlToyContext sqltoyContext, NoSqlConfigModel nosqlConfig, ElasticEndpoint esConfig, Object postValue) throws Exception {
        Response response;
        String realUrl;
        if (esConfig.getUrl() == null) {
            throw new IllegalArgumentException("\u8bf7\u6b63\u786e\u914d\u7f6esqltoyContext elasticConfigs \u6307\u5b9aes\u7684\u670d\u52a1\u5730\u5740!");
        }
        String charset = nosqlConfig.getCharset() == null ? CHARSET : nosqlConfig.getCharset();
        StringEntity httpEntity = null;
        if (nosqlConfig.isSqlMode()) {
            if (esConfig.isNativeSql()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("query", postValue.toString());
                httpEntity = new StringEntity(JSON.toJSONString(map), charset);
            } else {
                httpEntity = new StringEntity(postValue.toString(), charset);
            }
        } else {
            httpEntity = new StringEntity(JSON.toJSONString((Object)postValue), charset);
        }
        httpEntity.setContentEncoding(charset);
        httpEntity.setContentType(CONTENT_TYPE);
        HttpEntity reponseEntity = null;
        if (esConfig.getRestClient() != null) {
            realUrl = HttpClientUtils.wrapUrl(esConfig, nosqlConfig);
            if (sqltoyContext.isDebug()) {
                logger.debug("esRestClient\u6267\u884c:URL=[{}],Path={},\u6267\u884c\u7684JSON=[{}]", new Object[]{esConfig.getUrl(), realUrl, JSON.toJSONString((Object)postValue)});
            }
            try (RestClient restClient = null;){
                restClient = esConfig.getRestClient();
                Request request = new Request(POST, realUrl);
                request.setEntity((HttpEntity)httpEntity);
                response = restClient.performRequest(request);
                reponseEntity = response.getEntity();
            }
        }
        realUrl = HttpClientUtils.wrapUrl(esConfig, nosqlConfig);
        HttpPost httpPost = new HttpPost(realUrl);
        if (sqltoyContext.isDebug()) {
            logger.debug("httpClient\u6267\u884cURL=[{}],\u6267\u884c\u7684JSON=[{}]", (Object)realUrl, (Object)JSON.toJSONString((Object)postValue));
        }
        httpPost.setEntity((HttpEntity)httpEntity);
        httpPost.setHeader("Connection", "close");
        if (nosqlConfig.getRequestTimeout() != 30000 || nosqlConfig.getConnectTimeout() != 10000 || nosqlConfig.getSocketTimeout() != 180000) {
            httpPost.setConfig(RequestConfig.custom().setConnectionRequestTimeout(nosqlConfig.getRequestTimeout()).setConnectTimeout(nosqlConfig.getConnectTimeout()).setSocketTimeout(nosqlConfig.getSocketTimeout()).build());
        } else {
            httpPost.setConfig(requestConfig);
        }
        CloseableHttpClient client = null;
        if (StringUtil.isNotBlank(esConfig.getUsername()) && StringUtil.isNotBlank(esConfig.getPassword())) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esConfig.getUsername(), esConfig.getPassword()));
            client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        } else {
            client = HttpClients.createDefault();
        }
        response = client.execute((HttpUriRequest)httpPost);
        reponseEntity = response.getEntity();
        String result = null;
        if (reponseEntity != null) {
            result = EntityUtils.toString((HttpEntity)reponseEntity, (String)nosqlConfig.getCharset());
            if (sqltoyContext.isDebug()) {
                logger.debug("result={}", (Object)result);
            }
        }
        if (StringUtil.isBlank(result)) {
            return null;
        }
        JSONObject json = JSON.parseObject((String)result);
        if (json.containsKey((Object)"error")) {
            String errorMessage = JSON.toJSONString((Object)json.getJSONObject("error").getJSONArray("root_cause").get(0));
            logger.error("elastic\u67e5\u8be2\u5931\u8d25,endpoint:[{}],\u9519\u8bef\u4fe1\u606f:[{}]", (Object)nosqlConfig.getEndpoint(), (Object)errorMessage);
            throw new DataAccessException("ElasticSearch\u67e5\u8be2\u5931\u8d25,\u9519\u8bef\u4fe1\u606f:" + errorMessage);
        }
        return json;
    }

    private static String wrapUrl(ElasticEndpoint esConfig, NoSqlConfigModel nosqlConfig) {
        String url = esConfig.getUrl();
        String sqlPath = esConfig.getSqlPath();
        if (StringUtil.isBlank(sqlPath)) {
            sqlPath = "_sql";
        }
        if (nosqlConfig.isSqlMode()) {
            if (!url.toLowerCase().contains(sqlPath)) {
                url = url.concat(url.endsWith("/") ? "" : "/").concat(sqlPath);
            }
        } else {
            if (StringUtil.isNotBlank(nosqlConfig.getIndex())) {
                url = url.concat(url.endsWith("/") ? "" : "/").concat(nosqlConfig.getIndex());
            }
            if (StringUtil.isNotBlank(nosqlConfig.getType())) {
                url = url.concat(url.endsWith("/") ? "" : "/").concat(nosqlConfig.getType());
            }
            if (!url.toLowerCase().endsWith(SEARCH)) {
                url = url.concat(url.endsWith("/") ? "" : "/").concat(SEARCH);
            }
        }
        return url;
    }
}

