/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionUtil {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionUtil.class);
    public static final String OPTS = "+-*/%><][!|&=#";

    private ExpressionUtil() {
    }

    public static Object calculate(String expression) {
        try {
            Stack<String> Opts = new Stack<String>();
            Stack<String> Values2 = new Stack<String>();
            String exp = expression + "#";
            int nCount = exp.length();
            Opts.push("#");
            Object temp = "";
            String optIn = "";
            String value1 = "";
            String value2 = "";
            String opt = "";
            Object temp1 = "";
            int nFun = 0;
            boolean isFun = false;
            int i = 0;
            while (i < nCount) {
                int nOut;
                int nTemp = 0;
                opt = exp.substring(i, i + 1);
                isFun = false;
                temp1 = "";
                while (i < nCount) {
                    if (!"".equals(temp1)) {
                        if ("(".equals(opt)) {
                            ++nFun;
                            isFun = true;
                        } else if (")".equals(opt)) {
                            --nFun;
                        }
                    }
                    if (nFun > 0 || !isFun && ExpressionUtil.isValue(opt)) {
                        temp1 = (String)temp1 + opt;
                        opt = exp.substring(i + ++nTemp, i + nTemp + 1);
                        continue;
                    }
                    if (!isFun) break;
                    temp1 = (String)temp1 + opt;
                    ++nTemp;
                    break;
                }
                temp = "".equals(temp1) ? opt : temp1;
                if (nTemp > 0) {
                    i = i + nTemp - 1;
                }
                if (ExpressionUtil.isValue((String)(temp = ((String)temp).trim()))) {
                    temp = ExpressionUtil.getValue((String)temp);
                    Values2.push((String)temp);
                    ++i;
                    continue;
                }
                optIn = Opts.pop().toString();
                int nIn = ExpressionUtil.getOptPriorityIn(optIn);
                if (nIn == (nOut = ExpressionUtil.getOptPriorityOut((String)temp))) {
                    ++i;
                    continue;
                }
                if (nIn > nOut) {
                    String ret = "";
                    value1 = Values2.pop().toString();
                    value2 = Values2.pop().toString();
                    ret = String.valueOf(ExpressionUtil.calValue(value2, optIn, value1));
                    Values2.push(ret);
                    continue;
                }
                if (nIn >= nOut) continue;
                Opts.push(optIn);
                Opts.push((String)temp);
                ++i;
            }
            return Values2.pop();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            return expression;
        }
    }

    protected static int getOptPriorityOut(String opt) throws Exception {
        if ("+".equals(opt)) {
            return 1;
        }
        if ("-".equals(opt)) {
            return 2;
        }
        if ("*".equals(opt)) {
            return 5;
        }
        if ("/".equals(opt)) {
            return 6;
        }
        if ("%".equals(opt)) {
            return 7;
        }
        if (">".equals(opt)) {
            return 11;
        }
        if ("<".equals(opt)) {
            return 12;
        }
        if ("]".equals(opt)) {
            return 13;
        }
        if ("[".equals(opt)) {
            return 14;
        }
        if ("!".equals(opt)) {
            return 15;
        }
        if ("|".equals(opt)) {
            return 16;
        }
        if ("&".equals(opt)) {
            return 23;
        }
        if ("=".equals(opt)) {
            return 25;
        }
        if ("#".equals(opt)) {
            return 0;
        }
        if ("(".equals(opt)) {
            return 1000;
        }
        if (")".equals(opt)) {
            return -1000;
        }
        throw new RuntimeException("\u8fd0\u7b97\u7b26\u53f7" + opt + "\u975e\u6cd5!");
    }

    protected static int getOptPriorityIn(String opt) throws Exception {
        if ("+".equals(opt)) {
            return 3;
        }
        if ("-".equals(opt)) {
            return 4;
        }
        if ("*".equals(opt)) {
            return 8;
        }
        if ("/".equals(opt)) {
            return 9;
        }
        if ("%".equals(opt)) {
            return 10;
        }
        if (">".equals(opt)) {
            return 17;
        }
        if ("<".equals(opt)) {
            return 18;
        }
        if ("]".equals(opt)) {
            return 19;
        }
        if ("[".equals(opt)) {
            return 20;
        }
        if ("!".equals(opt)) {
            return 21;
        }
        if ("|".equals(opt)) {
            return 22;
        }
        if ("&".equals(opt)) {
            return 24;
        }
        if ("=".equals(opt)) {
            return 26;
        }
        if ("(".equals(opt)) {
            return -1000;
        }
        if (")".equals(opt)) {
            return 1000;
        }
        if ("#".equals(opt)) {
            return 0;
        }
        throw new RuntimeException("\u8fd0\u7b97\u7b26\u53f7:" + opt + "\u975e\u6cd5!");
    }

    protected static String getOPTS() {
        return OPTS;
    }

    protected static boolean isValue(String cValue) {
        String notValue = ExpressionUtil.getOPTS() + "()";
        return notValue.indexOf(cValue) == -1;
    }

    protected static boolean isOpt(String value) {
        return ExpressionUtil.getOPTS().indexOf(value) >= 0;
    }

    protected static double calValue(String value1, String opt, String value2) throws Exception {
        try {
            double dbValue1 = Double.valueOf(value1);
            double dbValue2 = Double.valueOf(value2);
            long lg = 0L;
            if ("+".equals(opt)) {
                return dbValue1 + dbValue2;
            }
            if ("-".equals(opt)) {
                return dbValue1 - dbValue2;
            }
            if ("*".equals(opt)) {
                return dbValue1 * dbValue2;
            }
            if ("/".equals(opt)) {
                return dbValue1 / dbValue2;
            }
            if ("%".equals(opt)) {
                lg = (long)(dbValue1 / dbValue2);
                return dbValue1 - (double)lg * dbValue2;
            }
            if (">".equals(opt)) {
                if (dbValue1 > dbValue2) {
                    return 1.0;
                }
                return 0.0;
            }
            if ("<".equals(opt)) {
                if (dbValue1 < dbValue2) {
                    return 1.0;
                }
                return 0.0;
            }
            if ("]".equals(opt)) {
                if (dbValue1 >= dbValue2) {
                    return 1.0;
                }
                return 0.0;
            }
            if ("[".equals(opt)) {
                if (dbValue1 <= dbValue2) {
                    return 1.0;
                }
                return 0.0;
            }
            if ("!".equals(opt)) {
                if (dbValue1 != dbValue2) {
                    return 1.0;
                }
                return 0.0;
            }
            if ("|".equals(opt)) {
                if (dbValue1 > 0.0 || dbValue2 > 0.0) {
                    return 1.0;
                }
                return 0.0;
            }
            if ("&".equals(opt)) {
                if (dbValue1 > 0.0 && dbValue2 > 0.0) {
                    return 1.0;
                }
                return 0.0;
            }
            if ("=".equals(opt)) {
                if (dbValue1 == dbValue2) {
                    return 1.0;
                }
                return 0.0;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u53c2\u6570:" + value1 + "\u548c:" + value2 + "\u5728\u8fdb\u884c:" + opt + "\u8fd0\u7b97\u65f6\u975e\u6cd5!");
        }
        throw new RuntimeException("\u8fd0\u7b97\u7b26\u53f7:" + opt + "\u975e\u6cd5!");
    }

    protected static String getValue(String oldValue) throws Exception {
        String reg = "^([a-zA-Z0-9_]+)\\(([a-zA-Z0-9_.()]+)\\)$";
        if (ExpressionUtil.isFunctionCal(oldValue)) {
            Pattern p = Pattern.compile(reg);
            Matcher m = p.matcher(oldValue);
            m.find();
            return ExpressionUtil.calFunction(m.group(1), m.group(2));
        }
        return oldValue;
    }

    protected static boolean isFunctionCal(String value) {
        String reg = "^([a-zA-Z0-9_]+)\\(([a-zA-Z0-9_.()]+)\\)$";
        return value.matches(reg);
    }

    protected static String calFunction(String function, String value) throws Exception {
        String lowerFun = function.toLowerCase();
        double db = 0.0;
        try {
            db = Double.valueOf(ExpressionUtil.getValue(value));
            if ("log".equals(lowerFun)) {
                return String.valueOf(Math.log(db));
            }
            if ("square".equals(lowerFun)) {
                return String.valueOf(Math.pow(db, 2.0));
            }
            if ("sqrt".equals(lowerFun)) {
                return String.valueOf(Math.sqrt(db));
            }
            if ("sin".equals(lowerFun)) {
                return String.valueOf(Math.sin(db));
            }
            if ("asin".equals(lowerFun)) {
                return String.valueOf(Math.asin(db));
            }
            if ("cos".equals(lowerFun)) {
                return String.valueOf(Math.cos(db));
            }
            if ("tan".equals(lowerFun)) {
                return String.valueOf(Math.tan(db));
            }
            if ("atan".equals(lowerFun)) {
                return String.valueOf(Math.atan(db));
            }
            if ("ceil".equals(lowerFun)) {
                return String.valueOf(Math.ceil(db));
            }
            if ("exp".equals(lowerFun)) {
                return String.valueOf(Math.exp(db));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u51fd\u6570" + function + "\u53c2\u6570:" + value + "\u975e\u6cd5!");
        }
        throw new RuntimeException("\u51fd\u6570" + function + "\u4e0d\u652f\u6301\uff01");
    }
}

