/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.translate;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.XMLCallbackHandler;
import org.sagacity.sqltoy.config.ScanEntityAndSqlResource;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.Translate;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.translate.model.CheckerConfigModel;
import org.sagacity.sqltoy.translate.model.DefaultConfig;
import org.sagacity.sqltoy.translate.model.TranslateConfigModel;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.FileUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.sagacity.sqltoy.utils.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TranslateConfigParse {
    protected static final Logger logger = LoggerFactory.getLogger(TranslateConfigParse.class);
    private static final String CLASSPATH = "classpath:";
    private static final String JAR = "jar";
    private static final String TRANSLATE_SUFFIX = "-translate";
    private static final String CHECKER_SUFFIX = "-checker";
    private static final String[] TRANSLATE_TYPES = new String[]{"sql", "service", "rest", "local"};
    private static final String[] TRANSLATE_CHECKER_TYPES = new String[]{"sql-increment", "sql", "service-increment", "service", "rest", "rest-increment"};
    private static final HashMap<String, HashMap<String, Translate>> classTranslateConfigMap = new HashMap();
    private static final HashSet<String> cacheCheckers = new HashSet();

    public static DefaultConfig parseTranslateConfig(SqlToyContext sqlToyContext, IgnoreKeyCaseMap<String, TranslateConfigModel> translateMap, CopyOnWriteArrayList<CheckerConfigModel> checker, String translateConfig, boolean isDefault, String charset) throws Exception {
        List translateFiles = TranslateConfigParse.getTranslateFiles(translateConfig);
        DefaultConfig result = new DefaultConfig();
        DefaultConfig defaultConfig = null;
        HashSet<String> fileSet = new HashSet<String>();
        int index = 0;
        for (int i = 0; i < translateFiles.size(); ++i) {
            Object translateFile = translateFiles.get(i);
            String translateFlieStr = translateFile instanceof File ? ((File)translateFile).getPath() : translateFile.toString();
            if (fileSet.contains(translateFlieStr)) continue;
            boolean fileExist = true;
            if (FileUtil.getFileInputStream(translateFile) == null) {
                fileExist = false;
            }
            if (!isDefault && !fileExist) {
                logger.warn("\u7f13\u5b58\u7ffb\u8bd1\u914d\u7f6e\u6587\u4ef6:{}\u65e0\u6cd5\u52a0\u8f7d,\u8bf7\u68c0\u67e5\u914d\u8def\u5f84\u6b63\u786e\u6027,\u5982\u4e0d\u4f7f\u7528\u7f13\u5b58\u7ffb\u8bd1\u53ef\u5ffd\u7565\u6b64\u63d0\u793a!", (Object)translateFlieStr);
                translateMap.clear();
                return result;
            }
            if (fileExist) {
                logger.debug("\u5f00\u59cb\u89e3\u6790\u7f13\u5b58\u914d\u7f6e\u6587\u4ef6:{}", (Object)translateFlieStr);
                defaultConfig = TranslateConfigParse.parseTranslate(sqlToyContext, translateMap, checker, index + 1, translateFile, charset);
                if (index == 0) {
                    result = defaultConfig;
                } else {
                    if (result.getDeviationSeconds() == -1 && defaultConfig.getDeviationSeconds() != -1) {
                        result.setDeviationSeconds(defaultConfig.getDeviationSeconds());
                    }
                    if (StringUtil.isBlank(result.getDiskStorePath()) && StringUtil.isNotBlank(defaultConfig.getDiskStorePath())) {
                        result.setDiskStorePath(defaultConfig.getDiskStorePath());
                    }
                }
                ++index;
            }
            fileSet.add(translateFlieStr);
        }
        return result;
    }

    private static DefaultConfig parseTranslate(final SqlToyContext sqlToyContext, final IgnoreKeyCaseMap<String, TranslateConfigModel> translateMap, final CopyOnWriteArrayList<CheckerConfigModel> checker, final int fileIndex, final Object translateConfig, String charset) throws Exception {
        return (DefaultConfig)XMLUtil.readXML(translateConfig, charset, false, new XMLCallbackHandler(){

            @Override
            public Object process(Document doc, Element root) throws Exception {
                boolean isShowSql;
                String sqlId;
                String sql;
                NodeList sqlNode;
                Element elt;
                NodeList elts;
                String translateFileStr = translateConfig instanceof File ? ((File)translateConfig).getName() : translateConfig.toString();
                DefaultConfig defaultConfig = new DefaultConfig();
                defaultConfig.setUseCache(true);
                NodeList nodeList = root.getElementsByTagName("cache-translates");
                if (nodeList.getLength() == 0) {
                    return defaultConfig;
                }
                Element node = (Element)nodeList.item(0);
                XMLUtil.setAttributes(node, defaultConfig, new String[0]);
                int index = 1;
                for (String translateType : TRANSLATE_TYPES) {
                    elts = node.getElementsByTagName(translateType.concat(TranslateConfigParse.TRANSLATE_SUFFIX));
                    if (elts.getLength() <= 0) continue;
                    for (int i = 0; i < elts.getLength(); ++i) {
                        elt = (Element)elts.item(i);
                        TranslateConfigModel translateCacheModel = new TranslateConfigModel();
                        translateCacheModel.setHeap(defaultConfig.getDefaultHeap());
                        translateCacheModel.setOffHeap(defaultConfig.getDefaultOffHeap());
                        translateCacheModel.setDiskSize(defaultConfig.getDefaultDiskSize());
                        translateCacheModel.setKeepAlive(defaultConfig.getDefaultKeepAlive());
                        XMLUtil.setAttributes(elt, translateCacheModel, new String[0]);
                        translateCacheModel.setType(translateType);
                        if ("sql".equals(translateType) && StringUtil.isBlank(translateCacheModel.getSql())) {
                            sqlNode = elt.getElementsByTagName("sql");
                            sql = sqlNode.getLength() > 0 ? StringUtil.trim(sqlNode.item(0).getTextContent()) : StringUtil.trim(elt.getTextContent());
                            sqlId = "s_trans_cache_" + fileIndex + "_0" + index;
                            isShowSql = StringUtil.matches(sql, SqlToyConstants.NOT_PRINT_REGEX);
                            SqlToyConfig sqlToyConfig = new SqlToyConfig(sqlId, SqlUtil.clearMistyChars(SqlUtil.clearMark(sql), " "));
                            sqlToyConfig.setShowSql(!isShowSql);
                            sqlToyConfig.setParamsName(SqlConfigParseUtils.getSqlParamsName(sqlToyConfig.getSql(null), true));
                            sqlToyContext.putSqlToyConfig(sqlToyConfig);
                            translateCacheModel.setSql(sqlId);
                            ++index;
                        }
                        if (elt.hasAttribute("i18n")) {
                            String[] i18nAry;
                            for (String i18n : i18nAry = elt.getAttribute("i18n").replace(";", ",").split("\\,")) {
                                String[] localIndex = i18n.split("\\:");
                                translateCacheModel.putI18n(localIndex[0].trim(), Integer.parseInt(localIndex[1].trim()));
                            }
                        }
                        if ("local".equals(translateType) && !elt.hasAttribute("keep-alive")) {
                            translateCacheModel.setKeepAlive(-1);
                        }
                        if (translateMap.containsKey(translateCacheModel.getCache())) {
                            throw new RuntimeException("\u7f13\u5b58\u7ffb\u8bd1\u914d\u7f6e\u4e2d\u7f13\u5b58:[" + translateCacheModel.getCache() + "] \u7684\u5b9a\u4e49\u5df2\u7ecf\u5b58\u5728!\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6:" + translateFileStr);
                        }
                        translateMap.put(translateCacheModel.getCache(), translateCacheModel);
                        logger.debug("\u5df2\u7ecf\u52a0\u8f7d\u7f13\u5b58\u7ffb\u8bd1:cache={},type={}", (Object)(translateCacheModel.getCache() == null ? "[\u975e\u589e\u91cf]" : translateCacheModel.getCache()), (Object)translateType);
                    }
                }
                nodeList = root.getElementsByTagName("cache-update-checkers");
                if (nodeList.getLength() == 0) {
                    return defaultConfig;
                }
                node = (Element)nodeList.item(0);
                if (node.hasAttribute("cluster-time-deviation")) {
                    defaultConfig.setDeviationSeconds(Integer.parseInt(node.getAttribute("cluster-time-deviation")));
                    if (Math.abs(defaultConfig.getDeviationSeconds()) > 60) {
                        logger.debug("\u60a8\u8bbe\u7f6e\u7684\u96c6\u7fa4\u8282\u70b9\u65f6\u95f4\u5dee\u5f02\u53c2\u6570cluster-time-deviation={} \u79d2>60\u79d2,\u5c06\u8bbe\u7f6e\u4e3a60\u79d2!", (Object)defaultConfig.getDeviationSeconds());
                        defaultConfig.setDeviationSeconds(-60);
                    } else {
                        defaultConfig.setDeviationSeconds(0 - Math.abs(defaultConfig.getDeviationSeconds()));
                    }
                }
                index = 1;
                for (String translateType : TRANSLATE_CHECKER_TYPES) {
                    String nodeType = translateType.concat(TranslateConfigParse.CHECKER_SUFFIX);
                    elts = node.getElementsByTagName(nodeType);
                    if (elts.getLength() <= 0) continue;
                    for (int i = 0; i < elts.getLength(); ++i) {
                        elt = (Element)elts.item(i);
                        CheckerConfigModel checherConfigModel = new CheckerConfigModel();
                        XMLUtil.setAttributes(elt, checherConfigModel, new String[0]);
                        checherConfigModel.setType(translateType.replace("-increment", ""));
                        if (translateType.endsWith("-increment")) {
                            checherConfigModel.setIncrement(true);
                            if (StringUtil.isBlank(checherConfigModel.getCache())) {
                                logger.error("translate update checker:{}  must config with cache=\"xxx\"!", (Object)nodeType);
                                throw new IllegalArgumentException(nodeType + " must config with cache=\"xxx\"");
                            }
                        } else {
                            checherConfigModel.setIncrement(false);
                        }
                        if ("sql".equals(checherConfigModel.getType()) && StringUtil.isBlank(checherConfigModel.getSql())) {
                            sqlId = (checherConfigModel.isIncrement() ? "s_trans_merge_chk_" : "s_trans_chk_") + fileIndex + "_0" + index;
                            sqlNode = elt.getElementsByTagName("sql");
                            sql = sqlNode.getLength() > 0 ? StringUtil.trim(sqlNode.item(0).getTextContent()) : StringUtil.trim(elt.getTextContent());
                            isShowSql = StringUtil.matches(sql, SqlToyConstants.NOT_PRINT_REGEX);
                            SqlToyConfig sqlToyConfig = new SqlToyConfig(sqlId, SqlUtil.clearMistyChars(SqlUtil.clearMark(sql), " "));
                            sqlToyConfig.setShowSql(!isShowSql);
                            sqlToyConfig.setParamsName(SqlConfigParseUtils.getSqlParamsName(sqlToyConfig.getSql(null), true));
                            if (sqlToyConfig.getParamsName() != null && sqlToyConfig.getParamsName().length > 1) {
                                throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u7f13\u5b58\u66f4\u65b0\u68c0\u6d4bsql\u8bed\u53e5\u4e2d\u7684\u53c2\u6570\u540d\u79f0,\u6240\u6709\u53c2\u6570\u540d\u79f0\u8981\u4fdd\u6301\u4e00\u81f4\u4e3alastUpdateTime!\u5f53\u524d\u6709:" + sqlToyConfig.getParamsName().length + " \u4e2a\u4e0d\u540c\u6761\u4ef6\u53c2\u6570\u540d!\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6:" + translateFileStr);
                            }
                            sqlToyContext.putSqlToyConfig(sqlToyConfig);
                            checherConfigModel.setSql(sqlId);
                            ++index;
                        }
                        checker.add(checherConfigModel);
                        if (StringUtil.isNotBlank(checherConfigModel.getCache())) {
                            if (cacheCheckers.contains(checherConfigModel.getCache())) {
                                throw new RuntimeException("\u7f13\u5b58\u7ffb\u8bd1\u914d\u7f6e\u9488\u5bf9\u7f13\u5b58:[" + checherConfigModel.getCache() + "]\u7684\u66f4\u65b0\u68c0\u6d4b\u5668\u5df2\u7ecf\u5b58\u5728!\u8bf7\u68c0\u67e5\u6587\u4ef6:" + translateFileStr);
                            }
                            cacheCheckers.add(checherConfigModel.getCache());
                        }
                        logger.debug("\u5df2\u7ecf\u52a0\u8f7d\u9488\u5bf9\u7f13\u5b58:{} \u66f4\u65b0\u7684\u68c0\u6d4b\u5668,type={}", (Object)checherConfigModel.getCache(), (Object)translateType);
                    }
                }
                return defaultConfig;
            }
        });
    }

    public static HashMap<String, Translate> getClassTranslates(Class classType) {
        if (classType == null || classType.equals(Map.class) || classType.equals(HashMap.class) || classType.equals(List.class) || classType.equals(ArrayList.class) || classType.equals(Array.class) || BeanUtil.isBaseDataType(classType)) {
            return null;
        }
        String className = classType.getName();
        if (classTranslateConfigMap.containsKey(className)) {
            return classTranslateConfigMap.get(className);
        }
        HashMap<String, Translate> translateConfig = new HashMap<String, Translate>();
        for (Class classVar = classType; classVar != null && !classVar.equals(Object.class); classVar = classVar.getSuperclass()) {
            for (Field field : classVar.getDeclaredFields()) {
                org.sagacity.sqltoy.config.annotation.Translate translate = field.getAnnotation(org.sagacity.sqltoy.config.annotation.Translate.class);
                if (translate == null || translateConfig.containsKey(field.getName())) continue;
                Translate trans = new Translate(translate.cacheName());
                trans.setIndex(translate.cacheIndex());
                if (StringUtil.isNotBlank(translate.cacheType())) {
                    trans.setCacheType(translate.cacheType());
                }
                trans.setKeyColumn(translate.keyField());
                trans.setColumn(field.getName());
                trans.setAlias(field.getName());
                if (StringUtil.isNotBlank(translate.split())) {
                    trans.setSplitRegex(translate.split());
                }
                if (StringUtil.isNotBlank(translate.join())) {
                    trans.setLinkSign(translate.join());
                }
                if (translate.uncached() != null && !"".equals(translate.uncached())) {
                    trans.setUncached(translate.uncached().trim());
                }
                translateConfig.put(field.getName(), trans);
            }
        }
        classTranslateConfigMap.put(className, translateConfig);
        return translateConfig;
    }

    public static List getTranslateFiles(String translateConfig) throws Exception {
        String[] translateCfgs;
        ArrayList<Object> result = new ArrayList<Object>();
        if (StringUtil.isBlank(translateConfig)) {
            return result;
        }
        for (String translate : translateCfgs = translateConfig.replaceAll("\\,", ";").replaceAll("\\\uff0c", ";").replaceAll("\\\uff1b", ";").split("\\;")) {
            Enumeration<URL> urls;
            String realRes = translate.trim();
            boolean startClasspath = false;
            if (realRes.toLowerCase().startsWith(CLASSPATH)) {
                realRes = realRes.substring(10).trim();
                startClasspath = true;
            }
            if ((urls = ScanEntityAndSqlResource.getResourceUrls(realRes, startClasspath)) == null) continue;
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url.getProtocol().equals(JAR)) {
                    if (realRes.length() > 0 && realRes.charAt(0) == '/') {
                        realRes = realRes.substring(1);
                    }
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String transConfigFile = entry.getName();
                        if (!transConfigFile.startsWith(realRes) || !TranslateConfigParse.isTranslateConfig(transConfigFile) || entry.isDirectory()) continue;
                        result.add(transConfigFile);
                    }
                    continue;
                }
                File transFile = new File(url.toURI());
                String fileName = transFile.getName();
                if (transFile.isDirectory()) {
                    File[] files = transFile.listFiles();
                    for (int loop = 0; loop < files.length; ++loop) {
                        File file = files[loop];
                        fileName = file.getName();
                        if (file.isDirectory() || !TranslateConfigParse.isTranslateConfig(fileName)) continue;
                        result.add(file);
                    }
                    continue;
                }
                if (!TranslateConfigParse.isTranslateConfig(fileName)) continue;
                result.add(transFile);
            }
        }
        return result;
    }

    private static boolean isTranslateConfig(String fileName) {
        String lowFile = fileName.toLowerCase();
        return lowFile.endsWith("-translate.xml") || lowFile.endsWith("-translates.xml") || lowFile.endsWith(".trans.xml") || lowFile.endsWith(".translate.xml") || lowFile.endsWith(".translates.xml");
    }
}

