/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.interceptors;

import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.plugins.SqlInterceptor;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class TenantFilterInterceptor
implements SqlInterceptor {
    @Override
    public SqlToyResult decorate(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, OperateType operateType, SqlToyResult sqlToyResult, Class entityClass, Integer dbType) {
        if (sqlToyContext.getUnifyFieldsHandler() == null || entityClass == null) {
            return sqlToyResult;
        }
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entityClass);
        if (entityMeta.getTenantField() == null) {
            return sqlToyResult;
        }
        String[] tenants = sqlToyContext.getUnifyFieldsHandler().authTenants(entityClass, operateType);
        if (tenants == null || tenants.length == 0) {
            return sqlToyResult;
        }
        String sql = sqlToyResult.getSql();
        String tenantColumn = entityMeta.getColumnName(entityMeta.getTenantField());
        tenantColumn = ReservedWordsUtil.convertWord(tenantColumn, dbType);
        if (StringUtil.matches(sql.substring(StringUtil.matchIndex(sql, "(?i)\\Wwhere\\W")), "(?i)\\W" + tenantColumn + "(\\s*\\=|\\s+in)")) {
            return sqlToyResult;
        }
        String sqlPart = " where ";
        sqlPart = tenants.length == 1 ? sqlPart.concat(tenantColumn).concat("='").concat(tenants[0]).concat("' and ") : sqlPart.concat(tenantColumn).concat("in (").concat(SqlUtil.combineQueryInStr(tenants, null, null, true).concat(") and "));
        if (operateType.equals((Object)OperateType.load) || operateType.equals((Object)OperateType.loadAll) || operateType.equals((Object)OperateType.update) || operateType.equals((Object)OperateType.updateAll) || operateType.equals((Object)OperateType.delete) || operateType.equals((Object)OperateType.deleteAll) || operateType.equals((Object)OperateType.unique) || operateType.equals((Object)OperateType.saveOrUpdate) || operateType.equals((Object)OperateType.singleTable)) {
            sqlToyResult.setSql(sql.replaceFirst("(?i)\\swhere\\s", sqlPart));
        }
        return sqlToyResult;
    }
}

