/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.calculator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.sagacity.sqltoy.config.model.ColsChainRelativeModel;
import org.sagacity.sqltoy.config.model.LabelIndexModel;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.ExpressionUtil;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class ColsChainRelative {
    public static void process(ColsChainRelativeModel relativeModel, LabelIndexModel labelIndexMap, List result) {
        Object[] relativeIndexs;
        if (result == null || result.isEmpty()) {
            return;
        }
        int dataSize = result.size();
        int dataWidth = ((List)result.get(0)).size();
        boolean isAppend = relativeModel.isInsert();
        int groupSize = relativeModel.getGroupSize();
        if (groupSize < 1) {
            groupSize = 1;
        }
        if ((relativeIndexs = relativeModel.getRelativeIndexs()) == null || relativeIndexs.length == 0) {
            relativeIndexs = new Integer[groupSize];
            for (int i = 0; i < groupSize; ++i) {
                relativeIndexs[i] = i;
            }
        }
        CollectionUtil.sortArray(relativeIndexs, true);
        int relativeSize = relativeIndexs.length;
        int radixSize = relativeModel.getRadixSize();
        boolean isIncrement = relativeModel.isReduceOne();
        double multiply = relativeModel.getMultiply();
        String format = relativeModel.getFormat();
        int start = 0;
        if (StringUtil.isBlank(relativeModel.getStartColumn())) {
            start = 0;
        } else if (NumberUtil.isInteger(relativeModel.getStartColumn())) {
            start = Integer.parseInt(relativeModel.getStartColumn());
        } else if (labelIndexMap.containsKey(relativeModel.getStartColumn())) {
            start = labelIndexMap.get(relativeModel.getStartColumn());
        }
        String endCol = relativeModel.getEndColumn();
        int end = StringUtil.isBlank(endCol) ? dataWidth - 1 : (NumberUtil.isInteger(endCol) ? Integer.parseInt(endCol) : (labelIndexMap.containsKey(endCol) ? labelIndexMap.get(endCol) : (NumberUtil.isInteger(endCol = endCol.replaceAll("result\\.width\\(\\)", Integer.toString(dataWidth)).replaceAll("(?i)\\$\\{dataWidth\\}", Integer.toString(dataWidth))) ? Integer.parseInt(endCol) : new BigDecimal(ExpressionUtil.calculate(endCol).toString()).intValue())));
        if (end < 0) {
            end = dataWidth - 1 + end;
        }
        if (end > dataWidth - 1) {
            end = dataWidth - 1;
        }
        String defaultValue = relativeModel.getDefaultValue();
        for (int i = end; i > start; i -= groupSize) {
            for (int j = 0; j < dataSize; ++j) {
                List rowList = (List)result.get(j);
                for (int k = 0; k < relativeSize; ++k) {
                    int divIndex = i - groupSize + (Integer)relativeIndexs[k] + 1;
                    int divedIndex = i - 2 * groupSize + (Integer)relativeIndexs[k] + 1;
                    if (i - groupSize <= start) {
                        if (isAppend) {
                            rowList.add(divIndex + 1, defaultValue);
                            continue;
                        }
                        rowList.set(divIndex + 1, defaultValue);
                        continue;
                    }
                    double divData = 0.0;
                    double divedData = 0.0;
                    if (rowList.get(divIndex) != null) {
                        divData = Double.valueOf(rowList.get(divIndex).toString());
                    }
                    if (rowList.get(divedIndex) != null) {
                        divedData = Double.valueOf(rowList.get(divedIndex).toString());
                    }
                    if (divedData == 0.0) {
                        if (isAppend) {
                            rowList.add(divIndex + 1, divData == 0.0 ? Integer.valueOf(0) : defaultValue);
                            continue;
                        }
                        rowList.set(divIndex + 1, divData == 0.0 ? Integer.valueOf(0) : defaultValue);
                        continue;
                    }
                    BigDecimal value = new BigDecimal((divData - (isIncrement ? divedData : 0.0)) * multiply / divedData).setScale(radixSize, RoundingMode.FLOOR);
                    if (isAppend) {
                        rowList.add(divIndex + 1, format == null ? value : NumberUtil.format(value, format));
                        continue;
                    }
                    rowList.set(divIndex + 1, format == null ? value : NumberUtil.format(value, format));
                }
            }
        }
    }
}

