/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.model;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.RoundingMode;
import java.util.Map;
import javax.sql.DataSource;
import org.sagacity.sqltoy.callback.RowCallbackHandler;
import org.sagacity.sqltoy.config.model.FormatModel;
import org.sagacity.sqltoy.config.model.PageOptimize;
import org.sagacity.sqltoy.config.model.PivotModel;
import org.sagacity.sqltoy.config.model.SecureMask;
import org.sagacity.sqltoy.config.model.ShardingStrategyConfig;
import org.sagacity.sqltoy.config.model.Translate;
import org.sagacity.sqltoy.config.model.UnpivotModel;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.MaskType;
import org.sagacity.sqltoy.model.ParamsFilter;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.model.inner.TranslateExtend;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutor
implements Serializable {
    protected final Logger logger = LoggerFactory.getLogger(QueryExecutor.class);
    private static final long serialVersionUID = -6149173009738072148L;
    private QueryExecutorExtend innerModel = new QueryExecutorExtend();

    public QueryExecutor(String sql) {
        this.innerModel.sql = sql;
    }

    public QueryExecutor(String sql, Serializable entity) {
        this.innerModel.sql = sql;
        this.innerModel.entity = entity;
        if (entity != null) {
            this.innerModel.resultType = BeanUtil.getEntityClass(entity.getClass());
            if (this.innerModel.resultType.equals("".getClass().getClass())) {
                throw new IllegalArgumentException("\u67e5\u8be2\u53c2\u6570\u662f\u8981\u6c42\u4f20\u9012\u5bf9\u8c61\u7684\u5b9e\u4f8b,\u4e0d\u662f\u4f20\u9012\u5bf9\u8c61\u7684class\u7c7b\u522b!\u4f60\u7684\u53c2\u6570=" + ((Class)entity).getName());
            }
        } else {
            this.logger.warn("\u8bf7\u5173\u6ce8:\u67e5\u8be2\u8bed\u53e5sql={} \u6307\u5b9a\u7684\u67e5\u8be2\u6761\u4ef6\u53c2\u6570entity=null,\u5c06\u4ee5ArrayList\u4f5c\u4e3a\u9ed8\u8ba4\u7c7b\u578b\u8fd4\u56de!", (Object)sql);
        }
    }

    public QueryExecutor filters(ParamsFilter ... filters) {
        if (filters != null && filters.length > 0) {
            for (ParamsFilter filter : filters) {
                if (StringUtil.isBlank(filter.getType()) || StringUtil.isBlank(filter.getParams())) {
                    throw new IllegalArgumentException("\u9488\u5bf9QueryExecutor\u8bbe\u7f6e\u6761\u4ef6\u8fc7\u6ee4\u5fc5\u987b\u8981\u8bbe\u7f6efilterParams=[" + filter.getParams() + "],\u548cfilterType=[" + filter.getType() + "]!");
                }
                if (CollectionUtil.any((Object)filter.getType(), "eq", "neq", "gt", "gte", "lt", "lte", "between") && StringUtil.isBlank(filter.getValue())) {
                    throw new IllegalArgumentException("\u9488\u5bf9QueryExecutor\u8bbe\u7f6e\u6761\u4ef6\u8fc7\u6ee4eq\u3001neq\u3001gt\u3001gte\u3001lt\u3001lte\u3001between\u7b49\u7c7b\u578b\u5fc5\u987b\u8981\u8bbe\u7f6evalues\u503c!");
                }
                if ("blank".equals(filter.getType())) {
                    this.innerModel.blankToNull = false;
                }
                this.innerModel.paramFilters.add(filter);
            }
        }
        return this;
    }

    public QueryExecutor(String sql, Map<String, Object> paramsMap) {
        this.innerModel.sql = sql;
        this.innerModel.entity = new IgnoreKeyCaseMap<String, Object>(paramsMap);
    }

    public QueryExecutor(String sql, String[] paramsName, Object[] paramsValue) {
        this.innerModel.sql = sql;
        this.innerModel.paramsName = paramsName;
        this.innerModel.paramsValue = paramsValue;
    }

    public QueryExecutor dataSource(DataSource dataSource) {
        this.innerModel.dataSource = dataSource;
        return this;
    }

    public QueryExecutor names(String ... paramsName) {
        this.innerModel.paramsName = paramsName;
        return this;
    }

    public QueryExecutor values(Object ... paramsValue) {
        this.innerModel.paramsValue = paramsValue;
        return this;
    }

    public QueryExecutor lock(LockMode lockMode) {
        this.innerModel.lockMode = lockMode;
        return this;
    }

    public QueryExecutor hiberarchy(Boolean hiberarchy) {
        this.innerModel.hiberarchy = hiberarchy;
        return this;
    }

    public QueryExecutor hiberarchyFieldsMap(Class resultType, Map fieldsMap) {
        if (resultType != null && fieldsMap != null) {
            this.innerModel.hiberarchy = true;
            if (this.innerModel.hiberarchyClasses == null) {
                this.innerModel.hiberarchyClasses = new Class[]{resultType};
            } else {
                boolean hasExist = false;
                for (Class cls : this.innerModel.hiberarchyClasses) {
                    if (!cls.equals(resultType)) continue;
                    hasExist = true;
                    break;
                }
                if (!hasExist) {
                    int len = this.innerModel.hiberarchyClasses.length;
                    Class[] hiberarchyClasses = new Class[len + 1];
                    System.arraycopy(this.innerModel.hiberarchyClasses, 0, hiberarchyClasses, 0, len);
                    hiberarchyClasses[len] = resultType;
                    this.innerModel.hiberarchyClasses = hiberarchyClasses;
                }
            }
            this.innerModel.fieldsMap.put(resultType, new IgnoreKeyCaseMap(fieldsMap));
        }
        return this;
    }

    public QueryExecutor hiberarchyClasses(Class ... hiberarchyClasses) {
        if (hiberarchyClasses != null && hiberarchyClasses.length > 0) {
            this.innerModel.hiberarchyClasses = hiberarchyClasses;
        }
        return this;
    }

    public QueryExecutor resultType(Type resultType) {
        this.innerModel.resultType = resultType;
        return this;
    }

    public QueryExecutor dbSharding(String strategy, String ... paramNames) {
        ShardingStrategyConfig sharding = new ShardingStrategyConfig(0);
        sharding.setStrategy(strategy);
        sharding.setFields(paramNames);
        sharding.setAliasNames(paramNames);
        this.innerModel.dbSharding = sharding;
        return this;
    }

    public QueryExecutor tableSharding(String strategy, String[] tables, String ... paramNames) {
        ShardingStrategyConfig sharding = new ShardingStrategyConfig(1);
        sharding.setTables(tables);
        sharding.setStrategy(strategy);
        sharding.setFields(paramNames);
        sharding.setAliasNames(paramNames);
        this.innerModel.tableShardings.add(sharding);
        return this;
    }

    public QueryExecutor fetchSize(int fetchSize) {
        this.innerModel.fetchSize = fetchSize;
        return this;
    }

    @Deprecated
    public QueryExecutor maxRows(int maxRows) {
        this.innerModel.maxRows = maxRows;
        return this;
    }

    public QueryExecutor humpMapLabel(Boolean humpMapLabel) {
        this.innerModel.humpMapLabel = humpMapLabel;
        return this;
    }

    public QueryExecutor blankNotNull() {
        this.innerModel.blankToNull = false;
        return this;
    }

    public QueryExecutor translates(Translate ... translates) {
        if (translates != null && translates.length > 0) {
            for (Translate trans : translates) {
                TranslateExtend extend = trans.getExtend();
                if (StringUtil.isBlank(extend.cache) || StringUtil.isBlank(extend.column)) {
                    throw new IllegalArgumentException("\u7ed9\u67e5\u8be2\u589e\u52a0\u7684\u7f13\u5b58\u7ffb\u8bd1\u65f6\u672a\u5b9a\u4e49\u5177\u4f53\u7684cacheName=[" + extend.cache + "] \u6216 \u5bf9\u5e94\u7684column=[" + extend.column + "]!");
                }
                this.innerModel.translates.put(extend.column, trans);
            }
        }
        return this;
    }

    @Deprecated
    public QueryExecutor rowCallbackHandler(RowCallbackHandler rowCallbackHandler) {
        this.innerModel.rowCallbackHandler = rowCallbackHandler;
        return this;
    }

    public QueryExecutor dateFmt(String format, String ... columns) {
        if (StringUtil.isNotBlank(format) && columns != null && columns.length > 0) {
            for (String column : columns) {
                FormatModel fmt = new FormatModel();
                fmt.setType(1);
                fmt.setColumn(column);
                fmt.setFormat(format);
                this.innerModel.colsFormat.put(column, fmt);
            }
        }
        return this;
    }

    public QueryExecutor numFmt(String format, RoundingMode roundingMode, String ... columns) {
        if (StringUtil.isNotBlank(format) && columns != null && columns.length > 0) {
            for (String column : columns) {
                FormatModel fmt = new FormatModel();
                fmt.setType(2);
                fmt.setColumn(column);
                fmt.setFormat(format);
                fmt.setRoundingMode(roundingMode);
                this.innerModel.colsFormat.put(column, fmt);
            }
        }
        return this;
    }

    public QueryExecutor secureMask(MaskType maskType, String ... columns) {
        if (maskType != null && columns != null && columns.length > 0) {
            for (String column : columns) {
                SecureMask mask = new SecureMask();
                mask.setColumn(column);
                mask.setType(maskType.getValue());
                this.innerModel.secureMask.put(column, mask);
            }
        }
        return this;
    }

    public QueryExecutor pageOptimize(PageOptimize pageOptimize) {
        if (pageOptimize != null) {
            this.innerModel.pageOptimize = pageOptimize;
        }
        return this;
    }

    @Deprecated
    public QueryExecutor paramsMap(Map<String, Object> paramsMap) {
        this.innerModel.entity = new IgnoreKeyCaseMap<String, Object>(paramsMap);
        return this;
    }

    public QueryExecutor unpivot(UnpivotModel unpivotModel) {
        if (unpivotModel != null) {
            this.innerModel.calculators.add(unpivotModel);
        }
        return this;
    }

    public QueryExecutor pivot(PivotModel pivotModel) {
        if (pivotModel != null) {
            this.innerModel.calculators.add(pivotModel);
        }
        return this;
    }

    public QueryExecutor countSql(String countSql) {
        if (countSql != null) {
            this.innerModel.countSql = countSql;
        }
        return this;
    }

    public QueryExecutor showSql(Boolean showSql) {
        this.innerModel.showSql = showSql;
        return this;
    }

    public QueryExecutorExtend getInnerModel() {
        return this.innerModel;
    }
}

