/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.model;

import java.io.Serializable;
import org.sagacity.sqltoy.model.DateType;
import org.sagacity.sqltoy.model.TimeUnit;

public class ParamsFilter
implements Serializable {
    private static final long serialVersionUID = 1976248512731692880L;
    private String type;
    private String[] params;
    private Object[] value;
    private String[] excludes;
    private int increase = 0;
    private TimeUnit timeUnit = TimeUnit.DAYS;
    private String dateType;

    public ParamsFilter(String ... params) {
        this.params = params;
    }

    public ParamsFilter blank() {
        this.type = "blank";
        return this;
    }

    public ParamsFilter eq(Object ... values) {
        this.type = "eq";
        this.value = values;
        return this;
    }

    public ParamsFilter neq(Object ... values) {
        this.type = "neq";
        this.value = values;
        return this;
    }

    public ParamsFilter gt(Object values) {
        this.type = "gt";
        this.value = new Object[]{values};
        return this;
    }

    public ParamsFilter gte(Object values) {
        this.type = "gte";
        this.value = new Object[]{values};
        return this;
    }

    public ParamsFilter lt(Object values) {
        this.type = "lt";
        this.value = new Object[]{values};
        return this;
    }

    public ParamsFilter lte(Object values) {
        this.type = "lte";
        this.value = new Object[]{values};
        return this;
    }

    public ParamsFilter llike() {
        this.type = "l-like";
        return this;
    }

    public ParamsFilter rlike() {
        this.type = "r-like";
        return this;
    }

    public ParamsFilter toDate(DateType dateType, int increase) {
        this.type = "to-date";
        this.dateType = dateType.getValue();
        this.increase = increase;
        this.timeUnit = TimeUnit.DAYS;
        return this;
    }

    public ParamsFilter toDate(DateType dateType, TimeUnit timeUnit, int increase) {
        this.type = "to-date";
        this.dateType = dateType.getValue();
        this.increase = increase;
        if (timeUnit != null) {
            this.timeUnit = timeUnit;
        }
        return this;
    }

    public ParamsFilter primary(String ... excludes) {
        this.type = "primary";
        this.excludes = excludes;
        return this;
    }

    public ParamsFilter between(Object startValue, Object endValue) {
        this.type = "between";
        this.value = new Object[]{startValue, endValue};
        return this;
    }

    public String getType() {
        return this.type;
    }

    public String[] getParams() {
        return this.params;
    }

    public Object[] getValue() {
        return this.value;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public int getIncrease() {
        return this.increase;
    }

    public String getDateType() {
        return this.dateType;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

