/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.link;

import java.io.Serializable;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.dialect.DialectFactory;
import org.sagacity.sqltoy.plugins.datasource.DataSourceSelector;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.sagacity.sqltoy.utils.StringUtil;

public abstract class BaseLink
implements Serializable {
    private static final long serialVersionUID = 6032935116286610811L;
    protected DataSource dataSource;
    protected SqlToyContext sqlToyContext;
    protected boolean defaultDataSource = true;
    protected DialectFactory dialectFactory = DialectFactory.getInstance();

    public BaseLink(SqlToyContext sqlToyContext, DataSource dataSource) {
        this.sqlToyContext = sqlToyContext;
        this.dataSource = dataSource;
    }

    public DataSource getDataSource(SqlToyConfig sqltoyConfig) {
        String sqlDataSource = null == sqltoyConfig ? null : sqltoyConfig.getDataSource();
        DataSourceSelector dataSourceSelector = this.sqlToyContext.getDataSourceSelector();
        return dataSourceSelector.getDataSource(this.sqlToyContext.getAppContext(), this.defaultDataSource ? null : this.dataSource, sqlDataSource, !this.defaultDataSource ? null : this.dataSource, this.sqlToyContext.getDefaultDataSource());
    }

    public String getDialect() {
        if (StringUtil.isNotBlank(this.sqlToyContext.getDialect())) {
            return this.sqlToyContext.getDialect();
        }
        return DataSourceUtils.getDialect(this.sqlToyContext, this.getDataSource(null));
    }
}

