/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sagacity.sqltoy.SqlExecuteStat;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.GenerateSavePKStrategy;
import org.sagacity.sqltoy.callback.GenerateSqlHandler;
import org.sagacity.sqltoy.callback.ReflectPropsHandler;
import org.sagacity.sqltoy.callback.UpdateRowHandler;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.dialect.Dialect;
import org.sagacity.sqltoy.dialect.model.SavePKStrategy;
import org.sagacity.sqltoy.dialect.utils.DefaultDialectUtils;
import org.sagacity.sqltoy.dialect.utils.DialectExtUtils;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.dialect.utils.OracleDialectUtils;
import org.sagacity.sqltoy.model.ColumnMeta;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.StoreResult;
import org.sagacity.sqltoy.model.TableMeta;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oracle11gDialect
implements Dialect {
    protected final Logger logger = LoggerFactory.getLogger(Oracle11gDialect.class);
    public static final String NVL_FUNCTION = "nvl";
    public static final String NEXTVAL = ".nextval";
    public static final String VIRTUAL_TABLE = "dual";

    @Override
    public boolean isUnique(SqlToyContext sqlToyContext, Serializable entity, String[] paramsNamed, Connection conn, Integer dbType, String tableName) {
        return DialectUtils.isUnique(sqlToyContext, entity, paramsNamed, conn, dbType, tableName, (entityMeta, realParamNamed, table, topSize) -> {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT sag_uniqueTop.* FROM ( ");
            sql.append(DialectExtUtils.wrapUniqueSql(entityMeta, realParamNamed, dbType, table));
            sql.append(") sag_uniqueTop where ROWNUM <=");
            sql.append(topSize);
            return sql.toString();
        });
    }

    @Override
    public QueryResult getRandomResult(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long totalCount, Long randomCount, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        return OracleDialectUtils.getRandomResult(sqlToyContext, sqlToyConfig, queryExecutor, decryptHandler, totalCount, randomCount, conn, dbType, dialect, fetchSize, maxRows);
    }

    @Override
    public QueryResult findPageBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long pageNo, Integer pageSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        StringBuilder sql = new StringBuilder();
        boolean isNamed = sqlToyConfig.isNamedParam();
        int startIndex = 1;
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
            startIndex = 0;
        }
        sql.append("SELECT * FROM (SELECT ROWNUM page_row_id,SAG_Paginationtable.* FROM ( ");
        sql.append(sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect));
        sql.append(") SAG_Paginationtable ");
        if (SqlToyConstants.oraclePageIgnoreOrder() || !SqlUtil.hasOrderBy(sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect), true)) {
            sql.append(" where ROWNUM <=");
            sql.append(isNamed ? ":pageFirstParamName" : "?");
            sql.append(" ) WHERE page_row_id>");
            sql.append(isNamed ? ":pageLastParamName" : "?");
        } else {
            sql.append(" ) WHERE page_row_id<=");
            sql.append(isNamed ? ":pageFirstParamName" : "?");
            sql.append(" and page_row_id >");
            sql.append(isNamed ? ":pageLastParamName" : "?");
        }
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), pageNo * (long)pageSize.intValue(), (pageNo - 1L) * (long)pageSize.intValue(), dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.page : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, startIndex, fetchSize, maxRows);
    }

    @Override
    public QueryResult findTopBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Integer topSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        StringBuilder sql = new StringBuilder();
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        sql.append("SELECT SAG_Paginationtable.* FROM ( ");
        sql.append(sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect));
        sql.append(") SAG_Paginationtable where ROWNUM <=");
        sql.append(Double.valueOf(topSize.intValue()).intValue());
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), null, null, dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.top : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    @Override
    public QueryResult findBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, QueryExecutorExtend queryExecutorExtend, DecryptHandler decryptHandler, Connection conn, LockMode lockMode, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        String realSql = sql.concat(OracleDialectUtils.getLockSql(sql, dbType, lockMode));
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, realSql, paramsValue, queryExecutorExtend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    @Override
    public Long getCountBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, boolean isLastSql, Connection conn, Integer dbType, String dialect) throws Exception {
        return DialectUtils.getCountBySql(sqlToyContext, sqlToyConfig, sql, paramsValue, isLastSql, conn, dbType);
    }

    @Override
    public Long saveOrUpdate(SqlToyContext sqlToyContext, Serializable entity, String[] forceUpdateFields, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        ArrayList<Serializable> entities = new ArrayList<Serializable>();
        entities.add(entity);
        return this.saveOrUpdateAll(sqlToyContext, entities, sqlToyContext.getBatchSize(), null, forceUpdateFields, conn, dbType, dialect, autoCommit, tableName);
    }

    @Override
    public Long saveOrUpdateAll(final SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, String[] forceUpdateFields, Connection conn, final Integer dbType, String dialect, Boolean autoCommit, final String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        if (sqlToyContext.isSplitMergeInto() || entityMeta.getTenantField() != null && sqlToyContext.getUnifyFieldsHandler() != null && sqlToyContext.getUnifyFieldsHandler().authTenants(entities.get(0).getClass(), OperateType.updateAll) != null) {
            Long updateCnt = DialectUtils.updateAll(sqlToyContext, entities, batchSize, forceUpdateFields, reflectPropsHandler, NVL_FUNCTION, conn, dbType, autoCommit, tableName, true);
            if (updateCnt >= (long)entities.size()) {
                SqlExecuteStat.debug("\u4fee\u6539\u8bb0\u5f55", "\u4fee\u6539\u8bb0\u5f55\u91cf:" + updateCnt + " \u6761,\u7b49\u4e8eentities\u96c6\u5408\u957f\u5ea6,\u4e0d\u518d\u505ainsert\u64cd\u4f5c!", new Object[0]);
                return updateCnt;
            }
            Long saveCnt = this.saveAllIgnoreExist(sqlToyContext, entities, batchSize, reflectPropsHandler, conn, dbType, dialect, autoCommit, tableName);
            SqlExecuteStat.debug("\u65b0\u589e\u8bb0\u5f55", "\u65b0\u5efa\u8bb0\u5f55\u6570\u91cf:" + saveCnt + " \u6761!", new Object[0]);
            return updateCnt + saveCnt;
        }
        return DialectUtils.saveOrUpdateAll(sqlToyContext, entities, batchSize, entityMeta, forceUpdateFields, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                Object sequence = entityMeta.getSequence() + Oracle11gDialect.NEXTVAL;
                if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    pkStrategy = PKStrategy.SEQUENCE;
                    sequence = entityMeta.getFieldsMeta().get(entityMeta.getIdArray()[0]).getDefaultValue();
                }
                return DialectUtils.getSaveOrUpdateSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, forceUpdateFields, Oracle11gDialect.VIRTUAL_TABLE, Oracle11gDialect.NVL_FUNCTION, (String)sequence, Oracle11gDialect.this.isAssignPKValue(pkStrategy), tableName);
            }
        }, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public Long saveAllIgnoreExist(SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, final Integer dbType, String dialect, Boolean autoCommit, final String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        return DialectUtils.saveAllIgnoreExist(sqlToyContext, entities, batchSize, entityMeta, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                Object sequence = entityMeta.getSequence() + Oracle11gDialect.NEXTVAL;
                if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    pkStrategy = PKStrategy.SEQUENCE;
                    sequence = entityMeta.getFieldsMeta().get(entityMeta.getIdArray()[0]).getDefaultValue();
                }
                return DialectExtUtils.mergeIgnore(dbType, entityMeta, pkStrategy, Oracle11gDialect.VIRTUAL_TABLE, Oracle11gDialect.NVL_FUNCTION, (String)sequence, Oracle11gDialect.this.isAssignPKValue(pkStrategy), tableName);
            }
        }, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public Serializable load(SqlToyContext sqlToyContext, Serializable entity, List<Class> cascadeTypes, LockMode lockMode, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return OracleDialectUtils.load(sqlToyContext, entity, cascadeTypes, lockMode, conn, dbType, dialect, tableName);
    }

    @Override
    public List<?> loadAll(SqlToyContext sqlToyContext, List<?> entities, List<Class> cascadeTypes, LockMode lockMode, Connection conn, Integer dbType, String dialect, String tableName, int fetchSize, int maxRows) throws Exception {
        return OracleDialectUtils.loadAll(sqlToyContext, entities, cascadeTypes, lockMode, conn, dbType, tableName, fetchSize, maxRows);
    }

    @Override
    public Object save(SqlToyContext sqlToyContext, Serializable entity, Connection conn, final Integer dbType, String dialect, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        PKStrategy pkStrategy = entityMeta.getIdStrategy();
        Object sequence = entityMeta.getSequence() + NEXTVAL;
        if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
            pkStrategy = PKStrategy.SEQUENCE;
            sequence = entityMeta.getFieldsMeta().get(entityMeta.getIdArray()[0]).getDefaultValue();
        }
        String insertSql = DialectExtUtils.generateInsertSql(dbType, entityMeta, pkStrategy, NVL_FUNCTION, (String)sequence, this.isAssignPKValue(pkStrategy), tableName);
        return DialectUtils.save(sqlToyContext, entityMeta, pkStrategy, this.isAssignPKValue(pkStrategy), insertSql, entity, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateField) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                Object sequence = entityMeta.getSequence() + Oracle11gDialect.NEXTVAL;
                if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    pkStrategy = PKStrategy.SEQUENCE;
                    sequence = entityMeta.getFieldsMeta().get(entityMeta.getIdArray()[0]).getDefaultValue();
                }
                return DialectExtUtils.generateInsertSql(dbType, entityMeta, pkStrategy, Oracle11gDialect.NVL_FUNCTION, (String)sequence, Oracle11gDialect.this.isAssignPKValue(pkStrategy), null);
            }
        }, new GenerateSavePKStrategy(){

            @Override
            public SavePKStrategy generate(EntityMeta entityMeta) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    pkStrategy = PKStrategy.SEQUENCE;
                }
                return new SavePKStrategy(pkStrategy, Oracle11gDialect.this.isAssignPKValue(pkStrategy));
            }
        }, conn, dbType);
    }

    @Override
    public Long saveAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        PKStrategy pkStrategy = entityMeta.getIdStrategy();
        boolean isAssignPK = this.isAssignPKValue(pkStrategy);
        Object sequence = entityMeta.getSequence() + NEXTVAL;
        if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
            pkStrategy = PKStrategy.SEQUENCE;
            sequence = entityMeta.getFieldsMeta().get(entityMeta.getIdArray()[0]).getDefaultValue();
        }
        String insertSql = DialectExtUtils.generateInsertSql(dbType, entityMeta, pkStrategy, NVL_FUNCTION, (String)sequence, isAssignPK, tableName);
        return DialectUtils.saveAll(sqlToyContext, entityMeta, pkStrategy, isAssignPK, insertSql, entities, batchSize, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public Long update(final SqlToyContext sqlToyContext, Serializable entity, String[] forceUpdateFields, boolean cascade, Class[] emptyCascadeClasses, HashMap<Class, String[]> subTableForceUpdateProps, Connection conn, final Integer dbType, String dialect, String tableName) throws Exception {
        return DialectUtils.update(sqlToyContext, entity, NVL_FUNCTION, forceUpdateFields, cascade, !cascade ? null : new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                Object sequence = entityMeta.getSequence() + Oracle11gDialect.NEXTVAL;
                if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    pkStrategy = PKStrategy.SEQUENCE;
                    sequence = entityMeta.getFieldsMeta().get(entityMeta.getIdArray()[0]).getDefaultValue();
                }
                return DialectUtils.getSaveOrUpdateSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, forceUpdateFields, Oracle11gDialect.VIRTUAL_TABLE, Oracle11gDialect.NVL_FUNCTION, (String)sequence, Oracle11gDialect.this.isAssignPKValue(pkStrategy), null);
            }
        }, emptyCascadeClasses, subTableForceUpdateProps, conn, dbType, tableName);
    }

    @Override
    public Long updateAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, String[] uniqueFields, String[] forceUpdateFields, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        return DialectUtils.updateAll(sqlToyContext, entities, batchSize, forceUpdateFields, reflectPropsHandler, NVL_FUNCTION, conn, dbType, autoCommit, tableName, false);
    }

    @Override
    public Serializable updateSaveFetch(SqlToyContext sqlToyContext, Serializable entity, UpdateRowHandler updateRowHandler, String[] uniqueProps, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return DefaultDialectUtils.updateSaveFetch(sqlToyContext, entity, updateRowHandler, uniqueProps, conn, dbType, dialect, tableName);
    }

    @Override
    public Long delete(SqlToyContext sqlToyContext, Serializable entity, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return DialectUtils.delete(sqlToyContext, entity, conn, dbType, tableName);
    }

    @Override
    public Long deleteAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        return DialectUtils.deleteAll(sqlToyContext, entities, batchSize, conn, dbType, autoCommit, tableName);
    }

    @Override
    public QueryResult updateFetch(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, UpdateRowHandler updateRowHandler, Connection conn, Integer dbType, String dialect, LockMode lockMode, int fetchSize, int maxRows) throws Exception {
        String realSql = sql.concat(OracleDialectUtils.getLockSql(sql, dbType, lockMode == null ? LockMode.UPGRADE : lockMode));
        return DialectUtils.updateFetchBySql(sqlToyContext, sqlToyConfig, realSql, paramsValue, updateRowHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    @Override
    public StoreResult executeStore(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] inParamsValue, Integer[] outParamsType, Connection conn, Integer dbType, String dialect, int fetchSize) throws Exception {
        return OracleDialectUtils.executeStore(sqlToyConfig, sqlToyContext, sql, inParamsValue, outParamsType, conn, dbType, fetchSize);
    }

    @Override
    public List<ColumnMeta> getTableColumns(String catalog, String schema, String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        List<ColumnMeta> tableColumns = OracleDialectUtils.getTableColumns(catalog, schema, tableName, conn, dbType, dialect);
        Map<String, ColumnMeta> pkMap = DefaultDialectUtils.getTablePrimaryKeys(catalog, schema, tableName, conn, dbType, dialect);
        if (pkMap == null || pkMap.isEmpty()) {
            return tableColumns;
        }
        for (ColumnMeta colMeta : tableColumns) {
            ColumnMeta mapMeta = pkMap.get(colMeta.getColName());
            if (mapMeta == null) continue;
            colMeta.setPK(true);
        }
        return tableColumns;
    }

    @Override
    public List<TableMeta> getTables(String catalog, String schema, String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        return OracleDialectUtils.getTables(catalog, schema, tableName, conn, dbType, dialect);
    }

    private boolean isAssignPKValue(PKStrategy pkStrategy) {
        return true;
    }
}

