/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.config.model;

import java.io.Serializable;
import org.sagacity.sqltoy.SqlToyConstants;

public class FieldMeta
implements Serializable {
    private static final long serialVersionUID = -6717053365757314662L;
    private String fieldName;
    private String columnName;
    private int type;
    private String fieldType;
    private boolean nullable;
    private boolean keyword = false;
    private int length;
    private int precision;
    private int scale;
    private String defaultValue;
    private boolean autoIncrement = false;
    private boolean partitionKey = false;
    private boolean isPK;

    public FieldMeta() {
    }

    public FieldMeta(String filedName, String columnName, String defaultValue, int type, boolean nullable, boolean keyword, int length, int precision, int scale) {
        this.fieldName = filedName;
        this.columnName = columnName;
        this.defaultValue = defaultValue;
        this.type = type;
        this.nullable = nullable;
        this.keyword = keyword;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnOptName() {
        if (this.keyword) {
            String sign = SqlToyConstants.keywordSign;
            return sign.concat(this.columnName).concat(sign);
        }
        return this.columnName;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public boolean isPK() {
        return this.isPK;
    }

    public void setPK(boolean isPK) {
        this.isPK = isPK;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isKeyword() {
        return this.keyword;
    }

    public void setKeyword(boolean keyword) {
        this.keyword = keyword;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(boolean partitionKey) {
        this.partitionKey = partitionKey;
    }
}

