/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.ReplaceVisitor;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAQueryMixin;
import com.querydsl.jpa.JPQLOps;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class JPAListAccessVisitor
extends ReplaceVisitor<Void> {
    private final QueryMetadata metadata;
    private final Map<Expression<?>, Path<?>> aliases;
    private final Map<Path<?>, Path<?>> replacements = new HashMap();

    JPAListAccessVisitor(QueryMetadata metadata, Map<Expression<?>, Path<?>> aliases) {
        this.metadata = metadata;
        this.aliases = aliases;
    }

    public Expression<?> visit(Path<?> expr, @Nullable Void context) {
        PathMetadata pathMetadata = (expr = (Path)super.visit(expr, null)).getMetadata();
        if (pathMetadata.getPathType() == PathType.LISTVALUE || pathMetadata.getPathType() == PathType.LISTVALUE_CONSTANT) {
            Path replacement = this.replacements.get(expr);
            if (replacement == null) {
                Path<?> parent = this.shorten(pathMetadata.getParent(), true);
                replacement = ExpressionUtils.path((Class)expr.getType(), (String)ExpressionUtils.createRootVariable(parent, (int)this.replacements.size()));
                this.metadata.addJoin(JoinType.LEFTJOIN, ExpressionUtils.as(parent, (Path)replacement));
                this.metadata.addJoinCondition(ExpressionUtils.eq((Expression)Expressions.operation(Integer.class, (Operator)JPQLOps.INDEX, (Expression[])new Expression[]{replacement}), (Expression)ExpressionUtils.toExpression((Object)pathMetadata.getElement())));
                this.replacements.put(expr, replacement);
            }
            return replacement;
        }
        return super.visit(expr, (Object)context);
    }

    private Path<?> shorten(Path<?> path, boolean outer) {
        if (this.aliases.containsKey(path)) {
            return this.aliases.get(path);
        }
        if (path.getMetadata().isRoot()) {
            return path;
        }
        if (path.getMetadata().getParent().getMetadata().isRoot() && outer) {
            return path;
        }
        Class<?> type = JPAQueryMixin.getElementTypeOrType(path);
        Path<?> parent = this.shorten(path.getMetadata().getParent(), false);
        Path oldPath = ExpressionUtils.path((Class)path.getType(), (PathMetadata)new PathMetadata(parent, path.getMetadata().getElement(), path.getMetadata().getPathType()));
        if (oldPath.getMetadata().getParent().getMetadata().isRoot() && outer) {
            return oldPath;
        }
        Path newPath = ExpressionUtils.path(type, (String)ExpressionUtils.createRootVariable((Path)oldPath));
        this.aliases.put((Expression<?>)path, (Path<?>)newPath);
        this.metadata.addJoin(JoinType.LEFTJOIN, ExpressionUtils.as((Expression)oldPath, (Path)newPath));
        return newPath;
    }
}

