/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.alias;

import com.querydsl.core.QueryException;
import com.querydsl.core.alias.ManagedObject;
import com.querydsl.core.alias.PathFactory;
import com.querydsl.core.alias.PropertyAccessInvocationHandler;
import com.querydsl.core.alias.TypeSystem;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadataFactory;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.jetbrains.annotations.Nullable;

class AliasFactory {
    private final ThreadLocal<Expression<?>> current = new ThreadLocal();
    private final PathFactory pathFactory;
    private final TypeSystem typeSystem;
    private final ConcurrentHashMap<Class<?>, Map<Expression<?>, ManagedObject>> proxyCache = new ConcurrentHashMap();

    AliasFactory(PathFactory pathFactory, TypeSystem typeSystem) {
        this.pathFactory = pathFactory;
        this.typeSystem = typeSystem;
    }

    public <A> A createAliasForExpr(Class<A> cl, Expression<? extends A> expr) {
        try {
            Map expressionCache = this.proxyCache.computeIfAbsent(cl, a -> Collections.synchronizedMap(new WeakHashMap()));
            return (A)expressionCache.computeIfAbsent(expr, e -> (ManagedObject)this.createProxy(cl, expr));
        }
        catch (ClassCastException e2) {
            throw new QueryException(e2);
        }
    }

    public <A> A createAliasForProperty(Class<A> cl, Expression<?> path) {
        return this.createProxy(cl, path);
    }

    public <A> A createAliasForVariable(Class<A> cl, String var) {
        Path<A> expr = this.pathFactory.createEntityPath(cl, PathMetadataFactory.forVariable(var));
        return this.createAliasForExpr(cl, expr);
    }

    protected <A> A createProxy(Class<A> cl, Expression<?> path) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(AliasFactory.class.getClassLoader());
        if (cl.isInterface()) {
            enhancer.setInterfaces(new Class[]{cl, ManagedObject.class});
        } else {
            enhancer.setSuperclass(cl);
            enhancer.setInterfaces(new Class[]{ManagedObject.class});
        }
        PropertyAccessInvocationHandler handler = new PropertyAccessInvocationHandler(path, this, this.pathFactory, this.typeSystem);
        enhancer.setCallback((Callback)handler);
        return (A)enhancer.create();
    }

    @Nullable
    public <A extends Expression<?>> A getCurrent() {
        return (A)this.current.get();
    }

    @Nullable
    public <A extends Expression<?>> A getCurrentAndReset() {
        A rv = this.getCurrent();
        this.reset();
        return rv;
    }

    public void reset() {
        this.current.set(null);
    }

    public void setCurrent(Expression<?> expr) {
        this.current.set(expr);
    }
}

