/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.intent.OIntent;
import org.apache.commons.configuration.Configuration;

public abstract class OrientConfigurableGraph {
    protected Settings settings = new Settings();
    protected static final boolean USE_LIGHTWEIGHT_EDGES_DEFAULT = false;
    protected static final boolean USE_CLASS_FOR_EDGE_LABEL_DEFAULT = true;
    protected static final boolean USE_CLASS_FOR_VERTEX_LABEL_DEFAULT = true;
    protected static final boolean KEEP_IN_MEMORY_REFERENCES_DEFAULT = false;
    protected static final boolean USE_VERTEX_FIELDS_FOR_EDGE_LABELS = true;
    protected static final boolean SAVE_ORIGINAL_IDS_DEFAULT = false;
    protected static final boolean STANDARD_ELEMENT_CONSTRAINTS_DEFAULT = true;
    protected static final boolean STANDARD_EXCEPTIONS = false;
    protected static final boolean WARN_ON_FORCE_CLOSING_TX_DEFAULT = true;
    protected static final boolean AUTO_SCALE_EDGE_TYPE_DEFAULT = false;
    protected static final boolean USE_LOG_DEFAULT = true;
    protected static final int EDGE_CONTAINER_EMBEDDED_2_TREE_THRESHOLD_DEFAULT = -1;
    protected static final int EDGE_CONTAINER_TREE_2_EMBEDDED_THRESHOLD_DEFAULT = -1;
    protected static final THREAD_MODE THREAD_MODE_DEFAULT = THREAD_MODE.AUTOSET_IFNULL;
    protected static final boolean AUTO_START_TX_DEFAULT = true;
    protected static final boolean REQUIRE_TRANSACTION_DEFAULT = false;
    protected static final boolean STANDARD_TX_REQUIRE_FOR_SQL_OPERATIONS = true;
    protected static final int STANDARD_MAX_RETRIES = 50;

    protected OrientConfigurableGraph() {
    }

    public abstract void declareIntent(OIntent var1);

    public boolean isUseLightweightEdges() {
        return this.settings.isUseLightweightEdges();
    }

    public OrientConfigurableGraph setUseLightweightEdges(boolean useDynamicEdges) {
        this.settings.setUseLightweightEdges(useDynamicEdges);
        return this;
    }

    public boolean isTxRequiredForSQLGraphOperations() {
        return this.settings.isTxRequiredForSQLGraphOperations();
    }

    public OrientConfigurableGraph setTxRequiredForSQLGraphOperations(boolean useTransaction) {
        this.settings.setTxRequiredForSQLGraphOperations(useTransaction);
        return this;
    }

    public boolean isAutoScaleEdgeType() {
        return this.settings.isAutoScaleEdgeType();
    }

    public OrientConfigurableGraph setAutoScaleEdgeType(boolean autoScaleEdgeType) {
        this.settings.setAutoScaleEdgeType(autoScaleEdgeType);
        return this;
    }

    public int getEdgeContainerEmbedded2TreeThreshold() {
        return this.settings.getEdgeContainerEmbedded2TreeThreshold();
    }

    public OrientConfigurableGraph setEdgeContainerEmbedded2TreeThreshold(int edgeContainerEmbedded2TreeThreshold) {
        this.settings.setEdgeContainerEmbedded2TreeThreshold(edgeContainerEmbedded2TreeThreshold);
        return this;
    }

    public int getEdgeContainerTree2EmbeddedThreshold() {
        return this.settings.getEdgeContainerTree2EmbeddedThreshold();
    }

    public OrientConfigurableGraph setEdgeContainerTree2EmbeddedThreshold(int edgeContainerTree2EmbeddedThreshold) {
        this.settings.edgeContainerTree2EmbeddedThreshold = edgeContainerTree2EmbeddedThreshold;
        return this;
    }

    public boolean isAutoStartTx() {
        return this.settings.isAutoStartTx();
    }

    public void setAutoStartTx(boolean autoStartTx) {
        this.settings.setAutoStartTx(autoStartTx);
    }

    public boolean isRequireTransaction() {
        return this.settings.isRequireTransaction();
    }

    public void setRequireTransaction(boolean requireTransaction) {
        this.settings.setRequireTransaction(requireTransaction);
    }

    public boolean isSaveOriginalIds() {
        return this.settings.isSaveOriginalIds();
    }

    public OrientConfigurableGraph setSaveOriginalIds(boolean saveIds) {
        this.settings.setSaveOriginalIds(saveIds);
        return this;
    }

    public boolean isKeepInMemoryReferences() {
        return this.settings.isKeepInMemoryReferences();
    }

    public OrientConfigurableGraph setKeepInMemoryReferences(boolean useReferences) {
        this.settings.setKeepInMemoryReferences(useReferences);
        return this;
    }

    public boolean isUseClassForEdgeLabel() {
        return this.settings.isUseClassForEdgeLabel();
    }

    public OrientConfigurableGraph setUseClassForEdgeLabel(boolean useCustomClassesForEdges) {
        this.settings.setUseClassForEdgeLabel(useCustomClassesForEdges);
        return this;
    }

    public boolean isUseClassForVertexLabel() {
        return this.settings.isUseClassForVertexLabel();
    }

    public OrientConfigurableGraph setUseClassForVertexLabel(boolean useCustomClassesForVertex) {
        this.settings.setUseClassForVertexLabel(useCustomClassesForVertex);
        return this;
    }

    public boolean isUseVertexFieldsForEdgeLabels() {
        return this.settings.isUseVertexFieldsForEdgeLabels();
    }

    public OrientConfigurableGraph setUseVertexFieldsForEdgeLabels(boolean useVertexFieldsForEdgeLabels) {
        this.settings.setUseVertexFieldsForEdgeLabels(useVertexFieldsForEdgeLabels);
        return this;
    }

    public boolean isStandardElementConstraints() {
        return this.settings.isStandardElementConstraints();
    }

    public OrientConfigurableGraph setStandardElementConstraints(boolean allowsPropertyValueNull) {
        this.settings.setStandardElementConstraints(allowsPropertyValueNull);
        return this;
    }

    public boolean isStandardExceptions() {
        return this.settings.isStandardExceptions();
    }

    public OrientConfigurableGraph setStandardExceptions(boolean stdExceptions) {
        this.settings.setStandardExceptions(stdExceptions);
        return this;
    }

    public boolean isWarnOnForceClosingTx() {
        return this.settings.isWarnOnForceClosingTx();
    }

    public OrientConfigurableGraph setWarnOnForceClosingTx(boolean warnOnSchemaChangeInTx) {
        this.settings.setWarnOnForceClosingTx(warnOnSchemaChangeInTx);
        return this;
    }

    public THREAD_MODE getThreadMode() {
        return this.settings.getThreadMode();
    }

    public OrientConfigurableGraph setThreadMode(THREAD_MODE iControl) {
        this.settings.setThreadMode(iControl);
        return this;
    }

    public OrientConfigurableGraph setUseLog(boolean useLog) {
        this.settings.useLog = useLog;
        return this;
    }

    public String getConnectionStrategy() {
        return this.settings.connectionStrategy;
    }

    public void setConnectionStrategy(String connectionStrategy) {
        this.settings.connectionStrategy = connectionStrategy;
    }

    public int getMaxRetries() {
        return this.settings.getMaxRetries();
    }

    public void setMaxRetries(int maxRetries) {
        this.settings.setMaxRetries(maxRetries);
    }

    protected void init(Configuration configuration) {
        Integer maxRetries;
        Boolean txRequiredForSQLGraphOperations;
        Boolean requireTransaction;
        Boolean autoScaleEdgeType;
        Boolean lightweightEdges;
        Boolean useVertexFieldsForEdgeLabels;
        Boolean useCustomClassesForVertex;
        Boolean useCustomClassesForEdges;
        Boolean keepInMemoryReferences;
        Boolean saveOriginalIds = configuration.getBoolean("blueprints.orientdb.saveOriginalIds", null);
        if (saveOriginalIds != null) {
            this.setSaveOriginalIds(saveOriginalIds);
        }
        if ((keepInMemoryReferences = configuration.getBoolean("blueprints.orientdb.keepInMemoryReferences", null)) != null) {
            this.setKeepInMemoryReferences(keepInMemoryReferences);
        }
        if ((useCustomClassesForEdges = configuration.getBoolean("blueprints.orientdb.useCustomClassesForEdges", null)) != null) {
            this.setUseClassForEdgeLabel(useCustomClassesForEdges);
        }
        if ((useCustomClassesForVertex = configuration.getBoolean("blueprints.orientdb.useCustomClassesForVertex", null)) != null) {
            this.setUseClassForVertexLabel(useCustomClassesForVertex);
        }
        if ((useVertexFieldsForEdgeLabels = configuration.getBoolean("blueprints.orientdb.useVertexFieldsForEdgeLabels", null)) != null) {
            this.setUseVertexFieldsForEdgeLabels(useVertexFieldsForEdgeLabels);
        }
        if ((lightweightEdges = configuration.getBoolean("blueprints.orientdb.lightweightEdges", null)) != null) {
            this.setUseLightweightEdges(lightweightEdges);
        }
        if ((autoScaleEdgeType = configuration.getBoolean("blueprints.orientdb.autoScaleEdgeType", null)) != null) {
            this.setAutoScaleEdgeType(autoScaleEdgeType);
        }
        if ((requireTransaction = configuration.getBoolean("blueprints.orientdb.requireTransaction", null)) != null) {
            this.setRequireTransaction(requireTransaction);
        }
        if ((txRequiredForSQLGraphOperations = configuration.getBoolean("blueprints.orientdb.txRequiredForSQLGraphOperations", null)) != null) {
            this.setTxRequiredForSQLGraphOperations(txRequiredForSQLGraphOperations);
        }
        if ((maxRetries = Integer.valueOf(configuration.getInt("blueprints.orientdb.maxRetries", 50))) != null) {
            this.setMaxRetries(maxRetries);
        }
    }

    public static class Settings {
        private Boolean useLightweightEdges = null;
        private Boolean useClassForEdgeLabel = null;
        private Boolean useClassForVertexLabel = null;
        private Boolean keepInMemoryReferences = null;
        private Boolean useVertexFieldsForEdgeLabels = null;
        private Boolean saveOriginalIds = null;
        private Boolean standardElementConstraints = null;
        private Boolean standardExceptions = null;
        private Boolean warnOnForceClosingTx = null;
        private Boolean autoScaleEdgeType = null;
        private Integer edgeContainerEmbedded2TreeThreshold = null;
        private Integer edgeContainerTree2EmbeddedThreshold = null;
        private THREAD_MODE threadMode = null;
        private Boolean autoStartTx = null;
        private Boolean txRequiredForSQLGraphOperations = null;
        private Boolean requireTransaction = null;
        private Boolean useLog = null;
        private String connectionStrategy = "STICKY";
        private Integer maxRetries = null;

        public Settings copy() {
            Settings copy = new Settings();
            copy.useLightweightEdges = this.useLightweightEdges;
            copy.useClassForEdgeLabel = this.useClassForEdgeLabel;
            copy.useClassForVertexLabel = this.useClassForVertexLabel;
            copy.keepInMemoryReferences = this.keepInMemoryReferences;
            copy.useVertexFieldsForEdgeLabels = this.useVertexFieldsForEdgeLabels;
            copy.saveOriginalIds = this.saveOriginalIds;
            copy.standardElementConstraints = this.standardElementConstraints;
            copy.standardExceptions = this.standardExceptions;
            copy.warnOnForceClosingTx = this.warnOnForceClosingTx;
            copy.autoScaleEdgeType = this.autoScaleEdgeType;
            copy.edgeContainerEmbedded2TreeThreshold = this.edgeContainerEmbedded2TreeThreshold;
            copy.edgeContainerTree2EmbeddedThreshold = this.edgeContainerTree2EmbeddedThreshold;
            copy.threadMode = this.threadMode;
            copy.autoStartTx = this.autoStartTx;
            copy.requireTransaction = this.requireTransaction;
            copy.txRequiredForSQLGraphOperations = this.txRequiredForSQLGraphOperations;
            copy.useLog = this.useLog;
            copy.connectionStrategy = this.connectionStrategy;
            copy.maxRetries = this.maxRetries;
            return copy;
        }

        public void copyFrom(Settings settings) {
            if (settings.useLightweightEdges != null) {
                this.useLightweightEdges = settings.useLightweightEdges;
            }
            if (settings.useClassForEdgeLabel != null) {
                this.useClassForEdgeLabel = settings.useClassForEdgeLabel;
            }
            if (settings.useClassForVertexLabel != null) {
                this.useClassForVertexLabel = settings.useClassForVertexLabel;
            }
            if (settings.keepInMemoryReferences != null) {
                this.keepInMemoryReferences = settings.keepInMemoryReferences;
            }
            if (settings.useVertexFieldsForEdgeLabels != null) {
                this.useVertexFieldsForEdgeLabels = settings.useVertexFieldsForEdgeLabels;
            }
            if (settings.saveOriginalIds != null) {
                this.saveOriginalIds = settings.saveOriginalIds;
            }
            if (settings.standardElementConstraints != null) {
                this.standardElementConstraints = settings.standardElementConstraints;
            }
            if (settings.standardExceptions != null) {
                this.standardExceptions = settings.standardExceptions;
            }
            if (settings.warnOnForceClosingTx != null) {
                this.warnOnForceClosingTx = settings.warnOnForceClosingTx;
            }
            if (settings.autoScaleEdgeType != null) {
                this.autoScaleEdgeType = settings.autoScaleEdgeType;
            }
            if (settings.edgeContainerEmbedded2TreeThreshold != null) {
                this.edgeContainerEmbedded2TreeThreshold = settings.edgeContainerEmbedded2TreeThreshold;
            }
            if (settings.edgeContainerTree2EmbeddedThreshold != null) {
                this.edgeContainerTree2EmbeddedThreshold = settings.edgeContainerTree2EmbeddedThreshold;
            }
            if (settings.threadMode != null) {
                this.threadMode = settings.threadMode;
            }
            if (settings.autoStartTx != null) {
                this.autoStartTx = settings.autoStartTx;
            }
            if (settings.requireTransaction != null) {
                this.requireTransaction = settings.requireTransaction;
            }
            if (settings.txRequiredForSQLGraphOperations != null) {
                this.txRequiredForSQLGraphOperations = settings.txRequiredForSQLGraphOperations;
            }
            if (settings.useLog != null) {
                this.useLog = settings.useLog;
            }
            if (settings.connectionStrategy != null) {
                this.connectionStrategy = settings.connectionStrategy;
            }
            if (settings.maxRetries != null) {
                this.maxRetries = settings.maxRetries;
            }
        }

        public boolean isUseLightweightEdges() {
            if (this.useLightweightEdges == null) {
                return false;
            }
            return this.useLightweightEdges;
        }

        public void setUseLightweightEdges(boolean useDynamicEdges) {
            this.useLightweightEdges = useDynamicEdges;
        }

        public boolean isAutoScaleEdgeType() {
            if (this.autoScaleEdgeType == null) {
                return false;
            }
            return this.autoScaleEdgeType;
        }

        public void setAutoScaleEdgeType(boolean autoScaleEdgeType) {
            this.autoScaleEdgeType = autoScaleEdgeType;
        }

        public boolean isUseLog() {
            if (this.useLog == null) {
                return true;
            }
            return this.useLog;
        }

        public void setUseLog(boolean useLog) {
            this.useLog = useLog;
        }

        public String getConnectionStrategy() {
            return this.connectionStrategy;
        }

        public void setConnectionStrategy(String connectionStrategy) {
            this.connectionStrategy = connectionStrategy;
        }

        public int getEdgeContainerEmbedded2TreeThreshold() {
            if (this.edgeContainerEmbedded2TreeThreshold == null) {
                return -1;
            }
            return this.edgeContainerEmbedded2TreeThreshold;
        }

        public void setEdgeContainerEmbedded2TreeThreshold(int edgeContainerEmbedded2TreeThreshold) {
            this.edgeContainerEmbedded2TreeThreshold = edgeContainerEmbedded2TreeThreshold;
        }

        public int getEdgeContainerTree2EmbeddedThreshold() {
            if (this.edgeContainerTree2EmbeddedThreshold == null) {
                return -1;
            }
            return this.edgeContainerTree2EmbeddedThreshold;
        }

        public void setEdgeContainerTree2EmbeddedThreshold(int edgeContainerTree2EmbeddedThreshold) {
            this.edgeContainerTree2EmbeddedThreshold = edgeContainerTree2EmbeddedThreshold;
        }

        public boolean isAutoStartTx() {
            if (this.autoStartTx == null) {
                return true;
            }
            return this.autoStartTx;
        }

        public void setAutoStartTx(boolean autoStartTx) {
            this.autoStartTx = autoStartTx;
        }

        public boolean isRequireTransaction() {
            if (this.requireTransaction == null) {
                return false;
            }
            return this.requireTransaction;
        }

        public void setRequireTransaction(boolean requireTransaction) {
            this.requireTransaction = requireTransaction;
        }

        public void setTxRequiredForSQLGraphOperations(boolean iValue) {
            this.txRequiredForSQLGraphOperations = iValue;
        }

        public boolean isTxRequiredForSQLGraphOperations() {
            if (this.txRequiredForSQLGraphOperations == null) {
                return true;
            }
            return this.txRequiredForSQLGraphOperations;
        }

        public boolean isSaveOriginalIds() {
            if (this.saveOriginalIds == null) {
                return false;
            }
            return this.saveOriginalIds;
        }

        public void setSaveOriginalIds(boolean saveIds) {
            this.saveOriginalIds = saveIds;
        }

        public boolean isKeepInMemoryReferences() {
            if (this.keepInMemoryReferences == null) {
                return false;
            }
            return this.keepInMemoryReferences;
        }

        public void setKeepInMemoryReferences(boolean useReferences) {
            this.keepInMemoryReferences = useReferences;
        }

        public boolean isUseClassForEdgeLabel() {
            if (this.useClassForEdgeLabel == null) {
                return true;
            }
            return this.useClassForEdgeLabel;
        }

        public void setUseClassForEdgeLabel(boolean useCustomClassesForEdges) {
            this.useClassForEdgeLabel = useCustomClassesForEdges;
        }

        public boolean isUseClassForVertexLabel() {
            if (this.useClassForVertexLabel == null) {
                return true;
            }
            return this.useClassForVertexLabel;
        }

        public void setUseClassForVertexLabel(boolean useCustomClassesForVertex) {
            this.useClassForVertexLabel = useCustomClassesForVertex;
        }

        public boolean isUseVertexFieldsForEdgeLabels() {
            if (this.useVertexFieldsForEdgeLabels == null) {
                return true;
            }
            return this.useVertexFieldsForEdgeLabels;
        }

        public void setUseVertexFieldsForEdgeLabels(boolean useVertexFieldsForEdgeLabels) {
            this.useVertexFieldsForEdgeLabels = useVertexFieldsForEdgeLabels;
        }

        public boolean isStandardElementConstraints() {
            if (this.standardElementConstraints == null) {
                return true;
            }
            return this.standardElementConstraints;
        }

        public void setStandardElementConstraints(boolean allowsPropertyValueNull) {
            this.standardElementConstraints = allowsPropertyValueNull;
        }

        public boolean isStandardExceptions() {
            if (this.standardExceptions == null) {
                return false;
            }
            return this.standardExceptions;
        }

        public void setStandardExceptions(boolean stdExceptions) {
            this.standardExceptions = stdExceptions;
        }

        public boolean isWarnOnForceClosingTx() {
            if (this.warnOnForceClosingTx == null) {
                return true;
            }
            return this.warnOnForceClosingTx;
        }

        public void setWarnOnForceClosingTx(boolean warnOnSchemaChangeInTx) {
            this.warnOnForceClosingTx = warnOnSchemaChangeInTx;
        }

        public THREAD_MODE getThreadMode() {
            if (this.threadMode == null) {
                return THREAD_MODE_DEFAULT;
            }
            return this.threadMode;
        }

        public void setThreadMode(THREAD_MODE iControl) {
            this.threadMode = iControl;
        }

        public int getMaxRetries() {
            if (this.maxRetries == null) {
                return 50;
            }
            return this.maxRetries;
        }

        public void setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
        }
    }

    public static enum THREAD_MODE {
        MANUAL,
        AUTOSET_IFNULL,
        ALWAYS_AUTOSET;

    }
}

