/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.opentable.db.postgres.embedded.DatabasePreparer;
import com.opentable.db.postgres.embedded.EmbeddedPostgres;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.sql.DataSource;
import org.apache.commons.lang3.RandomStringUtils;
import org.postgresql.ds.PGSimpleDataSource;

public class PreparedDbProvider {
    private static final String JDBC_FORMAT = "jdbc:postgresql://localhost:%d/%s";
    @GuardedBy(value="PreparedDbProvider.class")
    private static final Map<DatabasePreparer, PrepPipeline> CLUSTERS = new HashMap<DatabasePreparer, PrepPipeline>();
    private final PrepPipeline dbPreparer;

    public static PreparedDbProvider forPreparer(DatabasePreparer preparer) {
        return new PreparedDbProvider(preparer);
    }

    private PreparedDbProvider(DatabasePreparer preparer) {
        try {
            this.dbPreparer = this.createOrFindPreparer(preparer);
        }
        catch (IOException | SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private synchronized PrepPipeline createOrFindPreparer(DatabasePreparer preparer) throws IOException, SQLException {
        PrepPipeline result = CLUSTERS.get(preparer);
        if (result != null) {
            return result;
        }
        EmbeddedPostgres pg = EmbeddedPostgres.start();
        preparer.prepare(pg.getTemplateDatabase());
        result = new PrepPipeline(pg).start();
        CLUSTERS.put(preparer, result);
        return result;
    }

    public String createDatabase() throws SQLException {
        DbInfo db = this.dbPreparer.getNextDb();
        return this.getJdbcUri(db);
    }

    public DataSource createDataSource() throws SQLException {
        DbInfo db = this.dbPreparer.getNextDb();
        PGSimpleDataSource ds = new PGSimpleDataSource();
        ds.setPortNumber(db.port);
        ds.setDatabaseName(db.dbName);
        ds.setUser(db.user);
        return ds;
    }

    private String getJdbcUri(DbInfo db) {
        return String.format(JDBC_FORMAT, db.port, db.dbName);
    }

    public ImmutableMap<String, String> getConfigurationTweak(String dbModuleName) throws SQLException {
        DbInfo db = this.dbPreparer.getNextDb();
        return ImmutableMap.of((Object)("ot.db." + dbModuleName + ".uri"), (Object)this.getJdbcUri(db), (Object)("ot.db." + dbModuleName + ".ds.user"), (Object)db.user);
    }

    private static void create(DataSource connectDb, @Nonnull String dbName, @Nonnull String userName) throws SQLException {
        Preconditions.checkArgument((dbName != null ? 1 : 0) != 0, (Object)"the database name must not be null!");
        Preconditions.checkArgument((userName != null ? 1 : 0) != 0, (Object)"the user name must not be null!");
        try (Connection c = connectDb.getConnection();
             PreparedStatement stmt = c.prepareStatement(String.format("CREATE DATABASE %s OWNER %s ENCODING = 'utf8'", dbName, userName));){
            stmt.execute();
        }
    }

    private static class DbInfo {
        private final String dbName;
        private final int port;
        private final String user;
        private final SQLException ex;

        DbInfo(String dbName, int port, String user) {
            this.dbName = dbName;
            this.port = port;
            this.user = user;
            this.ex = null;
        }

        DbInfo(SQLException e) {
            this.dbName = null;
            this.port = -1;
            this.user = null;
            this.ex = e;
        }
    }

    private static class PrepPipeline
    implements Runnable {
        private final EmbeddedPostgres pg;
        private final SynchronousQueue<DbInfo> nextDatabase = new SynchronousQueue();

        PrepPipeline(EmbeddedPostgres pg) {
            this.pg = pg;
        }

        PrepPipeline start() {
            ExecutorService service = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("cluster-" + this.pg + "-preparer").build());
            service.submit(this);
            service.shutdown();
            return this;
        }

        DbInfo getNextDb() throws SQLException {
            try {
                DbInfo next = this.nextDatabase.take();
                if (next.ex != null) {
                    throw next.ex;
                }
                return next;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void run() {
            while (true) {
                String newDbName = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ENGLISH);
                SQLException failure = null;
                try {
                    PreparedDbProvider.create(this.pg.getPostgresDatabase(), newDbName, "postgres");
                }
                catch (SQLException e) {
                    failure = e;
                }
                try {
                    if (failure == null) {
                        this.nextDatabase.put(new DbInfo(newDbName, this.pg.getPort(), "postgres"));
                        continue;
                    }
                    this.nextDatabase.put(new DbInfo(failure));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }
}

