/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.ea;

import com.mycila.testing.core.util.SoftHashMap;
import com.mycila.testing.ea.AssertionExceptionImpl;
import com.mycila.testing.ea.Code;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtendedAssert {
    private static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    private static final SoftHashMap<URL, byte[]> cache = new SoftHashMap();

    private ExtendedAssert() {
    }

    public void assertSameXml(String actual, String expected) {
        this.assertSameXml(null, actual, expected);
    }

    public void assertSameXml(String message, String actual, String expected) {
        if (actual == null && expected == null) {
            return;
        }
        if (expected == null || actual == null) {
            ExtendedAssert.fail(message, actual, expected);
        }
        if (!actual.replaceAll("\\r|\\n", "").replaceAll(">\\s*<", "><").equals(expected.replaceAll("\\r|\\n", "").replaceAll(">\\s*<", "><"))) {
            ExtendedAssert.fail(message, actual, expected);
        }
    }

    public static void assertNotEquals(Object actual, Object expected) {
        ExtendedAssert.assertNotEquals(null, actual, expected);
    }

    public static void assertNotEquals(String message, Object actual, Object expected) {
        if (expected == null && actual == null || expected != null && expected.equals(actual)) {
            ExtendedAssert.fail(message, actual, "Objects not equals");
        }
    }

    public static void assertEmpty(String actual) {
        ExtendedAssert.assertEmpty(null, actual);
    }

    public static void assertEmpty(String message, String actual) {
        if (actual != null && actual.length() > 0) {
            ExtendedAssert.fail(message, actual, "Empty string");
        }
    }

    public static void assertEmpty(Collection<?> actual) {
        ExtendedAssert.assertEmpty(null, actual);
    }

    public static void assertEmpty(String message, Collection<?> actual) {
        if (actual != null && !actual.isEmpty()) {
            ExtendedAssert.fail(message, actual, "Empty collection");
        }
    }

    public static void assertEmpty(Object[] actual) {
        ExtendedAssert.assertEmpty(null, actual);
    }

    public static void assertEmpty(String message, Object[] actual) {
        if (actual != null && actual.length > 0) {
            ExtendedAssert.fail(message, actual, "Empty array");
        }
    }

    public static void assertBlank(String actual) {
        ExtendedAssert.assertBlank(null, actual);
    }

    public static void assertBlank(String message, String actual) {
        if (actual != null && actual.trim().length() > 0) {
            ExtendedAssert.fail(message, actual, "Blank string");
        }
    }

    public static URL resource(String classPath) {
        URL u = Thread.currentThread().getContextClassLoader().getResource(classPath.startsWith("/") ? classPath.substring(1) : classPath);
        if (u == null) {
            throw new IllegalArgumentException("Resource not found in classpath: " + classPath);
        }
        return u;
    }

    public static String asString(File file) {
        return ExtendedAssert.asString(file, DEFAULT_ENCODING);
    }

    public static String asString(URL url) {
        return ExtendedAssert.asString(url, DEFAULT_ENCODING);
    }

    public static String asString(String classPath) {
        return ExtendedAssert.asString(classPath, DEFAULT_ENCODING);
    }

    public static String asString(File file, String encoding) {
        try {
            return ExtendedAssert.asString(file.toURI().toURL(), encoding);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String asString(String classPath, String encoding) {
        try {
            return new String(ExtendedAssert.asBytes(classPath), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String asString(URL url, String encoding) {
        try {
            return new String(ExtendedAssert.asBytes(url), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static byte[] asBytes(File file) {
        try {
            return ExtendedAssert.asBytes(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static byte[] asBytes(String classPath) {
        return ExtendedAssert.asBytes(ExtendedAssert.resource(classPath));
    }

    public static byte[] asBytes(URL url) {
        byte[] data = cache.get(url);
        if (data == null) {
            try {
                int count;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BufferedInputStream bis = new BufferedInputStream(url.openStream());
                data = new byte[8192];
                while ((count = bis.read(data)) != -1) {
                    baos.write(data, 0, count);
                }
                bis.close();
                data = baos.toByteArray();
                cache.put(url, data);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return data;
    }

    public static AssertException assertThrow(Class<? extends Throwable> exceptionClass) {
        return new AssertionExceptionImpl(exceptionClass);
    }

    static String format(String message, Object actual, Object expected) {
        String actualString;
        String expectedString;
        String formatted = "";
        if (message != null && !message.equals("")) {
            formatted = message + " ";
        }
        if ((expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual))) {
            return formatted + "expected: " + ExtendedAssert.formatClassAndValue(expected, expectedString) + " but was: " + ExtendedAssert.formatClassAndValue(actual, actualString);
        }
        return formatted + "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + "<" + valueString + ">";
    }

    static void fail(String message, Object actual, Object expected) {
        ExtendedAssert.fail(ExtendedAssert.format(message, actual, expected));
    }

    static void fail(String message) {
        throw new AssertionError((Object)(message == null ? "" : message));
    }

    public static interface AssertException {
        public AssertException withMessage(String var1);

        public AssertException containingMessage(String var1);

        public void whenRunning(Code var1);
    }
}

