/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.core;

import com.mycila.log.Logger;
import com.mycila.log.Loggers;
import com.mycila.plugin.api.PluginBinding;
import com.mycila.plugin.spi.PluginManager;
import com.mycila.testing.core.AttributesImpl;
import com.mycila.testing.core.ExecutionImpl;
import com.mycila.testing.core.Mycila;
import com.mycila.testing.core.TestExecutionImpl;
import com.mycila.testing.core.api.Attributes;
import com.mycila.testing.core.api.Ensure;
import com.mycila.testing.core.api.Step;
import com.mycila.testing.core.api.TestContext;
import com.mycila.testing.core.api.TestNotifier;
import com.mycila.testing.core.api.TestPluginException;
import com.mycila.testing.core.introspect.Introspector;
import com.mycila.testing.core.plugin.TestPlugin;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TestContextImpl
implements TestContext,
TestNotifier {
    private static final Method prepareMethod;
    private static final Method fireAfterClassMethod;
    private static final Method shutdownMethod;
    private static final Logger LOGGER;
    private final Introspector introspector;
    private final PluginManager<TestPlugin> pluginManager;
    private final Attributes attributes = new AttributesImpl();

    TestContextImpl(PluginManager<TestPlugin> pluginManager, Object testInstance) {
        Ensure.notNull("Plugin manager", pluginManager);
        Ensure.notNull("Test instance", testInstance);
        this.introspector = new Introspector(testInstance);
        this.pluginManager = pluginManager;
        LOGGER.debug((Object)"Creating new Test Context for test %s#%s", new Object[]{this.introspector.testClass().getName(), this.introspector.instance().hashCode()});
        Mycila.registerContext(this);
    }

    @Override
    public PluginManager<TestPlugin> pluginManager() {
        return this.pluginManager;
    }

    @Override
    public Introspector introspector() {
        return this.introspector;
    }

    @Override
    public Attributes attributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prepare() throws TestPluginException {
        try {
            ExecutionImpl execution = new ExecutionImpl(this, prepareMethod);
            Mycila.registerCurrentExecution(execution.changeStep(Step.PREPARE));
            LOGGER.debug((Object)"Calling 'prepareTestInstance' on plugins for test %s#%s...", new Object[]{this.introspector.testClass().getName(), this.introspector.instance().hashCode()});
            for (PluginBinding binding : this.pluginManager.getResolver().getResolvedPlugins()) {
                try {
                    ((TestPlugin)binding.getPlugin()).prepareTestInstance(this);
                }
                catch (Exception e) {
                    throw new TestPluginException(e, "An error occured while executing 'prepareTestInstance' on plugin '%s': %s: %s", binding.getName(), e.getClass().getSimpleName(), e.getMessage());
                    return;
                }
            }
        }
        finally {
            Mycila.unsetCurrentExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fireBeforeTest(Method method) throws TestPluginException {
        Ensure.notNull("Test method", method);
        TestExecutionImpl testExecution = new TestExecutionImpl(this, method);
        try {
            Mycila.registerCurrentExecution(testExecution.changeStep(Step.BEFORE));
            LOGGER.debug((Object)"Calling 'beforeTest' on plugins for test %s#%s...", new Object[]{this.introspector.testClass().getName(), this.introspector.instance().hashCode()});
            for (PluginBinding binding : this.pluginManager.getResolver().getResolvedPlugins()) {
                try {
                    ((TestPlugin)binding.getPlugin()).beforeTest(testExecution);
                }
                catch (Exception e) {
                    throw new TestPluginException(e, "An error occured while executing 'beforeTest' on plugin '%s': %s: %s", binding.getName(), e.getClass().getSimpleName(), e.getMessage());
                    return;
                }
            }
        }
        finally {
            Mycila.unsetCurrentExecution();
            Mycila.registerCurrentExecution(testExecution.changeStep(Step.TEST));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fireAfterTest() throws TestPluginException {
        try {
            TestExecutionImpl testExecution = (TestExecutionImpl)Mycila.currentExecution();
            Mycila.unsetCurrentExecution();
            Mycila.registerCurrentExecution(testExecution.changeStep(Step.AFTER));
            LOGGER.debug((Object)"Calling 'afterTest' on plugins for test %s#%s...", new Object[]{this.introspector.testClass().getName(), this.introspector.instance().hashCode()});
            for (PluginBinding binding : this.pluginManager.getResolver().getResolvedPlugins()) {
                try {
                    ((TestPlugin)binding.getPlugin()).afterTest(testExecution);
                }
                catch (Exception e) {
                    throw new TestPluginException(e, "An error occured while executing 'afterTest' on plugin '%s': %s: %s", binding.getName(), e.getClass().getSimpleName(), e.getMessage());
                    return;
                }
            }
        }
        finally {
            Mycila.unsetCurrentExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fireAfterClass() throws TestPluginException {
        try {
            ExecutionImpl execution = new ExecutionImpl(this, fireAfterClassMethod);
            Mycila.registerCurrentExecution(execution.changeStep(Step.COMPLETED));
            LOGGER.debug((Object)"Calling 'afterClass' on plugins for test %s#%s...", new Object[]{this.introspector.testClass().getName(), this.introspector.instance().hashCode()});
            for (PluginBinding binding : this.pluginManager.getResolver().getResolvedPlugins()) {
                try {
                    ((TestPlugin)binding.getPlugin()).afterClass(this);
                }
                catch (Exception e) {
                    throw new TestPluginException(e, "An error occured while executing 'afterClass' on plugin '%s': %s: %s", binding.getName(), e.getClass().getSimpleName(), e.getMessage());
                    return;
                }
            }
        }
        finally {
            Mycila.unsetCurrentExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            ExecutionImpl execution = new ExecutionImpl(this, shutdownMethod);
            Mycila.registerCurrentExecution(execution.changeStep(Step.SHUTDOWN));
            LOGGER.debug((Object)"Calling 'shutdown' on plugins for test %s#%s...", new Object[]{this.introspector.testClass().getName(), this.introspector.instance().hashCode()});
            for (PluginBinding binding : this.pluginManager.getResolver().getResolvedPlugins()) {
                try {
                    ((TestPlugin)binding.getPlugin()).shutdown(this);
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e, (Object)"An error occured while executing 'shutdown' on plugin %s: %s: %s", new Object[]{binding.getName(), e.getClass().getSimpleName(), e.getMessage()});
                }
            }
        }
        finally {
            Mycila.unsetCurrentExecution();
            Mycila.unsetContext(this);
        }
    }

    static {
        try {
            prepareMethod = TestNotifier.class.getDeclaredMethod("prepare", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            fireAfterClassMethod = TestNotifier.class.getDeclaredMethod("fireAfterClass", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            shutdownMethod = TestNotifier.class.getDeclaredMethod("shutdown", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        LOGGER = Loggers.get(TestContextImpl.class);
    }
}

