/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.core;

import com.mycila.testing.core.AttributesImpl;
import com.mycila.testing.core.api.Attributes;
import com.mycila.testing.core.api.Ensure;
import com.mycila.testing.core.api.Execution;
import com.mycila.testing.core.api.Step;
import com.mycila.testing.core.api.TestContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class ExecutionImpl
implements Execution {
    private final TestContext context;
    private final Method method;
    private Throwable throwable;
    private Step step = Step.UNKNOWN;
    private final Attributes attributes = new AttributesImpl();

    ExecutionImpl(TestContext context, Method method) {
        Ensure.notNull("Test context", context);
        Ensure.notNull("Test method", method);
        this.context = context;
        this.method = method;
    }

    public Attributes attributes() {
        return this.attributes;
    }

    final ExecutionImpl changeStep(Step step) {
        Ensure.notNull("Step", (Object)step);
        this.step = step;
        return this;
    }

    public final Step step() {
        return this.step;
    }

    public final Method method() {
        return this.method;
    }

    public final TestContext context() {
        return this.context;
    }

    public final Throwable throwable() {
        return this.throwable;
    }

    public final boolean hasFailed() {
        return this.throwable != null;
    }

    public void setThrowable(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        this.throwable = throwable;
    }
}

