/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.WhoisRecord;
import com.microsoft.graph.security.requests.WhoisRecordCollectionPage;
import com.microsoft.graph.security.requests.WhoisRecordCollectionRequestBuilder;
import com.microsoft.graph.security.requests.WhoisRecordCollectionResponse;
import com.microsoft.graph.security.requests.WhoisRecordRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WhoisRecordCollectionRequest
extends BaseEntityCollectionRequest<WhoisRecord, WhoisRecordCollectionResponse, WhoisRecordCollectionPage> {
    public WhoisRecordCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WhoisRecordCollectionResponse.class, WhoisRecordCollectionPage.class, WhoisRecordCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<WhoisRecord> postAsync(@Nonnull WhoisRecord newWhoisRecord) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WhoisRecordRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newWhoisRecord);
    }

    @Nonnull
    public WhoisRecord post(@Nonnull WhoisRecord newWhoisRecord) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WhoisRecordRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWhoisRecord);
    }

    @Nonnull
    public WhoisRecordCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public WhoisRecordCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public WhoisRecordCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public WhoisRecordCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public WhoisRecordCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public WhoisRecordCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public WhoisRecordCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public WhoisRecordCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public WhoisRecordCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

