/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.ant;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.ant.FlaggedOptionConfiguration;
import com.martiansoftware.jsap.ant.ParameterConfiguration;
import com.martiansoftware.jsap.ant.SwitchConfiguration;
import com.martiansoftware.jsap.ant.UnflaggedOptionConfiguration;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JSAPAntTask
extends Task {
    private boolean isPublic = false;
    private File srcDir = null;
    private String className = null;
    private Vector parameterConfigs = new Vector();
    private JSAP jsap = null;
    private boolean containsFlaggedOptions = false;
    private boolean containsUnflaggedOptions = false;
    private boolean containsSwitches = false;
    private boolean hasProperties = false;

    public void setPublic(boolean bl) {
        this.isPublic = bl;
    }

    public void setSrcdir(File file) {
        this.srcDir = file;
    }

    public void setClassname(String string) {
        this.className = string.trim();
    }

    public void addConfiguredFlaggedoption(FlaggedOptionConfiguration flaggedOptionConfiguration) {
        this.containsFlaggedOptions = true;
        this.parameterConfigs.add(flaggedOptionConfiguration);
    }

    public void addConfiguredUnflaggedoption(UnflaggedOptionConfiguration unflaggedOptionConfiguration) {
        this.containsUnflaggedOptions = true;
        this.parameterConfigs.add(unflaggedOptionConfiguration);
    }

    public void addConfiguredSwitch(SwitchConfiguration switchConfiguration) {
        this.containsSwitches = true;
        this.parameterConfigs.add(switchConfiguration);
    }

    private void buildJSAP() throws JSAPException {
        JSAP jSAP = new JSAP();
        Enumeration enumeration = this.parameterConfigs.elements();
        while (enumeration.hasMoreElements()) {
            ParameterConfiguration parameterConfiguration = (ParameterConfiguration)enumeration.nextElement();
            if (parameterConfiguration.hasProperties()) {
                this.hasProperties = true;
            }
            jSAP.registerParameter(parameterConfiguration.getParameter());
        }
    }

    private void writeJSAP() throws IOException {
        int n = this.className.lastIndexOf(".");
        String string = "";
        String string2 = this.className;
        if (n > -1) {
            string = this.className.substring(0, n);
            string2 = this.className.substring(n + 1);
        }
        System.out.println("package name: [" + string + "]");
        System.out.println("shortClassName: [" + string2 + "]");
        File file = new File(this.srcDir.getCanonicalPath() + File.separatorChar + string.replace('.', File.separatorChar));
        File file2 = new File(file, string2 + ".java");
        System.out.println("Creating directory \"" + file.toString() + "\"");
        file.mkdirs();
        System.out.println("Creating JSAP class file \"" + file2 + "\"");
        file2.createNewFile();
        System.out.println("Created");
        PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file2)));
        this.createJavaFile(string2, string, printStream);
        printStream.close();
    }

    private String properCase(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string.length() < 2 ? string.toUpperCase() : string.toUpperCase().charAt(0) + string.substring(1);
        }
        return string2;
    }

    private void createJavaFile(String string, String string2, PrintStream printStream) throws IOException {
        ParameterConfiguration parameterConfiguration;
        if (string2.length() > 0) {
            printStream.println("package " + string2 + ";");
            printStream.println();
        }
        printStream.println(" /*");
        printStream.println("  * THIS FILE IS AUTOMATICALLY GENERATED - DO NOT EDIT");
        printStream.println("  */");
        printStream.println();
        printStream.println("import com.martiansoftware.jsap.JSAP;");
        printStream.println("import com.martiansoftware.jsap.JSAPException;");
        if (this.containsSwitches) {
            printStream.println("import com.martiansoftware.jsap.Switch;");
        }
        if (this.containsFlaggedOptions) {
            printStream.println("import com.martiansoftware.jsap.FlaggedOption;");
        }
        if (this.containsUnflaggedOptions) {
            printStream.println("import com.martiansoftware.jsap.UnflaggedOption;");
        }
        if (this.hasProperties) {
            printStream.println("import com.martiansoftware.jsap.PropertyStringParser;");
        }
        printStream.println();
        if (this.isPublic) {
            printStream.print("public ");
        }
        printStream.println("class " + string + " extends JSAP {");
        printStream.println();
        printStream.println("    public " + string + "() {");
        printStream.println("        super();");
        printStream.println("        try {");
        printStream.println("            init();");
        printStream.println("        } catch (JSAPException e) {");
        printStream.println("            throw(new IllegalStateException(e.getMessage()));");
        printStream.println("        }");
        printStream.println("    }");
        printStream.println();
        printStream.println("    private void init() throws JSAPException {");
        Enumeration enumeration = this.parameterConfigs.elements();
        while (enumeration.hasMoreElements()) {
            parameterConfiguration = (ParameterConfiguration)enumeration.nextElement();
            printStream.println("        this.registerParameter( create" + this.properCase(parameterConfiguration.getId()) + "() );");
        }
        printStream.println("    }");
        printStream.println();
        enumeration = this.parameterConfigs.elements();
        while (enumeration.hasMoreElements()) {
            parameterConfiguration = (ParameterConfiguration)enumeration.nextElement();
            parameterConfiguration.createMethod("create" + this.properCase(parameterConfiguration.getId()), printStream);
            printStream.println();
        }
        printStream.println("}");
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir is required.");
        }
        if (this.className == null || this.className.length() == 0) {
            throw new BuildException("classname is required.");
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("srcdir must be a directory.");
        }
        System.out.println("srcDir=[" + this.srcDir + "]");
        System.out.println("className=[" + this.className + "]");
        System.out.println("public=" + this.isPublic);
        try {
            this.buildJSAP();
            this.writeJSAP();
        }
        catch (Exception exception) {
            throw new BuildException(exception.getMessage());
        }
    }
}

