/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.*;
import com.jurismarches.vradi.ui.offer.OfferEditUI;
import com.jurismarches.vradi.ui.renderers.ThesaurusHighlighter;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusSelectionManager;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_THESAURUS_MODEL = "thesaurus.model";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JLABEL0_TOOL_TIP_TEXT = "$JLabel0.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.ThesaurusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTree thesaurus;
    protected javax.swing.JList thesaurusSelected;
    protected ThesaurusUI thesaurusUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JScrollPane $JScrollPane1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected DefaultListModel thesaurusSelectedModel;
    protected ThesaurusSelectionManager manager;
    protected ThesaurusTreeHelper helper;
    protected boolean deletable;
    
    
    public  ThesaurusUI(JAXXContext parentContext, ThesaurusSelectionManager manager, ThesaurusTreeHelper helper, boolean deletable) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
        this.deletable = deletable;
        this.helper = helper;
        this.manager = manager;
    $initialize();
    }
    
    public OfferEditUI getParentUI(){
        return getParentContainer(OfferEditUI.class);
    }
    
    protected ThesaurusHandler getHandler() {
        return getContextValue(ThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public ThesaurusTreeHelper getHelper() {
        return helper;
    }
    
    void $afterCompleteSetup() {
    
        // Remove on double click
        thesaurusSelected.addMouseListener(new MouseAdapter(){
    
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Thesaurus toUnselect = (Thesaurus)thesaurusSelected.getSelectedValue();
                    manager.tryToUnSelect(toUnselect);
                }
            }
        });
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                JTree tree = (JTree) mouseEvent.getSource();
                TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
                // If node is selected
                boolean isSelected = path != null;
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
                    JPopupMenu popup = new JPopupMenu();
    
    //                JMenuItem menuAddCriteria = new JMenuItem();
    //                menuAddCriteria.setText(_("vradi.menu.addCriteria"));
    //                menuAddCriteria.addActionListener(new ActionListener() {
    
    //                    @Override
    //                    public void actionPerformed(ActionEvent actionEvent) {
    //                        addCriteriaSelected(getPathSelected(mouseEvent));
    //                    }
    //                });
    //                popup.add(menuAddCriteria);
    
    //                JMenuItem menuAddColumns = new JMenuItem();
    //                menuAddColumns.setText(_("vradi.menu.addColumns"));
    //                menuAddColumns.addActionListener(new ActionListener() {
    //
    //                    @Override
    //                    public void actionPerformed(ActionEvent actionEvent) {
    //                        addColumnSelected(getPathSelected(mouseEvent));
    //                    }
    //                });
    //                popup.add(menuAddColumns);
    
                    if (isSelected){
                        JMenuItem menuAddThesaurus = new JMenuItem();
                        menuAddThesaurus.setText(_("vradi.menu.addThesaurus"));
                        menuAddThesaurus.addActionListener(new ActionListener() {
    
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                addThesaurusSelected(getPathSelected(mouseEvent));
                            }
                        });
                        popup.add(menuAddThesaurus);
                    }
                    
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        UIHelper.addThesaurusExpandOnClickListener(thesaurus);
    
        TreeSelectionListener selectionListener = new TreeSelectionListener() {
    
            @Override
            public void valueChanged(TreeSelectionEvent e) {
                thsaurusSelected();
            }
        };
        thesaurus.addTreeSelectionListener(selectionListener);
    
        // Expends root
        thesaurus.expandRow(0);
    
        // Override default selection model to enable one click selection
        thesaurus.setSelectionModel(new DefaultTreeSelectionModel() {
    
            @Override
            public void setSelectionPath(TreePath path) {
                TreePath[] treePaths = getSelectionPaths();
                if (treePaths == null || !Arrays.asList(treePaths).contains(path)) {
                    addSelectionPath(path);
                } else {
                    removeSelectionPath(path);
                }
            }
        });
    
        // If not root thesaurusUI
        if (deletable) {
            manager.registerTreeHelper(helper, thesaurus);
        } else {
            manager.registerRootTreeHelper(helper, thesaurus);
        }
        
        // Tooltip is not active without this code...
        javax.swing.ToolTipManager.sharedInstance().registerComponent(thesaurus);
    }
    
    public DefaultListModel getThesaurusSelectedModel(){
        return thesaurusSelectedModel;
    }
    
    protected void thsaurusSelected(){
        TreePath[] treePaths = thesaurus.getSelectionPaths();
        jaxx.runtime.JAXXUtil.assignment(thesaurusSelectedModel = new DefaultListModel(), "thesaurusSelectedModel", com.jurismarches.vradi.ui.offer.ThesaurusUI.this);
        if (treePaths != null){
            for (TreePath path : treePaths){
                VradiTreeNode selected = (VradiTreeNode)path.getLastPathComponent();
                if (selected.getInternalClass().equals(Thesaurus.class)) {
                    Thesaurus thesaurusSelected = ThesaurusDataHelper.restoreThesaurus(selected.getId());
                    thesaurusSelectedModel.addElement(thesaurusSelected);
                }
    
            }
        }
        thesaurusSelected.setModel(thesaurusSelectedModel);
    }
    
    protected TreePath getPathSelected(MouseEvent mouseEvent){
        JTree tree = (JTree) mouseEvent.getSource();
    
        // Recuperation du path selectionne
        TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
        return path;
    }
    
    protected void addCriteriaSelected(TreePath path){
        log.debug("addCriteriaSelected " + path);
        // Ajout dun nouveau thesaurus
        getHandler().addCriteria(this, helper, path);
    }
    
    protected void addThesaurusSelected(TreePath path){
        log.debug("addThesaurusSelected " + path);
        // Ajout dun nouveau thesaurus
        getHandler().newThesaurusUI(this, manager, path);
    }
    
    protected void addColumnSelected(TreePath path){
        log.debug("addColumnSelected " + path);
        // Ajout dune nouvelle column
    //    getHandler().addColumn(this, helper, path);
    }
    
    protected String getRootNamePath(){
        String path = getHandler().getNamePath(helper.getRootNode());
        return StringUtils.abbreviate(path, path.length() - 20, 23);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusUI() {
        $initialize();
    }

    public ThesaurusUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().closeThesaurus(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTree getThesaurus() {
        return thesaurus;
    }

    public javax.swing.JList getThesaurusSelected() {
        return thesaurusSelected;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JButton0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void create$JButton0() {
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setBorderPainted(false);
        $JButton0.setFocusPainted(false);
        $JButton0.setHorizontalTextPosition(0);
        $JButton0.setOpaque(true);
        $JButton0.setVerticalAlignment(0);
        $JButton0.setVerticalTextPosition(0);
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new javax.swing.JTree());
        
        thesaurus.setName("thesaurus");
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    protected void createThesaurusSelected() {
        $objectMap.put("thesaurusSelected", thesaurusSelected = new javax.swing.JList());
        
        thesaurusSelected.setName("thesaurusSelected");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurusSelected);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(thesaurus);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        $JLabel0.setText(_(getRootNamePath()));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("closeTab"));
        $JButton0.setSize(new Dimension(16, 16));
        thesaurusSelected.setCellRenderer(new ThesaurusHighlighter());
        thesaurus.setCellRenderer(new ThesaurusHighlighter());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("thesaurusUI", this);
        thesaurusSelectedModel = new DefaultListModel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        create$JButton0();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurusSelected();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createThesaurus();
        // inline creation of thesaurusUI
        setName("thesaurusUI");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TOOL_TIP_TEXT, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    $JLabel0.setToolTipText(_(getHandler().getNamePath(helper.getRootNode())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"deletable") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(deletable);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_MODEL, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    thesaurus.setModel(helper.createTreeModel());
                }
            }
        });
    }

}