/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: RequestFormViewHandler.java 1883 2011-01-11 00:23:36Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/offer/RequestFormViewHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import com.jurismarches.vradi.ui.helpers.UIHelper;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

import com.jurismarches.vradi.ui.helpers.VradiComparators;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.nuiton.i18n.I18n;

import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;

/**
 * RequestFormViewHandler.
 *
 * @author schorlet
 * @version $Revision: 1883 $ $Date: 2011-01-11 01:23:36 +0100 (mar., 11 janv. 2011) $
 * @since 19 mars 2010 14:42:03
 */
public class RequestFormViewHandler {
    private static Log log = LogFactory.getLog(RequestFormViewHandler.class);
    
    private VradiStorageService vradiStorageService;

    protected VradiStorageService getVradiStorageService() {
        if (vradiStorageService == null) {
            vradiStorageService = VradiService.getVradiStorageService();
        }
        return vradiStorageService;
    }
    
    public RequestFormViewUI initUI(JAXXContext rootContext, Map<Group, List<QueryBean>> queries) {
        JAXXInitialContext context = new JAXXInitialContext().add(rootContext).add(this);
        context.add("queries", queries);
        
        RequestFormViewUI requestFormViewUI = new RequestFormViewUI(context);
        JXTreeTable resultTreeTable = requestFormViewUI.getResultTreeTable();
        JXTable resultTable = requestFormViewUI.getResultTable();
        resultTreeTable.expandAll();
        
        Highlighter highlighter = HighlighterFactory.createAlternateStriping(
        HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        resultTable.addHighlighter(highlighter);
        resultTreeTable.addHighlighter(highlighter);
    
        return requestFormViewUI;
    }

    public TableModel getResultTableModel(RequestFormViewUI context) {
        QueryTableModel tableModel = context.getContextValue(QueryTableModel.class);
        if (tableModel == null) {
            Map<Group, List<QueryBean>> queries = context.getContextValue(Map.class, "queries");
            tableModel = new QueryTableModel(queries);
            context.setContextValue(tableModel);
            
            final JXTable resultTable = context.getResultTable();
            tableModel.addTableModelListener(new TableModelListener() {
                @Override
                public void tableChanged(TableModelEvent e) {
                    resultTable.packAll();
                }
            });
        }
        return tableModel;
    }
    
    public TreeTableModel getResultTreeTableModel(RequestFormViewUI context) {
        QueryTreeTableModel treeTableModel = context.getContextValue(QueryTreeTableModel.class);
        if (treeTableModel == null) {
            Map<Group, List<QueryBean>> queries = context.getContextValue(Map.class, "queries");
            treeTableModel = new QueryTreeTableModel(queries);
            context.setContextValue(treeTableModel);
            
            JXTreeTable resultTreeTable = context.getResultTreeTable();
            QueryTreeTableModelListener treeModelListener = new QueryTreeTableModelListener(resultTreeTable);
            treeTableModel.addTreeModelListener(treeModelListener);
        }
        return treeTableModel;
    }
    
    void close(RequestFormViewUI context) {
        context.setVisible(false);
        UIHelper.saveComponentDispositionConfig();
        context.dispose();
    }
    
    class QueryTreeTableModelListener implements TreeModelListener {
        final JXTreeTable treeTable;

        public QueryTreeTableModelListener(JXTreeTable treeTable) {
            this.treeTable = treeTable;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }
        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }
        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }
        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            treeTable.packAll();
        }
    }
    
    class QueryTreeTableModel extends AbstractTreeTableModel {
        /** clients and groups */
        final ArrayList<Group> topLevels = new ArrayList<Group>();
        
        /** queries indexed by wikittyId */
        final HashMap<String, List<QueryBean>> queryBeanMap = new HashMap<String, List<QueryBean>>();
        
        public QueryTreeTableModel(Map<Group, List<QueryBean>> queryMap) {
            super(1L);

            HashMap<String, Group> groupMap = new HashMap<String, Group>();

            for (Map.Entry<Group, List<QueryBean>> entry : queryMap.entrySet()) {
                Group group = entry.getKey();
                List<QueryBean> queries = entry.getValue();
                
                String wikittyId = group.getWikittyId();

                // client
                groupMap.put(wikittyId, group);
                
                // queries
                queryBeanMap.put(wikittyId, queries);
            }
            List<Group> groupList = new ArrayList<Group>(groupMap.values());

            Collections.sort(groupList, VradiComparators.GROUP_COMPARATOR);

            topLevels.addAll(groupList);
        }
        
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(Object node, int column) {
            if (node instanceof Group) {
                if (column == 0) {
                    Group group = (Group) node;
                    return group.getName();
                }
                
            } else if (node instanceof QueryBean) {
                QueryBean bean = (QueryBean) node;
                if (column == 0) {
                    return bean.getName();
                    
                } else if (column == 1) {
                    return bean.getDescription();
                    
                } else if (column == 2) {
                    return bean.getQuery();
                }
            }
            
            return null;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof Long) {
                return topLevels.get(index);
                
            } else if (parent instanceof Group) {
                Group group = (Group) parent;
                List<QueryBean> list = queryBeanMap.get(group.getWikittyId());
                QueryBean bean = list.get(index);
                return bean;
            }
            
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof Long) {
                return topLevels.size();
                
            } else if (parent instanceof Group) {
                Group group = (Group) parent;
                List<QueryBean> list = queryBeanMap.get(group.getWikittyId());
                return list.size();
            }
            
            return 0;
        }
        
        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof Long) {
                return topLevels.indexOf(child);
                
            } else if (parent instanceof Group) {
                Group group = (Group) parent;
                List<QueryBean> list = queryBeanMap.get(group.getWikittyId());
                return list.indexOf(child);
            }
            
            return 0;
        }
        
        @Override
        public String getColumnName(int column) {
            String columnName = null;
            if (column == 0) {
                columnName = I18n._("vradi.requestFormView.resultTable.name");
            } else if (column == 1) {
                columnName = I18n._("vradi.requestFormView.resultTable.description");
            } else if (column == 2) {
                columnName = I18n._("vradi.requestFormView.resultTable.query");
            }
            return columnName;
        }
    }
    
    /**
     * QueryTableModel.
     */
    class QueryTableModel extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        final QueryBean[] queries;
        
        public QueryTableModel(Map<Group, List<QueryBean>> queryMap) {
            HashSet<QueryBean> querySet = new HashSet<QueryBean>();
            Collection<List<QueryBean>> lists = queryMap.values();
            
            for (List<QueryBean> list : lists) {
                querySet.addAll(list);
            }
            
            queries = new QueryBean[querySet.size()];
            querySet.toArray(queries);
        }
        
        @Override
        public String getColumnName(int column) {
            String columnName = null;
            if (column == 0) {
                columnName = I18n._("vradi.requestFormView.resultTable.name");
            } else if (column == 1) {
                columnName = I18n._("vradi.requestFormView.resultTable.description");
            } else if (column == 2) {
                columnName = I18n._("vradi.requestFormView.resultTable.query");
            }
            return columnName;
        }
        
        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            /*
             * columnIndex  | Model         |  VradiQueryBean
             * -------------+---------------+------------------
             * 0            | name          | query
             * 1            | description   | name
             * 2            | query         | description
             */
            QueryBean queryBean = queries[rowIndex];
            String[] queryArray = queryBean.toArray();
            
            if (columnIndex < 2) {
                return queryArray[columnIndex + 1];
            } else {
                return queryArray[0];
            }
        }
        
        @Override
        public int getRowCount() {
            return queries.length;
        }
        
        @Override
        public int getColumnCount() {
            return 3;
        }
    }
}
