/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.email.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferListColumnFactory;
import com.jurismarches.vradi.ui.offer.OfferTable;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.wikitty.WikittyProxy;
import static com.jurismarches.vradi.VradiConstants.SendingStatus;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class SendingViewUI extends com.jurismarches.vradi.ui.email.EmailContentUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_SESSION = "session";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DESCRIPTION_FIELD_TEXT = "descriptionField.text";
    public static final String BINDING_RECEPTION_PROOF_FIELD_SELECTED = "receptionProofField.selected";
    public static final String BINDING_STATUS_FIELD_TEXT = "statusField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWQW8bRRTHJyZ24gaHtKZpoGkVWkuVKrpOggBBQkljEpLIpVGcRlV9Ybw7sSeMd5aZ2WbTA+Ij8BHgzgWJGyfEgTMHLoivgBAHrog3s86uN13bqzqHdXbee7/9z5s3b+b7v1BeCvTWCQ4CS/iuol1i7T148uRR64TY6hMibUE9xQUK/yZyKNdEM040LhW63azr8GovvFrjXY+7xO2LXqujS1KdMSI7hCiFbiQjbCmrjci8Fni+OKdGotKo3/7zd+4b5+vvcggFHqhbgKksjYqKZzJZRznqKHQFvvQMVxl22yBDULcNekt6rMawlJ/hLvkSfYWm6qjgYQEwhW5ln7JhmPjAU2iustXFlNW4q8D98e6yQvds3rVOfEFlFwu7Q6T1TGCHWj61iPa1GsR1QNQRJaePdz3PwAoKzfPjYyLqVKoaZ37X3cY2fPdMofcGA02I9Sg1MCaXI/IhbjHykDuEKfThKGxX+8mYHgfH6MkWwa5CdwawICdUUXjtzTkOnJJESsqzxRrPOLZU2WvYgjO2j10CGb+m1zaw5Cl8weozafdiFDVd2dODDAKuJALMqHZaiNVVzGTBdSFRf2GEsWnP61FAHrQycpFcx62QfPMFFSv6/UbSNiMhS71MwaolUJu+UtxN+pcqO9ThIjSB1pspWvs80oWsRkLi2czKUESvrPXokn68fTFBK5HJ6gebeS/r99v6sdw3Q4WVL7cpYU6KuSyITTwFi70vOD82bgpdTSSi1iH2F5s8SEb29KwO0bMSffCD9EoyDm8mHebOWyNoSpVzSAL1QBCs/T9K565G3Dh/RXa+oRS6m2l/R0W36UFbvJ5Yami4Vtxw44440UR54cMw1HHzxR59AKawOy9c6M4aaKz/zZd//+nPH7f7W/LVVNe+EwVapSe4R4Tevgq9FvZjX1FWfYi9tSYqSsKIHR43iynCGj0ziIPvXdbhlg63drDsACI/9cfPv8x//tsrKLeNLjGOnbDn7aKi6gjIAmdO4H28YRS9ejoNzzmtTaECw2ccdgOaXXewwkstagr9fgBJWExJQqSkVfz133Ljh43zREyAsDcGusfJyD9FBeoy6hJzOvUOntTTaMaTxHd4fMCkHTkT+nfR6zXDunnup810UkFlamsj8PXPoRGt/zsyjFtZGNQO28YAxp0MjCni6sp1xsLo4afQXdfDVC5hBed6y1fk/hjCOtQhh9QbIuxuFgxU2+n4mILCok2GLVgWSimkHFFJe93ipWF6+GAI4V62RdMPmk54JzthgIZ3M6RkOuw1Qwvw/bHnMj5hfexsbGTIxiz2FT8gkj43N7khtK0MtNdtc+HU1wQ47EZXXRZmye6/xI4JKx9TxqS+aXtcqB1C251hWywLstgW1IGLNhdjgq51uKDPIXWYhXeFrZGNMgs2b67tY0KmdVP7VNBRYv4H3vLyVHAOAAA=";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.SendingViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Sending bean;
    protected javax.swing.JTextArea descriptionField;
    protected com.jurismarches.vradi.ui.offer.OfferTable listTable;
    protected com.jurismarches.vradi.ui.offer.OfferListColumnFactory offerListColumnFactory;
    protected com.jurismarches.vradi.ui.offer.models.OfferListTableModel offerListTableModel;
    protected javax.swing.JCheckBox receptionProofField;
    protected javax.swing.JButton sendSending;
    protected jaxx.runtime.swing.Table sendingContent;
    protected com.jurismarches.vradi.entities.Session session;
    protected javax.swing.JLabel statusField;
    protected javax.swing.JLabel title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SendingViewUI $EmailContentUI0 = this;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JPanel $JPanel0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JPanel $JPanel1;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JPanel $JPanel2;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel0;
    private jaxx.runtime.swing.Table $Table2;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JScrollPane $JScrollPane1;
    private javax.swing.JScrollPane $JScrollPane2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected EmailNavigationTreeHelper helper;
    
    
    @Override
    public void openUI(VradiTreeNode node) {
        getHandler().displaySession(this, getHelper(), node);
    }
    
    public void setHelper(EmailNavigationTreeHelper helper){
        this.helper = helper;
    }
    
    public EmailNavigationTreeHelper getHelper(){
        if (helper != null){
            return helper;
        }
        jaxx.runtime.JAXXUtil.assignment(helper = getContextValue(EmailNavigationTreeHelper.class), "helper", com.jurismarches.vradi.ui.email.SendingViewUI.this);
        if (helper != null){
            return helper;
        }
        return getParentContainer(EmailPopupUI.class).helper;
    }
    
    protected EmailHandler getHandler() {
        return UIHelper.getHandler(this, EmailHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public void init() {
        title.setText(updateTitle());
        sendSending.setEnabled(canBeReSend());
    }
    
    protected String updateTitle() {
        if (getBean() == null){
            return "";
        }
        String title = "";
        WikittyProxy proxy = VradiService.getWikittyProxy();
        String userId = getBean().getUser();
        if (userId != null){
            User user = proxy.restore(User.class, userId);
            if (user != null) {
                title = _("vradi.email.titleUser", user.getName());
            }
        }
        return title;
    }
    
    protected boolean canBeReSend(){
        if (getBean() == null){
            return false;
        }
        return SendingStatus.isSent(getBean());
    }
    
    public boolean isNotClosed() {
        if (getBean() == null) {
            return false;
        }
        return !SendingStatus.isClosed(getBean());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SendingViewUI() {
        super();
        $initialize();
    }

    public SendingViewUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__receptionProofField(java.awt.event.ActionEvent event) {
        getHandler().updateReceptionProof(getBean(),                                                         receptionProofField.isSelected());
    }

    public void doActionPerformed__on__sendSending(java.awt.event.ActionEvent event) {
        getHandler().sendSending(this, getBean());
    }

    public void doFocusLost__on__descriptionField(java.awt.event.FocusEvent event) {
        getHandler().updateParagraph(getBean(),                                                          getBean().getParagraph());
    }

    public void doKeyReleased__on__descriptionField(java.awt.event.KeyEvent event) {
        getBean().setParagraph(descriptionField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Sending getBean() {
        return bean;
    }

    public javax.swing.JTextArea getDescriptionField() {
        return descriptionField;
    }

    public com.jurismarches.vradi.ui.offer.OfferTable getListTable() {
        return listTable;
    }

    public com.jurismarches.vradi.ui.offer.OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public com.jurismarches.vradi.ui.offer.models.OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public javax.swing.JCheckBox getReceptionProofField() {
        return receptionProofField;
    }

    public javax.swing.JButton getSendSending() {
        return sendSending;
    }

    public jaxx.runtime.swing.Table getSendingContent() {
        return sendingContent;
    }

    public com.jurismarches.vradi.entities.Session getSession() {
        return session;
    }

    public javax.swing.JLabel getStatusField() {
        return statusField;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Sending newValue) {
        com.jurismarches.vradi.entities.Sending oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setSession(com.jurismarches.vradi.entities.Session newValue) {
        com.jurismarches.vradi.entities.Session oldValue = this.session;
        this.session = newValue;
        firePropertyChange(PROPERTY_SESSION, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected javax.swing.JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSendingContent() {
        if (!allComponentsCreated) {
            return;
        }
        sendingContent.add($Table1, new GridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        sendingContent.add($Table2, new GridBagConstraints(0, 1, 1, 1, 0.8, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createDescriptionField() {
        $objectMap.put("descriptionField", descriptionField = new javax.swing.JTextArea());
        
        descriptionField.setName("descriptionField");
        descriptionField.setColumns(15);
        descriptionField.setLineWrap(true);
        descriptionField.setWrapStyleWord(true);
        descriptionField.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__descriptionField"));
        descriptionField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__descriptionField"));
    }

    protected void createListTable() {
        $objectMap.put("listTable", listTable = new com.jurismarches.vradi.ui.offer.OfferTable());
        
        listTable.setName("listTable");
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = new com.jurismarches.vradi.ui.offer.OfferListColumnFactory());
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = new com.jurismarches.vradi.ui.offer.models.OfferListTableModel(true));
    }

    protected void createReceptionProofField() {
        $objectMap.put("receptionProofField", receptionProofField = new javax.swing.JCheckBox());
        
        receptionProofField.setName("receptionProofField");
        receptionProofField.setText(_("vradi.email.receptionProof"));
        receptionProofField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__receptionProofField"));
    }

    protected void createSendSending() {
        $objectMap.put("sendSending", sendSending = new javax.swing.JButton());
        
        sendSending.setName("sendSending");
        sendSending.setText(_("vradi.email.sendSending"));
        sendSending.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sendSending"));
    }

    protected void createSendingContent() {
        $objectMap.put("sendingContent", sendingContent = new jaxx.runtime.swing.Table());
        
        sendingContent.setName("sendingContent");
    }

    protected void createSession() {
        $objectMap.put("session", session = null);
    }

    protected void createStatusField() {
        $objectMap.put("statusField", statusField = new javax.swing.JLabel());
        
        statusField.setName("statusField");
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $EmailContentUI0
        add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($JPanel0);
        // inline complete setup of $JPanel0
        $JPanel0.add($Table0, BorderLayout.NORTH);
        $JPanel0.add($JPanel2, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add(title, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sendSending, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($HidorButton0, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel2
        $JPanel2.add(sendingContent, BorderLayout.NORTH);
        $JPanel2.add($JScrollPane2, BorderLayout.CENTER);
        addChildrenToSendingContent();
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(statusField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(receptionProofField, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(descriptionField);
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(listTable);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        title.setText(_(updateTitle()));
        sendSending.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("send"));
        sendSending.setEnabled(canBeReSend());
        $HidorButton0.setHideTip(_("vradi.email.hideForm"));
        $HidorButton0.setShowTip(_("vradi.email.showForm"));
        $HidorButton0.setTarget(sendingContent);
        $HidorButton0.setTargetVisible(true);
        listTable.setAutoResizeMode(2);
        listTable.setColumnControlVisible(true);
        listTable.setColumnFactory(offerListColumnFactory);
        listTable.setFillsViewportHeight(true);
        listTable.setGridColor(Color.GRAY);
        listTable.setHorizontalScrollEnabled(true);
        listTable.setModel(offerListTableModel);
        listTable.setShowGrid(true);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$EmailContentUI0", this);
        createOfferListColumnFactory();
        createOfferListTableModel();
        createBean();
        createSession();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        createTitle();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        createSendSending();
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        
        $HidorButton0.setName("$HidorButton0");
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new javax.swing.JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        createSendingContent();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.status"));
        createStatusField();
        createReceptionProofField();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.email.paragraph"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createDescriptionField();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new javax.swing.JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_NEVER,                                                 JScrollPane.HORIZONTAL_SCROLLBAR_NEVER));
        
        $JScrollPane2.setName("$JScrollPane2");
        createListTable();
        // inline creation of $EmailContentUI0
        setName("$EmailContentUI0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATUS_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("status", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    statusField.setText(_(VradiConstants.SendingStatus.getStatus(getBean().getStatus()).getDescription()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("status", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RECEPTION_PROOF_FIELD_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("receptionProof", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    receptionProofField.setSelected(getBean().getReceptionProof());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("receptionProof", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESCRIPTION_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("paragraph", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(descriptionField, getBean().getParagraph());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("paragraph", this);
                }
            }
        });
    }

}