/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.renderers.ThesaurusHighlighter;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusPathChooserUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SAVED = "saved";
    public static final String PROPERTY_SELECTED = "selected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SELECT_ENABLED = "select.enabled";
    public static final String BINDING_THESAURUS_TREE_TABLE_MODEL = "thesaurus.treeTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.ThesaurusPathChooserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton cancel;
    protected java.lang.Boolean saved;
    protected javax.swing.JButton select;
    protected java.lang.Boolean selected;
    protected org.jdesktop.swingx.JXTreeTable thesaurus;
    protected ThesaurusPathChooserUI thesaurusPathChooserUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ThesaurusTreeTableHelper helper;
    
    
    public  ThesaurusPathChooserUI(jaxx.runtime.JAXXContext parentContext, ThesaurusTreeTableHelper helper) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
        this.helper = helper;
    $initialize();
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected ThesaurusTreeTableHelper getHelper() {
        return helper;
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        thesaurus.putClientProperty("JTree.lineStyle", "Angled");
    
        TreeSelectionListener listener = new TreeSelectionListener(){
    
            @Override
            public void valueChanged(TreeSelectionEvent e) {
    
                // Get selcted node
                VradiTreeTableNode selectedNode = helper.getSelectedNode();
    
                // Set as selected
                setSelected(selectedNode != null);
            }
        };
    
        // Register tree table
        helper.setUI(thesaurus, true, false, listener);
        
        UIHelper.addThesaurusExpandOnClickListener(thesaurus);
    
        // Render
        thesaurus.setTreeCellRenderer(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.MOVE));
    
        this.pack();
    
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
        
    protected void close(){
        UIHelper.saveComponentDispositionConfig();
        setVisible(false);
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusPathChooserUI() {
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__select(java.awt.event.ActionEvent event) {
        setSaved(true);close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public java.lang.Boolean getSaved() {
        return saved;
    }

    public javax.swing.JButton getSelect() {
        return select;
    }

    public java.lang.Boolean getSelected() {
        return selected;
    }

    public org.jdesktop.swingx.JXTreeTable getThesaurus() {
        return thesaurus;
    }

    public java.lang.Boolean isSaved() {
        return saved !=null && saved;
    }

    public java.lang.Boolean isSelected() {
        return selected !=null && selected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setSaved(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.saved;
        this.saved = newValue;
        firePropertyChange(PROPERTY_SAVED, oldValue, newValue);
    }

    public void setSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selected;
        this.selected = newValue;
        firePropertyChange(PROPERTY_SELECTED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusPathChooserUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createSaved() {
        $objectMap.put("saved", saved = false);
    }

    protected void createSelect() {
        $objectMap.put("select", select = new javax.swing.JButton());
        
        select.setName("select");
        select.setText(_("vradi.common.select"));
        select.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__select"));
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new org.jdesktop.swingx.JXTreeTable());
        
        thesaurus.setName("thesaurus");
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusPathChooserUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(select, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        thesaurus.setHighlighters(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.MOVE));
        cancel.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        select.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("select"));
        // late initializer
        thesaurusPathChooserUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("thesaurusPathChooserUI", this);
        createSelected();
        createSaved();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminThesaurus.selectAsk"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        createCancel();
        createSelect();
        // inline creation of thesaurusPathChooserUI
        setName("thesaurusPathChooserUI");
        thesaurusPathChooserUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminThesaurus.select"));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_TREE_TABLE_MODEL, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    thesaurus.setTreeTableModel(helper.createTreeModel());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECT_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                select.setEnabled(isSelected());
            }
        });
    }

}