/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.task;

import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.task.AbstractProgressBarUI;
import com.jurismarches.vradi.ui.task.ProgressBarUI;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JFrame;
import javax.swing.SwingWorker;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public abstract class VradiTask<T>
extends SwingWorker<T, Void> {
    private static final Log log = LogFactory.getLog(VradiTask.class);
    protected JAXXContext context;
    protected String i18nKey;
    protected AbstractProgressBarUI pb = null;
    protected boolean showErrorDialog = true;

    public VradiTask(JAXXContext context) {
        this.context = context;
        this.i18nKey = null;
        this.pb = new ProgressBarUI(context);
    }

    public VradiTask(JAXXContext context, boolean showProgressBar) {
        this.context = context;
        this.i18nKey = null;
        if (showProgressBar) {
            this.pb = new ProgressBarUI(context);
        }
    }

    public VradiTask(JAXXContext context, String i18nKey) {
        this.context = context;
        this.i18nKey = i18nKey;
        this.pb = new ProgressBarUI(context);
    }

    public VradiTask(JAXXContext context, boolean showProgressBar, String i18nKey) {
        this.context = context;
        this.i18nKey = i18nKey;
        if (showProgressBar) {
            this.pb = new ProgressBarUI(context);
        }
    }

    public VradiTask(JAXXContext context, AbstractProgressBarUI pb, String i18nKey) {
        this.context = context;
        this.i18nKey = i18nKey;
        this.pb = pb;
    }

    public VradiTask(JAXXContext context, AbstractProgressBarUI pb, String i18nKey, boolean showErrorDialog) {
        this.context = context;
        this.i18nKey = i18nKey;
        this.pb = pb;
        this.showErrorDialog = showErrorDialog;
    }

    @Override
    protected T doInBackground() {
        Component component = (Component)this.context;
        component.setCursor(Cursor.getPredefinedCursor(3));
        if (this.pb != null) {
            JFrame frame;
            if (this.i18nKey != null) {
                this.pb.setTitle(this.getTitleMsg());
                this.pb.setMsg(this.getMsg());
            }
            if ((frame = (JFrame)this.context.getContextValue(JFrame.class, "parent")) != null) {
                SwingUtil.center((Component)frame, (Component)this.pb);
            } else {
                SwingUtil.center((Component)component, (Component)this.pb);
            }
            this.pb.pack();
            this.pb.setVisible(true);
            UIHelper.registerComponentToSaveDispositionConfig(this.pb);
        }
        try {
            return this.doAction();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)this.getErrorMsg(), (Throwable)eee);
                if (this.showErrorDialog) {
                    ErrorDialogUI.showError((Exception)eee);
                }
                this.doWhenError(eee);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done() {
        try {
            this.doWhenDone();
        }
        catch (Exception eee) {
            log.error((Object)this.getErrorMsg(), (Throwable)eee);
            if (this.showErrorDialog) {
                ErrorDialogUI.showError((Exception)eee);
            }
        }
        finally {
            if (this.pb != null) {
                this.pb.dispose();
            }
            ((Component)this.context).setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected String getTitleMsg() {
        return I18n._(this.i18nKey + ".title");
    }

    protected String getMsg() {
        return I18n._(this.i18nKey + ".msg");
    }

    protected String getErrorMsg() {
        if (this.i18nKey != null) {
            return I18n._(this.i18nKey + ".error");
        }
        return I18n._("vradi.error.executeTask");
    }

    public abstract T doAction() throws Exception;

    public void doWhenDone() throws Exception {
    }

    public void doWhenError(Exception eee) {
    }
}

