/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.ui.admin.popups.ThesaurusQueryChangesUI;
import com.jurismarches.vradi.ui.admin.query.QueryCellEditor;
import com.jurismarches.vradi.ui.admin.query.QueryCheckCellRenderer;
import com.jurismarches.vradi.ui.admin.query.ThesaurusChangesTreeTableModel;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.table.TableColumn;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class ThesaurusQueryChangesHandler {
    public static final String QUERY = "query";
    public static final String ROOT_BEFORE_MODIF = "rootBeforeModif";
    public static final String THESAURUS_BEFORE_MODIF = "thesaurusBeforeModif";
    public static final String ROOT_AFTER_MODIF = "rootAfterModif";
    public static final String THESAURUS_AFTER_MODIF = "thesaurusAfterModif";

    public ThesaurusQueryChangesUI initUI(JAXXContext rootContext, Map<Group, List<QueryBean>> queries, String rootThesaurusBefore, String rootThesaurusAfter, String thesaurusBefore, String thesaurusAfter) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
        context.add(QUERY, queries);
        context.add(ROOT_BEFORE_MODIF, (Object)rootThesaurusBefore);
        context.add(ROOT_AFTER_MODIF, (Object)rootThesaurusAfter);
        if (thesaurusAfter != null) {
            context.add(THESAURUS_AFTER_MODIF, (Object)thesaurusAfter);
            context.add(THESAURUS_BEFORE_MODIF, (Object)thesaurusBefore);
        }
        ThesaurusQueryChangesUI thesaurusChangesUI = new ThesaurusQueryChangesUI((JAXXContext)context);
        JXTreeTable resultTreeTable = thesaurusChangesUI.getResultTreeTable();
        resultTreeTable.expandAll();
        TableColumn column = resultTreeTable.getColumnModel().getColumn(3);
        column.setCellEditor(new QueryCellEditor(rootContext));
        column = resultTreeTable.getColumnModel().getColumn(4);
        QueryCheckCellRenderer checkBox = new QueryCheckCellRenderer();
        column.setCellRenderer(checkBox);
        column.setCellEditor(new DefaultCellEditor(checkBox));
        column.setMaxWidth((int)checkBox.getPreferredSize().getWidth());
        Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.NOTEPAD, (Color)HighlighterFactory.GENERIC_GRAY);
        resultTreeTable.addHighlighter(highlighter);
        return thesaurusChangesUI;
    }

    void close(ThesaurusQueryChangesUI context) {
        context.setVisible(false);
        context.dispose();
    }

    public TreeTableModel getResultTreeTableModel(ThesaurusQueryChangesUI context) {
        ThesaurusChangesTreeTableModel treeTableModel = context.getContextValue(ThesaurusChangesTreeTableModel.class);
        if (treeTableModel == null) {
            Map queries = context.getContextValue(Map.class, QUERY);
            String rootThesaurusBefore = context.getContextValue(String.class, ROOT_BEFORE_MODIF);
            String rootThesaurusAfter = context.getContextValue(String.class, ROOT_AFTER_MODIF);
            String thesaurusBefore = context.getContextValue(String.class, THESAURUS_BEFORE_MODIF);
            String thesaurusAfter = context.getContextValue(String.class, THESAURUS_AFTER_MODIF);
            treeTableModel = new ThesaurusChangesTreeTableModel(queries, rootThesaurusBefore, rootThesaurusAfter, thesaurusBefore, thesaurusAfter);
            context.setContextValue(treeTableModel);
        }
        return treeTableModel;
    }
}

