/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SystemProperty
extends SystemFunction
implements XSLTFunction {
    private NamespaceResolver nsContext;
    private transient boolean checked = false;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(staticContext);
        if (!(this.argument[0] instanceof StringValue)) {
            this.nsContext = staticContext.getNamespaceResolver();
        }
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        CharSequence charSequence = ((StringValue)this.argument[0]).getStringValueCS();
        try {
            String[] stringArray = staticContext.getConfiguration().getNameChecker().getQNameParts(charSequence);
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = string.equals("") ? "" : staticContext.getURIForPrefix(string);
            return new StringValue(SystemProperty.getProperty(string3, string2, staticContext.getConfiguration()));
        }
        catch (QNameException qNameException) {
            throw new StaticError("Invalid system property name. " + qNameException.getMessage());
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        CharSequence charSequence = this.argument[0].evaluateItem(xPathContext).getStringValueCS();
        try {
            String[] stringArray = xPathContext.getConfiguration().getNameChecker().getQNameParts(charSequence);
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = string.equals("") ? "" : this.nsContext.getURIForPrefix(string, false);
            return new StringValue(SystemProperty.getProperty(string3, string2, xPathContext.getConfiguration()));
        }
        catch (QNameException qNameException) {
            this.dynamicError("Invalid system property name. " + qNameException.getMessage(), "XTDE1390", xPathContext);
            return null;
        }
    }

    public static String getProperty(String string, String string2, Configuration configuration) {
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string2.equals("version")) {
                return Version.getXSLVersionString();
            }
            if (string2.equals("vendor")) {
                return Version.getProductTitle();
            }
            if (string2.equals("vendor-url")) {
                return Version.getWebSiteAddress();
            }
            if (string2.equals("product-name")) {
                return Version.getProductName();
            }
            if (string2.equals("product-version")) {
                return configuration.isSchemaAware(50) ? Version.getSchemaAwareProductVersion() : Version.getProductVersion();
            }
            if (string2.equals("is-schema-aware")) {
                return configuration.isSchemaAware(50) ? "yes" : "no";
            }
            if (string2.equals("supports-serialization")) {
                return "yes";
            }
            if (string2.equals("supports-backwards-compatibility")) {
                return "yes";
            }
            return "";
        }
        if (string.equals("")) {
            String string3 = System.getProperty(string2);
            if (string3 == null) {
                string3 = "";
            }
            return string3;
        }
        return "";
    }
}

