/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Searcher;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class ScaleFloatFunction
extends ValueSource {
    protected final ValueSource source;
    protected final float min;
    protected final float max;

    public ScaleFloatFunction(ValueSource source, float min, float max) {
        this.source = source;
        this.min = min;
        this.max = max;
    }

    public String description() {
        return "scale(" + this.source.description() + "," + this.min + "," + this.max + ")";
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues vals = this.source.getValues(context, reader);
        int maxDoc = reader.maxDoc();
        float minVal = 0.0f;
        float maxVal = 0.0f;
        if (maxDoc > 0) {
            minVal = maxVal = vals.floatVal(0);
        }
        for (int i = 0; i < maxDoc; ++i) {
            float val = vals.floatVal(i);
            if ((Float.floatToRawIntBits(val) & 0x7F800000) == 2139095040) continue;
            if (val < minVal) {
                minVal = val;
                continue;
            }
            if (!(val > maxVal)) continue;
            maxVal = val;
        }
        final float scale = maxVal - minVal == 0.0f ? 0.0f : (this.max - this.min) / (maxVal - minVal);
        final float minSource = minVal;
        final float maxSource = maxVal;
        return new DocValues(){

            public float floatVal(int doc) {
                return (vals.floatVal(doc) - minSource) * scale + ScaleFloatFunction.this.min;
            }

            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            public String toString(int doc) {
                return "scale(" + vals.toString(doc) + ",toMin=" + ScaleFloatFunction.this.min + ",toMax=" + ScaleFloatFunction.this.max + ",fromMin=" + minSource + ",fromMax=" + maxSource + ")";
            }
        };
    }

    public void createWeight(Map context, Searcher searcher) throws IOException {
        this.source.createWeight(context, searcher);
    }

    public int hashCode() {
        int h = Float.floatToIntBits(this.min);
        h *= 29;
        h += Float.floatToIntBits(this.max);
        h *= 29;
        return h += this.source.hashCode();
    }

    public boolean equals(Object o) {
        if (ScaleFloatFunction.class != o.getClass()) {
            return false;
        }
        ScaleFloatFunction other = (ScaleFloatFunction)o;
        return this.min == other.min && this.max == other.max && this.source.equals(other.source);
    }
}

