/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.definition;

import java.util.Iterator;
import java.util.List;
import org.webharvest.definition.BaseElementDef;
import org.webharvest.definition.DefinitionResolver;
import org.webharvest.definition.IElementDef;
import org.webharvest.definition.IfDef;
import org.webharvest.definition.XmlNode;

public class CaseDef
extends BaseElementDef {
    private IfDef[] ifDefs;
    private BaseElementDef elseDef;

    public CaseDef(XmlNode xmlNode) {
        super(xmlNode, false);
        List ifNodesList = (List)xmlNode.get("if");
        int size = ifNodesList == null ? 0 : ifNodesList.size();
        this.ifDefs = new IfDef[size];
        if (ifNodesList != null) {
            Iterator it = ifNodesList.iterator();
            int index = 0;
            while (it.hasNext()) {
                XmlNode currParamNode = (XmlNode)it.next();
                DefinitionResolver.validate(currParamNode);
                this.ifDefs[index++] = new IfDef(currParamNode);
            }
        }
        XmlNode elseDefNode = (XmlNode)xmlNode.get("else[0]");
        DefinitionResolver.validate(elseDefNode);
        this.elseDef = elseDefNode == null ? null : new BaseElementDef(elseDefNode, "else");
    }

    public IfDef[] getIfDefs() {
        return this.ifDefs;
    }

    public BaseElementDef getElseDef() {
        return this.elseDef;
    }

    @Override
    public String getShortElementName() {
        return "case";
    }

    @Override
    public IElementDef[] getOperationDefs() {
        int size = (this.ifDefs == null ? 0 : this.ifDefs.length) + (this.elseDef == null ? 0 : 1);
        IElementDef[] result = new IElementDef[size];
        if (this.ifDefs != null) {
            for (int index = 0; index < this.ifDefs.length; ++index) {
                result[index] = this.ifDefs[index];
            }
        }
        if (this.elseDef != null) {
            result[index] = this.elseDef;
        }
        return result;
    }
}

