/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.thesaurus.models;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.ui.thesaurus.ThesaurusDataProvider;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import jaxx.runtime.swing.nav.treetable.NavTreeTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ThesaurusTreeTableModel
extends NavTreeTableModel.MyDefaultTreeTableModel {
    private static final Log log = LogFactory.getLog(ThesaurusTreeTableModel.class);
    protected ThesaurusDataProvider dataProvider;

    public ThesaurusTreeTableModel(ThesaurusDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public Object getValueAt(Object value, int column) {
        Object result;
        VradiTreeTableNode node = (VradiTreeTableNode)((Object)value);
        RootThesaurus rootThesaurus = ThesaurusTreeTableHelper.getRootThesaurus(node);
        if (rootThesaurus != null) {
            result = this.getValueForRootThesaurus(rootThesaurus, column);
        } else {
            Thesaurus thesaurus = ThesaurusTreeTableHelper.getThesaurus(node);
            result = this.getValueForThesaurus(thesaurus, column);
        }
        return result;
    }

    public String[] getColumnsNames() {
        return new String[]{I18n._((String)"vradi.thesaurus.colomns.name"), I18n._((String)"vradi.thesaurus.colomns.nbForm"), I18n._((String)"vradi.thesaurus.colomns.tags")};
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    protected Object getValueForRootThesaurus(RootThesaurus rootThesaurus, int column) {
        if (rootThesaurus == null) {
            return "not found";
        }
        if (column == 0) {
            return rootThesaurus;
        }
        return "";
    }

    protected Object getValueForThesaurus(Thesaurus thesaurus, int column) {
        if (thesaurus == null) {
            return "not found";
        }
        Object result = null;
        switch (column) {
            case 0: {
                result = thesaurus;
                break;
            }
            case 1: {
                result = String.valueOf(this.dataProvider.getNbFormsForThesaurus(thesaurus));
                break;
            }
            case 2: {
                result = ThesaurusDataHelper.getTagsAsString(thesaurus);
            }
        }
        return result;
    }
}

