/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.helpers;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiEntitiesListener;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.loadors.ClientsAndUsersNodeLoadors;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientNavigationTreeHelper
extends AdminNavigationTreeHelper<Client> {
    private static final Log log = LogFactory.getLog(ClientNavigationTreeHelper.class);
    protected VradiEntitiesListener<User> userVradiEntitiesListener;

    public ClientNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
        VradiContext.get().getVradiNotifier().addVradiListener(Client.class, this);
        this.userVradiEntitiesListener = new VradiEntitiesListener<User>(){

            @Override
            public void entitiesAdded(Set<User> added) {
                for (User user : added) {
                    String wikittyId = user.getWikittyId();
                    VradiTreeNode existingNode = ClientNavigationTreeHelper.this.findNode(ClientNavigationTreeHelper.this.getRootNode(), wikittyId);
                    if (existingNode != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"User modification occured");
                        }
                        ClientNavigationTreeHelper.this.refresh(existingNode);
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"User creation occured");
                    }
                    ClientNavigationTreeHelper.this.createUserNode(wikittyId, false);
                }
            }

            @Override
            public void entitiesRemoved(Set<String> removed) {
                ClientNavigationTreeHelper.this.removeEntities(removed);
            }
        };
        VradiContext.get().getVradiNotifier().addVradiListener(User.class, this.userVradiEntitiesListener);
    }

    @Override
    public VradiTreeNode createNode() {
        return new VradiTreeNode(String.class, AdminBeanConstant.CLIENT.getCategoryName(), null, new ClientsAndUsersNodeLoadors());
    }

    @Override
    public void createEntityNode(String wikittyId) {
        this.createClientNode(wikittyId, false);
    }
}

