/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.caucho.hessian.client.HessianProxyFactory;
import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.services.FileService;
import com.jurismarches.vradi.services.FileServiceImpl;
import com.jurismarches.vradi.services.FileServiceProxy;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.services.VradiDataServiceImpl;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.VradiStorageServiceImpl;
import java.net.MalformedURLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceCached;
import org.nuiton.wikitty.WikittyServiceNotifier;

public class VradiService {
    private static final Log log = LogFactory.getLog(VradiService.class);
    protected static WikittyService wikittyService;
    protected static WikittyProxy wikittyProxy;
    protected static VradiStorageService vradiStorageService;
    protected static VradiDataService vradiDataService;
    protected static FileService fileService;

    public static void initServiceProxies(VradiConfig configuration) {
        String serviceEndpoint = configuration.getRemoteEndpoint();
        if (serviceEndpoint != null && serviceEndpoint.startsWith("http://")) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Use remote mode with url : " + serviceEndpoint));
            }
            HessianProxyFactory factory = new HessianProxyFactory();
            factory.setHessian2Request(true);
            factory.setOverloadEnabled(true);
            try {
                vradiStorageService = (VradiStorageService)factory.create(VradiStorageService.class, VradiService.getServiceURL(serviceEndpoint, "vradiservice"));
                WikittyService wikittyServiceRemote = (WikittyService)factory.create(WikittyService.class, VradiService.getServiceURL(serviceEndpoint, "wikittyservice"));
                wikittyService = VradiService.initLocalWikittyService(wikittyServiceRemote, configuration);
                fileService = new FileServiceProxy(VradiService.getServiceURL(serviceEndpoint, "file"));
            }
            catch (MalformedURLException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't init remote proxy", (Throwable)eee);
                }
            }
        } else {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Can't parse remote serveur endpoint as valid url (" + serviceEndpoint + ")"));
                log.warn((Object)"Use local embedded mode");
            }
            vradiStorageService = new VradiStorageServiceImpl();
            Properties properties = configuration.getFlatOptions();
            properties.remove("wikitty.service.cache.listenevents");
            wikittyService = ServiceFactory.getWikittyService((Properties)properties);
            fileService = new FileServiceImpl();
        }
        wikittyProxy = new WikittyProxy();
        wikittyProxy.setWikittyService(wikittyService);
        vradiDataService = new VradiDataServiceImpl(wikittyProxy);
    }

    protected static WikittyService initLocalWikittyService(WikittyService wikittyServiceRemote, VradiConfig configuration) {
        Properties options = configuration.getFlatOptions();
        log.info((Object)("RemoteNotifier used is : " + options.getProperty("wikitty.notifier.transporter.class")));
        log.info((Object)("Propagation event is set to : " + options.getProperty("wikitty.service.event.propagateEvent")));
        WikittyServiceNotifier wikittyServiceNotifier = new WikittyServiceNotifier(wikittyServiceRemote, options);
        options.setProperty("wikitty.service.cache.listenevents", "true");
        WikittyServiceCached wikittyServiceLocal = new WikittyServiceCached((WikittyService)wikittyServiceNotifier, options);
        return wikittyServiceLocal;
    }

    protected static String getServiceURL(String serviceEndpoint, String serviceEndUrl) {
        String fullUrl = serviceEndpoint;
        if (!fullUrl.endsWith("/")) {
            fullUrl = fullUrl + "/";
        }
        fullUrl = fullUrl + serviceEndUrl;
        return fullUrl;
    }

    public static VradiStorageService getVradiStorageService() {
        return vradiStorageService;
    }

    public static VradiDataService getVradiDataService() {
        return vradiDataService;
    }

    public static WikittyProxy getWikittyProxy() {
        return wikittyProxy;
    }

    public static WikittyService getWikittyService() {
        return wikittyService;
    }

    public static FileService getFileService() {
        return fileService;
    }
}

