/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.services.VradiService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public class EntityModel<E extends BusinessEntity>
extends AbstractListModel
implements ComboBoxModel,
WikittyServiceListener {
    private static final Log log = LogFactory.getLog(EntityModel.class);
    protected Map<String, E> datas;
    protected E selected;
    protected boolean firstNull = true;
    protected String ext;
    protected Class<E> clazz;

    public EntityModel(Class<E> clazz, String ext, List<E> datas) {
        this(clazz, ext, datas, true);
    }

    public EntityModel(Class<E> clazz, String ext, List<E> datas, boolean firstNull) {
        this.firstNull = firstNull;
        this.datas = new HashMap<String, E>();
        this.fillDatas(datas);
        this.ext = ext;
        this.clazz = clazz;
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.ALL);
    }

    protected void fillDatas(List<E> datas) {
        if (datas == null) {
            return;
        }
        for (BusinessEntity data : datas) {
            if (data == null) continue;
            this.datas.put(data.getWikittyId(), data);
        }
    }

    @Override
    public int getSize() {
        if (this.firstNull) {
            return this.datas.size() + 1;
        }
        return this.datas.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (this.firstNull) {
            if (index == 0) {
                return null;
            }
            ArrayList<String> keys = new ArrayList<String>(this.datas.keySet());
            return this.datas.get(keys.get(index - 1));
        }
        ArrayList<String> keys = new ArrayList<String>(this.datas.keySet());
        return this.datas.get(keys.get(index));
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selected = (BusinessEntity)anItem;
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    protected void updateDatas(List<E> datas) {
        this.fillDatas(datas);
        this.fireContentsChanged(this, 0, datas.size() - 1);
    }

    public void putWikitty(WikittyServiceEvent event) {
        Map idAndExtensions;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service put event : " + event));
        }
        if ((idAndExtensions = event.getIdExtensions()) != null) {
            for (final String wikittyId : event.getIds()) {
                Set wikittyExtensions = (Set)idAndExtensions.get(wikittyId);
                if (!wikittyExtensions.contains(this.ext)) continue;
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        BusinessEntity entity = VradiService.getWikittyProxy().restore(EntityModel.this.clazz, wikittyId);
                        if (entity != null) {
                            EntityModel.this.datas.put(entity.getWikittyId(), entity);
                        }
                        EntityModel.this.fireContentsChanged(this, 0, EntityModel.this.datas.size() - 1);
                    }
                });
            }
        }
    }

    public void removeWikitty(WikittyServiceEvent event) {
        Map idAndExtensions;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove event : " + event));
        }
        if ((idAndExtensions = event.getIdExtensions()) != null) {
            for (final String wikittyId : event.getIds()) {
                Set wikittyExtensions = (Set)idAndExtensions.get(wikittyId);
                if (!wikittyExtensions.contains(this.ext)) continue;
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        EntityModel.this.datas.remove(wikittyId);
                        EntityModel.this.fireContentsChanged(this, 0, EntityModel.this.datas.size() - 1);
                    }
                });
            }
        }
    }

    public void clearWikitty(WikittyServiceEvent event) {
    }

    public void putExtension(WikittyServiceEvent event) {
    }

    public void removeExtension(WikittyServiceEvent event) {
    }

    public void clearExtension(WikittyServiceEvent event) {
    }
}

