/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.entities.XmlFieldBinding;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlStreamFieldTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(XmlStreamFieldTableModel.class);
    protected List<XmlFieldBinding> data = new ArrayList<XmlFieldBinding>();
    protected boolean valueIsAdjusting;

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    public void clear() {
        this.data.clear();
        if (!this.valueIsAdjusting) {
            this.fireTableDataChanged();
        }
    }

    public boolean isValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }

    public List<XmlFieldBinding> getData() {
        return new ArrayList<XmlFieldBinding>(this.data);
    }

    public void addEntry(XmlFieldBinding b) {
        String formField = b.getFormField();
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding form " + formField));
        }
        this.data.add(b);
        if (this.isValueIsAdjusting()) {
            int newInbdex = this.data.size() - 1;
            this.fireTableRowsInserted(newInbdex, newInbdex);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        this.ensureRowIndex(rowIndex);
        log.debug((Object)rowIndex);
        XmlFieldBinding value = this.data.get(rowIndex);
        Object result = null;
        switch (columnIndex) {
            case 0: {
                String key = value.getFormField();
                if (key == null) break;
                result = key.substring(key.lastIndexOf(46) + 1);
                break;
            }
            case 1: {
                result = value.getXmlField();
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        this.ensureRowIndex(rowIndex);
        XmlFieldBinding value = this.data.get(rowIndex);
        Object[] values = (Object[])aValue;
        value.clearXmlField();
        for (Object v : values) {
            value.addXmlField(v + "");
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    protected void ensureRowIndex(int rowIndex) {
        if (rowIndex >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException("rowIndex (" + rowIndex + ") can not be greater than " + this.getRowCount());
        }
    }

    protected void ensureColumnIndex(int columnIndex) {
        if (columnIndex >= this.getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException("columnIndex (" + columnIndex + ") can not be greater than " + this.getColumnCount());
        }
    }
}

