/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import au.com.bytecode.opencsv.CSVWriter;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.ui.OfferEditHandler;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.VradiI18nTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.NumberFormatter;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class UIHelper
extends SwingUtil {
    private static final Log log = LogFactory.getLog(UIHelper.class);

    private UIHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateListSelection(JList list, Object value) {
        list.setValueIsAdjusting(true);
        list.clearSelection();
        try {
            if (value != null) {
                int size = list.getModel().getSize();
                Collection valuesToSelect = (Collection)value;
                int[] indexToSelect = new int[valuesToSelect.size()];
                int index = 0;
                block3: for (Object v : valuesToSelect) {
                    for (int i = 0; i < size; ++i) {
                        Object o = list.getModel().getElementAt(i);
                        if (!o.equals(v)) continue;
                        indexToSelect[index++] = i;
                        continue block3;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("index to select = " + Arrays.toString(indexToSelect)));
                }
                list.setSelectedIndices(indexToSelect);
            }
        }
        finally {
            list.setValueIsAdjusting(false);
        }
    }

    public static void setI18nTableHeaderRenderer(JTable table, String ... libelles) {
        table.getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)new VradiI18nTableCellRenderer(table.getTableHeader().getDefaultRenderer(), libelles)));
    }

    public static void openAddressInBrowser(String address) {
        UIHelper.browseURI("http://maps.google.fr/maps?f=q&source=s_q&hl=fr&geocode=&q=" + UIHelper.getStringValue((Object)address) + ",France");
    }

    public static void browseURI(String uri) {
        try {
            Desktop.getDesktop().browse(new URI(uri.replace(" ", "+")));
        }
        catch (IOException e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
        }
        catch (URISyntaxException e) {
            log.error((Object)e);
            ErrorDialogUI.showError((Exception)e);
        }
    }

    public static void createEmail(String emailAdress) {
        block7: {
            try {
                URI mailtoURI = new URI("mailto:" + emailAdress);
                Desktop.getDesktop().mail(mailtoURI);
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)e);
                }
                ErrorDialogUI.showError((Exception)e);
            }
            catch (URISyntaxException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Error while opening link", (Throwable)e);
                }
            }
            catch (UnsupportedOperationException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Cannot open link (maybe defaut browser in not configured ?)");
                }
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)"Error while opening link", (Throwable)e);
            }
        }
    }

    public static void exportToCSV(File file, OfferListTableModel model) {
        try {
            int i;
            FileWriter fileWriter = new FileWriter(file);
            CSVWriter csvWriter = new CSVWriter((Writer)fileWriter);
            int columnCount = model.getColumnCount();
            String[] nextLine = new String[columnCount];
            for (i = 0; i < model.getColumnCount(); ++i) {
                nextLine[i] = I18n._((String)model.getColumnName(i));
            }
            csvWriter.writeNext(nextLine);
            for (i = 0; i < model.getRowCount(); ++i) {
                nextLine = new String[columnCount];
                for (int j = 0; j < model.getColumnCount(); ++j) {
                    String value;
                    Object valueAt = model.getValueAt(i, j);
                    if (valueAt == null) continue;
                    nextLine[j] = value = String.valueOf(valueAt);
                }
                csvWriter.writeNext(nextLine);
            }
            csvWriter.close();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
    }

    public static File openFileChooser(final String fileExtension, final String description, Component component, String validationLabel) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String ext = null;
                String fileName = file.getName();
                int dot = fileName.lastIndexOf(46);
                if (dot > 0 && dot < fileName.length() - 1) {
                    ext = fileName.substring(dot).toLowerCase();
                }
                return ext != null && ext.equals(fileExtension);
            }

            @Override
            public String getDescription() {
                return I18n._((String)description);
            }
        });
        int returnVal = fileChooser.showDialog(component, I18n._((String)validationLabel));
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            if (!file.getName().endsWith(fileExtension)) {
                file = new File(file.getAbsolutePath() + fileExtension);
            }
            log.debug((Object)("saving : " + file.getName() + "."));
            return file;
        }
        log.debug((Object)"No file chosen by user.");
        return null;
    }

    public static ListCellRenderer getTranslationListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value != null) {
                    return super.getListCellRendererComponent((JList<?>)list, I18n._((String)value.toString()), index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        };
    }

    public static <T> T getHandler(JAXXContext context, Class<T> handlerClass) {
        Object handler = context.getContextValue(handlerClass);
        if (handler != null) {
            return (T)handler;
        }
        try {
            handler = handlerClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)("Cant create handler instance of type " + handlerClass.getName() + " : "), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Cant create handler instance of type " + handlerClass.getName() + " : "), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
        if (context instanceof JAXXInitialContext) {
            ((JAXXInitialContext)context).add(handler);
        } else {
            context.setContextValue(handler);
        }
        return (T)handler;
    }

    public static ComboBoxModel getNumberComboBoxModel(int nbData) {
        Integer[] data = new Integer[nbData];
        for (int i = 0; i < data.length; ++i) {
            data[i] = i;
        }
        return new DefaultComboBoxModel<Integer>(data);
    }

    public static ComboBoxModel getHourModel() {
        return UIHelper.getNumberComboBoxModel(24);
    }

    public static ComboBoxModel getMinuteModel() {
        return UIHelper.getNumberComboBoxModel(60);
    }

    public static ListCellRenderer get2DigitsRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object o, int i, boolean b, boolean b1) {
                String value = (Integer)o < 10 ? "0" + o.toString() : o.toString();
                return super.getListCellRendererComponent((JList<?>)jList, value, i, b, b1);
            }
        };
    }

    public static void openFormPopup(JAXXContext context, Form form) {
        context.setContextValue((Object)form);
        OfferEditUI ui = (OfferEditUI)context.getContextValue(OfferEditUI.class, "formPopupOfferEditUI");
        if (ui == null) {
            ui = new OfferEditUI(context);
            context.setContextValue((Object)ui, "formPopupOfferEditUI");
        }
        ui.getContent().removeAll();
        OfferEditHandler handler = UIHelper.getHandler(context, OfferEditHandler.class);
        handler.fillfields(ui, form);
        handler.initThesaurus(context, ui);
        JDialog frame = (JDialog)context.getContextValue(JDialog.class, "formPopup");
        if (frame == null) {
            JDialog parent = null;
            Component c = (Component)context;
            while (parent == null && c != null) {
                if (JDialog.class.isAssignableFrom(c.getClass())) {
                    parent = (JDialog)c;
                    continue;
                }
                c = c.getParent();
            }
            frame = new JDialog(parent);
            frame.setLayout(new BorderLayout());
            frame.setSize(new Dimension(800, 800));
            frame.getContentPane().add((Component)ui, "Center");
            context.setContextValue((Object)frame, "formPopup");
        }
        frame.setTitle(form.getObjet());
        frame.setVisible(true);
    }

    public static class NumberFormatterFactory
    extends JFormattedTextField.AbstractFormatterFactory {
        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
            numberFormatter.setAllowsInvalid(false);
            numberFormatter.setValueClass(Integer.class);
            return numberFormatter;
        }
    }
}

