/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.InfogeneImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.binding.DefaultJAXXBinding;
import org.apache.commons.lang.StringUtils;
import org.nuiton.i18n.I18n;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.WikittyExtension;

public class OfferListTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_PAGE_TO_SHOW = "pageToShow";
    public static final String PROPERTY_NB_FORMS_PER_PAGE = "nbFormsPerPage";
    public static final String PROPERTY_BINDING_CHANGE = "bindings";
    public static final String PROPERTY_TOTAL_FORMS = "totalFoundFormNb";
    public static final String PROPERTY_NB_PAGES = "nbPagesAsText";
    public static final String PROPERTY_LAST_PAGE = "lastPage";
    public static final int TOOLTIP_ELEMENT_MAX_CHAR_NB = 500;
    protected final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected final List<Column> columns = new ArrayList<Column>();
    protected VradiFormPageDTO formPageDTO = new VradiFormPageDTO();

    public OfferListTableModel() {
        this.initColumns();
        this.formPageDTO.setPageToShow(1);
        this.formPageDTO.setNbFormsToShow(10);
    }

    public OfferListTableModel(VradiFormPageDTO formPageDTO) {
        this.initColumns();
        this.setFormPageDTO(formPageDTO);
    }

    public void setFormPageDTO(VradiFormPageDTO formPageDTO) {
        if (formPageDTO == null) {
            throw new IllegalArgumentException("formPageDTO is null");
        }
        this.formPageDTO = formPageDTO;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_TOTAL_FORMS, null, (Object)formPageDTO.getTotalFoundFormNb());
        this.propertyChangeSupport.firePropertyChange(PROPERTY_NB_PAGES, null, (Object)this.getNbPages());
        this.propertyChangeSupport.firePropertyChange(PROPERTY_LAST_PAGE, null, (Object)this.isLastPage());
        this.fireTableDataChanged();
    }

    public VradiFormPageDTO getFormPageDTO() {
        return this.formPageDTO;
    }

    protected void initColumns() {
        WikittyExtension extension = InfogeneImpl.extensionInfogene;
        List fieldNames = extension.getFieldNames();
        for (String fieldName : fieldNames) {
            FieldType fieldType = extension.getFieldType(fieldName);
            Class columnClass = null;
            columnClass = fieldType.getType() == FieldType.TYPE.BOOLEAN ? Boolean.class : (fieldType.getType() == FieldType.TYPE.DATE ? Date.class : (fieldType.getType() == FieldType.TYPE.NUMERIC ? Double.class : String.class));
            Column column = new Column(extension.getName(), fieldName, columnClass);
            this.columns.add(column);
        }
    }

    public Integer getNbFormsPerPage() {
        return this.formPageDTO.getNbFormsToShow();
    }

    public void setNbFormsPerPage(Integer nbFormsPerPage) {
        Integer pageToShow;
        Integer nbFormsToShow = this.formPageDTO.getNbFormsToShow();
        int topRow = nbFormsToShow * (this.formPageDTO.getPageToShow() - 1);
        if ((pageToShow = Integer.valueOf((int)Math.ceil((double)(++topRow) / nbFormsPerPage.doubleValue()))) < 1) {
            pageToShow = 1;
        }
        this.formPageDTO.setNbFormsToShow(nbFormsPerPage.intValue());
        this.propertyChangeSupport.firePropertyChange(PROPERTY_NB_FORMS_PER_PAGE, nbFormsToShow, nbFormsPerPage);
        this.setPageToShow(pageToShow);
    }

    public int getPageToShow() {
        return this.formPageDTO.getPageToShow();
    }

    public void setPageToShow(int pageToShow) {
        int oldValue = this.formPageDTO.getPageToShow();
        this.formPageDTO.setPageToShow(pageToShow);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_PAGE_TO_SHOW, oldValue, pageToShow);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_BINDING_CHANGE, Boolean.FALSE, Boolean.TRUE);
    }

    public boolean isLastPage() {
        int pageToShow;
        int nbPages = this.getNbPages();
        boolean result = nbPages == (pageToShow = this.formPageDTO.getPageToShow());
        return result;
    }

    public String getNbPagesAsText() {
        int nbPages = this.getNbPages();
        return " / " + String.valueOf(nbPages);
    }

    public int getNbPages() {
        int nbFormsPerPage;
        int totalFoundFormNb = this.formPageDTO.getTotalFoundFormNb();
        int nbPages = (int)Math.ceil((double)totalFoundFormNb / (double)(nbFormsPerPage = this.formPageDTO.getNbFormsToShow()));
        if (nbPages == 0) {
            nbPages = 1;
        }
        return nbPages;
    }

    public String getFieldToSort() {
        return this.formPageDTO.getFieldToSort();
    }

    public void setFieldToSort(String fieldToSort) {
        if (fieldToSort != null) {
            this.formPageDTO.setFieldToSort(fieldToSort);
        }
    }

    public boolean isAscending() {
        return this.formPageDTO.isAscending();
    }

    public void setAscending(boolean ascending) {
        this.formPageDTO.setAscending(ascending);
    }

    public int getTotalFoundFormNb() {
        return this.formPageDTO.getTotalFoundFormNb();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public String getColumnName(int col) {
        Column column = this.columns.get(col);
        return column.i18name;
    }

    @Override
    public int getRowCount() {
        return this.formPageDTO.getFormsToShow() != null ? this.formPageDTO.getFormsToShow().size() : 0;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        List formsToShow = this.formPageDTO.getFormsToShow();
        if (row >= formsToShow.size()) {
            return null;
        }
        Form form = (Form)formsToShow.get(row);
        if (form == null) {
            return null;
        }
        String fqColumnName = this.getColumnFqName(col);
        if (fqColumnName.equals("Infogene.status")) {
            String statusId = form.getStatus();
            Status status = VradiHelper.getStatus(statusId);
            return status;
        }
        int indexOf = fqColumnName.indexOf(46);
        String extension = fqColumnName.substring(0, indexOf);
        String fieldName = fqColumnName.substring(indexOf + 1);
        Object field = form.getField(extension, fieldName);
        FieldType fieldType = form.getFieldType(extension, fieldName);
        return fieldType.getValidValue(field);
    }

    public Class getColumnClass(int col) {
        Column column = this.columns.get(col);
        return column.columnClass;
    }

    public String getColumnFqName(int col) {
        Column column = this.columns.get(col);
        return column.fqName;
    }

    public String getToolTip(int row) {
        String[] infogeneFields;
        String[] formFields;
        List formsToShow = this.formPageDTO.getFormsToShow();
        if (row >= formsToShow.size()) {
            return null;
        }
        Form form = (Form)formsToShow.get(row);
        if (form == null) {
            return null;
        }
        LinkedHashMap<String, Object> fieldValues = new LinkedHashMap<String, Object>();
        for (String fieldName : formFields = new String[]{"datePub", "datePeremption"}) {
            fieldValues.put(fieldName, form.getField("Form", fieldName));
        }
        for (String fieldName : infogeneFields = new String[]{"id", "objet", "entity", "sourceText", "description"}) {
            fieldValues.put(fieldName, form.getField("Infogene", fieldName));
        }
        Collection extensionNames = form.getExtensionNames();
        for (String extensionName : extensionNames) {
            if ("Form".equals(extensionName) || "Infogene".equals(extensionName)) continue;
            List fieldNames = (List)form.getExtensionFields(extensionName);
            for (String fieldName : fieldNames) {
                fieldValues.put(fieldName, form.getField(extensionName, fieldName));
            }
        }
        StringBuffer result = new StringBuffer();
        result.append("<html>");
        for (Map.Entry entry : fieldValues.entrySet()) {
            Object value = entry.getValue();
            String key = (String)entry.getKey();
            if (value == null) continue;
            String stringValue = null;
            if (value instanceof Date) {
                stringValue = DateFormat.getDateTimeInstance(3, 2, Locale.FRANCE).format((Date)value);
            } else {
                stringValue = String.valueOf(value);
                stringValue = StringUtils.replace((String)stringValue, (String)"\r", (String)"");
                stringValue = StringUtils.replace((String)stringValue, (String)"\n\n", (String)"\n");
                stringValue = StringUtils.abbreviate((String)stringValue, (int)500);
                stringValue = StringUtils.replace((String)stringValue, (String)"\n", (String)"<br/>");
            }
            result.append("<strong>").append(key).append("</strong>").append(" : ").append(stringValue).append("<br/>");
        }
        result.append("</html>");
        return result.toString();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public static class OfferListTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String stringValue = null;
            stringValue = value == null ? null : (value instanceof Date ? DateFormat.getDateTimeInstance(3, 3, Locale.FRANCE).format((Date)value) : (value instanceof Status ? ((Status)value).getName() : String.valueOf(value)));
            OfferListTableModel model = (OfferListTableModel)table.getModel();
            this.setToolTipText(model.getToolTip(table.convertRowIndexToModel(row)));
            return super.getTableCellRendererComponent(table, stringValue, isSelected, hasFocus, row, column);
        }
    }

    public static abstract class OfferListTableModelBinding
    extends DefaultJAXXBinding {
        protected OfferListTableModel model;

        public OfferListTableModelBinding(JAXXObject source, String id, OfferListTableModel model) {
            super(source, id, false);
            this.model = model;
        }

        public void applyDataBinding() {
            if (this.model != null) {
                this.model.addPropertyChangeListener(OfferListTableModel.PROPERTY_BINDING_CHANGE, (PropertyChangeListener)((Object)this));
            }
        }

        public void removeDataBinding() {
            if (this.model != null) {
                this.model.removePropertyChangeListener(OfferListTableModel.PROPERTY_BINDING_CHANGE, (PropertyChangeListener)((Object)this));
            }
        }
    }

    static class Column {
        private static final String I18N_COLUMN_PREFIX = "vradi.offer.";
        final String i18name;
        final Class columnClass;
        final String fqName;

        Column(String extension, String name, Class columnClass) {
            this.fqName = extension + "." + name;
            this.columnClass = columnClass;
            this.i18name = I18n._((String)(I18N_COLUMN_PREFIX + this.fqName));
        }
    }
}

